/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.util.StringTokenizer;

class CC2Elm
extends ChipElm {
    double gain;

    public CC2Elm(int n, int n2) {
        super(n, n2);
        this.gain = 1.0;
    }

    public CC2Elm(int n, int n2, int n3) {
        super(n, n2);
        this.gain = n3;
    }

    public CC2Elm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
        this.gain = new Double(stringTokenizer.nextToken());
    }

    String dump() {
        return super.dump() + " " + this.gain;
    }

    String getChipName() {
        return "CC2";
    }

    void setupPins() {
        this.sizeX = 2;
        this.sizeY = 3;
        this.pins = new ChipElm.Pin[3];
        this.pins[0] = new ChipElm.Pin(this, 0, 2, "X");
        this.pins[0].output = true;
        this.pins[1] = new ChipElm.Pin(this, 2, 2, "Y");
        this.pins[2] = new ChipElm.Pin(this, 1, 3, "Z");
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = this.gain == 1.0 ? "CCII+" : "CCII-";
        stringArray[1] = "X,Y = " + CC2Elm.getVoltageText(this.volts[0]);
        stringArray[2] = "Z = " + CC2Elm.getVoltageText(this.volts[2]);
        stringArray[3] = "I = " + CC2Elm.getCurrentText(this.pins[0].current);
    }

    void stamp() {
        sim.stampVoltageSource(0, this.nodes[0], this.pins[0].voltSource);
        sim.stampVCVS(0, this.nodes[1], 1.0, this.pins[0].voltSource);
        sim.stampCCCS(0, this.nodes[2], this.pins[0].voltSource, this.gain);
    }

    void draw(Graphics graphics) {
        this.pins[2].current = this.pins[0].current * this.gain;
        this.drawChip(graphics);
    }

    int getPostCount() {
        return 3;
    }

    int getVoltageSourceCount() {
        return 1;
    }

    int getDumpType() {
        return 179;
    }
}

