/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class TappedTransformerElm
extends CircuitElm {
    double inductance;
    double ratio;
    Point[] ptEnds;
    Point[] ptCoil;
    Point[] ptCore;
    double[] current;
    double[] curcount;
    double[] a;
    double[] curSourceValue;
    double[] voltdiff;

    public TappedTransformerElm(int n, int n2) {
        super(n, n2);
        this.inductance = 4.0;
        this.ratio = 1.0;
        this.noDiagonal = true;
        this.current = new double[4];
        this.curcount = new double[4];
    }

    public TappedTransformerElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.inductance = new Double(stringTokenizer.nextToken());
        this.ratio = new Double(stringTokenizer.nextToken());
        this.current = new double[4];
        this.curcount = new double[4];
        this.current[0] = new Double(stringTokenizer.nextToken());
        this.current[1] = new Double(stringTokenizer.nextToken());
        try {
            this.current[2] = new Double(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.noDiagonal = true;
    }

    int getDumpType() {
        return 169;
    }

    String dump() {
        return super.dump() + " " + this.inductance + " " + this.ratio + " " + this.current[0] + " " + this.current[1] + " " + this.current[2];
    }

    void draw(Graphics graphics) {
        int n;
        for (n = 0; n != 5; ++n) {
            this.setVoltageColor(graphics, this.volts[n]);
            TappedTransformerElm.drawThickLine(graphics, this.ptEnds[n], this.ptCoil[n]);
        }
        for (n = 0; n != 4; ++n) {
            if (n == 1) continue;
            this.setPowerColor(graphics, this.current[n] * (this.volts[n] - this.volts[n + 1]));
            this.drawCoil(graphics, n > 1 ? -6 : 6, this.ptCoil[n], this.ptCoil[n + 1], this.volts[n], this.volts[n + 1]);
        }
        graphics.setColor(this.needsHighlight() ? selectColor : lightGrayColor);
        for (n = 0; n != 4; n += 2) {
            TappedTransformerElm.drawThickLine(graphics, this.ptCore[n], this.ptCore[n + 1]);
        }
        this.current[3] = this.current[1] - this.current[2];
        for (n = 0; n != 4; ++n) {
            this.curcount[n] = this.updateDotCount(this.current[n], this.curcount[n]);
        }
        this.drawDots(graphics, this.ptEnds[0], this.ptCoil[0], this.curcount[0]);
        this.drawDots(graphics, this.ptCoil[0], this.ptCoil[1], this.curcount[0]);
        this.drawDots(graphics, this.ptCoil[1], this.ptEnds[1], this.curcount[0]);
        this.drawDots(graphics, this.ptEnds[2], this.ptCoil[2], this.curcount[1]);
        this.drawDots(graphics, this.ptCoil[2], this.ptCoil[3], this.curcount[1]);
        this.drawDots(graphics, this.ptCoil[3], this.ptEnds[3], this.curcount[3]);
        this.drawDots(graphics, this.ptCoil[3], this.ptCoil[4], this.curcount[2]);
        this.drawDots(graphics, this.ptCoil[4], this.ptEnds[4], this.curcount[2]);
        this.drawPosts(graphics);
        this.setBbox(this.ptEnds[0], this.ptEnds[4], 0.0);
    }

    void setPoints() {
        super.setPoints();
        int n = 32;
        this.ptEnds = this.newPointArray(5);
        this.ptCoil = this.newPointArray(5);
        this.ptCore = this.newPointArray(4);
        this.ptEnds[0] = this.point1;
        this.ptEnds[2] = this.point2;
        this.interpPoint(this.point1, this.point2, this.ptEnds[1], 0.0, -n * 2);
        this.interpPoint(this.point1, this.point2, this.ptEnds[3], 1.0, -n);
        this.interpPoint(this.point1, this.point2, this.ptEnds[4], 1.0, -n * 2);
        double d = 0.5 - 12.0 / this.dn;
        double d2 = 0.5 - 2.0 / this.dn;
        this.interpPoint(this.ptEnds[0], this.ptEnds[2], this.ptCoil[0], d);
        this.interpPoint(this.ptEnds[0], this.ptEnds[2], this.ptCoil[1], d, -n * 2);
        this.interpPoint(this.ptEnds[0], this.ptEnds[2], this.ptCoil[2], 1.0 - d);
        this.interpPoint(this.ptEnds[0], this.ptEnds[2], this.ptCoil[3], 1.0 - d, -n);
        this.interpPoint(this.ptEnds[0], this.ptEnds[2], this.ptCoil[4], 1.0 - d, -n * 2);
        for (int i = 0; i != 2; ++i) {
            int n2 = -n * i * 2;
            this.interpPoint(this.ptEnds[0], this.ptEnds[2], this.ptCore[i], d2, n2);
            this.interpPoint(this.ptEnds[0], this.ptEnds[2], this.ptCore[i + 2], 1.0 - d2, n2);
        }
    }

    Point getPost(int n) {
        return this.ptEnds[n];
    }

    int getPostCount() {
        return 5;
    }

    void reset() {
        this.curcount[1] = 0.0;
        this.curcount[0] = 0.0;
        this.volts[3] = 0.0;
        this.volts[2] = 0.0;
        this.volts[1] = 0.0;
        this.volts[0] = 0.0;
        this.current[1] = 0.0;
        this.current[0] = 0.0;
    }

    void stamp() {
        double d = this.inductance;
        double d2 = this.inductance * this.ratio * this.ratio / 4.0;
        double d3 = 0.99;
        this.a = new double[9];
        this.a[0] = (1.0 + d3) / (d * (1.0 + d3 - 2.0 * d3 * d3));
        this.a[3] = this.a[6] = 2.0 * d3 / ((2.0 * d3 * d3 - d3 - 1.0) * this.inductance * this.ratio);
        this.a[2] = this.a[6];
        this.a[1] = this.a[6];
        this.a[4] = this.a[8] = -4.0 * (1.0 + d3) / ((2.0 * d3 * d3 - d3 - 1.0) * d * this.ratio * this.ratio);
        this.a[5] = this.a[7] = 4.0 * d3 / ((2.0 * d3 * d3 - d3 - 1.0) * d * this.ratio * this.ratio);
        int n = 0;
        while (n != 9) {
            int n2 = n++;
            this.a[n2] = this.a[n2] * (TappedTransformerElm.sim.timeStep / 2.0);
        }
        sim.stampConductance(this.nodes[0], this.nodes[1], this.a[0]);
        sim.stampVCCurrentSource(this.nodes[0], this.nodes[1], this.nodes[2], this.nodes[3], this.a[1]);
        sim.stampVCCurrentSource(this.nodes[0], this.nodes[1], this.nodes[3], this.nodes[4], this.a[2]);
        sim.stampVCCurrentSource(this.nodes[2], this.nodes[3], this.nodes[0], this.nodes[1], this.a[3]);
        sim.stampConductance(this.nodes[2], this.nodes[3], this.a[4]);
        sim.stampVCCurrentSource(this.nodes[2], this.nodes[3], this.nodes[3], this.nodes[4], this.a[5]);
        sim.stampVCCurrentSource(this.nodes[3], this.nodes[4], this.nodes[0], this.nodes[1], this.a[6]);
        sim.stampVCCurrentSource(this.nodes[3], this.nodes[4], this.nodes[2], this.nodes[3], this.a[7]);
        sim.stampConductance(this.nodes[3], this.nodes[4], this.a[8]);
        for (n = 0; n != 5; ++n) {
            sim.stampRightSide(this.nodes[n]);
        }
        this.voltdiff = new double[3];
        this.curSourceValue = new double[3];
    }

    void startIteration() {
        this.voltdiff[0] = this.volts[0] - this.volts[1];
        this.voltdiff[1] = this.volts[2] - this.volts[3];
        this.voltdiff[2] = this.volts[3] - this.volts[4];
        for (int i = 0; i != 3; ++i) {
            this.curSourceValue[i] = this.current[i];
            for (int j = 0; j != 3; ++j) {
                int n = i;
                this.curSourceValue[n] = this.curSourceValue[n] + this.a[i * 3 + j] * this.voltdiff[j];
            }
        }
    }

    void doStep() {
        sim.stampCurrentSource(this.nodes[0], this.nodes[1], this.curSourceValue[0]);
        sim.stampCurrentSource(this.nodes[2], this.nodes[3], this.curSourceValue[1]);
        sim.stampCurrentSource(this.nodes[3], this.nodes[4], this.curSourceValue[2]);
    }

    void calculateCurrent() {
        this.voltdiff[0] = this.volts[0] - this.volts[1];
        this.voltdiff[1] = this.volts[2] - this.volts[3];
        this.voltdiff[2] = this.volts[3] - this.volts[4];
        for (int i = 0; i != 3; ++i) {
            this.current[i] = this.curSourceValue[i];
            for (int j = 0; j != 3; ++j) {
                int n = i;
                this.current[n] = this.current[n] + this.a[i * 3 + j] * this.voltdiff[j];
            }
        }
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "transformer";
        stringArray[1] = "L = " + TappedTransformerElm.getUnitText(this.inductance, "H");
        stringArray[2] = "Ratio = " + this.ratio;
        stringArray[3] = "Vd1 = " + TappedTransformerElm.getVoltageText(this.volts[0] - this.volts[2]);
        stringArray[4] = "Vd2 = " + TappedTransformerElm.getVoltageText(this.volts[1] - this.volts[3]);
    }

    boolean getConnection(int n, int n2) {
        if (this.comparePair(n, n2, 0, 1)) {
            return true;
        }
        if (this.comparePair(n, n2, 2, 3)) {
            return true;
        }
        if (this.comparePair(n, n2, 3, 4)) {
            return true;
        }
        return this.comparePair(n, n2, 2, 4);
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Primary Inductance (H)", this.inductance, 0.01, 5.0);
        }
        if (n == 1) {
            return new EditInfo("Ratio", this.ratio, 1.0, 10.0).setDimensionless();
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.inductance = editInfo.value;
        }
        if (n == 1) {
            this.ratio = editInfo.value;
        }
    }
}

