/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class TransformerElm
extends CircuitElm {
    double inductance;
    double ratio;
    double couplingCoef;
    Point[] ptEnds;
    Point[] ptCoil;
    Point[] ptCore;
    double[] current;
    double[] curcount;
    int width;
    public static final int FLAG_BACK_EULER = 2;
    double a1;
    double a2;
    double a3;
    double a4;
    double curSourceValue1;
    double curSourceValue2;

    public TransformerElm(int n, int n2) {
        super(n, n2);
        this.inductance = 4.0;
        this.ratio = 1.0;
        this.width = 32;
        this.noDiagonal = true;
        this.couplingCoef = 0.999;
        this.current = new double[2];
        this.curcount = new double[2];
    }

    public TransformerElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.width = TransformerElm.max(32, TransformerElm.abs(n4 - n2));
        this.inductance = new Double(stringTokenizer.nextToken());
        this.ratio = new Double(stringTokenizer.nextToken());
        this.current = new double[2];
        this.curcount = new double[2];
        this.current[0] = new Double(stringTokenizer.nextToken());
        this.current[1] = new Double(stringTokenizer.nextToken());
        this.couplingCoef = 0.999;
        try {
            this.couplingCoef = new Double(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.noDiagonal = true;
    }

    void drag(int n, int n2) {
        n = sim.snapGrid(n);
        n2 = sim.snapGrid(n2);
        this.width = TransformerElm.max(32, TransformerElm.abs(n2 - this.y));
        if (n == this.x) {
            n2 = this.y;
        }
        this.x2 = n;
        this.y2 = n2;
        this.setPoints();
    }

    int getDumpType() {
        return 84;
    }

    String dump() {
        return super.dump() + " " + this.inductance + " " + this.ratio + " " + this.current[0] + " " + this.current[1] + " " + this.couplingCoef;
    }

    boolean isTrapezoidal() {
        return (this.flags & 2) == 0;
    }

    void draw(Graphics graphics) {
        int n;
        for (n = 0; n != 4; ++n) {
            this.setVoltageColor(graphics, this.volts[n]);
            TransformerElm.drawThickLine(graphics, this.ptEnds[n], this.ptCoil[n]);
        }
        for (n = 0; n != 2; ++n) {
            this.setPowerColor(graphics, this.current[n] * (this.volts[n] - this.volts[n + 2]));
            this.drawCoil(graphics, this.dsign * (n == 1 ? -6 : 6), this.ptCoil[n], this.ptCoil[n + 2], this.volts[n], this.volts[n + 2]);
        }
        graphics.setColor(this.needsHighlight() ? selectColor : lightGrayColor);
        for (n = 0; n != 2; ++n) {
            TransformerElm.drawThickLine(graphics, this.ptCore[n], this.ptCore[n + 2]);
            this.curcount[n] = this.updateDotCount(this.current[n], this.curcount[n]);
        }
        for (n = 0; n != 2; ++n) {
            this.drawDots(graphics, this.ptEnds[n], this.ptCoil[n], this.curcount[n]);
            this.drawDots(graphics, this.ptCoil[n], this.ptCoil[n + 2], this.curcount[n]);
            this.drawDots(graphics, this.ptEnds[n + 2], this.ptCoil[n + 2], -this.curcount[n]);
        }
        this.drawPosts(graphics);
        this.setBbox(this.ptEnds[0], this.ptEnds[3], 0.0);
    }

    void setPoints() {
        super.setPoints();
        this.point2.y = this.point1.y;
        this.ptEnds = this.newPointArray(4);
        this.ptCoil = this.newPointArray(4);
        this.ptCore = this.newPointArray(4);
        this.ptEnds[0] = this.point1;
        this.ptEnds[1] = this.point2;
        this.interpPoint(this.point1, this.point2, this.ptEnds[2], 0.0, -this.dsign * this.width);
        this.interpPoint(this.point1, this.point2, this.ptEnds[3], 1.0, -this.dsign * this.width);
        double d = 0.5 - 12.0 / this.dn;
        double d2 = 0.5 - 2.0 / this.dn;
        for (int i = 0; i != 4; i += 2) {
            this.interpPoint(this.ptEnds[i], this.ptEnds[i + 1], this.ptCoil[i], d);
            this.interpPoint(this.ptEnds[i], this.ptEnds[i + 1], this.ptCoil[i + 1], 1.0 - d);
            this.interpPoint(this.ptEnds[i], this.ptEnds[i + 1], this.ptCore[i], d2);
            this.interpPoint(this.ptEnds[i], this.ptEnds[i + 1], this.ptCore[i + 1], 1.0 - d2);
        }
    }

    Point getPost(int n) {
        return this.ptEnds[n];
    }

    int getPostCount() {
        return 4;
    }

    void reset() {
        this.curcount[1] = 0.0;
        this.curcount[0] = 0.0;
        this.volts[3] = 0.0;
        this.volts[2] = 0.0;
        this.volts[1] = 0.0;
        this.volts[0] = 0.0;
        this.current[1] = 0.0;
        this.current[0] = 0.0;
    }

    void stamp() {
        double d = this.inductance;
        double d2 = this.inductance * this.ratio * this.ratio;
        double d3 = this.couplingCoef * Math.sqrt(d * d2);
        double d4 = 1.0 / (d * d2 - d3 * d3);
        double d5 = this.isTrapezoidal() ? TransformerElm.sim.timeStep / 2.0 : TransformerElm.sim.timeStep;
        this.a1 = d2 * d4 * d5;
        this.a2 = -d3 * d4 * d5;
        this.a3 = -d3 * d4 * d5;
        this.a4 = d * d4 * d5;
        sim.stampConductance(this.nodes[0], this.nodes[2], this.a1);
        sim.stampVCCurrentSource(this.nodes[0], this.nodes[2], this.nodes[1], this.nodes[3], this.a2);
        sim.stampVCCurrentSource(this.nodes[1], this.nodes[3], this.nodes[0], this.nodes[2], this.a3);
        sim.stampConductance(this.nodes[1], this.nodes[3], this.a4);
        sim.stampRightSide(this.nodes[0]);
        sim.stampRightSide(this.nodes[1]);
        sim.stampRightSide(this.nodes[2]);
        sim.stampRightSide(this.nodes[3]);
    }

    void startIteration() {
        double d = this.volts[0] - this.volts[2];
        double d2 = this.volts[1] - this.volts[3];
        if (this.isTrapezoidal()) {
            this.curSourceValue1 = d * this.a1 + d2 * this.a2 + this.current[0];
            this.curSourceValue2 = d * this.a3 + d2 * this.a4 + this.current[1];
        } else {
            this.curSourceValue1 = this.current[0];
            this.curSourceValue2 = this.current[1];
        }
    }

    void doStep() {
        sim.stampCurrentSource(this.nodes[0], this.nodes[2], this.curSourceValue1);
        sim.stampCurrentSource(this.nodes[1], this.nodes[3], this.curSourceValue2);
    }

    void calculateCurrent() {
        double d = this.volts[0] - this.volts[2];
        double d2 = this.volts[1] - this.volts[3];
        this.current[0] = d * this.a1 + d2 * this.a2 + this.curSourceValue1;
        this.current[1] = d * this.a3 + d2 * this.a4 + this.curSourceValue2;
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "transformer";
        stringArray[1] = "L = " + TransformerElm.getUnitText(this.inductance, "H");
        stringArray[2] = "Ratio = 1:" + this.ratio;
        stringArray[3] = "Vd1 = " + TransformerElm.getVoltageText(this.volts[0] - this.volts[2]);
        stringArray[4] = "Vd2 = " + TransformerElm.getVoltageText(this.volts[1] - this.volts[3]);
        stringArray[5] = "I1 = " + TransformerElm.getCurrentText(this.current[0]);
        stringArray[6] = "I2 = " + TransformerElm.getCurrentText(this.current[1]);
    }

    boolean getConnection(int n, int n2) {
        if (this.comparePair(n, n2, 0, 2)) {
            return true;
        }
        return this.comparePair(n, n2, 1, 3);
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Primary Inductance (H)", this.inductance, 0.01, 5.0);
        }
        if (n == 1) {
            return new EditInfo("Ratio", this.ratio, 1.0, 10.0).setDimensionless();
        }
        if (n == 2) {
            return new EditInfo("Coupling Coefficient", this.couplingCoef, 0.0, 1.0).setDimensionless();
        }
        if (n == 3) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Trapezoidal Approximation", this.isTrapezoidal());
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.inductance = editInfo.value;
        }
        if (n == 1) {
            this.ratio = editInfo.value;
        }
        if (n == 2 && editInfo.value > 0.0 && editInfo.value < 1.0) {
            this.couplingCoef = editInfo.value;
        }
        if (n == 3) {
            this.flags = editInfo.checkbox.getState() ? (this.flags &= 0xFFFFFFFD) : (this.flags |= 2);
        }
    }
}

