/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.util.StringTokenizer;

class VCOElm
extends ChipElm {
    final double cResistance = 1000000.0;
    double cCurrent;
    int cDir;

    public VCOElm(int n, int n2) {
        super(n, n2);
    }

    public VCOElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
    }

    String getChipName() {
        return "VCO";
    }

    void setupPins() {
        this.sizeX = 2;
        this.sizeY = 4;
        this.pins = new ChipElm.Pin[6];
        this.pins[0] = new ChipElm.Pin(0, 2, "Vi");
        this.pins[1] = new ChipElm.Pin(3, 2, "Vo");
        this.pins[1].output = true;
        this.pins[2] = new ChipElm.Pin(0, 3, "C");
        this.pins[3] = new ChipElm.Pin(1, 3, "C");
        this.pins[4] = new ChipElm.Pin(2, 3, "R1");
        this.pins[4].output = true;
        this.pins[5] = new ChipElm.Pin(3, 3, "R2");
        this.pins[5].output = true;
    }

    boolean nonLinear() {
        return true;
    }

    void stamp() {
        sim.stampVoltageSource(0, this.nodes[1], this.pins[1].voltSource);
        sim.stampVoltageSource(this.nodes[0], this.nodes[4], this.pins[4].voltSource, 0.0);
        sim.stampVoltageSource(0, this.nodes[5], this.pins[5].voltSource, 5.0);
        sim.stampResistor(this.nodes[2], this.nodes[3], 1000000.0);
        sim.stampNonLinear(this.nodes[2]);
        sim.stampNonLinear(this.nodes[3]);
    }

    void doStep() {
        int n;
        double d = this.volts[3] - this.volts[2];
        double d2 = this.volts[1];
        int n2 = n = d2 < 2.5 ? 1 : -1;
        if (d2 < 2.5 && d > 4.5) {
            d2 = 5.0;
            n = -1;
        }
        if (d2 > 2.5 && d < 0.5) {
            d2 = 0.0;
            n = 1;
        }
        sim.updateVoltageSource(0, this.nodes[1], this.pins[1].voltSource, d2);
        int n3 = VCOElm.sim.nodeList.size() + this.pins[4].voltSource;
        int n4 = VCOElm.sim.nodeList.size() + this.pins[5].voltSource;
        sim.stampMatrix(this.nodes[2], n3, n);
        sim.stampMatrix(this.nodes[2], n4, n);
        sim.stampMatrix(this.nodes[3], n3, -n);
        sim.stampMatrix(this.nodes[3], n4, -n);
        this.cDir = n;
    }

    void computeCurrent() {
        double d = (double)this.cDir * (this.pins[4].current + this.pins[5].current) + (this.volts[3] - this.volts[2]) / 1000000.0;
        this.pins[2].current = -d;
        this.pins[3].current = d;
        this.pins[0].current = -this.pins[4].current;
    }

    void draw(Graphics graphics) {
        this.computeCurrent();
        this.drawChip(graphics);
    }

    int getPostCount() {
        return 6;
    }

    int getVoltageSourceCount() {
        return 3;
    }

    int getDumpType() {
        return 158;
    }
}

