; PICula project
; Copyright (c) 2010 Istvan Cserny (cserny@atomki.hu)
;
; Ez a header llomny gondoskodik a RESET s az interupt vektorok
; thelyezsrl s a hardver absztrakcirl 
;
;=== BECSATOLSOK  ====================================================
#include <p18cxxx.inc> 	

;=== KONFIGURCIS BITEK BELLTSA ===================================

	 
;=== VEKTOROK THELYEZSE =============================================
; Ha a felhasznli programban hasznlja a programmegszaktsokat, akkor
; a program legelejn definilni kell az "USE_INTERRUPT" szimblumot
; s gondoskodni kell a programmegszaktsokat kiszolgl eljrsokrl
; hi_isr s lo_isr nev belpsi pontokkal!
; 
; Ha a USE_INTERRUPT szimblum nincs definilva, akkor az albbi kd
; egy-egy "return" utastst rak be az interrupt vektorok helyre, ami
; egy vletlenl elszabadult s lekezeletlen programmegszakts
; esetn visszatr a fprogramhoz, de letiltva hagyja a 
; programmegszaktst. 
;----------------------------------------------------------------------
RST     CODE
        goto   main      ; RESET vektor: ugrs a fprogramhoz
        fill   0,4
  #IFDEF USE_INTERRUPT
        extern hi_isr    ; Magas priorits interrupt vektor:
        goto   hi_isr	 ; ugrs az interrupt kiszolgl eljrshoz
  #ELSE
	return           ; Letiltva hagyjuk az interruptot!!!
        nop
  #ENDIF		
        fill 0,0xc
  #IFDEF USE_INTERRUPT
        extern lo_isr    ; Alacsony priorits interrupt vektor:
        goto lo_isr      ; ugrs az interrupt kiszolgl eljrshoz
  #ELSE
	return           ; Letiltva hagyjuk az interruptot!!!
  #ENDIF		

;=== DEFINCIK =======================================================
#ifdef __18F4520
  #define LEDport LATB
  #define LEDtris TRISB
  #define LED1 LATB,LATB0
  #define LED2 LATB,LATB1
  #define LED3 LATB,LATB2
  #define LED4 LATB,LATB3
  #DEFINE SW1  PORTA,RA4 
  #DEFINE SW2  PORTB,RB0 
  #DEFINE SW3  PORTE,RE3 
#else 
   error "A vlasztott mikrovezrl tpust nem tmogatja a PICULA project!" 
#endif
