/* PICula project
 * Copyright (c) 2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#ifndef PICULA_4520_H
#define PICULA_4520_H

/** \file
 *  Ebben a header llomnyban a PIC18F4520 alap DB-DP113 ksrleti ramkr
 *  (SURE Electronics) hardver sajtossgait definiljuk. 
 *  A konfigurcis bitek belltsaira csak abban az esetben van tnyleges 
 *  szksgnk, ha nem hasznlunk bootloadert.
 *  Bootloaderes betltsnl ugyanis a konfigurcis biteket nem rjuk fell, a
 *  bootloaderrel egytt begetett konfigurcis bellts marad rvnyben.
 */  

    /*****************************************************************/
    /*** HARDVER belltsi opcik PIC18F4520 mintaramkrhz *******/
    /*****************************************************************/
		
	/*   KONFIGURCIS BITEK *****************************************/
    #if defined(PICULA_ALL)	                    // Csak a fprogramhoz csatoljhatuk!
		#pragma config OSC      = HS        // HS oszcilltor (20 MHz)
		#pragma config FCMEN    = ON        // Fail Safe Clock Monitor engedlyezve
		#pragma config IESO     = ON        // Bels/kls oszcilltor vlts engedlyezve
		#pragma config PWRT     = ON        // Bekapcsolskor 62 ms vrakozs
		#pragma config BOREN    = SBORDIS   // Brown our Reset engedlyezve
		#pragma config BORV     = 1         // Reset szint = 4.2 V
		#pragma config WDT      = OFF       // Watchdog timer letiltva
		#pragma config WDTPS    = 256       // Watchdog utszmll belltsa
		#pragma config MCLRE    = ON        // MCLR (reset) bemenet engedlyezve
		#pragma config LPT1OSC  = OFF       // T1OSC nagyobb teljestmny zemmd
		#pragma config PBADEN   = OFF       // PORTB<4:0> digitlis I/O-knt inicializldik
		#pragma config CCP2MX   = PORTC     // RC1 legyen a CCP2 kimenete
		#pragma config STVREN   = ON        // A verem tlcsordulsa RESET-et okoz
		#pragma config LVP      = OFF       // Alacsonyfeszltsg programozs letiltva
		#pragma config XINST    = OFF       // Extended Instruction Set letiltva
		#pragma config DEBUG    = OFF       // Httr nyomkvets letiltva, RB6/7 norml I/O
		#pragma config CP0      = OFF       // Kdvdelem kikapcsolva
		#pragma config CP1      = OFF
		#pragma config CP2      = OFF
		#pragma config CP3      = OFF
		#if defined(USE_BOOTLOADER)     
		    #pragma config CPB      = ON    // Boot Blokk kdvdelem bekapcsolva
		#else 
		    #pragma config CPB      = OFF   // Boot Blokk kdvdelem kikapcsolva
		#endif
		#pragma config CPD      = OFF
		#pragma config WRT0     = OFF       // rsvdelem kikapcsolva
		#pragma config WRT1     = OFF
		#pragma config WRT2     = OFF
		#pragma config WRT3     = OFF
		#if defined(USE_BOOTLOADER)
		    #pragma config WRTB     = ON    // Boot Blokk rsvdelem bekapcsolva
		#else
		    #pragma config WRTB     = OFF   // Boot Blokk rsvdelem kikapcsolva
		#endif
		#pragma config WRTC     = OFF
		#pragma config WRTD     = OFF
		#pragma config EBTR0    = OFF       // Tblzatolvass ne legyen letiltva
		#pragma config EBTR1    = OFF
		#pragma config EBTR2    = OFF
		#pragma config EBTR3    = OFF
		#pragma config EBTRB    = OFF       //Boot blokk tblaolvass ne legyen letiltva
    #endif

	
    /*******************************************************************/
    /******** ramkri hardver elemek definilsa **********************/
    /*******************************************************************/
    #define CLOCK_FREQ 20000000

    /** LED-ek  ********************************************************/
    #define mInitAllLEDs()      { LATB |= 0x0F; TRISB &= 0xF0; }  
    #define LEDport LATB
    #define LEDtris TRISB   
    #define mLED_1              LATBbits.LATB0
    #define mLED_2              LATBbits.LATB1
    #define mLED_3              LATBbits.LATB2
    #define mLED_4              LATBbits.LATB3
    
    #define mGetLED_1()         mLED_1
    #define mGetLED_2()         mLED_2
    #define mGetLED_3()         mLED_3
    #define mGetLED_4()         mLED_4

    #define mLED_1_On()         mLED_1 = 0;
    #define mLED_2_On()         mLED_2 = 0;
    #define mLED_3_On()         mLED_3 = 0;
    #define mLED_4_On()         mLED_4 = 0;
    
    #define mLED_1_Off()        mLED_1 = 1;
    #define mLED_2_Off()        mLED_2 = 1;
    #define mLED_3_Off()        mLED_3 = 1;
    #define mLED_4_Off()        mLED_4 = 1;
    
    #define mLED_1_Toggle()     mLED_1 = !mLED_1;
    #define mLED_2_Toggle()     mLED_2 = !mLED_2;
    #define mLED_3_Toggle()     mLED_3 = !mLED_3;
    #define mLED_4_Toggle()     mLED_4 = !mLED_4;
    
    /** SWITCH *********************************************************/
    #define mInitSwitch1()      TRISAbits.TRISA4=1;
    #define SW1                 PORTAbits.RA4
    #define mInitSwitch2()      TRISBbits.TRISB0=1;
    #define SW2                 PORTBbits.RB0    
    #define mInitSwitch3()      TRISEbits.TRISE3=1;
    #define SW3                 PORTEBbits.RE3      

    /** I/O pin definitions ********************************************/
    #define INPUT_PIN 1
    #define OUTPUT_PIN 0

    /** POT ************************************************************/
    #define mInitPOT()          {TRISAbits.TRISA0=1;    \
                                 ADCON0=0x01;           \
                                 ADCON2=0x3C;           \
                                 ADCON2bits.ADFM = 1;}	// AN0 on RA0	

   /** ANALOG CSATORNK tiltsa/engedlyezse **************************/
   #define DISABLE_ALL_ANALOG() {CMCON  = 0b00000111;  ADCON1 = 0b00001111; } 
   #define ENABLE_ONE_ANALOG()  {CMCON  = 0b00000111;  ADCON1 = 0b00001110; } 
   #define ENABLE_TWO_ANALOG()  {CMCON  = 0b00000111;  ADCON1 = 0b00001101; } 
#endif  
/** EOF PICULA-4550.H *************************************************/
