/* PICula project
 * Copyright (c) 2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

/** \file
 *  Ebben a header llomnyban konfigurlhatja a bootloader s az USB-USART kapcsolat
 *  hasznlatval kapcsolatosos legfontosabb belltsokat. 
 *
 *  - <b>USE_USART:</b> Akkor definiljuk, ha hasznlni kvnjuk az USB-USART kapcsolatot (\ref picula_config.h 
 *    llomnyban vagy az MPLAB IDE Project/Build Options/Project menjben definilhatjuk)
 *
 *  - <b>USE_INTERRUPT:</b> Akkor definiljuk, ha hasznlni kvnjuk a programmegszaktst 
 *    (vagy a \ref picula_config.h llomnyban, vagy az MPLAB IDE Project/Build Options/Project 
 *    menben definilhatjuk). <b>Figyelem! Programmegszakts esetn gondoskodnunk kell a magas s az 
 *    alacsony priorits interruptok kiszolglst ellt hi_isr() s lo_isr() eljrsokrl!</b>  
 *    Ha az USE_USART s az USE_INTERRUPT szimblumok definilva vannak, akkor gondoskodnunk kell
 *    arrl is, hogy az alacsony szint megszaktsbl meghvjuk az USARTDeviceTasks() eljrst is.
 *    Ha csak az USE_USART szimblum van definilva, a USE_INTERRUPT pedig nem, akkor pedig a
 *    fprogrambl kell rendszeresen hvogatni az USARTDeviceTasks() eljrst (karakterkirs vagy
 *    karakterre vrs kzben ez automatikusan teljesl). A \ref hello-int.c mintaprogramban lthat, 
 *    hogy az USART perifria interruptos kiszolglsa hogyan vgezhet. A \ref hello-poll.c mintaprogram
 *    pedig a lekrdezses md kezelsre mutat pldt.
 *
 *  - <b>Blinking_at_start:</b> azt engedlyezhetjk vele, hogy LED4 jelezze a program futst. 
 *    A lehetsges rtkek: 0 = tilts, 1 = engedlyezs. (Jelenleg mg nincs implementlva!)
 * 
 *  - <b>USE_BOOTLOADER:</b> Akkor definiljuk, ha a bootloadert hasznljuk (vagy a \ref picula_config.h  
 *    llomnyban, vagy az MPLAB IDE Project/Build Options/Project menpontjban definilhatjuk). 
 *    Ezzel szinkronban a linker programnak (MPLINK) is t kell adni a USE_BOOTLOADER szimbolumot 
 *    (a parancssori /uUSE_BOOTLOADER opci megadsa a Project/Build Options/Project menben, MPLINK 
 *    belltsainak lapjn trtnhet).
 *   
 */

#ifndef PICULA_CONFIG
#define PICULA_CONFIG 

/*** USB-USART hasznlat  **************************************************/
//-- Aktivlja a kvetkez sort az USB-USART kapcsolat hasznlathoz! -------
//#define USE_USART

/*** Interrupt hasznlat  ********************************************/
//-- Aktivlja az albbi defincit a programmegszaktsok hasznlathoz! 
//#define USE_INTERRUPT 

/*** Heartbeat LED engedlyezse ************************************/
// A Blinking_at_start szimblum lehetleg legyen mindig definlva,  
// csupn az rtkt (0 vagy 1) mdostsa, szksg szerint! 
// 1: Engedlyezi, hogy LED4 jelezze, hogy fut a program
// 0: Tiltja, hogy LED4 jelezze, hogy fut a program
#define Blinking_at_start 1

/* BOOTLOADER *********************************************************
* Az itteni defincival szinkronban a Linker szmra is definilja
* az USE_BOOTLOADER szimblumot az MPLAB
* Project/Build options/Project menpontban az MPLINK Linker flre
* kattintva, s az Use Alternate Settings kivlasztsa utn, /u kapcsolval!  
**********************************************************************/
//--- Aktivlja az albbi sort a BOOTLOADER hasznlathoz
//#define USE_BOOTLOADER

/*  A HARDVERSPECIFIKUS DEFINCIK BECSATOLSA ***********************/
#if defined(__18F4520)
  #include "p18f4520.h"	
  #include "picula-4520.h"
#elif defined(__18F2420)
  #include "p18f2420.h"	
  #include "picula-2420.h"  
#else
   #error "A vlasztott mikrovezrlt nem tmogatja a PICULA projekt!"  
#endif


#endif
/*** EOF PICULA-CONFIG.H ********************************************/