/* PICula project
 * Copyright (c) 2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

/** \file
 *  Ez az llomny deklarlja azokat a fggvnyeket, amelyekkel az
 *  alkalmazi programbl az USB-USART kapcsolat kezelhetjk. Ezt az llomnyt
 *  a programjainkba kzvetlenl nem kell becsatolnunk. Ha definiltuk
 *  az USE_USART szimblumot, akkor a \ref picula_all.h llomnyban elhelyezett
 *  feltteles fordtsi direktvk gondoskodnak az automatikus becsatolsrl.
 *
 *  Megjegyzs: Ez az llomny automatikusan becsatolja az MCC18 fejleszti
 *  krnyezethez tartoz stdio.h llomnyt is.
 *
 *  \see picula_usb.c a tovbbi rszletekrt.
 */

#ifndef PICULA_USART
#define PICULA_USART
#include  <stdio.h>

//-- Baudrate setting for Fcy=20 MHz, BRGH=1, BRG16=1
#define BPS_300		16666
#define BPS_600		8332
#define BPS_1200	4166
#define BPS_2400	2082
#define BPS_4800	1041
#define BPS_9400	520
#define BPS_19200	259
#define BPS_38400	129
#define BPS_57600	86
#define BPS_115200	42
#define BPS_230400	21
#define BPS_250000	19
#define BPS_460800	10
#define BPS_500000	9
#define BPS_614400	7

extern FILE stdin;

/* FGGVNY PROTOTPUSOK *********************************************/

void InitializeSystem(unsigned int usart_baud);  /**< Rendszer inicializlsa (USART csatlakoztats) **/
void USARTDeviceTasks(void);    /**< USART kezelse (interrupt vagy polling) */
int _usart_putc(char c);       /**< Egy karakter kirsa soros porton keresztl */
void outString(const rom char* psz_s); /**< Karakterfzr kiratsa */
char _usart_getc(void);      /**< Egy karakter beolvassa soros portrl */
void outdec(long data, unsigned int ndigits); /**< Decimlis kirats adott szm tizedesjegyre */
void out4hex(unsigned int t); /**< Egy 16 bites szm kirsa hexadecimlisan */
unsigned int get4hex(void);   /**< Ngyjegy hexadecimlis szm beolvassa */ 
unsigned char get2hex(void);  /**< Ktjegy hexadecimlis szm beolvassa */
void delay_ms(unsigned int d); /**< Ksleltet eljrs, ami USARTDeviceTasks()-ot is rendszeresen meghvja */
char getc(FILE *f);
unsigned int ReadPOT(void);            // Analg jel mrse (potmter)

#define getchar() getc(stdin); 
#define putchar(x) putc(x,stdout); 
#endif //PICULA_USART