//;****************************************************************
//;*  Name    : rlight.c
//;*  Author  : DV Electronics
//;*  Notice  : Copyright (c) 2010 DV Electronics
//;*          : All Rights Reserved
//;*  Date    : 12/12/2010
//;*  Version : 1.0
//;*  Notes   : Runin' Light
//;*		  : 
//;*		  : 
//;*  Processor : 16F684      INT OSC
//;*  Compiler  : CCS C
//;*****************************************************************/

#include <16F684.h>
#fuses  INTRC_IO,NOWDT,PUT,NOMCLR,NOPROTECT
#DEVICE ADC=8  
#use delay(clock=4000000)
#use fast_io(C)



#BYTE RTCC = 0x01
#BYTE port_a = 5
#BYTE port_c = 7
#BYTE option_r = 0x81
#BYTE tris_a = 0x85
#BYTE tris_c = 0x87
#BYTE INTCON = 0x0B



#define L_TIME              50
#define SEC_TIME            50
#define I_TIME              78
//;*****************************************************************/



int1 sample;
int l_tick;
int t_cnt ;
long sec_1 ;
long value;




//;*****************************************************************/
#int_rtcc                           // This function is called every time
									// the RTCC (timer0) overflows (255->0).
                                    // For this program this is apx 50 times
                                    // per second.

void clock_isr() 
	{               					   
		RTCC = 0xff-I_TIME;
		sec_1--;	
		if(!sec_1)
		{
			sec_1=value+1;
			t_cnt++;
			if (t_cnt==18) t_cnt=0;
		}
		l_tick++;
		if(l_tick==L_TIME)
		{
			sample=1;
			l_tick=0;
		}

	}



//;*****************************************************************/
	
#zero_ram
void main() 
{
	RTCC =0xff-I_TIME;
	setup_timer_0( RTCC_INTERNAL| RTCC_DIV_256 );	
	sec_1=SEC_TIME;								
	setup_port_a(sAN0);
	setup_adc(adc_clock_internal);
	set_adc_channel( 0 );
	sec_1=1;
	port_c=0;
	tris_c=0b11110000;
	INTCON=0;
	enable_interrupts(INT_RTCC);
	enable_interrupts(GLOBAL);	
	while( TRUE ) 
	{
		if(sample)
		{
 			value=read_adc();	//read pot @ AN0
 			sample=0;
 		}		
		switch(t_cnt)			//Write port_c 
		{
			case 1:		port_c=0b00000001;
						break;
			case 3:		port_c=0b00000010;
						break;
			case 5:		port_c=0b00000100;
						break;
			case 7:		port_c=0b00001000;
						break;
			case 9:	
			case 10:		
			case 11:		
			case 13:		
			case 15:		
			case 17:	port_c=0b00001111;
						break;
							
			default:	port_c=0;
		}
	}
}

//;*****************************************************************/