unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Buttons, ExtDlgs, StdCtrls, ComCtrls, ComDrv32, fftunit;

const dn= 128;

type
  TForm1 = class(TForm)
    Image1: TImage;
    Bevel1: TBevel;
    Bevel2: TBevel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SavePictureDialog1: TSavePictureDialog;
    SpeedButton3: TSpeedButton;
    Bevel3: TBevel;
    Label1: TLabel;
    Bevel4: TBevel;
    Bevel5: TBevel;
    Label2: TLabel;
    ComboBox1: TComboBox;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    Bevel6: TBevel;
    Bevel7: TBevel;
    Label3: TLabel;
    StaticText1: TStaticText;
    TrackBar1: TTrackBar;
    Bevel8: TBevel;
    Bevel9: TBevel;
    Label4: TLabel;
    StaticText2: TStaticText;
    TrackBar2: TTrackBar;
    Label5: TLabel;
    Bevel10: TBevel;
    Bevel11: TBevel;
    StaticText3: TStaticText;
    tgrLed: TImage;
    runLed: TImage;
    preLed: TImage;
    Label6: TLabel;
    Bevel12: TBevel;
    Image2: TImage;
    Label7: TLabel;
    Label8: TLabel;
    CommPortDriver: TCommPortDriver;
    Label10: TLabel;
    Bevel13: TBevel;
    Bevel14: TBevel;
    TrackBar3: TTrackBar;
    TrackBar4: TTrackBar;
    Memo1: TMemo;
    TrackBar5: TTrackBar;
    TrackBar6: TTrackBar;
    StaticText4: TStaticText;
    StaticText5: TStaticText;
    StaticText6: TStaticText;
    StaticText7: TStaticText;
    StaticText8: TStaticText;
    StaticText9: TStaticText;
    StaticText10: TStaticText;
    StaticText11: TStaticText;
    Label9: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    StaticText12: TStaticText;
    Bevel15: TBevel;
    Image3: TImage;
    Label13: TLabel;
    Bevel16: TBevel;
    ScrollBar1: TScrollBar;
    ScrollBar2: TScrollBar;
    Label14: TLabel;
    Label15: TLabel;
    StaticText13: TStaticText;
    Bfft: TImage;
    Toff: TImage;
    Ton: TImage;
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure Timer;
    procedure FormDestroy(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    function triggerstatus (status: char) : integer;
    procedure proccessidle (c:char);
    procedure proccesspret ;
    procedure proccesstrig ;
    procedure proccessrunn (c:char) ;
    procedure proccessfinn ;
    procedure adddata (c:char);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CommPortDriverReceiveData(Sender: TObject; DataPtr: Pointer;
      DataSize: Integer);
    procedure ScrollBar1Change(Sender: TObject);
    procedure ScrollBar2Change(Sender: TObject);
    procedure TrackBar3Change(Sender: TObject);
    procedure TrackBar4Change(Sender: TObject);
    procedure TrackBar5Change(Sender: TObject);
    procedure TrackBar6Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    ss , txts , isf ,rsf : boolean ;
    bmp: TBitmap ;
    ts,hs,vs,trigger,fftg,fftc,vc1,vc2,hc1,hc2:integer;
    sbyte : char;
    scrarray : array[0..239] of byte;
    datacount : integer;

    xstart, xslut, mx, my : integer;
    offset : integer;
    tr, ti : realarray;

  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


function TForm1.triggerstatus (status: char) : integer;
var trig : integer;
begin
  // trigger  1=idle
  // trigger  2=pre-triggering
  // trigger  3=triggering
  // trigger  4=running
  // trigger  5=end

  if status='I' then
    begin
      preLed.Visible := false;
      tgrLed.Visible := false;
      runLed.Visible := false;
      Label6.Caption := 'Idle...';
      trig := 1;
    end;
  if status='P' then
    begin
      preLed.Visible := true;
      tgrLed.Visible := false;
      runLed.Visible := false;
      Label6.Caption := 'Pre-Triggering...';
      trig := 2;
    end;
  if status='T' then
    begin
      preLed.Visible := false;
      tgrLed.Visible := true;
      runLed.Visible := false;
      Label6.Caption := 'Triggering...';
      trig := 3;
    end;
  if status='R' then
    begin
      preLed.Visible := false;
      tgrLed.Visible := false;
      runLed.Visible := true;
      Label6.Caption := 'Running...';
      trig := 4;
    end;
  if status='F' then
    begin
      preLed.Visible := false;
      tgrLed.Visible := false;
      runLed.Visible := true;
      Label6.Caption := 'Waiting...';
      trig := 5;
    end;


  Result := trig ;
end;

procedure TForm1.proccessidle (c:char);
var cc:char;
begin
  trigger:=triggerstatus('I');

//  cc := chr(lo(ts)) ;
//  CommPortDriver.SendData( @cc, length(cc));
  ts := ord(c);
  StaticText3.Caption := inttostr ( ts );

  case vs of
   0: StaticText12.Caption := FloatToStrF (ts*0.5/255,ffFixed,4,2)+'V';
   1: StaticText12.Caption := FloatToStrF ( ts*5/255,ffFixed,4,2 )+'V';
   2: StaticText12.Caption := FloatToStrF ( ts*10/255,ffFixed,4,2 )+'V';
   3: StaticText12.Caption := FloatToStrF ( ts*20/255 ,ffFixed,4,2)+'V';
  end;

  cc := chr(lo(vs)) ;
  CommPortDriver.SendData( @cc, length(cc));
  cc := chr(lo(hs)) ;
  CommPortDriver.SendData( @cc, length(cc));
  datacount := 0;
  trigger := 0;
  
end;

procedure TForm1.proccesspret ;
begin
  trigger:=triggerstatus('P');
  trigger := 0;
end;

procedure TForm1.proccesstrig ;
begin
  trigger:=triggerstatus('T');
  trigger := 0;
end;

procedure TForm1.Timer;
var i:integer;
begin
LockWindowUpdate(Form1.Handle); {Desactiva la actualizacin visual del form}
  bmp.canvas.brush.style := bsSolid;
  if ss then bmp.Canvas.Brush.Color := clWhite
     else bmp.Canvas.Brush.Color := clBlack;
  bmp.Canvas.FillRect(rect(0,0,240,256));

  if txts then
   begin
     bmp.Canvas.pen.Color := clblue ;
     bmp.Canvas.MoveTo(0,255-vc1);
     bmp.Canvas.LineTo(239,255-vc1);
     bmp.Canvas.MoveTo(0,255-vc2);
     bmp.Canvas.LineTo(239,255-vc2);
     statictext6.caption := inttostr(vc1);
     statictext8.caption := inttostr(vc2);
     statictext10.caption := inttostr(vc1-vc2);
     bmp.Canvas.MoveTo(hc1,0);
     bmp.Canvas.LineTo(hc1,255);
     bmp.Canvas.MoveTo(hc2,0);
     bmp.Canvas.LineTo(hc2,255);
     statictext7.caption := inttostr(hc1);
     statictext9.caption := inttostr(hc2);
     statictext11.caption := inttostr(hc1-hc2);
     bmp.Canvas.pen.Color := clGray ;
     bmp.Canvas.Font.Color := clGray ;
     bmp.Canvas.MoveTo(0,63);
     bmp.Canvas.LineTo(239,63);
     bmp.Canvas.MoveTo(0,127);
     bmp.Canvas.LineTo(239,127);
     bmp.Canvas.MoveTo(0,191);
     bmp.Canvas.LineTo(239,191);
     bmp.Canvas.MoveTo(63,0);
     bmp.Canvas.LineTo(63,255);
     bmp.Canvas.MoveTo(127,0);
     bmp.Canvas.LineTo(127,255);
     bmp.Canvas.MoveTo(191,0);
     bmp.Canvas.LineTo(191,256);
     bmp.Canvas.TextOut ( 0,64,'192');
     bmp.Canvas.TextOut ( 0,128,'128');
     bmp.Canvas.TextOut ( 0,192,'64');
     bmp.Canvas.TextOut ( 50,242,'64');
     bmp.Canvas.TextOut ( 108,242,'128');
     bmp.Canvas.TextOut ( 172,242,'192');
     bmp.Canvas.TextOut ( 1,1,StaticText1.Caption);
     bmp.Canvas.TextOut ( 1,242,'0');
     case hs of
       0: bmp.Canvas.TextOut ( 205,242,'2.4 ms');
       1: bmp.Canvas.TextOut ( 205,242,'4.8 ms');
       2: bmp.Canvas.TextOut ( 205,242,' 12 ms');
       3: bmp.Canvas.TextOut ( 205,242,' 24 ms');
       4: bmp.Canvas.TextOut ( 207,242,' 48 ms');
       5: bmp.Canvas.TextOut ( 209,242,'120 ms');
       6: bmp.Canvas.TextOut ( 209,242,'240 ms');
    end;
   end;

  if ss then bmp.Canvas.pen.Color := clBlack
     else bmp.Canvas.pen.Color := clLime;

  for i:=1 to 239 do
   begin
    bmp.Canvas.MoveTo(i-1,255-scrarray[i-1]);
    bmp.Canvas.lineTo(i,255-scrarray[i]);
   end;

  bmp.Canvas.pen.Color := clRed ;
  bmp.Canvas.MoveTo(0,255-(ts));
  bmp.Canvas.lineTo(8,255-(ts));
  bmp.Canvas.pen.Color := clGray ;

  Image1.Picture.Bitmap.Assign(bmp);

  for i:=0 to 128 do
     begin
         ti[i] := 0;
         tr[i] :=  scrarray[i] ;
     end;
  fr := tr;
  fi := ti;
  fft(fr, fi, 7, -1) ;
 Image3.Picture.Bitmap.Assign(Bfft.Picture.Bitmap);
 Image3.Picture.Bitmap.Canvas.MoveTo(0,0);
 Image3.Picture.Bitmap.Canvas.pen.Color := clLime;
  tr := fr;
  ti := fi;
  for i:=0 to 64 do
   Image3.Picture.Bitmap.Canvas.LineTo(i,64-round(sqrt(tr[i]*tr[i]+ti[i]*ti[i])/fftg));

 Image3.Picture.Bitmap.Canvas.pen.Color := clWhite;
 Image3.Picture.Bitmap.Canvas.MoveTo(0,0);
 Image3.Picture.Bitmap.Canvas.MoveTo(fftc,70-round(sqrt(tr[fftc]*tr[fftc]+ti[fftc]*ti[fftc])/fftg));
 Image3.Picture.Bitmap.Canvas.LineTo(fftc,58-round(sqrt(tr[fftc]*tr[fftc]+ti[fftc]*ti[fftc])/fftg));

     case hs of
       0:  StaticText13.Caption := inttostr(round(sqrt(tr[fftc]*tr[fftc]+ti[fftc]*ti[fftc])))+' '+inttostr(round( fftc/(128*10.4E-6)))+'H';
       1:  StaticText13.Caption := inttostr(round(sqrt(tr[fftc]*tr[fftc]+ti[fftc]*ti[fftc])))+' '+inttostr(round( fftc/(128*20.5E-6)))+'H';
       2:  StaticText13.Caption := inttostr(round(sqrt(tr[fftc]*tr[fftc]+ti[fftc]*ti[fftc])))+' '+inttostr(round( fftc/(128*50E-6)))+'H';
       3:  StaticText13.Caption := inttostr(round(sqrt(tr[fftc]*tr[fftc]+ti[fftc]*ti[fftc])))+' '+inttostr(round( fftc/(128*100E-6)))+'H';
       4:  StaticText13.Caption := inttostr(round(sqrt(tr[fftc]*tr[fftc]+ti[fftc]*ti[fftc])))+' '+inttostr(round( fftc/(128*200E-6)))+'H';
       5:  StaticText13.Caption := inttostr(round(sqrt(tr[fftc]*tr[fftc]+ti[fftc]*ti[fftc])))+' '+inttostr(round( fftc/(128*500E-6)))+'H';
       6:  StaticText13.Caption := inttostr(round(sqrt(tr[fftc]*tr[fftc]+ti[fftc]*ti[fftc])))+' '+inttostr(round( fftc/(128*1E-3)))+'H';
    end;
 LockWindowUpdate(0);            {La vuelve a activar}

end;


procedure Tform1.adddata (c:char);
var i:integer ;
begin
    scrarray[datacount] := ord( c);
    datacount := datacount +1 ;
end;

procedure TForm1.proccessrunn (c:char);
begin
  trigger:=triggerstatus('R');
  adddata ( c ) ;
  if datacount = 240 then
   begin
      datacount := 0 ;
      trigger := 0;
      timer ;
   end;
end;

procedure TForm1.proccessfinn ;
begin
  trigger:=triggerstatus('F');
  trigger := 0;
end;


procedure TForm1.FormCreate;
var i:integer;
begin
 ss:= false;
 txts := true;
 bmp := TBitmap.Create ;
 bmp.Assign (Image1.Picture.bitmap);
 ts := 127 ;
 hs := 3;
 vs := 1;
 ComboBox1.ItemIndex := 1;
 trigger := 0;
 for i:=0 to 239 do  scrarray[i] := 0 ;

  mx := 128;
  my := 256;
  divN := 1/sqrt(7*1.0)  ;
  fftg := 1 ;
  fftc := 1 ;
  trigger := 0 ;
//   SetPriorityClass(GetCurrentProcess, REALTIME_PRIORITY_CLASS);
//   SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_TIME_CRITICAL);

end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  ss := not ss ;
end;



procedure TForm1.FormDestroy(Sender: TObject);
begin
 bmp.free ;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
 SavePictureDialog1.InitialDir := ExtractFilePath ( ParamStr(0) ) ;
 if SavePictureDialog1.Execute then
    Image1.Picture.Bitmap.SaveToFile ( SavePictureDialog1.filename );
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  if   txts then
    SpeedButton3.Glyph.Assign(ton.picture.bitmap)
  else
      SpeedButton3.Glyph.Assign(toff.picture.bitmap);
  txts := not txts ;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin

  CommPortDriver.ComPort := TComPortNumber(ord(ComboBox1.ItemIndex));
  CommPortDriver.ComPortSpeed := br19200 ;
  if CommPortDriver.Connect then
  begin
    SpeedButton4.Enabled := false ;
    SpeedButton5.Enabled := true ;
    Form1.Caption :=' JAL Scope ['+ComboBox1.text+']' ;
    ShowMessage('Reset the PIC now.');
  end
  else // Error !
    begin
      Form1.Caption := 'Error: could not connect. Check COM port settings and try again.';
      MessageBeep( 0 );
    end;

end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
 CommPortDriver.Disconnect;
 Form1.Caption :=' JAL Scope';
 SpeedButton5.Enabled := false ;
 SpeedButton4.Enabled := true ;

end;

procedure TForm1.TrackBar2Change(Sender: TObject);
begin
  hs := TrackBar2.Position ;
  case hs of
   0: StaticText2.Caption := '10 us';
   1: StaticText2.Caption := '20 us';
   2: StaticText2.Caption := '50 us';
   3: StaticText2.Caption := '100 us';
   4: StaticText2.Caption := '200 us';
   5: StaticText2.Caption := '500 us';
   6: StaticText2.Caption := '1 ms';
  end;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  vs := TrackBar1.Position ;
  case vs of
   0: StaticText1.Caption := '0.5 V';
   1: StaticText1.Caption := '5 V';
   2: StaticText1.Caption := '10 V';
   3: StaticText1.Caption := '20 V';
  end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
//   SetPriorityClass(GetCurrentProcess, NORMAL_PRIORITY_CLASS);
//   SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_NORMAL);
 CommPortDriver.Disconnect;
 Application.Terminate;         
end;

procedure TForm1.CommPortDriverReceiveData(Sender: TObject;
  DataPtr: Pointer; DataSize: Integer);
var p: pchar;
    s: string;

begin
  s := '';
  // Parse incoming text
  p := DataPtr;
  while DataSize > 0 do
  begin
if trigger = 0  then
begin
 case P^ of
 'I':trigger := 1 ;
 'P':trigger := 2 ;
 'T':trigger := 3 ;
 'R':trigger := 4 ;
 'F':trigger := 5 ;
 end ;
 dec( DataSize );
 inc( p );
end
else
begin
 case trigger of
 1:begin
    proccessidle (p^);
    dec( DataSize );
    inc( p );
   end;
 2:begin
   proccesspret;
   end;
 3:begin
   proccesstrig;
   end;
 4:begin
    proccessrunn (p^);
    dec( DataSize );
    inc( p );
   end;
 5:proccessfinn;
 end
end;
end;
end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
ScrollBar1.Hint := 'Gain: '+inttostr(ScrollBar1.Position);
Label14.Caption := 'G '+inttostr(ScrollBar1.Position);
fftg := ScrollBar1.Position ;
end;

procedure TForm1.ScrollBar2Change(Sender: TObject);
begin
ScrollBar2.Hint := 'Pos: '+inttostr(ScrollBar2.Position);
Label15.Caption := 'P '+inttostr(ScrollBar2.Position);
fftc := ScrollBar2.Position ;
end;

procedure TForm1.TrackBar3Change(Sender: TObject);
begin
vc1 := 255- TrackBar3.Position;
end;

procedure TForm1.TrackBar4Change(Sender: TObject);
begin
vc2 := 255- TrackBar4.Position;
end;

procedure TForm1.TrackBar5Change(Sender: TObject);
begin
hc1 := 240- TrackBar5.Position;
end;

procedure TForm1.TrackBar6Change(Sender: TObject);
begin
hc2 := 240- TrackBar6.Position;
end;

end.
