; compiler          : jal 00.04-40
; date              : 28-May-2002 18:31:40
; main source       : adc
; command line      : -casz -vtz -orsctd -s\JALCC\JAL\LIB adc.jal 
; target  chip      : 16f877
;         cpu       : pic 14
;         clock     : 20000000
; input   files     : 18
;         lines     : 3685
;         chars     : 95289
; compilation nodes : 20338
;             stack : 41Kb
;              heap : 6836Kb
;           seconds : 2.088 (1764 lines/second)
; output       code : 1634
;              page :    0 (0.0%)
;              bank :    0 (0.0%)
;         page+bank :    0 (0.0%)
;              file :   25
;              stack:    3 (3,0,0)

 errorlevel -306
 list p=PIC16f877

; note: the f877 config is still fixed!
 __CONFIG H'3F72' 
 ORG 0000
  goto    __main
 ORG 0004
 ORG 0004
_706__vector: ; 0004

;; 080 : operator << ( byte in a, byte in n ) return byte is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_706_shift_left
_3121__vector: ; 0007

;; 042 : procedure bank_0 is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_3121_bank_0
_3158__vector: ; 000A

;; 050 : procedure bank_1 is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_3158_bank_1
_3531__vector: ; 000D

;; 140 : procedure _trisa_flush is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_3531__trisa_flush
_3554__vector: ; 0010

;; 147 : procedure _trisb_flush is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_3554__trisb_flush
_3577__vector: ; 0013

;; 154 : procedure _trisc_flush is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_3577__trisc_flush
_3703__vector: ; 0016

;; 181 : procedure port_b_direction'put( byte in x at trisb ) is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_3703_put
_4023__vector: ; 0019

;; 220 : procedure pin_a4_direction'put( bit in d at trisa : 4 ) is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_4023_put
_4470__vector: ; 001C

;; 273 : procedure pin_c2_direction'put( bit in d at trisc : 2 ) is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_4470_put
_5852__vector: ; 001F

;; 433 : procedure _port_b_flush is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_5852__port_b_flush
_5875__vector: ; 0022

;; 436 : procedure _port_c_flush is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_5875__port_c_flush
_5975__vector: ; 0025

;; 449 : procedure port_b'put( byte in x at _port_b_buffer ) is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_5975_put
_7147__vector: ; 0028

;; 576 : procedure pin_c2'put( bit in x at _port_c_buffer : 2 ) is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_7147_put
_9490__vector: ; 002B

;; 230 : procedure _delay_100us( byte in x, byte in y, byte in z ) is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_9490__delay_100us
_9915__vector: ; 002E

;; 343 : procedure delay_1ms( byte in x = 1 ) is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_9915_delay_1ms
_12056__vector: ; 0031

;; 049 : procedure _file_get( byte in Haddr , byte in Laddr , byte out data ) is begin 
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_12056__file_get
_12112__vector: ; 0034

;; 059 : procedure _file_put( byte in Haddr , byte in Laddr , byte in data ) is begin 
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_12112__file_put
_12168__vector: ; 0037

;; 069 : procedure _file_bit_set ( byte in Haddr , byte in Laddr , byte in pos ) is begin 
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_12168__file_bit_set
_12809__vector: ; 003A

;; 083 : Procedure F877_serial_setup ( byte in BAUD_CONSTANT ) is begin
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_12809_f877_serial_setup
_13251__vector: ; 003D

;; 164 : Procedure F877_serial_recibe ( byte out data ) is begin
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_13251_f877_serial_recibe
_13303__vector: ; 0040

;; 171 : Procedure F877_serial_transmit ( byte in data ) is begin
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_13303_f877_serial_transmit
_13789__vector: ; 0043

;; 146 : procedure array1'put ( byte in data ) is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_13789_put
_13879__vector: ; 0046

;; 178 : function array1'get return byte is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_13879_get
_13962__vector: ; 0049

;; 211 : procedure array2'put ( byte in data ) is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_13962_put
_14052__vector: ; 004C

;; 243 : function array2'get return byte is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_14052_get
_14135__vector: ; 004F

;; 276 : procedure array3'put ( byte in data ) is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_14135_put
_14225__vector: ; 0052

;; 308 : function array3'get return byte is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_14225_get
_14335__vector: ; 0055

;; 013 : procedure adcf (byte out data ) is begin
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_14335_adcf
_14428__vector: ; 0058

;; 039 : procedure trigf (byte out data ) is begin
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_14428_trigf
_14527__vector: ; 005B

;; 067 : Procedure PWM  is begin   -- 1250 Hz -- 800us
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_14527_pwm
_14708__vector: ; 005E

;; 135 : procedure _delay_5uS is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_14708__delay_5us
_15211__vector: ; 0061

;; 003 : procedure mode1 is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_15211_mode1
_15566__vector: ; 0064

;; 108 : procedure mode2 is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_15566_mode2
_15957__vector: ; 0067

;; 218 : procedure mode3 is
  bcf     H'0A',3
  bcf     H'0A',4
  goto    p_15957_mode3
__interrupt: ; 006A
__main: ; 006A
; var H'020:000'  transfer_bit
; var H'021:000'  transfer_byte

;; 010 : var volatile byte port_a       at  5
; var H'005:000' port_a

;; 020 : var volatile bit  pin_a4 at port_a : 4
; var H'005:004' pin_a4

;; 059 : var volatile byte indf         at  0
; var H'000:000' indf

;; 062 : var volatile byte status       at  3
; var H'003:000' status

;; 064 : var volatile bit  status_c    at status : 0
; var H'003:000' status_c

;; 071 : var volatile bit  status_irp  at status : 7
; var H'003:007' status_irp

;; 073 : var volatile byte fsr          at  4
; var H'004:000' fsr

;; 109 : var volatile byte f877_PIR1     at 0x0C
; var H'00C:000' f877_pir1

;; 111 : var volatile bit  f877_TMR1IF   at f877_PIR1 : 0
; var H'00C:000' f877_tmr1if

;; 115 : var volatile bit  f877_TXIF     at f877_PIR1 : 4
; var H'00C:004' f877_txif

;; 116 : var volatile bit  f877_RCIF     at f877_PIR1 : 5
; var H'00C:005' f877_rcif

;; 127 : var volatile byte f877_TMR1L    at 0x0E
; var H'00E:000' f877_tmr1l

;; 128 : var volatile byte f877_TMR1H    at 0x0F
; var H'00F:000' f877_tmr1h

;; 130 : var volatile byte f877_T1CON    at 0x10
; var H'010:000' f877_t1con

;; 141 : var volatile byte f877_T2CON    at 0x12
; var H'012:000' f877_t2con

;; 164 : var volatile byte f877_CCPR1L   at 0x15
; var H'015:000' f877_ccpr1l

;; 167 : var volatile byte f877_CCP1CON  at 0x17
; var H'017:000' f877_ccp1con

;; 176 : var volatile byte f877_RCSTA    at 0x18
; var H'018:000' f877_rcsta

;; 182 : var volatile bit  f877_CREN     at f877_RCSTA : 4
; var H'018:004' f877_cren

;; 185 : var volatile bit  f877_SPEN     at f877_RCSTA : 7
; var H'018:007' f877_spen

;; 201 : var volatile byte f877_ADRESH   at 0x1E
; var H'01E:000' f877_adresh

;; 203 : var volatile byte f877_ADCON0   at 0x1F
; var H'01F:000' f877_adcon0

;; 246 : var volatile byte f877_PR2      at 0x92
; var H'092:000' f877_pr2

;; 260 : var volatile byte f877_TXSTA    at 0x98
; var H'098:000' f877_txsta

;; 264 : var volatile bit  f877_BRGH     at f877_TXSTA : 2
; var H'098:002' f877_brgh

;; 266 : var volatile bit  f877_TXEN     at f877_TXSTA : 5
; var H'098:005' f877_txen

;; 270 : var volatile byte f877_SPBRG    at 0x99
; var H'099:000' f877_spbrg

;; 274 : var volatile byte f877_ADCON1   at 0x9F
; var H'09F:000' f877_adcon1

;; 120 : var byte trisa
; var H'022:000' trisa

;; 121 : var byte trisb
; var H'023:000' trisb

;; 122 : var byte trisc
; var H'024:000' trisc

;; 123 : var byte trisd
; var H'025:000' trisd

;; 124 : var byte trise
; var H'026:000' trise

;; 128 : trisa = all_input
  movlw   H'FF'
  movwf   H'22'

;; 130 :    trisb = all_input
  movlw   H'FF'
  movwf   H'23'

;; 133 :    trisc = all_input
  movlw   H'FF'
  movwf   H'24'

;; 136 :    trisd = all_input
  movlw   H'FF'
  movwf   H'25'

;; 137 :    trise = 0x0F -- high nibble has other functions!
  movlw   H'0F'
  movwf   H'26'

;; 425 : var byte _port_b_buffer
; var H'027:000' _port_b_buffer

;; 426 : var byte _port_c_buffer
; var H'028:000' _port_c_buffer

;; 065 : var volatile byte array1_index at 0x7E
; var H'07E:000' array1_index

;; 066 : var volatile byte array2_index at 0x7D
; var H'07D:000' array2_index

;; 067 : var volatile byte array3_index at 0x7C
; var H'07C:000' array3_index

;; 010 : var byte cc0,stat,vts,vhs,vvs,machine   -- global variables
; var H'029:000' vts
; var H'02A:000' vhs
; var H'02B:000' vvs
; var H'02C:000' machine

;; 011 : var byte tmr1Htemp,tmr1Ltemp,tgrtemp    -- global variables
; var H'02D:000' tmr1htemp
; var H'02E:000' tmr1ltemp
; var H'02F:000' tgrtemp

;; 082 : port_b = 0
  movlw   H'00'
  bcf     H'0A',3
  bcf     H'0A',4
  call    _5975__vector

;; 083 : port_b_direction = all_output
  movlw   H'00'
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3703__vector

;; 084 : port_b = 0
  movlw   H'00'
  bcf     H'0A',3
  bcf     H'0A',4
  call    _5975__vector

;; 086 : pin_a4_direction = input
  bsf     H'22',4
  bcf     H'0A',3
  bcf     H'0A',4
  call    _4023__vector

;; 088 : 		Bank_1
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3158__vector

;; 089 : 		f877_ADCON1 = 0x00			;left justified & all analog inputs
  clrf    H'9F'

;; 090 : 		Bank_0
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3121__vector

;; 092 : delay_1ms ( 200 )
  movlw   H'C8'
  bcf     H'0A',3
  bcf     H'0A',4
  call    _9915__vector

;; 094 : pwm
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14527__vector

;; 096 : f877_serial_setup ( 192 )
  movlw   H'C0'
  bcf     H'0A',3
  bcf     H'0A',4
  call    _12809__vector

;; 103 : forever loop
w_16650_ag: ; 0096

;; 106 :   f877_serial_transmit ( "I" )
  movlw   H'49'
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector

;; 108 :   trigf ( tgrtemp )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14428__vector
  movf    H'30',w
  movwf   H'2F'

;; 109 :   vts = tgrtemp
  movf    H'2F',w
  movwf   H'29'

;; 110 :   f877_serial_transmit ( vts )
  movf    H'29',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector

;; 112 :   f877_serial_recibe ( vvs )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13251__vector
  movf    H'30',w
  movwf   H'2B'

;; 113 :   f877_serial_recibe ( vhs )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13251__vector
  movf    H'30',w
  movwf   H'2A'

;; 126 :   _file_bit_set ( 0x00 , 0x06 , vvs )
  clrf    H'30'
  movlw   H'06'
  movwf   H'31'
  movf    H'2B',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _12168__vector

;; 128 :     machine = "T"
  movlw   H'54'
  movwf   H'2C'

;; 129 :     f877_serial_transmit ( machine )
  movf    H'2C',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector

;; 140 :   if (vhs == 0) then  -- 30 us -> 10us
  movf    H'2A',f
  bcf     H'0A',3
  bcf     H'0A',4
  btfss   H'03',2
  goto    if_16409_by
if_16409_th: ; 00C1

;; 141 :     f877_T1CON = 0x01  -- 1:1 prescaler
  movlw   H'01'
  movwf   H'10'

;; 142 :    tmr1Htemp = 255
  movlw   H'FF'
  movwf   H'2D'

;; 143 :    tmr1Ltemp = 107
  movlw   H'6B'
  movwf   H'2E'

;; 144 :    mode1
  bcf     H'0A',3
  bcf     H'0A',4
  call    _15211__vector
if_16409_by: ; 00CA

;; 147 :   if (vhs == 1) then  -- 60 us  -> 20us
  movf    H'2A',w
  sublw   H'01'
  bcf     H'0A',3
  bcf     H'0A',4
  btfss   H'03',2
  goto    if_16441_by
if_16441_th: ; 00D0

;; 148 :     f877_T1CON = 0x01  -- 1:1 prescaler
  movlw   H'01'
  movwf   H'10'

;; 149 :    tmr1Htemp = 254
  movlw   H'FE'
  movwf   H'2D'

;; 150 :    tmr1Ltemp = 213
  movlw   H'D5'
  movwf   H'2E'

;; 151 :    mode2
  bcf     H'0A',3
  bcf     H'0A',4
  call    _15566__vector
if_16441_by: ; 00D9

;; 154 :   if (vhs == 2) then  -- 50 us
  movf    H'2A',w
  sublw   H'02'
  bcf     H'0A',3
  bcf     H'0A',4
  btfss   H'03',2
  goto    if_16473_by
if_16473_th: ; 00DF

;; 155 :     f877_T1CON = 0x31  -- 1:8 prescaler
  movlw   H'31'
  movwf   H'10'

;; 156 :    tmr1Htemp = 255
  movlw   H'FF'
  movwf   H'2D'

;; 157 :    tmr1Ltemp = 225
  movlw   H'E1'
  movwf   H'2E'

;; 158 :    mode3
  bcf     H'0A',3
  bcf     H'0A',4
  call    _15957__vector
if_16473_by: ; 00E8

;; 162 :   if (vhs == 3) then  -- 100 us
  movf    H'2A',w
  sublw   H'03'
  bcf     H'0A',3
  bcf     H'0A',4
  btfss   H'03',2
  goto    if_16505_by
if_16505_th: ; 00EE

;; 163 :     f877_T1CON = 0x31  -- 1:8 prescaler
  movlw   H'31'
  movwf   H'10'

;; 164 :    tmr1Htemp = 255
  movlw   H'FF'
  movwf   H'2D'

;; 165 :    tmr1Ltemp = 194
  movlw   H'C2'
  movwf   H'2E'

;; 166 :    mode3
  bcf     H'0A',3
  bcf     H'0A',4
  call    _15957__vector
if_16505_by: ; 00F7

;; 169 :   if (vhs == 4) then  -- 200 us
  movf    H'2A',w
  sublw   H'04'
  bcf     H'0A',3
  bcf     H'0A',4
  btfss   H'03',2
  goto    if_16537_by
if_16537_th: ; 00FD

;; 170 :     f877_T1CON = 0x31  -- 1:8 prescaler
  movlw   H'31'
  movwf   H'10'

;; 171 :    tmr1Htemp = 255
  movlw   H'FF'
  movwf   H'2D'

;; 172 :    tmr1Ltemp = 131
  movlw   H'83'
  movwf   H'2E'

;; 173 :    mode3
  bcf     H'0A',3
  bcf     H'0A',4
  call    _15957__vector
if_16537_by: ; 0106

;; 176 :   if (vhs == 5) then  -- 500 us
  movf    H'2A',w
  sublw   H'05'
  bcf     H'0A',3
  bcf     H'0A',4
  btfss   H'03',2
  goto    if_16569_by
if_16569_th: ; 010C

;; 177 :     f877_T1CON = 0x31  -- 1:8 prescaler
  movlw   H'31'
  movwf   H'10'

;; 178 :    tmr1Htemp = 254
  movlw   H'FE'
  movwf   H'2D'

;; 179 :    tmr1Ltemp = 199
  movlw   H'C7'
  movwf   H'2E'

;; 180 :    mode3
  bcf     H'0A',3
  bcf     H'0A',4
  call    _15957__vector
if_16569_by: ; 0115

;; 183 :   if (vhs == 6) then  -- 1000 us
  movf    H'2A',w
  sublw   H'06'
  bcf     H'0A',3
  bcf     H'0A',4
  btfss   H'03',2
  goto    if_16601_by
if_16601_th: ; 011B

;; 184 :     f877_T1CON = 0x31  -- 1:8 prescaler
  movlw   H'31'
  movwf   H'10'

;; 185 :    tmr1Htemp = 253
  movlw   H'FD'
  movwf   H'2D'

;; 186 :    tmr1Ltemp = 143
  movlw   H'8F'
  movwf   H'2E'

;; 187 :    mode3
  bcf     H'0A',3
  bcf     H'0A',4
  call    _15957__vector
if_16601_by: ; 0124

;; 191 :   machine = "F"
  movlw   H'46'
  movwf   H'2C'

;; 192 :  f877_serial_transmit ( machine )
  movf    H'2C',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector
  bcf     H'0A',3
  bcf     H'0A',4
  goto    w_16650_ag

;; 003 :   idle_loop: page goto idle_loop
as_16653_idle_loop: ; 012D
  bcf     H'0A',3
  bcf     H'0A',4
  goto    H'12D'
p_15957_mode3: ; 0130

;; 221 :     array1_index = 0
  clrf    H'7E'

;; 225 : wait2:
as_15973_wait2: ; 0131

;; 226 :       btfsc pin_a4
  btfsc   H'05',4

;; 227 :       goto wait2
  goto    H'131'

;; 228 : wait1:
as_15970_wait1: ; 0133

;; 229 :       btfss pin_a4
  btfss   H'05',4

;; 230 :       goto wait1
  goto    H'133'

;; 233 :     for 80 loop
; var H'030:000' _loop_temp_15995
  movlw   H'50'
  movwf   H'30'
f_15995_again: ; 0137

;; 234 :       F877_TMR1H = tmr1Htemp
  movf    H'2D',w
  movwf   H'0F'

;; 235 :       F877_TMR1L = tmr1Ltemp
  movf    H'2E',w
  movwf   H'0E'

;; 236 :       f877_TMR1IF = low
  bcf     H'0C',0

;; 237 :       adcf ( array1 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14335__vector
  movf    H'31',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13789__vector

;; 240 : wait3:
as_16025_wait3: ; 0143

;; 241 :       btfss f877_TMR1IF
  btfss   H'0C',0

;; 242 :       goto wait3
  goto    H'143'

;; 243 :       bcf f877_TMR1IF
  bcf     H'0C',0
  bcf     H'0A',3
  bcf     H'0A',4

  decfsz  H'30',f
  goto    f_15995_again

;; 247 :       array2_index = 0
  clrf    H'7D'

;; 249 :     for 80 loop
; var H'030:000' _loop_temp_16047
  movlw   H'50'
  movwf   H'30'
f_16047_again: ; 014D

;; 250 :       F877_TMR1H = tmr1Htemp
  movf    H'2D',w
  movwf   H'0F'

;; 251 :       F877_TMR1L = tmr1Ltemp
  movf    H'2E',w
  movwf   H'0E'

;; 252 :       f877_TMR1IF = low
  bcf     H'0C',0

;; 253 :       adcf ( array2 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14335__vector
  movf    H'31',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13962__vector

;; 256 : wait3:
as_16077_wait3: ; 0159

;; 257 :       btfss f877_TMR1IF
  btfss   H'0C',0

;; 258 :       goto wait3
  goto    H'159'

;; 259 :       bcf f877_TMR1IF
  bcf     H'0C',0
  bcf     H'0A',3
  bcf     H'0A',4

  decfsz  H'30',f
  goto    f_16047_again

;; 263 :       array3_index = 0
  clrf    H'7C'

;; 265 :     for 80 loop
; var H'030:000' _loop_temp_16099
  movlw   H'50'
  movwf   H'30'
f_16099_again: ; 0163

;; 266 :       F877_TMR1H = tmr1Htemp
  movf    H'2D',w
  movwf   H'0F'

;; 267 :       F877_TMR1L = tmr1Ltemp
  movf    H'2E',w
  movwf   H'0E'

;; 268 :       f877_TMR1IF = low
  bcf     H'0C',0

;; 269 :       adcf ( array3 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14335__vector
  movf    H'31',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14135__vector

;; 272 : wait3:
as_16129_wait3: ; 016F

;; 273 :       btfss f877_TMR1IF
  btfss   H'0C',0

;; 274 :       goto wait3
  goto    H'16F'

;; 275 :       bcf f877_TMR1IF
  bcf     H'0C',0
  bcf     H'0A',3
  bcf     H'0A',4

  decfsz  H'30',f
  goto    f_16099_again

;; 279 :     machine = "R"
  movlw   H'52'
  movwf   H'2C'

;; 280 :     f877_serial_transmit ( machine )
  movf    H'2C',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector

;; 282 :       array1_index = 0
  clrf    H'7E'

;; 284 :     for 80 loop
; var H'030:000' _loop_temp_16168
  movlw   H'50'
  movwf   H'30'
f_16168_again: ; 017F

;; 285 :       f877_serial_transmit ( array1 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13879__vector
  movf    H'33',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector
  bcf     H'0A',3
  bcf     H'0A',4

  decfsz  H'30',f
  goto    f_16168_again

;; 288 :       array2_index = 0
  clrf    H'7D'

;; 290 :     for 80 loop
; var H'030:000' _loop_temp_16191
  movlw   H'50'
  movwf   H'30'
f_16191_again: ; 018D

;; 291 :       f877_serial_transmit ( array2 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14052__vector
  movf    H'33',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector
  bcf     H'0A',3
  bcf     H'0A',4

  decfsz  H'30',f
  goto    f_16191_again

;; 294 :       array3_index = 0
  clrf    H'7C'

;; 296 :     for 80 loop
; var H'030:000' _loop_temp_16214
  movlw   H'50'
  movwf   H'30'
f_16214_again: ; 019B

;; 297 :       f877_serial_transmit ( array3 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14225__vector
  movf    H'33',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector
  bcf     H'0A',3
  bcf     H'0A',4

  decfsz  H'30',f
  goto    f_16214_again
e_15957_mode3: ; 01A6
  return  
p_15566_mode2: ; 01A7

;; 111 :     array1_index = 0
  clrf    H'7E'

;; 115 : wait2:
as_15582_wait2: ; 01A8

;; 116 :       btfsc pin_a4
  btfsc   H'05',4

;; 117 :       goto wait2
  goto    H'1A8'

;; 118 : wait1:
as_15579_wait1: ; 01AA

;; 119 :       btfss pin_a4
  btfss   H'05',4

;; 120 :       goto wait1
  goto    H'1AA'

;; 123 :     for 80 loop
; var H'030:000' _loop_temp_15604
  movlw   H'50'
  movwf   H'30'
f_15604_again: ; 01AE

;; 124 :       F877_TMR1H = tmr1Htemp
  movf    H'2D',w
  movwf   H'0F'

;; 125 :       F877_TMR1L = tmr1Ltemp
  movf    H'2E',w
  movwf   H'0E'

;; 126 :       f877_TMR1IF = low
  bcf     H'0C',0

;; 127 :       adcf ( array1 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14335__vector
  movf    H'31',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13789__vector

;; 130 : wait3:
as_15634_wait3: ; 01BA

;; 131 :       btfss f877_TMR1IF
  btfss   H'0C',0

;; 132 :       goto wait3
  goto    H'1BA'

;; 133 :       bcf f877_TMR1IF
  bcf     H'0C',0
  bcf     H'0A',3
  bcf     H'0A',4

  decfsz  H'30',f
  goto    f_15604_again

;; 137 :       array2_index = 0
  clrf    H'7D'

;; 141 : wait2:
as_15660_wait2: ; 01C2

;; 142 :       btfsc pin_a4
  btfsc   H'05',4

;; 143 :       goto wait2
  goto    H'1C2'

;; 144 : wait1:
as_15657_wait1: ; 01C4

;; 145 :       btfss pin_a4
  btfss   H'05',4

;; 146 :       goto wait1
  goto    H'1C4'

;; 149 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 150 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 151 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 152 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 154 :     for 80 loop
; var H'030:000' _loop_temp_15706
  movlw   H'50'
  movwf   H'30'
f_15706_again: ; 01D4

;; 155 :       F877_TMR1H = tmr1Htemp
  movf    H'2D',w
  movwf   H'0F'

;; 156 :       F877_TMR1L = tmr1Ltemp
  movf    H'2E',w
  movwf   H'0E'

;; 157 :       f877_TMR1IF = low
  bcf     H'0C',0

;; 158 :       adcf ( array2 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14335__vector
  movf    H'31',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13962__vector

;; 161 : wait3:
as_15736_wait3: ; 01E0

;; 162 :       btfss f877_TMR1IF
  btfss   H'0C',0

;; 163 :       goto wait3
  goto    H'1E0'

;; 164 :       bcf f877_TMR1IF
  bcf     H'0C',0
  bcf     H'0A',3
  bcf     H'0A',4

  decfsz  H'30',f
  goto    f_15706_again

;; 168 :       array3_index = 0
  clrf    H'7C'

;; 172 : wait2:
as_15762_wait2: ; 01E8

;; 173 :       btfsc pin_a4
  btfsc   H'05',4

;; 174 :       goto wait2
  goto    H'1E8'

;; 175 : wait1:
as_15759_wait1: ; 01EA

;; 176 :       btfss pin_a4
  btfss   H'05',4

;; 177 :       goto wait1
  goto    H'1EA'

;; 180 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 181 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 182 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 183 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 184 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 185 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 186 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 187 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 189 :     for 80 loop
; var H'030:000' _loop_temp_15832
  movlw   H'50'
  movwf   H'30'
f_15832_again: ; 0206

;; 190 :       F877_TMR1H = tmr1Htemp
  movf    H'2D',w
  movwf   H'0F'

;; 191 :       F877_TMR1L = tmr1Ltemp
  movf    H'2E',w
  movwf   H'0E'

;; 192 :       f877_TMR1IF = low
  bcf     H'0C',0

;; 193 :       adcf ( array3 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14335__vector
  movf    H'31',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14135__vector

;; 196 : wait3:
as_15862_wait3: ; 0212

;; 197 :       btfss f877_TMR1IF
  btfss   H'0C',0

;; 198 :       goto wait3
  goto    H'212'

;; 199 :       bcf f877_TMR1IF
  bcf     H'0C',0
  bcf     H'0A',3
  bcf     H'0A',4

  decfsz  H'30',f
  goto    f_15832_again

;; 203 :     machine = "R"
  movlw   H'52'
  movwf   H'2C'

;; 204 :     f877_serial_transmit ( machine )
  movf    H'2C',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector

;; 206 :       array1_index = 0
  clrf    H'7E'

;; 207 :       array2_index = 0
  clrf    H'7D'

;; 208 :       array3_index = 0
  clrf    H'7C'

;; 210 :     for 80 loop
; var H'030:000' _loop_temp_15913
  movlw   H'50'
  movwf   H'30'
f_15913_again: ; 0224

;; 211 :       f877_serial_transmit ( array1 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13879__vector
  movf    H'33',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector

;; 212 :       f877_serial_transmit ( array2 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14052__vector
  movf    H'33',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector

;; 213 :       f877_serial_transmit ( array3 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14225__vector
  movf    H'33',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector
  bcf     H'0A',3
  bcf     H'0A',4

  decfsz  H'30',f
  goto    f_15913_again
e_15566_mode2: ; 023D
  return  
p_15211_mode1: ; 023E

;; 006 :     array1_index = 0
  clrf    H'7E'

;; 010 : wait2:
as_15227_wait2: ; 023F

;; 011 :       btfsc pin_a4
  btfsc   H'05',4

;; 012 :       goto wait2
  goto    H'23F'

;; 013 : wait1:
as_15224_wait1: ; 0241

;; 014 :       btfss pin_a4
  btfss   H'05',4

;; 015 :       goto wait1
  goto    H'241'

;; 018 :     for 80 loop
; var H'030:000' _loop_temp_15249
  movlw   H'50'
  movwf   H'30'
f_15249_again: ; 0245

;; 019 :       F877_TMR1H = tmr1Htemp
  movf    H'2D',w
  movwf   H'0F'

;; 020 :       F877_TMR1L = tmr1Ltemp
  movf    H'2E',w
  movwf   H'0E'

;; 021 :       f877_TMR1IF = low
  bcf     H'0C',0

;; 022 :       adcf ( array1 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14335__vector
  movf    H'31',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13789__vector

;; 025 : wait3:
as_15279_wait3: ; 0251

;; 026 :       btfss f877_TMR1IF
  btfss   H'0C',0

;; 027 :       goto wait3
  goto    H'251'

;; 028 :       bcf f877_TMR1IF
  bcf     H'0C',0
  bcf     H'0A',3
  bcf     H'0A',4

  decfsz  H'30',f
  goto    f_15249_again

;; 032 :       array2_index = 0
  clrf    H'7D'

;; 036 : wait2:
as_15305_wait2: ; 0259

;; 037 :       btfsc pin_a4
  btfsc   H'05',4

;; 038 :       goto wait2
  goto    H'259'

;; 039 : wait1:
as_15302_wait1: ; 025B

;; 040 :       btfss pin_a4
  btfss   H'05',4

;; 041 :       goto wait1
  goto    H'25B'

;; 044 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 045 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 048 :     for 80 loop
; var H'030:000' _loop_temp_15339
  movlw   H'50'
  movwf   H'30'
f_15339_again: ; 0265

;; 049 :       F877_TMR1H = tmr1Htemp
  movf    H'2D',w
  movwf   H'0F'

;; 050 :       F877_TMR1L = tmr1Ltemp
  movf    H'2E',w
  movwf   H'0E'

;; 051 :       f877_TMR1IF = low
  bcf     H'0C',0

;; 052 :       adcf ( array2 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14335__vector
  movf    H'31',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13962__vector

;; 055 : wait3:
as_15369_wait3: ; 0271

;; 056 :       btfss f877_TMR1IF
  btfss   H'0C',0

;; 057 :       goto wait3
  goto    H'271'

;; 058 :       bcf f877_TMR1IF
  bcf     H'0C',0
  bcf     H'0A',3
  bcf     H'0A',4

  decfsz  H'30',f
  goto    f_15339_again

;; 062 :       array3_index = 0
  clrf    H'7C'

;; 066 : wait2:
as_15395_wait2: ; 0279

;; 067 :       btfsc pin_a4
  btfsc   H'05',4

;; 068 :       goto wait2
  goto    H'279'

;; 069 : wait1:
as_15392_wait1: ; 027B

;; 070 :       btfss pin_a4
  btfss   H'05',4

;; 071 :       goto wait1
  goto    H'27B'

;; 074 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 075 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 076 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 077 :     _delay_5us
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14708__vector

;; 079 :     for 80 loop
; var H'030:000' _loop_temp_15441
  movlw   H'50'
  movwf   H'30'
f_15441_again: ; 028B

;; 080 :       F877_TMR1H = tmr1Htemp
  movf    H'2D',w
  movwf   H'0F'

;; 081 :       F877_TMR1L = tmr1Ltemp
  movf    H'2E',w
  movwf   H'0E'

;; 082 :       f877_TMR1IF = low
  bcf     H'0C',0

;; 083 :       adcf ( array3 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14335__vector
  movf    H'31',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14135__vector

;; 086 : wait3:
as_15471_wait3: ; 0297

;; 087 :       btfss f877_TMR1IF
  btfss   H'0C',0

;; 088 :       goto wait3
  goto    H'297'

;; 089 :       bcf f877_TMR1IF
  bcf     H'0C',0
  bcf     H'0A',3
  bcf     H'0A',4

  decfsz  H'30',f
  goto    f_15441_again

;; 093 :     machine = "R"
  movlw   H'52'
  movwf   H'2C'

;; 094 :     f877_serial_transmit ( machine )
  movf    H'2C',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector

;; 096 :       array1_index = 0
  clrf    H'7E'

;; 097 :       array2_index = 0
  clrf    H'7D'

;; 098 :       array3_index = 0
  clrf    H'7C'

;; 100 :     for 80 loop
; var H'030:000' _loop_temp_15522
  movlw   H'50'
  movwf   H'30'
f_15522_again: ; 02A9

;; 101 :       f877_serial_transmit ( array1 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13879__vector
  movf    H'33',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector

;; 102 :       f877_serial_transmit ( array2 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14052__vector
  movf    H'33',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector

;; 103 :       f877_serial_transmit ( array3 )
  bcf     H'0A',3
  bcf     H'0A',4
  call    _14225__vector
  movf    H'33',w
  bcf     H'0A',3
  bcf     H'0A',4
  call    _13303__vector
  bcf     H'0A',3
  bcf     H'0A',4

  decfsz  H'30',f
  goto    f_15522_again
e_15211_mode1: ; 02C2
  return  
p_14708__delay_5us: ; 02C3

;; 136 : var byte x
; var H'030:000' x

;; 138 :   local delay
; const H'2C9' delay

;; 139 :   page delay
  bcf     H'0A',3
  bcf     H'0A',4

;; 140 :       movlw    5
  movlw   H'05'

;; 141 :       movwf    x   
  movwf   H'30'

;; 142 :       nop
  nop     

;; 143 :       nop
  nop     

;; 144 :     delay:        
as_14718_delay: ; 02C9

;; 145 :       decfsz   x,f  
  decfsz  H'30',f

;; 146 :       goto     delay 
  goto    H'2C9'
e_14708__delay_5us: ; 02CB
  return  
p_14527_pwm: ; 02CC

;; 068 : 		Bank_1
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3158__vector

;; 069 : 		f877_PR2 = 249				-- PWM period = (PR2+1)*4*Tosc*TMR2prescaler
  movlw   H'F9'
  movwf   H'92'

;; 070 : 		Bank_0
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3121__vector

;; 071 : 		f877_CCPR1L = 0x80			-- 50% Duty cycle
  movlw   H'80'
  movwf   H'15'

;; 072 : 		pin_c2_direction = output 		-- Set PortC:2 as output
  bcf     H'24',2
  bcf     H'0A',3
  bcf     H'0A',4
  call    _4470__vector

;; 073 : 		pin_c2 = low
  bcf     H'28',2
  bcf     H'0A',3
  bcf     H'0A',4
  call    _7147__vector

;; 074 : 		f877_T2CON = 0x06			-- TRM2 prescaler=16 postscaler=1 Timer2 ON
  movlw   H'06'
  movwf   H'12'

;; 075 : 		f877_CCP1CON = 0x0C			-- PWM mode and simetric duty cycle
  movlw   H'0C'
  movwf   H'17'
e_14527_pwm: ; 02E2
  return  

;; 039 : procedure trigf (byte out data ) is begin
; var H'030:000' data
p_14428_trigf: ; 02E3
  movwf   H'30'

;; 040 : var byte x
; var H'031:000' x

;; 043 : 	clrf	f877_ADCON0			;store in ADCON0
  clrf    H'1F'

;; 044 :   bsf f877_ADCON0,3     ; an1
  bsf     H'1F',3

;; 045 : 	bsf	f877_ADCON0,6  		;Fosc/8 (4MHz) Tadc = 8 cycles
  bsf     H'1F',6

;; 046 : 	bsf	f877_ADCON0,0	    ;turn on ADC
  bsf     H'1F',0

;; 048 :       movlw    20     ; 16 us
  movlw   H'14'

;; 049 :       movwf    x
  movwf   H'31'

;; 050 :       nop
  nop     

;; 051 :       nop
  nop     

;; 052 :     delay:
as_14446_delay: ; 02EC

;; 053 :       decfsz   x,f
  decfsz  H'31',f

;; 054 :       goto     delay
  goto    H'2EC'

;; 056 : 	bsf	f877_ADCON0,2		;start conversion
  bsf     H'1F',2

;; 057 : wait:
as_14449_wait: ; 02EF

;; 058 : 	btfsc	f877_ADCON0,2
  btfsc   H'1F',2

;; 059 : 	goto	wait			;wait conversion completed
  goto    H'2EF'

;; 060 : 	clrf	f877_ADCON0			;stop the adc
  clrf    H'1F'

;; 061 :   movf f877_ADRESH,w
  movf    H'1E',w

;; 062 :   movwf DATA
  movwf   H'30'
e_14428_trigf: ; 02F4
  return  

;; 013 : procedure adcf (byte out data ) is begin
; var H'031:000' data
p_14335_adcf: ; 02F5
  movwf   H'31'

;; 014 : var byte x
; var H'032:000' x

;; 017 : 	clrf	f877_ADCON0			;store in ADCON0
  clrf    H'1F'

;; 018 : 	bsf	f877_ADCON0,6  		;Fosc/8 (4MHz) Tadc = 8 cycles
  bsf     H'1F',6

;; 019 : 	bsf	f877_ADCON0,0		 ;turn on ADC
  bsf     H'1F',0

;; 021 :       movlw    10     ; 8 us
  movlw   H'0A'

;; 022 :       movwf    x
  movwf   H'32'

;; 023 :       nop
  nop     

;; 024 :       nop
  nop     

;; 025 :     delay:
as_14353_delay: ; 02FD

;; 026 :       decfsz   x,f
  decfsz  H'32',f

;; 027 :       goto     delay
  goto    H'2FD'

;; 029 : 	bsf	f877_ADCON0,2		;start conversion
  bsf     H'1F',2

;; 030 : wait:
as_14356_wait: ; 0300

;; 031 : 	btfsc	f877_ADCON0,2
  btfsc   H'1F',2

;; 032 : 	goto	wait			;wait conversion completed
  goto    H'300'

;; 033 : 	clrf	f877_ADCON0			;stop the adc
  clrf    H'1F'

;; 034 :   movf f877_ADRESH,w
  movf    H'1E',w

;; 035 :   movwf DATA
  movwf   H'31'
e_14335_adcf: ; 0305
  return  
p_14225_get: ; 0306

;; 308 : function array3'get return byte is
; var H'033:000'  return value

;; 309 : 	FSR = array3_start + array3_index  -- calculate position in array
  movf    H'7C',w
  addlw   H'1A0'
  movwf   H'04'

;; 325 :     status_IRP = true
  bsf     H'03',7

;; 328 :   array3_index = array3_index + 1   -- auto increment of array index
  incf    H'7C',f

;; 329 :   return INDF                       -- get data from array
  movf    H'00',w
  movwf   H'33'
e_14225_get: ; 030D
  return  

;; 276 : procedure array3'put ( byte in data ) is
p_14135__array3__put_t: ; 030E
; var H'032:000' data
p_14135_put: ; 030E
  movwf   H'32'

;; 277 : 	FSR = array3_start + array3_index  -- calculate position in array
  movf    H'7C',w
  addlw   H'1A0'
  movwf   H'04'

;; 293 :     status_IRP = true
  bsf     H'03',7

;; 296 : 	INDF = data                       -- store data in array
  movf    H'32',w
  movwf   H'00'

;; 297 :   array3_index = array3_index + 1   -- auto increment of array index
  incf    H'7C',f
e_14135_put: ; 0316
  return  
p_14052_get: ; 0317

;; 243 : function array2'get return byte is
; var H'033:000'  return value

;; 244 : 	FSR = array2_start + array2_index  -- calculate position in array
  movf    H'7D',w
  addlw   H'120'
  movwf   H'04'

;; 260 :     status_IRP = true
  bsf     H'03',7

;; 263 :   array2_index = array2_index + 1   -- auto increment of array index
  incf    H'7D',f

;; 264 :   return INDF                       -- get data from array
  movf    H'00',w
  movwf   H'33'
e_14052_get: ; 031E
  return  

;; 211 : procedure array2'put ( byte in data ) is
p_13962__array2__put_t: ; 031F
; var H'032:000' data
p_13962_put: ; 031F
  movwf   H'32'

;; 212 : 	FSR = array2_start + array2_index  -- calculate position in array
  movf    H'7D',w
  addlw   H'120'
  movwf   H'04'

;; 228 :     status_IRP = true
  bsf     H'03',7

;; 231 : 	INDF = data                       -- store data in array
  movf    H'32',w
  movwf   H'00'

;; 232 :   array2_index = array2_index + 1   -- auto increment of array index
  incf    H'7D',f
e_13962_put: ; 0327
  return  
p_13879_get: ; 0328

;; 178 : function array1'get return byte is
; var H'033:000'  return value

;; 179 : 	FSR = array1_start + array1_index  -- calculate position in array
  movf    H'7E',w
  addlw   H'A0'
  movwf   H'04'

;; 193 :     status_IRP = false
  bcf     H'03',7

;; 198 :   array1_index = array1_index + 1   -- auto increment of array index
  incf    H'7E',f

;; 199 :   return INDF                       -- get data from array
  movf    H'00',w
  movwf   H'33'
e_13879_get: ; 032F
  return  

;; 146 : procedure array1'put ( byte in data ) is
p_13789__array1__put_t: ; 0330
; var H'032:000' data
p_13789_put: ; 0330
  movwf   H'32'

;; 147 : 	FSR = array1_start + array1_index  -- calculate position in array
  movf    H'7E',w
  addlw   H'A0'
  movwf   H'04'

;; 161 :     status_IRP = false
  bcf     H'03',7

;; 166 : 	INDF = data                       -- store data in array
  movf    H'32',w
  movwf   H'00'

;; 167 :   array1_index = array1_index + 1   -- auto increment of array index
  incf    H'7E',f
e_13789_put: ; 0338
  return  

;; 171 : Procedure F877_serial_transmit ( byte in data ) is begin
; var H'031:000' data
p_13303_f877_serial_transmit: ; 0339
  movwf   H'31'

;; 172 : 	Bank_0
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3121__vector

;; 173 : 	while ! f877_TXIF loop
w_13326_ag: ; 033D
  bcf     H'0A',3
  bcf     H'0A',4
  btfsc   H'0C',4
  goto    w_13326_be
w_13326_bo: ; 0341
  bcf     H'0A',3
  bcf     H'0A',4
  goto    w_13326_ag
w_13326_be: ; 0344

;; 175 : 	_file_put ( 0x00 , 0x19 , data )
  clrf    H'32'
  movlw   H'19'
  movwf   H'33'
  movf    H'31',w
  bcf     H'0A',3
  bcf     H'0A',4
  goto    _12112__vector
e_13303_f877_serial_transmit: ; 034B

;; 164 : Procedure F877_serial_recibe ( byte out data ) is begin
; var H'030:000' data
p_13251_f877_serial_recibe: ; 034B
  movwf   H'30'

;; 165 : 		Bank_0
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3121__vector

;; 166 : 	while ! f877_RCIF loop
w_13274_ag: ; 034F
  bcf     H'0A',3
  bcf     H'0A',4
  btfsc   H'0C',5
  goto    w_13274_be
w_13274_bo: ; 0353
  bcf     H'0A',3
  bcf     H'0A',4
  goto    w_13274_ag
w_13274_be: ; 0356

;; 168 : 	_file_get ( 0x00 , 0x1A , data )
  clrf    H'31'
  movlw   H'1A'
  movwf   H'32'
  bcf     H'0A',3
  bcf     H'0A',4
  call    _12056__vector
  movf    H'33',w
  movwf   H'30'
e_13251_f877_serial_recibe: ; 035E
  return  

;; 083 : Procedure F877_serial_setup ( byte in BAUD_CONSTANT ) is begin
; var H'030:000' baud_constant
p_12809_f877_serial_setup: ; 035F
  movwf   H'30'

;; 134 : 	  if BAUD_CONSTANT == 192 then
  movf    H'30',w
  sublw   H'C0'
  bcf     H'0A',3
  bcf     H'0A',4
  btfss   H'03',2
  goto    if_13096_el
if_13096_th: ; 0366

;; 135 : 		Bank_1
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3158__vector

;; 136 :       		f877_SPBRG = 64
  movlw   H'40'
  movwf   H'99'

;; 137 : 		f877_BRGH = high
  bsf     H'98',2

;; 138 : 		Bank_0
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3121__vector
  bcf     H'0A',3
  bcf     H'0A',4
  goto    if_13096_by
if_13096_el: ; 0372

;; 139 : 	  elsif BAUD_CONSTANT == 96 then
  movf    H'30',w
  sublw   H'60'
  bcf     H'0A',3
  bcf     H'0A',4
  btfss   H'03',2
  goto    if_13126_el
if_13126_th: ; 0378

;; 140 : 		Bank_1
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3158__vector

;; 141 :       		f877_SPBRG = 129
  movlw   H'81'
  movwf   H'99'

;; 142 : 		f877_BRGH = high
  bsf     H'98',2

;; 143 : 		Bank_0
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3121__vector
  bcf     H'0A',3
  bcf     H'0A',4
  goto    if_13126_by
if_13126_el: ; 0384

;; 144 : 	  elsif BAUD_CONSTANT == 24 then
  movf    H'30',w
  sublw   H'18'
  bcf     H'0A',3
  bcf     H'0A',4
  btfss   H'03',2
  goto    if_13156_el
if_13156_th: ; 038A

;; 145 : 		Bank_1
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3158__vector

;; 146 :       		f877_SPBRG = 129
  movlw   H'81'
  movwf   H'99'

;; 147 : 		f877_BRGH = low
  bcf     H'98',2

;; 148 : 		Bank_0
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3121__vector
  bcf     H'0A',3
  bcf     H'0A',4
  goto    if_13156_by
if_13156_el: ; 0396

;; 149 : 	  elsif BAUD_CONSTANT == 12 then
  movf    H'30',w
  sublw   H'0C'
  bcf     H'0A',3
  bcf     H'0A',4
  btfss   H'03',2
  goto    if_13186_by
if_13186_th: ; 039C

;; 150 : 		Bank_1
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3158__vector

;; 151 :       		f877_SPBRG = 255
  movlw   H'FF'
  movwf   H'99'

;; 152 : 		f877_BRGH = low
  bcf     H'98',2

;; 153 : 		Bank_0
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3121__vector
if_13186_by: ; 03A5
if_13156_by: ; 03A5
if_13126_by: ; 03A5
if_13096_by: ; 03A5

;; 156 : 		Bank_1
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3158__vector

;; 157 : 	f877_TXEN = High
  bsf     H'98',5

;; 158 : 		Bank_0
  bcf     H'0A',3
  bcf     H'0A',4
  call    _3121__vector

;; 159 : 	f877_CREN = high
  bsf     H'18',4

;; 160 : 	f877_SPEN = high
  bsf     H'18',7
e_12809_f877_serial_setup: ; 03AE
  return  

;; 069 : procedure _file_bit_set ( byte in Haddr , byte in Laddr , byte in pos ) is begin 
; var H'030:000' haddr
; var H'031:000' laddr
; var H'032:000' pos
p_12168__file_bit_set: ; 03AF
  movwf   H'32'

;; 070 : var volatile bit local_irp
; var H'020:001' local_irp

;; 071 : var volatile bit HAddr0 at Haddr : 0
; var H'030:000' haddr0

;; 072 : var volatile byte temp1 , temp2
; var H'033:000' temp1
; var H'034:000' temp2
  bcf     H'0A',3
  bcf     H'0A',4

;; 073 :    local_irp = STATUS_IRP
  btfss   H'03',7
  goto    ass_12207_f
ass_12207_t: ; 03B4
  bsf     H'20',1
  bcf     H'0A',3
  bcf     H'0A',4
  goto    ass_12207_b
ass_12207_f: ; 03B8
  bcf     H'20',1
ass_12207_b: ; 03B9
  bcf     H'0A',3
  bcf     H'0A',4

;; 074 :    STATUS_IRP = HAddr0
  btfss   H'30',0
  goto    ass_12211_f
ass_12211_t: ; 03BD
  bsf     H'03',7
  bcf     H'0A',3
  bcf     H'0A',4
  goto    ass_12211_b
ass_12211_f: ; 03C1
  bcf     H'03',7
ass_12211_b: ; 03C2

;; 075 :    fsr = Laddr
  movf    H'31',w
  movwf   H'04'

;; 076 :    temp1 = INDF
  movf    H'00',w
  movwf   H'33'

;; 077 :    temp2 = 0x01
  movlw   H'01'
  movwf   H'34'

;; 078 :    status_c = low
  bcf     H'03',0
; var H'035:000' sq_temp_12234

;; 079 :    temp2 = temp2 << ( pos )
  movf    H'34',w
  movwf   H'36'
  movf    H'32',w
  movwf   H'37'
  bcf     H'0A',3
  bcf     H'0A',4
  call    _706__vector
  movf    H'38',w
  movwf   H'35'
  movf    H'35',w
  movwf   H'34'

;; 080 :    temp1 = temp1 | temp2
  movf    H'34',w
  iorwf   H'33',f

;; 081 :    INDF = temp1
  movf    H'33',w
  movwf   H'00'
  bcf     H'0A',3
  bcf     H'0A',4

;; 082 :    STATUS_IRP = local_irp
  btfss   H'20',1
  goto    ass_12250_f
ass_12250_t: ; 03DC
  bsf     H'03',7
  bcf     H'0A',3
  bcf     H'0A',4
  goto    ass_12250_b
ass_12250_f: ; 03E0
  bcf     H'03',7
ass_12250_b: ; 03E1
e_12168__file_bit_set: ; 03E1
  return  

;; 059 : procedure _file_put( byte in Haddr , byte in Laddr , byte in data ) is begin 
; var H'032:000' haddr
; var H'033:000' laddr
; var H'034:000' data
p_12112__file_put: ; 03E2
  movwf   H'34'

;; 060 : var volatile bit local_irp
; var H'020:001' local_irp

;; 061 : var volatile bit HAddr0 at Haddr : 0
; var H'032:000' haddr0
  bcf     H'0A',3
  bcf     H'0A',4

;; 062 :    local_irp = STATUS_IRP
  btfss   H'03',7
  goto    ass_12145_f
ass_12145_t: ; 03E7
  bsf     H'20',1
  bcf     H'0A',3
  bcf     H'0A',4
  goto    ass_12145_b
ass_12145_f: ; 03EB
  bcf     H'20',1
ass_12145_b: ; 03EC
  bcf     H'0A',3
  bcf     H'0A',4

;; 063 :    STATUS_IRP = HAddr0
  btfss   H'32',0
  goto    ass_12149_f
ass_12149_t: ; 03F0
  bsf     H'03',7
  bcf     H'0A',3
  bcf     H'0A',4
  goto    ass_12149_b
ass_12149_f: ; 03F4
  bcf     H'03',7
ass_12149_b: ; 03F5

;; 064 :    fsr = Laddr
  movf    H'33',w
  movwf   H'04'

;; 065 :    INDF = data
  movf    H'34',w
  movwf   H'00'
  bcf     H'0A',3
  bcf     H'0A',4

;; 066 :    STATUS_IRP = local_irp
  btfss   H'20',1
  goto    ass_12161_f
ass_12161_t: ; 03FD
  bsf     H'03',7
  bcf     H'0A',3
  bcf     H'0A',4
  goto    ass_12161_b
ass_12161_f: ; 0401
  bcf     H'03',7
ass_12161_b: ; 0402
e_12112__file_put: ; 0402
  return  

;; 049 : procedure _file_get( byte in Haddr , byte in Laddr , byte out data ) is begin 
; var H'031:000' haddr
; var H'032:000' laddr
; var H'033:000' data
p_12056__file_get: ; 0403
  movwf   H'33'

;; 050 : var volatile bit local_irp
; var H'020:001' local_irp

;; 051 : var volatile bit HAddr0 at Haddr : 0
; var H'031:000' haddr0
  bcf     H'0A',3
  bcf     H'0A',4

;; 052 :    local_irp = STATUS_IRP
  btfss   H'03',7
  goto    ass_12089_f
ass_12089_t: ; 0408
  bsf     H'20',1
  bcf     H'0A',3
  bcf     H'0A',4
  goto    ass_12089_b
ass_12089_f: ; 040C
  bcf     H'20',1
ass_12089_b: ; 040D
  bcf     H'0A',3
  bcf     H'0A',4

;; 053 :    STATUS_IRP = HAddr0
  btfss   H'31',0
  goto    ass_12093_f
ass_12093_t: ; 0411
  bsf     H'03',7
  bcf     H'0A',3
  bcf     H'0A',4
  goto    ass_12093_b
ass_12093_f: ; 0415
  bcf     H'03',7
ass_12093_b: ; 0416

;; 054 :    fsr = Laddr
  movf    H'32',w
  movwf   H'04'

;; 055 :    data = INDF
  movf    H'00',w
  movwf   H'33'
  bcf     H'0A',3
  bcf     H'0A',4

;; 056 :    STATUS_IRP = local_irp
  btfss   H'20',1
  goto    ass_12105_f
ass_12105_t: ; 041E
  bsf     H'03',7
  bcf     H'0A',3
  bcf     H'0A',4
  goto    ass_12105_b
ass_12105_f: ; 0422
  bcf     H'03',7
ass_12105_b: ; 0423
e_12056__file_get: ; 0423
  return  

;; 343 : procedure delay_1ms( byte in x = 1 ) is
; var H'030:000' x
p_9915_delay_1ms: ; 0424
  movwf   H'30'

;; 344 :    _delay_100us( x, 10, 1 )
  movf    H'30',w
  movwf   H'31'
  movlw   H'0A'
  movwf   H'32'
  movlw   H'01'
  bcf     H'0A',3
  bcf     H'0A',4
  goto    _9490__vector
e_9915_delay_1ms: ; 042D

;; 230 : procedure _delay_100us( byte in x, byte in y, byte in z ) is
; var H'031:000' x
; var H'032:000' y
; var H'033:000' z
p_9490__delay_100us: ; 042D
  movwf   H'33'

;; 284 :       var byte minus_one = -1
; var H'034:000' minus_one
  movlw   H'FFFFFFFF'
  movwf   H'34'

;; 286 :       var byte xx, yy
; var H'035:000' xx
; var H'036:000' yy

;; 290 :          local loop_x, loop_y, loop_z, loop_w
; const H'437' loop_w

;; 293 :       loop_z:
as_9691_loop_z: ; 0430

;; 296 :          movfw y
  movfw   H'32'

;; 297 :          movwf yy
  movwf   H'36'

;; 298 :       loop_y:
as_9688_loop_y: ; 0432

;; 301 :          movfw x
  movfw   H'31'

;; 302 :          movwf xx
  movwf   H'35'

;; 303 :       loop_x:
as_9685_loop_x: ; 0434

;; 305 :          movlw inner_iterations
  movlw   H'77'

;; 306 :          page loop_w
  bcf     H'0A',3
  bcf     H'0A',4

;; 307 :       loop_w:
as_9694_loop_w: ; 0437

;; 308 :          addwf minus_one, w
  addwf   H'34',w

;; 309 :          skpnc
  skpnc   

;; 310 :             goto loop_w
  goto    H'437'

;; 312 :          page loop_x
  bcf     H'0A',3
  bcf     H'0A',4

;; 313 :          decfsz xx, f
  decfsz  H'35',f

;; 314 :          goto loop_x
  goto    H'434'

;; 316 :          page loop_y
  bcf     H'0A',3
  bcf     H'0A',4

;; 317 :          decfsz yy, f
  decfsz  H'36',f

;; 318 :          goto loop_y
  goto    H'432'

;; 320 :          page loop_z
  bcf     H'0A',3
  bcf     H'0A',4

;; 321 :          decfsz z, f
  decfsz  H'33',f

;; 322 :          goto loop_z
  goto    H'430'
e_9490__delay_100us: ; 0446
  return  

;; 576 : procedure pin_c2'put( bit in x at _port_c_buffer : 2 ) is
p_7147__pin_c2__put_t: ; 0447
; var H'028:002' x
p_7147_put: ; 0447

;; 577 :    _port_c_flush
  bcf     H'0A',3
  bcf     H'0A',4
  goto    _5875__vector
e_7147_put: ; 044A

;; 449 : procedure port_b'put( byte in x at _port_b_buffer ) is
p_5975__port_b__put_t: ; 044A
; var H'027:000' x
p_5975_put: ; 044A
  movwf   H'27'

;; 450 :    _port_b_flush
  bcf     H'0A',3
  bcf     H'0A',4
  goto    _5852__vector
e_5975_put: ; 044E
p_5875__port_c_flush: ; 044E

;; 437 :    var volatile byte port_c at 7 = _port_c_buffer
; var H'007:000' port_c
  movf    H'28',w
  movwf   H'07'
e_5875__port_c_flush: ; 0450
  return  
p_5852__port_b_flush: ; 0451

;; 434 :    var volatile byte port_b at 6 = _port_b_buffer
; var H'006:000' port_b
  movf    H'27',w
  movwf   H'06'
e_5852__port_b_flush: ; 0453
  return  

;; 273 : procedure pin_c2_direction'put( bit in d at trisc : 2 ) is
p_4470__pin_c2_direction__put_t: ; 0454
; var H'024:002' d
p_4470_put: ; 0454

;; 274 :    _trisc_flush
  bcf     H'0A',3
  bcf     H'0A',4
  goto    _3577__vector
e_4470_put: ; 0457

;; 220 : procedure pin_a4_direction'put( bit in d at trisa : 4 ) is
p_4023__pin_a4_direction__put_t: ; 0457
; var H'022:004' d
p_4023_put: ; 0457

;; 221 :    _trisa_flush
  bcf     H'0A',3
  bcf     H'0A',4
  goto    _3531__vector
e_4023_put: ; 045A

;; 181 : procedure port_b_direction'put( byte in x at trisb ) is
p_3703__port_b_direction__put_t: ; 045A
; var H'023:000' x
p_3703_put: ; 045A
  movwf   H'23'

;; 182 :    _trisb_flush
  bcf     H'0A',3
  bcf     H'0A',4
  goto    _3554__vector
e_3703_put: ; 045E
p_3577__trisc_flush: ; 045E

;; 156 :       bank movfw trisc
  movfw   H'24'

;; 157 :            tris  7
  tris    H'07'
e_3577__trisc_flush: ; 0460
  return  
p_3554__trisb_flush: ; 0461

;; 149 :       bank movfw trisb
  movfw   H'23'

;; 150 :            tris  6
  tris    H'06'
e_3554__trisb_flush: ; 0463
  return  
p_3531__trisa_flush: ; 0464

;; 142 :       bank movfw trisa
  movfw   H'22'

;; 143 :            tris  5
  tris    H'05'
e_3531__trisa_flush: ; 0466
  return  
p_3158_bank_1: ; 0467

;; 052 :       asm bsf status, 5
  bsf     H'03',5

;; 053 :       asm bcf status, 6
  bcf     H'03',6
e_3158_bank_1: ; 0469
  return  
p_3121_bank_0: ; 046A

;; 044 :       asm bcf status, 5
  bcf     H'03',5

;; 045 :       asm bcf status, 6
  bcf     H'03',6
e_3121_bank_0: ; 046C
  return  

;; 080 : operator << ( byte in a, byte in n ) return byte is
; var H'036:000' a
; var H'037:000' n
p_706_shift_left: ; 046D
; var H'038:000'  return value

;; 081 :    while n > 0 loop
w_742_ag: ; 046D
  movf    H'37',w
  sublw   H'00'
  bcf     H'0A',3
  bcf     H'0A',4
  btfss   H'03',0
  goto    w_742_bo
w_742_jb: ; 0473
  bcf     H'0A',3
  bcf     H'0A',4
  goto    w_742_be
w_742_bo: ; 0476

;; 082 :       asm      clrc
  clrc    

;; 083 :       asm bank rlf  a,f
  rlf     H'36',f

;; 084 :       n = n - 1
  movlw   H'01'
  subwf   H'37',w
  movwf   H'37'
  bcf     H'0A',3
  bcf     H'0A',4
  goto    w_742_ag
w_742_be: ; 047E

;; 086 :    return a
  movf    H'36',w
  movwf   H'38'
e_706_shift_left: ; 0480
  return  

 END

; ********** variable mapping
; 00:0 : ;
;   indf                           * 0059:19 \JALCC\JAL\LIB\sfr.jal 
; 03:0 : ;
;   status_c                       * 0064:19 \JALCC\JAL\LIB\sfr.jal 
;   status                         * 0062:19 \JALCC\JAL\LIB\sfr.jal 
; 03:7 : ;
;   status_irp                     * 0071:19 \JALCC\JAL\LIB\sfr.jal 
; 04:0 : ;
;   fsr                            * 0073:19 \JALCC\JAL\LIB\sfr.jal 
; 05:0 : ;
;   port_a                         * 0010:19 \JALCC\JAL\LIB\sfr.jal 
; 05:4 : ;
;   pin_a4                         * 0020:19 \JALCC\JAL\LIB\sfr.jal 
; 06:0 : ;
;   port_b                         * 0434:22 \JALCC\JAL\LIB\jpic.jal 
; 07:0 : ;
;   port_c                         * 0437:22 \JALCC\JAL\LIB\jpic.jal 
; 0C:0 : ;
;   f877_tmr1if                    * 0111:19 \JALCC\JAL\LIB\sfr.jal 
;   f877_pir1                      * 0109:19 \JALCC\JAL\LIB\sfr.jal 
; 0C:4 : ;
;   f877_txif                      * 0115:19 \JALCC\JAL\LIB\sfr.jal 
; 0C:5 : ;
;   f877_rcif                      * 0116:19 \JALCC\JAL\LIB\sfr.jal 
; 0E:0 : ;
;   f877_tmr1l                     * 0127:19 \JALCC\JAL\LIB\sfr.jal 
; 0F:0 : ;
;   f877_tmr1h                     * 0128:19 \JALCC\JAL\LIB\sfr.jal 
; 10:0 : ;
;   f877_t1con                     * 0130:19 \JALCC\JAL\LIB\sfr.jal 
; 12:0 : ;
;   f877_t2con                     * 0141:19 \JALCC\JAL\LIB\sfr.jal 
; 15:0 : ;
;   f877_ccpr1l                    * 0164:19 \JALCC\JAL\LIB\sfr.jal 
; 17:0 : ;
;   f877_ccp1con                   * 0167:19 \JALCC\JAL\LIB\sfr.jal 
; 18:0 : ;
;   f877_rcsta                     * 0176:19 \JALCC\JAL\LIB\sfr.jal 
; 18:4 : ;
;   f877_cren                      * 0182:19 \JALCC\JAL\LIB\sfr.jal 
; 18:7 : ;
;   f877_spen                      * 0185:19 \JALCC\JAL\LIB\sfr.jal 
; 1E:0 : ;
;   f877_adresh                    * 0201:19 \JALCC\JAL\LIB\sfr.jal 
; 1F:0 : ;
;   f877_adcon0                    * 0203:19 \JALCC\JAL\LIB\sfr.jal 
; 20:0 : ;
;    transfer_bit                    
; 20:1 : ;
;   local_irp                        0050:18 \JALCC\JAL\LIB\indf_bits.jal 
;   local_irp                        0060:18 \JALCC\JAL\LIB\indf_bits.jal 
;   local_irp                        0070:18 \JALCC\JAL\LIB\indf_bits.jal 
; 21:0 : ;
;    transfer_byte                   
; 22:0 : ;
;   trisa                            0120:10 \JALCC\JAL\LIB\jpic.jal 
; 22:4 : ;
;   d                              * 0220:33 \JALCC\JAL\LIB\jpic.jal 
; 23:0 : ;
;   x                              * 0181:33 \JALCC\JAL\LIB\jpic.jal 
;   trisb                            0121:10 \JALCC\JAL\LIB\jpic.jal 
; 24:0 : ;
;   trisc                            0122:10 \JALCC\JAL\LIB\jpic.jal 
; 24:2 : ;
;   d                              * 0273:33 \JALCC\JAL\LIB\jpic.jal 
; 25:0 : ;
;   trisd                            0123:10 \JALCC\JAL\LIB\jpic.jal 
; 26:0 : ;
;   trise                            0124:10 \JALCC\JAL\LIB\jpic.jal 
; 27:0 : ;
;   x                              * 0449:23 \JALCC\JAL\LIB\jpic.jal 
;   _port_b_buffer                   0425:10 \JALCC\JAL\LIB\jpic.jal 
; 28:0 : ;
;   _port_c_buffer                   0426:10 \JALCC\JAL\LIB\jpic.jal 
; 28:2 : ;
;   x                              * 0576:23 \JALCC\JAL\LIB\jpic.jal 
; 29:0 : ;
;   vts                              0010:19 adc.jal 
; 2A:0 : ;
;   vhs                              0010:23 adc.jal 
; 2B:0 : ;
;   vvs                              0010:27 adc.jal 
; 2C:0 : ;
;   machine                          0010:31 adc.jal 
; 2D:0 : ;
;   tmr1htemp                        0011:10 adc.jal 
; 2E:0 : ;
;   tmr1ltemp                        0011:20 adc.jal 
; 2F:0 : ;
;   tgrtemp                          0011:30 adc.jal 
; 30:0 : ;
;   x                                0343:22 \JALCC\JAL\LIB\jdelay.jal 
;   haddr0                         * 0071:18 \JALCC\JAL\LIB\indf_bits.jal 
;   haddr                            0069:27 \JALCC\JAL\LIB\indf_bits.jal 
;   baud_constant                    0083:31 \JALCC\JAL\LIB\f877_modules.jal 
;   data                             0164:32 \JALCC\JAL\LIB\f877_modules.jal 
;   data                             0039:18 adc.jal 
;   x                                0136:10 \JALCC\JAL\LIB\delay_20mc.jal 
;   _loop_temp_15522                 0100:05 horizontal.jal 
;   _loop_temp_15441                 0079:05 horizontal.jal 
;   _loop_temp_15339                 0048:05 horizontal.jal 
;   _loop_temp_15249                 0018:05 horizontal.jal 
;   _loop_temp_15913                 0210:05 horizontal.jal 
;   _loop_temp_15832                 0189:05 horizontal.jal 
;   _loop_temp_15706                 0154:05 horizontal.jal 
;   _loop_temp_15604                 0123:05 horizontal.jal 
;   _loop_temp_16214                 0296:05 horizontal.jal 
;   _loop_temp_16191                 0290:05 horizontal.jal 
;   _loop_temp_16168                 0284:05 horizontal.jal 
;   _loop_temp_16099                 0265:05 horizontal.jal 
;   _loop_temp_16047                 0249:05 horizontal.jal 
;   _loop_temp_15995                 0233:05 horizontal.jal 
; 31:0 : ;
;   x                                0230:25 \JALCC\JAL\LIB\jdelay.jal 
;   haddr0                         * 0051:18 \JALCC\JAL\LIB\indf_bits.jal 
;   haddr                            0049:22 \JALCC\JAL\LIB\indf_bits.jal 
;   laddr                            0069:43 \JALCC\JAL\LIB\indf_bits.jal 
;   data                             0171:34 \JALCC\JAL\LIB\f877_modules.jal 
;   data                             0013:17 adc.jal 
;   x                                0040:10 adc.jal 
; 32:0 : ;
;   y                                0230:36 \JALCC\JAL\LIB\jdelay.jal 
;   laddr                            0049:38 \JALCC\JAL\LIB\indf_bits.jal 
;   haddr0                         * 0061:18 \JALCC\JAL\LIB\indf_bits.jal 
;   haddr                            0059:22 \JALCC\JAL\LIB\indf_bits.jal 
;   pos                              0069:59 \JALCC\JAL\LIB\indf_bits.jal 
;   data                             0146:24 \JALCC\JAL\LIB\bank_arrays.jal 
;   data                             0211:24 \JALCC\JAL\LIB\bank_arrays.jal 
;   data                             0276:24 \JALCC\JAL\LIB\bank_arrays.jal 
;   x                                0014:10 adc.jal 
; 33:0 : ;
;   z                                0230:47 \JALCC\JAL\LIB\jdelay.jal 
;   data                             0049:54 \JALCC\JAL\LIB\indf_bits.jal 
;   laddr                            0059:38 \JALCC\JAL\LIB\indf_bits.jal 
;   temp1                            0072:19 \JALCC\JAL\LIB\indf_bits.jal 
;    return value                    0178:10 \JALCC\JAL\LIB\bank_arrays.jal 
;    return value                    0243:10 \JALCC\JAL\LIB\bank_arrays.jal 
;    return value                    0308:10 \JALCC\JAL\LIB\bank_arrays.jal 
; 34:0 : ;
;   minus_one                        0284:16 \JALCC\JAL\LIB\jdelay.jal 
;   data                             0059:54 \JALCC\JAL\LIB\indf_bits.jal 
;   temp2                            0072:27 \JALCC\JAL\LIB\indf_bits.jal 
; 35:0 : ;
;   xx                               0286:16 \JALCC\JAL\LIB\jdelay.jal 
;   sq_temp_12234                    
; 36:0 : ;
;   a                                0080:15 jal rtl 
;   yy                               0286:20 \JALCC\JAL\LIB\jdelay.jal 
; 37:0 : ;
;   n                                0080:26 jal rtl 
; 38:0 : ;
;    return value                    0080:10 jal rtl 
; 7C:0 : ;
;   array3_index                   * 0067:19 \JALCC\JAL\LIB\bank_arrays.jal 
; 7D:0 : ;
;   array2_index                   * 0066:19 \JALCC\JAL\LIB\bank_arrays.jal 
; 7E:0 : ;
;   array1_index                   * 0065:19 \JALCC\JAL\LIB\bank_arrays.jal 
; 92:0 : ;
;   f877_pr2                       * 0246:19 \JALCC\JAL\LIB\sfr.jal 
; 98:0 : ;
;   f877_txsta                     * 0260:19 \JALCC\JAL\LIB\sfr.jal 
; 98:2 : ;
;   f877_brgh                      * 0264:19 \JALCC\JAL\LIB\sfr.jal 
; 98:5 : ;
;   f877_txen                      * 0266:19 \JALCC\JAL\LIB\sfr.jal 
; 99:0 : ;
;   f877_spbrg                     * 0270:19 \JALCC\JAL\LIB\sfr.jal 
; 9F:0 : ;
;   f877_adcon1                    * 0274:19 \JALCC\JAL\LIB\sfr.jal 

