#ifndef F_CPU
#define F_CPU 8000000 
#endif

#include <avr/io.h>
#include <util/delay.h>

//Nyomgombok
//**************************
#define PIN_PWRONOFFSW   PB5

//**************************

//Kimenetek
//<<<<<<<<<<<<<<<<<<<<<<<<<<
#define PIN_Cooler       PB2 

//<<<<<<<<<<<<<<<<<<<<<<<<<<

//Vezrelt kimentek
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

#define COOLER_ON        PORTB |=  (1<<PIN_Cooler)
#define COOLER_OFF       PORTB &= ~(1<<PIN_Cooler)

//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


//Hfok rtkek termisztoros hmrshez T20C=5,6KOhm-os termisztorral
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#define T80C             921   // 4,5V
#define T75C             901   // 4,4V
#define T70C             880   // 4,3V
#define T65C             860   // 4,2V 
#define T60C             839   // 4,1V
#define T59C             829
#define T55C             819   // 4V 
#define T50C             778   // 3,8V                           
#define T45C             758   // 3,6V   
#define T44C             756             //
#define T40C             717   // 3,3V   // A hfokok az       
#define T40C_            715   // ??     // ADC-nek megfelel rtkekkel 
#define T38C             700   // ??     // amelyek a hfoknak megfelel referenciafeszltsgbl szmithat ki :
#define T35C             675   // 3,2V   // (1024/5000mV)*hmrsklethez tartoz referenciafeszltsg mV-ban
#define T30C             614   // 3V     //
#define T25C             553   // 2,7V
#define T20C             512   // 2,5V
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


//-------------------------------------
void m_delay_10ms(unsigned short val) {
//-------------------------------------
while(val--) _delay_ms(10);
}

//-------------------------------------
void init() {
//-------------------------------------
DDRB = (1<<PIN_Cooler); //kimenetek
PORTB |= (1<<PIN_PWRONOFFSW); //nyomgomb

//Init ADC
          
ADMUX =
      (1<<REFS1)
    | (0<<REFS0)
    | (0<<MUX3)  
    | (0<<MUX2)
    | (0<<MUX1)
    | (1<<MUX0)
	;
ADCSRA = 
      (1<<ADEN)
    | (0<<ADSC)
    | (1<<ADPS2)
    | (1<<ADPS1)
    | (1<<ADPS0)
    ;
//Init Timer0
/* TCCR1A =
      (1<<COM1A1) //1
    |  (0<<COM1A0) //0  //Nem invert. PWM A
    |  (1<<COM1B1) //1
    |  (0<<COM1B0) //0  //Nem invert. PWM B
    |  (0<<WGM11) //0
    |  (1<<WGM10) //1   //Fast PWM
    ;
   TCCR1B = (1<<WGM12) //1
          | (0<<CS12)
          | (0<<CS11)
          | (1<<CS10)      //div 8 -> 9.6/8/256 ~= 4,7 KHz
          ;*/
//Start folyamat
          
//m_delay_10ms(300);
}

//-------------------------------------
unsigned short ADConvert(unsigned char channel) {
//-------------------------------------
           ADMUX &= ~(0<<MUX2
				     |0<<MUX1
				     |1<<MUX0);
           ADMUX |= channel;
           ADCSRA |= (1<<ADSC);
           while(ADCSRA & (1<<ADSC));
           return ADC;
}

//-------------------------------------
int main(void) {
//-------------------------------------
unsigned int Adj_Temp;
unsigned int Temp;

		 init();
         
//Vltozk
//---------------------------	    
		 
         
		 int Cooler = 0;
		 int PWR_sw = 0;
        
    	 for(;;)  {
//---------------------------


//#############################################################################
               
            if(!(PINB & (1<<PIN_PWRONOFFSW))&& PWR_sw==0 && Cooler==0) { //Tesztgomb zrt llapot
                    COOLER_ON;
					PWR_sw = 1;
				    continue;             
			   }

			   if((PINB & (1<<PIN_PWRONOFFSW))&& PWR_sw==1 && Cooler==0) { //Tesztgomb nyitott llapot
			       COOLER_OFF;
				   PWR_sw = 0;
				   continue;
			   }    
				
				
				

 		 				
			Adj_Temp = ADConvert(0);	
		 	Temp = ADConvert(1); //ADC3, CH1 mrt hmrsklet 2-es lb
			   if(Temp<=Adj_Temp && PWR_sw==0 && Cooler==1) { // Ha a hmrsklet alacsony s a szivatty jr 
                   COOLER_OFF; // 6-os lb             // a kimenet alacsony szintre vlt hogy a szivattyt lellitsa  
				   Cooler = 0;
				    }

			   if(Temp>=Adj_Temp && PWR_sw==0 && Cooler==0) { // Ha a hmrsklet alacsony s a szivatty jr 
                   COOLER_ON;                             // a kimenet alacsony szintre vlt hogy a szivattyt lellitsa  
				   Cooler = 1; 
				   }

 
               
           }
        }
