

PM_USED			EQU	1

	INCLUDE	"16F628.INC"

RAM_START       		EQU	00020h
RAM_END         		EQU	0014Fh
RAM_BANKS       		EQU	00003h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00120h
BANK2_END       		EQU	0014Fh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0217Fh

R0              		EQU	RAM_START + 000h
R1              		EQU	RAM_START + 002h
R2              		EQU	RAM_START + 004h
R3              		EQU	RAM_START + 006h
R4              		EQU	RAM_START + 008h
R5              		EQU	RAM_START + 00Ah
R6              		EQU	RAM_START + 00Ch
R7              		EQU	RAM_START + 00Eh
R8              		EQU	RAM_START + 010h
T1              		EQU	RAM_START + 012h
T2              		EQU	RAM_START + 014h
FLAGS           		EQU	RAM_START + 016h
GOP             		EQU	RAM_START + 017h
RM1             		EQU	RAM_START + 018h
RM2             		EQU	RAM_START + 019h
RR1             		EQU	RAM_START + 01Ah
RR2             		EQU	RAM_START + 01Bh
_epromOnTime     		EQU	RAM_START + 01Ch
_fadeSpeed       		EQU	RAM_START + 01Eh
_i               		EQU	RAM_START + 020h
_onTime          		EQU	RAM_START + 022h
_onTimeSetPoint  		EQU	RAM_START + 024h
_onTimeTimer     		EQU	RAM_START + 026h
_secondCalibrate 		EQU	RAM_START + 028h
_x               		EQU	RAM_START + 02Ah
_y               		EQU	RAM_START + 02Ch
_botIRValue      		EQU	RAM_START + 02Eh
_parrernSelected 		EQU	RAM_START + 02Fh
PB01            		EQU	RAM_START + 030h
_programSwitchLastMode		EQU	RAM_START + 031h
_topIRValue      		EQU	RAM_START + 032h
_PORTL           		EQU	 PORTB
_PORTH           		EQU	 PORTA
_TRISL           		EQU	 TRISB
_TRISH           		EQU	 TRISA
#define _step10LED       	_PORTB_0
#define _step9LED        	_PORTB_1
#define _step8LED        	_PORTB_2
#define _step7LED        	_PORTB_3
#define _step6LED        	_PORTB_4
#define _step5LED        	_PORTB_5
#define _step4LED        	_PORTB_6
#define _step3LED        	_PORTB_7
#define _step2LED        	_PORTA_7
#define _step1LED        	_PORTA_0
#define _topSensor       	_PORTA_1
#define _botSensor       	_PORTA_2
#define _auxOutput       	_PORTA_4
#define _IRDrive         	_PORTA_3
#define _setupModeInput  	_PORTA_5
#define _lastActivatedSensor	 PB01, 000h
#define _PORTB_0         	 PORTB, 000h
#define _PORTB_1         	 PORTB, 001h
#define _PORTB_2         	 PORTB, 002h
#define _PORTB_3         	 PORTB, 003h
#define _PORTB_4         	 PORTB, 004h
#define _PORTB_5         	 PORTB, 005h
#define _PORTB_6         	 PORTB, 006h
#define _PORTB_7         	 PORTB, 007h
#define _PORTA_7         	 PORTA, 007h
#define _PORTA_0         	 PORTA, 000h
#define _PORTA_1         	 PORTA, 001h
#define _PORTA_2         	 PORTA, 002h
#define _PORTA_4         	 PORTA, 004h
#define _PORTA_3         	 PORTA, 003h
#define _PORTA_5         	 PORTA, 005h

; Constants.
_IPNormal        		EQU	00000h
_IPAbnormal      		EQU	00001h
_top             		EQU	00000h
_bot             		EQU	00001h

; EEPROM data.
	ORG EEPROM_START

	ORG EEPROM_START + 00001h
	DE	003h

	INCLUDE	"STAIR_~2.MAC"
	INCLUDE	"PBPPIC14.LIB"


	ASM?
 DEVICE pic16F628, INTRC_OSC_CLKOUT 

	ENDASM?


	ASM?
 DEVICE pic16F628, WDT_ON 

	ENDASM?


	ASM?
 DEVICE pic16F628, PWRT_ON 

	ENDASM?


	ASM?
 DEVICE pic16F628, MCLR_OFF 

	ENDASM?


	ASM?
 DEVICE pic16F628, BOD_ON 

	ENDASM?


	ASM?
 DEVICE pic16F628, LVP_OFF 

	ENDASM?


	ASM?
 DEVICE pic16F628, CPD_OFF 

	ENDASM?


	ASM?
 DEVICE pic16F628, PROTECT_OFF 

	ENDASM?

	MOVE?CB	007h, CMCON
	MOVE?CB	000h, TRISB
	MOVE?CB	026h, TRISA
	MOVE?CW	002D1h, _secondCalibrate
	MOVE?CB	_IPAbnormal, _programSwitchLastMode
	MOVE?CW	000h, _onTime
	MOVE?CW	000h, _onTimeTimer
	GOSUB?L	_startup
	GOSUB?L	_readTimeFromFlash
	GOSUB?L	_setOnTimeSetPoint
	CMPEQ?TCL	_setupModeInput, _IPAbnormal, _setupMode
	GOSUB?L	_readSensorValue
	CMPEQ?BCB	_topIRValue, _IPAbnormal, T1
	CMPEQ?BCB	_botIRValue, _IPAbnormal, T2
	LAND?BBW	T1, T2, T2
	CMPF?WL	T2, L00001
	GOTO?L	_programMode
	LABEL?L	L00001	

	LABEL?L	_sensorWatch	
	GOSUB?L	_lightTimer
	CMPNE?WCL	_onTime, 000h, L00003
	GOSUB?L	_readSensorValue
	LABEL?L	L00003	
	CMPEQ?BCB	_botIRValue, _IPAbnormal, T1
	CMPEQ?WCB	_onTime, 000h, T2
	LAND?BBW	T1, T2, T2
	CMPF?WL	T2, L00005
	GOSUB?L	_botSensorAbnormal
	LABEL?L	L00005	
	CMPEQ?BCB	_topIRValue, _IPAbnormal, T1
	CMPEQ?WCB	_onTime, 000h, T2
	LAND?BBW	T1, T2, T2
	CMPF?WL	T2, L00007
	GOSUB?L	_topSensorAbnormal
	LABEL?L	L00007	
	GOTO?L	_sensorWatch

	LABEL?L	_readSensorValue	
	CMPNE?WCL	_onTime, 000h, L00009
	LOW?T	_IRDrive
	LABEL?L	L00009	
	PAUSEUS?C	0012Ch
	MOVE?TB	_topSensor, _topIRValue
	MOVE?TB	_botSensor, _botIRValue
	HIGH?T	_IRDrive
	PAUSE?C	01Eh
	RETURN?	

	LABEL?L	_lightTimer	
	CMPEQ?WCL	_onTime, 000h, L00011
	ADD?WCW	_onTimeTimer, 001h, _onTimeTimer
	PAUSE?C	001h
	CMPLE?WWL	_onTimeTimer, _secondCalibrate, L00013
	ADD?WCW	_onTime, 001h, _onTime
	MOVE?CW	000h, _onTimeTimer
	LABEL?L	L00013	
	CMPLT?WWL	_onTime, _onTimeSetPoint, L00015
	MOVE?CW	000h, _onTime
	MOVE?CW	000h, _onTimeTimer
	GOTO?L	_softOff
	LABEL?L	L00015	
	LABEL?L	L00011	
	RETURN?	

	LABEL?L	_topSensorAbnormal	
	LOW?T	_auxOutput
	GOSUB?L	_lightsOnSoftly
	MOVE?CW	001h, _onTime
	MOVE?CT	_top, _lastActivatedSensor
	RETURN?	

	LABEL?L	_botSensorAbnormal	
	LOW?T	_auxOutput
	GOSUB?L	_lightsOnSoftly
	MOVE?CW	001h, _onTime
	MOVE?CT	_bot, _lastActivatedSensor
	RETURN?	

	LABEL?L	_allLightsOn	
	LOW?T	_step1LED
	LOW?T	_step2LED
	LOW?T	_step3LED
	LOW?T	_step4LED
	LOW?T	_step5LED
	LOW?T	_step6LED
	LOW?T	_step7LED
	LOW?T	_step8LED
	LOW?T	_step9LED
	LOW?T	_step10LED
	RETURN?	

	LABEL?L	_allLightsOff	
	HIGH?T	_step1LED
	HIGH?T	_step2LED
	HIGH?T	_step3LED
	HIGH?T	_step4LED
	HIGH?T	_step5LED
	HIGH?T	_step6LED
	HIGH?T	_step7LED
	HIGH?T	_step8LED
	HIGH?T	_step9LED
	HIGH?T	_step10LED
	RETURN?	

	LABEL?L	_softOff	
	CMPEQ?TCL	_lastActivatedSensor, _top, _softOffDown
	CMPEQ?TCL	_lastActivatedSensor, _bot, _softOffUp
	GOTO?L	_sensorWatch

	LABEL?L	_softOffDown	
	MOVE?CW	003E8h, _fadeSpeed
	MOVE?WW	_fadeSpeed, _x
	MOVE?CW	001h, _i
	LABEL?L	L00017	
	CMPGT?WWL	_i, _fadeSpeed, L00018
	LOW?T	_step1LED
	PAUSEUS?W	_x
	HIGH?T	_step1LED
	PAUSEUS?W	_i
	SUB?WCW	_x, 001h, _x
	NEXT?WCL	_i, 001h, L00017
	LABEL?L	L00018	
	MOVE?WW	_fadeSpeed, _x
	MOVE?CW	001h, _i
	LABEL?L	L00019	
	CMPGT?WWL	_i, _fadeSpeed, L00020
	LOW?T	_step2LED
	PAUSEUS?W	_x
	HIGH?T	_step2LED
	PAUSEUS?W	_i
	SUB?WCW	_x, 001h, _x
	NEXT?WCL	_i, 001h, L00019
	LABEL?L	L00020	
	MOVE?CW	007h, _y
	LABEL?L	L00021	
	CMPLT?WCL	_y, 001h, L00022
	MOVE?WW	_fadeSpeed, _x
	MOVE?CW	001h, _i
	LABEL?L	L00023	
	CMPGT?WWL	_i, _fadeSpeed, L00024
	ADD?TWW	_PORTB_0, _y, T1
	LOW?W	T1
	PAUSEUS?W	_x
	ADD?TWW	_PORTB_0, _y, T1
	HIGH?W	T1
	PAUSEUS?W	_i
	SUB?WCW	_x, 001h, _x
	NEXT?WCL	_i, 001h, L00023
	LABEL?L	L00024	
	NEXTM?WCL	_y, 001h, L00021
	LABEL?L	L00022	
	MOVE?WW	_fadeSpeed, _x
	MOVE?CW	001h, _i
	LABEL?L	L00025	
	CMPGT?WWL	_i, _fadeSpeed, L00026
	LOW?T	_PORTB_0
	PAUSEUS?W	_x
	HIGH?T	_PORTB_0
	PAUSEUS?W	_i
	SUB?WCW	_x, 001h, _x
	NEXT?WCL	_i, 001h, L00025
	LABEL?L	L00026	
	HIGH?T	_auxOutput
	GOTO?L	_sensorWatch

	LABEL?L	_softOffUp	
	MOVE?CW	003E8h, _fadeSpeed
	MOVE?WW	_fadeSpeed, _x
	MOVE?CW	001h, _i
	LABEL?L	L00027	
	CMPGT?WWL	_i, _fadeSpeed, L00028
	LOW?T	_PORTB_0
	PAUSEUS?W	_x
	HIGH?T	_PORTB_0
	PAUSEUS?W	_i
	SUB?WCW	_x, 001h, _x
	NEXT?WCL	_i, 001h, L00027
	LABEL?L	L00028	
	MOVE?CW	000h, _y
	LABEL?L	L00029	
	CMPGT?WCL	_y, 006h, L00030
	MOVE?WW	_fadeSpeed, _x
	MOVE?CW	001h, _i
	LABEL?L	L00031	
	CMPGT?WWL	_i, _fadeSpeed, L00032
	ADD?TWW	_PORTB_0, _y, T1
	LOW?W	T1
	PAUSEUS?W	_x
	ADD?TWW	_PORTB_0, _y, T1
	HIGH?W	T1
	PAUSEUS?W	_i
	SUB?WCW	_x, 001h, _x
	NEXT?WCL	_i, 001h, L00031
	LABEL?L	L00032	
	NEXT?WCL	_y, 001h, L00029
	LABEL?L	L00030	
	MOVE?WW	_fadeSpeed, _x
	MOVE?CW	001h, _i
	LABEL?L	L00033	
	CMPGT?WWL	_i, _fadeSpeed, L00034
	LOW?T	_step2LED
	PAUSEUS?W	_x
	HIGH?T	_step2LED
	PAUSEUS?W	_i
	SUB?WCW	_x, 001h, _x
	NEXT?WCL	_i, 001h, L00033
	LABEL?L	L00034	
	MOVE?WW	_fadeSpeed, _x
	MOVE?CW	001h, _i
	LABEL?L	L00035	
	CMPGT?WWL	_i, _fadeSpeed, L00036
	LOW?T	_step1LED
	PAUSEUS?W	_x
	HIGH?T	_step1LED
	PAUSEUS?W	_i
	SUB?WCW	_x, 001h, _x
	NEXT?WCL	_i, 001h, L00035
	LABEL?L	L00036	
	HIGH?T	_auxOutput
	GOTO?L	_sensorWatch

	LABEL?L	_lightsOnSoftly	
	MOVE?CW	004B0h, _fadeSpeed
	MOVE?WW	_fadeSpeed, _x
	MOVE?CW	001h, _i
	LABEL?L	L00037	
	CMPGT?WWL	_i, _fadeSpeed, L00038
	GOSUB?L	_allLightsOn
	PAUSEUS?W	_i
	GOSUB?L	_allLightsOff
	PAUSEUS?W	_x
	SUB?WCW	_x, 001h, _x
	NEXT?WCL	_i, 001h, L00037
	LABEL?L	L00038	
	GOSUB?L	_allLightsOn
	RETURN?	

	LABEL?L	_startup	
	GOSUB?L	_allLightsOff
	HIGH?T	_IRDrive
	HIGH?T	_auxOutput
	RETURN?	

	LABEL?L	_setupMode	
	GOSUB?L	_readSensorValue
	MOVE?BT	_topIRValue, _step1LED
	MOVE?BT	_botIRValue, _step2LED
	CMPNE?BCL	_topIRValue, _IPAbnormal, L00039
	GOSUB?L	_SetupTopBeamOff
	GOTO?L	L00040
	LABEL?L	L00039	
	GOSUB?L	_SetupTopBeamOn
	LABEL?L	L00040	
	CMPNE?BCL	_botIRValue, _IPAbnormal, L00041
	GOSUB?L	_setupBottomBeamOff
	GOTO?L	L00042
	LABEL?L	L00041	
	GOSUB?L	_setupBottomBeamOn
	LABEL?L	L00042	
	GOTO?L	_setupMode

	LABEL?L	_SetupTopBeamOn	
	LOW?T	_step1LED
	LOW?T	_step3LED
	LOW?T	_step5LED
	LOW?T	_step7LED
	LOW?T	_step9LED
	RETURN?	

	LABEL?L	_SetupTopBeamOff	
	HIGH?T	_step1LED
	HIGH?T	_step3LED
	HIGH?T	_step5LED
	HIGH?T	_step7LED
	HIGH?T	_step9LED
	RETURN?	

	LABEL?L	_setupBottomBeamOn	
	LOW?T	_step2LED
	LOW?T	_step4LED
	LOW?T	_step6LED
	LOW?T	_step8LED
	LOW?T	_step10LED
	RETURN?	

	LABEL?L	_setupBottomBeamOff	
	HIGH?T	_step2LED
	HIGH?T	_step4LED
	HIGH?T	_step6LED
	HIGH?T	_step8LED
	HIGH?T	_step10LED
	RETURN?	

	LABEL?L	_writeTimeToFlash	
	WRITE?CW	001h, _epromOnTime
	RETURN?	

	LABEL?L	_readTimeFromFlash	
	READ?CW	001h, _epromOnTime
	CMPLT?WCB	_epromOnTime, 001h, T1
	CMPGT?WCB	_epromOnTime, 005h, T2
	LOR?BBW	T1, T2, T2
	CMPF?WL	T2, L00043
	MOVE?CW	001h, _epromOnTime
	GOSUB?L	_writeTimeToFlash
	LABEL?L	L00043	
	RETURN?	

	LABEL?L	_setOnTimeSetPoint	
	CMPNE?WCL	_epromOnTime, 001h, L00045
	MOVE?CW	005h, _onTimeSetPoint
	LABEL?L	L00045	
	CMPNE?WCL	_epromOnTime, 002h, L00047
	MOVE?CW	00Ah, _onTimeSetPoint
	LABEL?L	L00047	
	CMPNE?WCL	_epromOnTime, 003h, L00049
	MOVE?CW	014h, _onTimeSetPoint
	LABEL?L	L00049	
	CMPNE?WCL	_epromOnTime, 004h, L00051
	MOVE?CW	01Eh, _onTimeSetPoint
	LABEL?L	L00051	
	CMPNE?WCL	_epromOnTime, 005h, L00053
	MOVE?CW	064h, _onTimeSetPoint
	LABEL?L	L00053	
	CMPLT?WCB	_epromOnTime, 001h, T1
	CMPGT?WCB	_epromOnTime, 005h, T2
	LOR?BBW	T1, T2, T2
	CMPF?WL	T2, L00055
	MOVE?CW	014h, _onTimeSetPoint
	MOVE?CW	003h, _epromOnTime
	LABEL?L	L00055	
	RETURN?	

	LABEL?L	_programModeIncMode	
	CMPLE?WCL	_epromOnTime, 004h, L00057
	MOVE?CW	001h, _epromOnTime
	GOTO?L	L00058
	LABEL?L	L00057	
	ADD?WCW	_epromOnTime, 001h, _epromOnTime
	LABEL?L	L00058	
	GOSUB?L	_writeTimeToFlash
	RETURN?	

	LABEL?L	_programMode	
	MOVE?CW	001h, _x
	LABEL?L	L00059	
	CMPGT?WWL	_x, _epromOnTime, L00060
	GOSUB?L	_allLightsOn
	GOSUB?L	_programModeShortDelay
	GOSUB?L	_allLightsOff
	GOSUB?L	_programModeShortDelay
	NEXT?WCL	_x, 001h, L00059
	LABEL?L	L00060	
	GOSUB?L	_programModeLongDelay
	GOTO?L	_programMode

	LABEL?L	_programModeShortDelay	
	MOVE?CW	001h, _i
	LABEL?L	L00061	
	CMPGT?WCL	_i, 00Ah, L00062
	GOSUB?L	_readSensorValue
	CMPEQ?BCB	_topIRValue, _IPNormal, T1
	CMPEQ?BCB	_programSwitchLastMode, _IPAbnormal, T2
	LAND?BBW	T1, T2, T2
	CMPF?WL	T2, L00063
	GOSUB?L	_programModeIncMode
	GOSUB?L	_setOnTimeSetPoint
	GOSUB?L	_programModeSettingChangedBurst
	MOVE?CB	_IPNormal, _programSwitchLastMode
	GOTO?L	_programMode
	LABEL?L	L00063	
	CMPNE?BCL	_topIRValue, _IPNormal, L00065
	MOVE?CB	_IPNormal, _programSwitchLastMode
	GOTO?L	L00066
	LABEL?L	L00065	
	MOVE?CB	_IPAbnormal, _programSwitchLastMode
	LABEL?L	L00066	
	PAUSE?C	005h
	NEXT?WCL	_i, 001h, L00061
	LABEL?L	L00062	
	RETURN?	

	LABEL?L	_programModeLongDelay	
	MOVE?CW	001h, _i
	LABEL?L	L00067	
	CMPGT?WCL	_i, 028h, L00068
	GOSUB?L	_readSensorValue
	CMPEQ?BCB	_topIRValue, _IPNormal, T1
	CMPEQ?BCB	_programSwitchLastMode, _IPAbnormal, T2
	LAND?BBW	T1, T2, T2
	CMPF?WL	T2, L00069
	GOSUB?L	_programModeIncMode
	GOSUB?L	_setOnTimeSetPoint
	GOSUB?L	_programModeSettingChangedBurst
	MOVE?CB	_IPNormal, _programSwitchLastMode
	GOTO?L	_programMode
	LABEL?L	L00069	
	CMPNE?BCL	_topIRValue, _IPNormal, L00071
	MOVE?CB	_IPNormal, _programSwitchLastMode
	GOTO?L	L00072
	LABEL?L	L00071	
	MOVE?CB	_IPAbnormal, _programSwitchLastMode
	LABEL?L	L00072	
	PAUSE?C	005h
	NEXT?WCL	_i, 001h, L00067
	LABEL?L	L00068	
	RETURN?	

	LABEL?L	_programModeSettingChangedBurst	
	MOVE?CW	001h, _i
	LABEL?L	L00073	
	CMPGT?WCL	_i, 00Fh, L00074
	GOSUB?L	_allLightsOn
	PAUSE?C	014h
	GOSUB?L	_allLightsOff
	PAUSE?C	014h
	NEXT?WCL	_i, 001h, L00073
	LABEL?L	L00074	
	RETURN?	
	END?	

	END
