#DEFINE SRCLK   PORTB,4     ; 74hc595 clock output
#DEFINE SRDAT   PORTB,5     ; 74hc595 data output  
#DEFINE SRLAT   PORTB,3     ; 74hc595 output latch 

;----------------------------------------------------------------------
;  set LEDs to match WREG
;  8 bits are clocked out to 74hc595 and then strobed to output register
;----------------------------------------------------------------------
set_leds
	 movwf   sr_sr           ; save a temp copy of LED image
	movlw 	d'8'		    ; 8 hi bits to shift out
	movwf 	sr_tmp
   

sr_001
	bcf	    SRDAT	        ; start with bit low
	rlf 	sr_sr,f		    ; rotate bits through c
	btfsc	STATUS,C
	bsf	    SRDAT   	    ; flip data if needed
	nop

	bsf	    SRCLK	        ; strobe active rising edge
	nop
	bcf	    SRCLK

	decfsz	sr_tmp,f
	goto	sr_001		    ; loop for rest of bits in byte	
    
	bsf	    SRLAT	        ; xfer data from sr to output latch
	nop
	bcf	    SRLAT

	return
