#include <avr/io.h>         // Az I/O nevek definicioja
#include <avr/interrupt.h>  // Megszakitassal kezeljuk a soros portot
 
#define F_CPU 8000000       // A processzor orajele
#define BAUDRATE 9600       // Az atvitel sebessege
//calculate UBRR value
#define UBRRVAL ((F_CPU/(BAUDRATE*16UL))-1)  // Kiszamitjuk a leosztas erteket
 
void USART_Init();          // A soros egyseg (USART) inicializalasa
 
int main(void)
   {
   int byte;
   DDRC=0x3F;                 // A C port adatiranya 1-ki, 0-be 
   PORTC=0x01;                // A PORTC LSB legyen egy
	
   USART_Init();              // Inicializaljuk az USART-ot
 
   PORTC=0x00;
   sei();             // IT engedelyezese
   while(1)           // Vegtelen ciklus
      {
      }
   return 0;          // Ide soha nem jut el
   }
 
void USART_Init()
   {
	                        //baud belltsa
   UBRR0L=UBRRVAL;		//low byte
   UBRR0H=(UBRRVAL>>8);	//high byte
   UCSR0C=(0<<UMSEL01)|(0<<UMSEL00)|(0<<UPM01)|(0<<UPM00)|
		(0<<USBS0)|(0<<UCSZ02)|(1<<UCSZ01)|(1<<UCSZ00);	        //belltjuk asinkron md, 8 adatbit, 0 paritsbit, 1 stopbit
   UCSR0B=(1<<RXEN0)|(1<<TXEN0) |(1<<RXCIE0);               	        //engedlyezzk a megszaktst ha fogadott egy bjtot
   }
 
// ide akkor ugrik ha fogadott egy teljes bjtot
// ez a megszakitast kiszolgalo rutin
 
ISR(USART_RX_vect)
   {
   char byte;
   byte=UDR0;                                                               // a fogadott bajtot betszi a byte nevu valtozoba
 
   if( (byte >= 'a' && byte <='z') || (byte >= 'A' && byte <= 'Z'))	    // ha betu akkor
      {
      byte=byte^32;                                                         // megcsereli a mertet kicsibol nagyra ,  nagybol kicsibe
      } 
 
   while ( !( UCSR0A & (1<<UDRE0)) );                                       // var ameddig kesz nem lesz a soros egyseg arra hogz uj bajtot kuldjunk
                                                                            // Na ilyet soha ne csinalj, mert kiszamithatatatlan lesz a progi, de most                        
                                                                            // kivetelesen elmegy
   UDR0=byte;                                                               // elkuldjuk az uj bajtot
   }
