#include <pic18.h>
#include "hitech.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "delay.h"
#include "Nokia_LCD.h"
#include "sajat.h"

__CONFIG(1,HSPLL & OSCSDIS);
__CONFIG(2,BORDIS & WDTDIS);
__CONFIG(3,CCP2RC1);
__CONFIG(4,DEBUGDIS & LVPDIS & STVRDIS);
__CONFIG(5,49167);
__CONFIG(6,57359);
__CONFIG(7,SWDTDIS);

 //Nyomgombok
#define lenyil   RA4
#define felnyil  RA1
#define jobbnyil RA3
#define balnyil  RA2
#define enter    RE0
#define esc      RA5

//#define EGYES 112  //(112) 58 usec flperidus
//#define NULLA 196  //(196) 100 usec flperidus
#define PREAMBLE 14  // preamble bitek szma

unsigned int j,EGYES,NULLA;
unsigned char utasitas,s[10],mi;

void BEALLITASOK(void)
{
  TRISA=0B11111111;
  ADCON1=0B11001110;
  ADCON0=0B00000000;
  TRISB=0B00000000;
  TRISC=0B10000000;
  TRISD=0B00000000;
  TRISE=0B001;
  LATB=0;
  LATD=0;
  LATC=0;
  T0CON=0b11000011;
  INTCON=0b10100100;

}

void interrupt isr(void) //kb 8KHZ
{
 RD0=!RD0; 
 TMR0IF=0;
 TMR0=217;
}

void BITEK(unsigned char adat) 
{
 unsigned char i,x;
 i=0;
  do 
   {
    if(i==7) x=0B00000001;
    if(i==6) x=0B00000010;
    if(i==5) x=0B00000100;
    if(i==4) x=0B00001000;
    if(i==3) x=0B00010000;
    if(i==2) x=0B00100000;
    if(i==1) x=0B01000000;
    if(i==0) x=0B10000000;
    if(adat&x)
       {
        RD0=1;
        DelayBigUs(EGYES); 
        RD0=0;
        DelayBigUs(EGYES);
       }
      else
       {
        RD0=1;
        DelayBigUs(NULLA); 
        RD0=0;
        DelayBigUs(NULLA);
       }   
    i++;
   } 
  while(i<8); 
}

void PACKET(unsigned char cim,unsigned char utasitas)
{
unsigned char i,x,hiba;
 hiba=cim^utasitas;
 i=0;
 TMR0ON=0; //timer0 kikapcsols
  do 
   {
    RD0=1;
    DelayBigUs(EGYES); 
    RD0=0;
    DelayBigUs(EGYES); 
    i++;
   } 
  while(i<PREAMBLE);
 RD0=1; DelayBigUs(NULLA); RD0=0; DelayBigUs(NULLA); //lezr 0
 BITEK(cim);
 RD0=1; DelayBigUs(NULLA); RD0=0; DelayBigUs(NULLA); //lezr 0
 BITEK(utasitas);
 RD0=1; DelayBigUs(NULLA); RD0=0; DelayBigUs(NULLA); //lezr 0
 BITEK(hiba);
 RD0=1; DelayBigUs(EGYES); RD0=0; DelayBigUs(EGYES); //lezr 1
 TMR0ON=1;//timer0 bekapcsols
}

void main(void)
{
 BEALLITASOK();
 Lcd_init(); 
 EGYES=112;  
 NULLA=196; 
 GIE=1;
 LCD_printstr(1,1,"8KHZ",0);
 mi=1;

 do
  {
    if(enter==0)
      {
       if(mi==0) utasitas=0B01100000;  
       if(mi==1) utasitas=0B01100001;  
       if(mi==2) utasitas=0B01100010;  
       if(mi==3) utasitas=0B01100011;  
       if(mi==4) utasitas=0B01100100;  
       if(mi==5) utasitas=0B01100101;  
       if(mi==6) utasitas=0B01100110;  
       if(mi==7) utasitas=0B01000111;
       if(mi==8) utasitas=0B01101000;
       LCD_printstr(1,1,"              ",0);
       LCD_printstr(1,1,"Packet=",0); 
       INTOSTR(s,mi); 
       LCD_printstr(8,1,s,0);        
       do
        {    //3-as mozdony aktulis sebessg
         PACKET(3,utasitas);
        }
       while(esc!=0);
       LCD_printstr(1,1,"              ",0);
       LCD_printstr(1,1,"8KHZ",0);
      } 

    if(lenyil==0)
      {
        if(mi>0) mi--;       
       LCD_printstr(1,2,"              ",0);
       LCD_printstr(1,2,"Sebessg=",0); 
       INTOSTR(s,mi); 
       LCD_printstr(10,2,s,0);  
       do
        {
       
        }
       while(lenyil==0); //pergs mentests
      } 
    if(felnyil==0)
      {
        if(mi<8) mi++;       
       LCD_printstr(1,2,"              ",0);
       LCD_printstr(1,2,"Sebessg=",0); 
       INTOSTR(s,mi); 
       LCD_printstr(10,2,s,0);  
       do
        {
       
        }
       while(felnyil==0); //pergs mentests
      } 
   if(jobbnyil==0) //packet idzts vltoztats
      {
       LCD_printstr(1,1,"              ",0);
       LCD_printstr(1,2,"              ",0);
       LCD_printstr(1,2,"Bellts",0); 
       TMR0ON=0; //timer0 kikapcsols
       INTOSTR(s,EGYES); 
       LCD_printstr(1,3,"              ",0);
       LCD_printstr(1,3,s,0);
       INTOSTR(s,NULLA); 
       LCD_printstr(1,4,"              ",0);
       LCD_printstr(1,4,s,0);
        do{}while(jobbnyil==0);//pergs mentests
       do
        {
         if(lenyil==0) 
           {
            NULLA--;
            EGYES=(int)(NULLA/1.74);
            INTOSTR(s,EGYES); 
            LCD_printstr(1,3,"              ",0);
            LCD_printstr(1,3,s,0);
            INTOSTR(s,NULLA); 
            LCD_printstr(1,4,"              ",0);
            LCD_printstr(1,4,s,0);
            do{}while(lenyil==0);//pergs mentests
           } 
         if(felnyil==0) 
           {
            NULLA++;
            EGYES=(int)(NULLA/1.74);
            INTOSTR(s,EGYES); 
            LCD_printstr(1,3,"              ",0);
            LCD_printstr(1,3,s,0);
            INTOSTR(s,NULLA); 
            LCD_printstr(1,4,"              ",0);
            LCD_printstr(1,4,s,0);
            do{}while(felnyil==0);//pergs mentests
           } 

        }
       while(enter!=0);
       TMR0ON=1;//timer0 bekapcsols
       LCD_printstr(1,2,"              ",0);
      }  
  }
 while(1); 
}
/*
Univerzlis lokodekder.
 Az els bekapcsolskor a kvetkez adatok lltdnak be.
- CV1   mozdonycm (3)
- CV2   elindulsi feszltsg (20)
- CV3   gyorsts (1)
- CV4   fkezs (2)
- CV5   max. gyorsasg (200)
- CV9   PWM (3)
             000-2kHz, 001-1kHz, 010-500Hz, 011-250Hz, 100-125Hz, 101-62Hz, 110-31Hz, 111-15Hz
- CV19 sszetett mozdonycm (0)
- CV29 bit 0 menetirny (0)
             bit 1 menetfokozat 14/28 (1)
- CV64 bit 0 vilgts a menetirny szerint ki/be (1)
             bit 1 izzszimulci ki/be (1)
             bit 2 ksleltets a menetirnyvltsnl ki/be (0)
- CV65 indulskor tbb energit ad a motorra (20)
**********************************************************************
111111111111  0 0AAAAAAA 0 01DCSSSS     0 EEEEEEEE 1
1Byte=bevezet  2Byte=cm  3byte=         4byte=hiba byte  
                           01=utasts
                           D=irny bit 
                           C=vilgts
                           SSSS=sebessg  
*/

