;==============================================================
; Copyright 2002 Eelke Visser
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
; 
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;==============================================================
                                LIST P=PIC16F84
                                ; Zet het processor type.
                                INCLUDE p16f84.inc
                                ; Haal de juiste processor register file op.
;==============================================================
				
				INCLUDE DEv_FAM.INC
P16_MAP1	SET	FALSE
P16_MAP2	SET	FALSE

				INCLUDE MATH16.INC				
				
                                ; Voeg de subroutines in.
;==============================================================


SCL    equ     H'0'            ; SCLK is RA0
SDA    equ     H'1'            ; DIN is RA1
MRQ    equ     H'2'            ; Dout is RA2
;      equ     H'3'            ; RESPOND is RA3

;==============================================================
        CBLOCK  H'0C'           ; Eerste vrije geheugen locatie in het Data RAM
        T1                      ; temp 1
        T2                      ; temp byte
        T3
        T4
        T5

	STAT
	FILTER
        W1                      ; temp 's, voor het wachten.
        W2
        W3
        
	TMR1			; timers for 3 bytes timer.
	TMR2
	TIM0
	TIM1
	TIM2
	
	PLS0			; aantal pulsen 
	PLS1
	HI			; Delen!!!
	LO
	RESLT

	POINT
	I2CBYTE			; i2c hulp bytes
	I2CBITCNT
	AARGB5;
	AARGB4

	AARGB3
	AARGB2
	AARGB1
	AARGB0
	SIGN

	TEMPB0
	TEMPB1
	TEMPB2
	TEMPB3
	LOOPCOUNT

	BARGB0
	BARGB1
	BARGB2
	REMB0
	REMB1

	REMB2
	TEMP
   	WSTACK                  ; de stack :-)))
        STATSTACK               

 
	


        ENDC                    ; Einde van het C-Block
;==============================================================
        org     H'0'            ; Eerste adres
        goto    Start           ; Start prog
;	goto Test
        org     H'3FF'          ; Hoogste program adres
        goto    Start           ; Start prog
                                ; Mocht de processor tegen deze adressen aanlopen door storing of id. dan weer bij het begin van het programma beginnen.

;==============================================================
        org     H'0004'         ; interrupt controller op adres 4
                                ; Hier komt de code voor de interrupts.

Push:   movwf WSTACK            ; klap w ff op de stack
        swapf STATUS,W          ; verplaats status naar w zonder de status bits te wijzigen.
        MOVWF STATSTACK         ; klap status op zijn stack
Isr:                            ; hier wordt de interruptroutine afgehandeld.

        bcf STATUS,RP0          ; switch naar bank 0 indien nodig.
				; Start de ISR routine hier.
	btfss INTCON,2
	goto bit
				; timer overflow!
	incf TMR1,F		; tmr1=tmr1+1
	btfsc STATUS,Z		;Carry?
	incf TMR2,F
	bcf INTCON,2		; neem tim intbron weg!
	

				; als filter >= 1 then filter++
	movfw FILTER		; w=filter
	sublw D'00'		; w=1-w of w=1-filter
	btfss STATUS,C		; is Filter 16?
	incf FILTER,F

				; als filter = 2 then filter is 0 en INTE=1	
	movfw FILTER		; w=filter
	sublw D'16'		; w=16-w of w=16-filter
	btfss STATUS,Z		; is Filter 16?
	goto pop		; nee weg wezen
				; ja filter = 0 en inte=1
	clrf FILTER
	bcf INTCON,1		; neem puls interrupt weg
	bsf INTCON,INTE		; interrrupt voor rb0 weer aan.

	goto pop	
;filter1:;
				; filter =filter +1 
	;movfw FILTER		; w=filter
	;sublw H'01'		; w=2-w w=2-filter
	;btfss STATUS,Z		; is Filter 2?
	;goto pop		; nee weg wezen
				; filter=1
;	movlw H'02'
;	movwf FILTER

;	goto pop		


bit:	
				; Start de ISR routine hier.
	btfss INTCON,1
	goto pop


				; en copie de waarde?

				; er kwam een puls binnen
				; als stat =1 dan tim=0 puls =0 STAT=0
									
				; als stat =0
				; dan puls++



	movfw FILTER
	btfss STATUS,Z		
	goto pop			; ALs filter = 0 then geldige pulse 
	movlw H'01'
	movwf FILTER		; We hebben een pulse dus filter=1 start tellen!

	bcf INTCON, INTE	; interrupt voor puls uit!

	movfw STAT
	btfsc STATUS,Z		; is ie nul?
	goto bittel		; ja dus goto bittel voor puls ++
				; nee dus is ie 1, reset meting!

	clrf TMR0
	clrf TMR1
	clrf TMR2
	clrf PLS1
	clrf PLS0

	clrf STAT
	bcf INTCON,1		; neem intbron weg!
	goto pop
bittel:
				; inc puls
	movfw TMR0
	movwf TIM0
	movfw TMR1
	movwf TIM1
	movfw TMR2
	movwf TIM2

	incf PLS0,F		
	btfsc STATUS,Z		; PLS++
	incf PLS1,F

	bcf INTCON,1		; neem intbron weg!
	;goto pop
					

				; Stop met de ISR
pop:	swapf STATSTACK,W       ; verpl statstack naar w
        movwf STATUS            ; herstel status
        swapf WSTACK,F          ; verpl wstack naar w
        swapf WSTACK,w          ; verpl wstack naar w
        retfie                  ; return from Interrupt !
;==============================================================
Start:                          ; Begin van de test code.

	call Initi2c		; initialiseer de io        	
	call Flash	
	call Initi2c		; initialiseer de io        
    	
	bcf PORTA,MRQ
	call W1ms
    	bsf PORTA,MRQ
	call W1ms
	call Starti2c


	movlw H'94'
	call Sendi2c 		; ("&h94")

    	bcf PORTA,MRQ

	movlw H'01'		; WELCOME
	call Sendi2c 		
	movlw H'01'
	call Sendi2c 		
	movlw H'AE'
	call Sendi2c 	;AE 8A 98 86 9E 9B 8A 40 		
	movlw H'8A'
	call Sendi2c 		
	movlw H'98'
	call Sendi2c 		
	movlw H'86'
	call Sendi2c 		
	movlw H'9E'
	call Sendi2c 		
	movlw H'9B'
	call Sendi2c 		
	movlw H'8A'
	call Sendi2c 		
	movlw H'40'
	call Sendi2c 		

	bsf PORTA,MRQ
	call Stopi2c


	call Flash2		; wait ff...

	clrf TMR1
	clrf TMR2

	movlw H'ff'
	movwf TIM0
	movwf TIM1
	movwf TIM2

	movlw H'01'
	movwf STAT
		
	clrf FILTER		; FILTER om de intb interrrupt ff uit te zetten gedurende 256 us

	clrf PLS1
	clrf PLS0	
	;movlw H'01'
	;movwf PLS0

	call Initi2c		; initialiseer de io        
	call Init               ; initialiseer de isr.
	


    	bcf PORTA,MRQ
	call W1ms
    	bsf PORTA,MRQ
	call W1ms
	call Starti2c


	movlw H'94'
	call Sendi2c 		; ("&h94")

    	bcf PORTA,MRQ

	movlw H'01'		; WELCOME
	call Sendi2c 		
	movlw H'01'
	call Sendi2c 		
	movlw H'AE'
	call Sendi2c 	;AE 8A 98 86 9E 9B 8A 40 		
	movlw H'8A'
	call Sendi2c 		
	movlw H'98'
	call Sendi2c 		
	movlw H'86'
	call Sendi2c 		
	movlw H'9E'
	call Sendi2c 		
	movlw H'9B'
	call Sendi2c 		
	movlw H'8A'
	call Sendi2c 		
	movlw H'40'
	call Sendi2c 		

	bsf PORTA,MRQ
	call Stopi2c


        call Flash2


Dummy:
	movfw STAT
	btfss STATUS,Z
	goto Label0
	bcf INTCON,7            ; Even geen interrupts aub.
				; TIM012 bevat de gemeten tijd.
				; Sla dat op! Zodat ints weer aan kunnen
				; PLS01 bevat de aantallen pulsen
				; Sla dat op! Zodat ints weer aan kunnen
	movfw TIM0
	movwf W1
	movfw TIM1
	movwf W2
	movfw TIM2
	movwf W3

	movfw PLS0
	movwf 	T1
	movfw PLS1
	movwf 	T2
	
	movlw H'01'
	movwf STAT		; STAT =1 herstart de meting!	

	bsf INTCON,7            ; Interrupts aub.
				; puls = puls * 30 000 000 =H'01 c9 c3 80'

	movlw H'80';
	movwf AARGB3
	movlw H'C3'
	movwf 	AARGB2
	movlw H'C9'
	movwf 	AARGB1
	movlw H'01'
	movwf 	AARGB0

	movlw H'00'
	movwf 	AARGB4
	movwf 	AARGB5


				; BARGB01 wordt gezet tijden de int uit periode.
	movfw T1
	movwf 	BARGB1
	movfw T2
	movwf 	BARGB0
	movlw H'00'
	movwf 	BARGB2

	CALL 	FXM3216U	; Multiply!!!
				; Antwoord staat in AAARG A0..A5.
				; in : AAARG: A0..A3
	
	movfw AARGB2
	movwf AARGB0
	movfw AARGB3
	movwf AARGB1
	movfw AARGB4
	movwf AARGB2
	movfw AARGB5
	movwf AARGB3
	clrf AARGB4
	clrf AARGB5

	movfw W1
	movwf BARGB2
	movfw W2
	movwf BARGB1
	movfw W3
	movwf BARGB0
	
	Call	FXD3224U		; division!!!
					; uit: A0...A3
				; Het antwoord moet LO,HI komen te staan!


	movfw AARGB3
	movwf LO
	movfw AARGB2
	movwf HI
	goto Labelnot0
Label0:
	clrf LO
	clrf HI
	;call flash?
				
Labelnot0:
	call Valtostr		; converteer de LO HI naar T5..T1

    	bcf PORTA,MRQ		; RPMXXXXX!!!
	call W1ms
    	bsf PORTA,MRQ
	call W1ms
	call Starti2c


	movlw H'94'
	call Sendi2c 		; ("&h94")

    	bcf PORTA,MRQ

	movlw H'01'		; 
	call Sendi2c 		
	movlw H'01'
	call Sendi2c 		
	movlw H'A4'
	call Sendi2c 		
	movlw H'A1'
	call Sendi2c 		
	movlw H'9b'
	call Sendi2c 		
	movfw T1
	call Sendi2c 		
	movfw T2
	call Sendi2c 		
	movfw T3
	call Sendi2c 		
	movfw T4
	call Sendi2c 		
	movfw T5
	call Sendi2c 		

	bsf PORTA,MRQ
	call Stopi2c

				; blink ledje en wacht ff.
        call Flash


Einde:
        goto Dummy              ; Programma heeft geen einde.
;==============================================================
                                INCLUDE i2csub.ASM
                                ; Voeg de time-subroutines in.
;==============================================================
                                INCLUDE time.ASM
                                ; Voeg de time-subroutines in.
;==============================================================
                                INCLUDE init.ASM
                                ; Voeg de init-subroutines in.
;==============================================================
                                INCLUDE math.ASM
                                ; Voeg de init-subroutines in.
;==============================================================
				INCLUDE FXM26.A16
				INCLUDE FXD24.A16
;==============================================================
        END
