;==============================================================
; Copyright 2002 Eelke Visser
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
; 
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;==============================================================
;
; Deze file bevat alleen subroutines die vanuit iedere andere
; willekeurige file aangeroepen kunnen worden mits deze file
; geINCLUDE is. 
;==============================================================
Initi2c:                        ; Start van de init routine voor i2c praat.

        bsf STATUS,RP0          ; Zet de rp0 status op 1.

        bcf TRISA^80H,SCL       ; Zet SCL (=ra0) als output
        bcf TRISA^80H,SDA       ; Zet SDA (=ra1) als output
        bcf TRISA^80H,MRQ       ; Zet mrq (ra3) als output
        bcf TRISA^80H,3         ; zet de LED op output.

        bsf TRISA^80H,4         ; Zet SCL (=ra4) als output
        bsf TRISA^80H,5         ; Zet SCL (=ra5) als output
        bsf TRISA^80H,6         ; Zet SCL (=ra6) als output
        bsf TRISA^80H,7         ; Zet SCL (=ra7) als output

        bcf STATUS,RP0          ; Zet de rp0 status op 0.

        bsf PORTA,SDA           ; Zet SDA op 1
        bsf PORTA,SCL           ; Zet SCL op 1
        bsf PORTA,MRQ           ; Zet SCL op 1

        bcf PORTA,3             ; error lamp = out

        return                  ; Ga terug naar de aanroepende code
;==============================================================
Starti2c:                       ; Genereer een start conditie op de i2c bus.

                                ; Zet de richting op output.
        bsf STATUS,RP0          ; Zet de rp0 status op 1.
        bcf TRISA^80H,SDA           ; Zet SDA als output
        bcf TRISA^80H,SCL           ; Zet SCL als output
                        
                                ; Zet SDA en SCL op 1
        bcf STATUS,RP0          ; Zet de rp0 status op 0.
        bsf PORTA,SDA           ; Zet SDA op 1
        bsf PORTA,SCL           ; Zet SCL op 1

     
	call W1ms
   	                        ; wacht 5 us

                                ; Zet SDA op 0 en zie een i2c start.
        bcf STATUS,RP0          ; Zet de rp0 status op 0.
        bcf PORTA,SDA           ; Zet SDA op 0

	call W1ms

        return                  ; ga terug naar de aanroepende code
;==============================================================
Stopi2c:                        ; Genereer een stop conditie op de i2c bus.

                                ; Zet de richting op output.
        bsf STATUS,RP0          ; Zet de rp0 status op 1.
        bcf TRISA^80H,SDA           ; Zet SDA als output
        bcf TRISA^80H,SCL           ; Zet SCL als output

                                ; Zet SDA op 0 en SCL op 1
        bcf STATUS,RP0          ; Zet de rp0 status op 0.
        bcf PORTA,SDA           ; Zet SDA op 0
        bsf PORTA,SCL           ; Zet SCL op 1

	call W1ms
                                ; Zet SDA op 1 en zie een i2c stop.
        bcf STATUS,RP0          ; Zet de rp0 status op 0.
        bsf PORTA,SDA           ; Zet SDA op 1
	call W1ms
        return                  ; ga terug naar de aanroepende code
;==============================================================
Sendi2c:                        ; Verstuur de byte die in het W-register staat.
        movwf I2CBYTE           ; De te versturen byte gaat naar I2CBYTE.
        
        movlw 8                 ; Verstuur bits 7 tot 0 (8 stuks)
        movwf I2CBITCNT         ; I2CBITCNT telt het aantal bits.

        bsf STATUS,RP0          ; Ga naar pagina 1

        bcf TRISA^80H,SDA           ; SDA is output = 0

        bcf STATUS,RP0          ; Ga naar pagina 0

Sendi2clp:                      ; Label: LOOP naar i2c send.

        bcf PORTA,SCL           ; Clock op nul zodat de data gewijzigd kan worden.

	call W1ms

        btfsc I2CBYTE,7         ; Is bit 7 van I2CBYTE gelijk aan 1
        goto Sendi2csda1        ; Ja, bit7 is 1.

Sendi2csda0:
        bcf PORTA,SDA           ; Nee, bit 7 is 0. SDA is ook 0
        goto Sendi2ctst

Sendi2csda1:
        bsf PORTA,SDA           ; SDA is 1

Sendi2ctst:
	call W1ms


        bsf PORTA,SCL           ; Clock op een zodat de data gelezen wordt door receiver.

	call W1ms

        rlf I2CBYTE,F              ; schuif VAR1 over 1 bit naar links.

        decfsz I2CBITCNT,F           ; Is I2CBITCNT gelijk aan 0 ?
        goto Sendi2clp          ; Nee dus nog minstens 1 bit teversturen.
                                ; Ja, alle bits zijn verstuurd.

;controleer de ack

        bcf STATUS,RP0          ; Ga naar pagina 0

        bcf PORTA,SCL           ; Clock op nul zodat de data gewijzigd kan worden.

        bsf STATUS,RP0          ; pag1
        bsf TRISA^80H,SDA           ; sda is input
        bcf STATUS,RP0          ; pag0

	call W1ms

        bsf PORTA,SCL           ; Clock op een zodat de data gelezen wordt door master

	call W1ms
        bcf STATUS,C            ; Nee, Clear carry (Acknoledge alles = ok)
        btfsc PORTA,SDA         ; Is R-SDA gelijk aan 0 ?
        bsf STATUS,C            ; Ja, zet carry (NACK, niet ok)

        bcf PORTA,SCL           ; Clock op nul zodat de data gewijzigd kan worden.

	call W1ms

        return                  ; ga terug naar de aanroepende code
;==============================================================
