;----------------------------------------------------------------------------;
; Echo (T = 0 to 420ms)
;----------------------------------------------------------------------------;
; Note1: ATtiny26 @16MHz

.include "tn26def.inc"	; This file is contained in "AVR Family Assembler".
.include "avr.inc"
.include "vp_def.inc"


;----------------------------------------------------------;
; Program code

.cseg

	outi	SP, RAMEND
	 rcall	init_io

	lsr	_VOL		;FIFO length (delay time) is 0 to 0x4000
	lsr	_VOL		;/


;---------------------------------------;
; Main loop (38.5kHz)

main:
	RFSH2
	CVS	AH
	XFER
	CVS	AL

	 rcall	read_ram	;Read FIFO
	asr	AH		;x0.5
	ADDS	AL, AH		;Add to new sample
	 rcall	write_ram	;Store FIFO
	mov	AH, AL		;Next output value

	adiw	XL, 1		;Next ptr
	cp	XH, _VOL	;Wrap by FIFO length
	brcs	PC+2		;
	clr	XH		;/

	rjmp	main



;---------------------------------------;
; Read from RAM (29clk)
;
;AH = read data

read_ram:
	READ
	ret


;---------------------------------------;
; Write to RAM (21clk)
;
;AL = data to be written

write_ram:
	WRITE
	ret


;---------------------------------------;
; Initialize peripherals

init_io:
	clr	_0
	clr	_255
	dec	_255

	ldi	AL, 0b10100111
	mov	_NTRL, AL
	ldi	AL, 0b10000111
	mov	_RAS0, AL
	ldi	AL, 0b10000101
	mov	_CAS0, AL
	ldi	AL, 0b11000111
	mov	_RAS1, AL
	ldi	AL, 0b11000101
	mov	_CAS1, AL
	ldi	AL, 0b10000100
	mov	_OE, AL
	ldi	AL, 0b10000001
	mov	_WE, AL

	outi	MCUCR, 0b01000000	;Disable pull-ups

	out	PORTB, _NTRL		;RAS,CAS,OE,WE,OC1B = output
	outi	DDRB, 0b10101111	;/
	out	DDRA, _255		;AD0..7 = output

					;A/D converter
	outi	ADMUX, 0b00101001	;Ch9:, Vref:Vcc
	outi	ADCSR, 0b11110101	;Clock:500kHz
	sbis	ADCSR, 4		;Wait for EOC
	rjmp	PC-1			;/
	in	_VOL, ADCH		;Get volume setting (PB6)
	outi	ADMUX, 0b10100111	;Ch:7, Vref:2.56V

	outi	DDRB, 0b11101111	;A8 = output

					;Timer/Counter 1
	outi	PLLCSR, 0b00000110	;Select 64MHz PLL clock for TC1
	outi	TCCR1A, 0b00100001	;Enable TC1 8bit 250kHz PWM mode
	outi	TCCR1B, 0b00000001	;
	out	OCR1C, _255		;/

	ldiw	X, 0			;Clear RAM
	ldi	AL, 0			;
	 rcall	write_ram		;
	adiw	XL, 1			;
	brne	PC-2			;/

	ret
