;------------------------------------------------------------;
; Voice processor macros
;
; (C)ChaN, 2004


.def	_0	= r15
.def	_255	= r14
			; A8 RAS CAS  OE  WE
.def	_NTRL	= r13	; L   H   H   H   H
.def	_RAS0	= r12	; L   L   H   H   H
.def	_CAS0	= r11	; L   L   L   H   H
.def	_RAS1	= r10	; H   L   H   H   H
.def	_CAS1	= r9	; H   L   L   H   H
.def	_OE	= r8	; L   L   L   L   H
.def	_WE	= r7	; L   L   L   H   L

.def	_VOL	= r6

.equ	RAS	= 5
.equ	CAS	= 1



;---------------------------------------------;
; External DRAM access macros
;---------------------------------------------;
; Relationship between pointer X and DRAM pin
; are as follows:
;
; CA[7..0] = XL
; CA8 = 0:high nibble, 1:low nibble
; RA[7..0] = XH
; RA8 = fixed to 0


; Write AL to RAM (14clk)
.macro	WRITE
	out	PORTA, XH	;Row address, A8=L
	out	PORTB, _RAS0	;RAS=L
	out	PORTA, XL	;Column address
	out	PORTB, _CAS0	;CAS=L
	swap	AL		;PA[3..0]=Write data[7..4]
	out	PORTA, AL	;/
	out	PORTB, _WE	;WE=L
	out	PORTB, _RAS1	;WE=H, CAS=H, A8=H
	out	PORTA, XL	;Column address
	out	PORTB, _CAS1	;CAS=L
	swap	AL		;PA[3..0]=Write data[3..0]
	out	PORTA, AL	;/
	out	PORTB, _WE	;WE=L
	out	PORTB, _NTRL	;WE=H,CAS=H,RAS=H
.endm



; Read RAM to AH (21clk)
.macro	READ
	out	PORTA, XH	;Row address, A8=L
	out	PORTB, _RAS0	;RAS=L
	out	PORTA, XL	;Column address
	out	PORTB, _CAS0	;CAS=L
	out	DDRA, _0	;PA=in
	out	PORTB, _OE	;OE=L
	rjmp	PC+1		;
	in	AH, PINA	;Read data[7..4]
	out	PORTB, _RAS1	;OE=H,CAS=H,A8=H
	out	DDRA, _255	;PA=out
	out	PORTB, _CAS1	;CAS=L
	out	DDRA, _0	;PA=in
	out	PORTB, _OE	;OE=L
	swap	AH		;
	andi	AH, 0xf0	;/
	in	BH, PINA	;Read data[3..0]
	out	PORTB, _NTRL	;OE=H,CAS=H,RAS=H
	out	DDRA, _255	;PA=out
	andi	BH, 0x0f	;Marge read data[7..4] and [3..0] into AH
	or	AH, BH		;/
.endm



; Read RAM to AH, Write AL to RAM (28clk)
.macro	RMW
	out	PORTA, XH	;Row address, A8=L
	out	PORTB, _RAS0	;RAS=L
	out	PORTA, XL	;Column address
	out	PORTB, _CAS0	;CAS=L
	out	DDRA, _0	;PA=in
	out	PORTB, _OE	;OE=L
	swap	AL		;PA[3..0]=Write data[7..4]
	out	PORTA, AL	;/
	in	AH, PINA	;Read data[7..4]
	out	PORTB, _CAS0	;OE=H
	out	DDRA, _255	;PA=out
	out	PORTB, _WE	;WE=L
	out	PORTB, _RAS1	;WE=H,CAS=H,A8=H
	out	PORTA, XL	;Column address
	out	PORTB, _CAS1	;CAS=L
	out	DDRA, _0	;PA=in
	out	PORTB, _OE	;OE=L
	swap	AL		;PA[3..0]=Write data[3..0]
	out	PORTA, AL	;/
	in	BH, PINA	;Read data[3..0]
	out	PORTB, _CAS0	;OE=H
	out	DDRA, _255	;PA=out
	out	PORTB, _WE	;WE=L
	out	PORTB, _NTRL	;WE=H,CAS=H,RAS=H
	swap	AH		;Marge read data[7..4] and [3..0] into AH
	andi	AH, 0xf0	;
	andi	BH, 0x0f	;
	or	AH, BH		;/
.endm



;CBR refresh x2 (9clk)
.macro	RFSH2
	cbi	PORTB, CAS	;CAS=L
	out	PORTB, _CAS0	;RAS=L
	sbi	PORTB, RAS	;RAS=H
	cbi	PORTB, RAS	;RAS=L
	nop
	out	PORTB, _NTRL	;CAS=RAS=H
.endm



;---------------------------------------------;


;Add @0 to @1 with saturation
.macro	ADDS
	add	@0, @1
	brvc	PC+4
	ldi	@0, 127
	brmi	PC+2
	ldi	@0, -128
.endm



;Transfer and Sample data (9clk + wait)
.macro	XFER
	sbis	ADCSR, 4	;Wait for EOC
	rjmp	PC-1		;/
	sbi	ADCSR, 4	;Clear ADIF
	out	OCR1B, AH	;Update analog output
	in	AL, ADCH	;Read A/D data
.endm



;Convert Signed <--> Offset
.macro	CVS
	subi	@0, 128
.endm



; A = AL * BL (34clk)
.macro	MUL8
	clr	AH
	lsr	AL
	brcc	PC+2
	add	AH, BL
	ror	AH
	ror	AL
	brcc	PC+2
	add	AH, BL
	ror	AH
	ror	AL
	brcc	PC+2
	add	AH, BL
	ror	AH
	ror	AL
	brcc	PC+2
	add	AH, BL
	ror	AH
	ror	AL
	brcc	PC+2
	add	AH, BL
	ror	AH
	ror	AL
	brcc	PC+2
	add	AH, BL
	ror	AH
	ror	AL
	brcc	PC+2
	add	AH, BL
	ror	AH
	ror	AL
	brcc	PC+2
	add	AH, BL
	ror	AH
	ror	AL
.endm


