;----------------------------------------------------------------------------;
; FIR Filter
;----------------------------------------------------------------------------;
; Note1: ATtiny26 @16MHz
; Note2: Multiplying table (VP_FIL_M.HEX) must be
; written with the program code (VP_FIL.HEX).

.include "tn26def.inc"	; This file is contained in "AVR Family Assembler".
.include "avr.inc"
.include "vp_def.inc"



;----------------------------------------------------------;
; Program code

.cseg
	outi	SP, RAMEND
	 rcall	init_io

	ldiw	Y, 0x80


;---------------------------------------;
; Main loop (38.5kHz)

main:
	CVS	AH

	sbis	ADCSR, 4	;Wait for EOC
	rjmp	PC-1		;/
	sbi	ADCSR, 4	;Clear ADIF

	out	OCR1B, AH	;Update analog output
	in	AL, ADCH	;Read A/D data

	CVS	AL

	st	Y+, AL		;Store sample
	cbr	YL, bit6	;/


	; 0,1,1,0,-1,-3,-2,0,5,10,14,16,14,10,5,0,-2,-3,-1,0,1,1,0

	pushw	Y
	clrw	B

	addi	YL, 41
	ori	YL, 0x80
	andi	YL, 0xBF

	ld	ZL, Y+
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x04	;1
	ori	ZL, 0x01	;
	lpm	AL, Z
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x04	;1
	ori	ZL, 0x01	;
	lpm	AL, Z
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	inc	YL
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x04	;1
	ori	ZL, 0x01	;
	lpm	AL, Z
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x04	;1
	ori	ZL, 0x01	;
	lpm	AL, Z
	neg	AL		;-
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x04	;3
	ori	ZL, 0x03	;
	lpm	AL, Z
	neg	AL		;-
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	inc	YL
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x04	;2
	ori	ZL, 0x02	;
	lpm	AL, Z
	neg	AL		;-
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x05	;5
	ori	ZL, 0x01	;
	lpm	AL, Z
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x06	;10
	ori	ZL, 0x02	;
	lpm	AL, Z
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x07	;14
	ori	ZL, 0x02	;
	lpm	AL, Z
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	AL, Y+		;16
	andi	YL, 0xBF
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x07	;14
	ori	ZL, 0x02	;
	lpm	AL, Z
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x06	;10
	ori	ZL, 0x02	;
	lpm	AL, Z
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	inc	YL
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x05	;5
	ori	ZL, 0x01	;
	lpm	AL, Z
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x04	;2
	ori	ZL, 0x02	;
	lpm	AL, Z
	neg	AL		;-
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x04	;3
	ori	ZL, 0x03	;
	lpm	AL, Z
	neg	AL		;-
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	inc	YL
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x04	;1
	ori	ZL, 0x01	;
	lpm	AL, Z
	neg	AL		;-
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x04	;1
	ori	ZL, 0x01	;
	lpm	AL, Z
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x04	;1
	ori	ZL, 0x01	;
	lpm	AL, Z
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	ld	ZL, Y+
	andi	YL, 0xBF
	andi	ZL, 0xFC
	ldi	ZH, 0x04	;1
	ori	ZL, 0x01	;
	lpm	AL, Z
	clr	AH
	sbrc	AL, 7
	com	AH
	addw	B, A

	lslw	B
	lslw	B
	lslw	B
	lslw	B
	lslw	B
	lslw	B

	mov	AH, BH

	popw	Y

	rjmp	main




;---------------------------------------;
; Initialize peripherals

init_io:
	clr	_0
	clr	_255
	dec	_255

	ldi	AL, 0b10100111
	mov	_NTRL, AL

	outi	MCUCR, 0b01000000	;Disable pull-ups

	out	PORTB, _NTRL		;RAS,CAS,OE,WE,OC1B = output
	outi	DDRB, 0b11101111	;/
	out	DDRA, _255		;AD0..7 = output

					;A/D converter
	outi	ADMUX, 0b10100111	;Ch:7, Vref:2.56V
	outi	ADCSR, 0b11110101	;Clock:500kHz

					;Timer/Counter 1
	outi	PLLCSR, 0b00000110	;Select 64MHz PLL clock for TC1
	outi	TCCR1A, 0b00100001	;Enable TC1 8bit 250kHz PWM mode
	outi	TCCR1B, 0b00000001	;
	out	OCR1C, _255		;/

	ret

