;----------------------------------------------------------------------------;
; Ampritude Moduration
;----------------------------------------------------------------------------;
; Note1: ATtiny26 @16MHz

.include "tn26def.inc"	; This file is contained in "AVR Family Assembler".
.include "avr.inc"
.include "vp_def.inc"


;----------------------------------------------------------;
; Program code

.cseg

	outi	SP, RAMEND
	 rcall	init_io

	clrw	T2		;T2 = Moduration phase
	mov	T0L, _VOL	;T0 = moduration anguler speed
	clr	T0H
	lslw	T0
	lslw	T0
	lslw	T0


;---------------------------------------;
; Main loop (38.5kHz)

main:
	XFER
	CVS	AL

	mov	ZL, T2H
	clr	ZH
	addiw	Z, cos*2
	lpm	BL, Z
	addw	T2, T0

	clr	CL
	tst	AL
	brpl	PC+3
	neg	AL
	inc	CL
	tst	BL
	brpl	PC+3
	neg	BL
	inc	CL
	MUL8
	lslw	A
	sbrs	CL, 0
	neg	AH

	CVS	AH
	rjmp	main


;---------------------------------------;
; Initialize peripherals

init_io:
	clr	_0
	clr	_255
	dec	_255

	ldi	AL, 0b10100111
	mov	_NTRL, AL
	ldi	AL, 0b10000111
	mov	_RAS0, AL
	ldi	AL, 0b10000101
	mov	_CAS0, AL
	ldi	AL, 0b11000111
	mov	_RAS1, AL
	ldi	AL, 0b11000101
	mov	_CAS1, AL
	ldi	AL, 0b10000100
	mov	_OE, AL
	ldi	AL, 0b10000001
	mov	_WE, AL

	outi	MCUCR, 0b01000000	;Disable pull-ups

	out	PORTB, _NTRL		;RAS,CAS,OE,WE,OC1B = output
	outi	DDRB, 0b10101111	;/
	out	DDRA, _255		;AD0..7 = output

					;A/D converter
	outi	ADMUX, 0b00101001	;Ch9:, Vref:Vcc
	outi	ADCSR, 0b11110101	;Clock:500kHz
	sbis	ADCSR, 4		;Wait for EOC
	rjmp	PC-1			;/
	in	_VOL, ADCH		;Get volume setting (PB6)
	outi	ADMUX, 0b10100111	;Ch:7, Vref:2.56V

	outi	DDRB, 0b11101111	;A8 = output

					;Timer/Counter 1
	outi	PLLCSR, 0b00000110	;Select 64MHz PLL clock for TC1
	outi	TCCR1A, 0b00100001	;Enable TC1 8bit 250kHz PWM mode
	outi	TCCR1B, 0b00000001	;
	out	OCR1C, _255		;/

	ret


;---------------------------------------;
; cos table

cos:	.db	127,127,127,127,127,127,126,126,125,124,124,123,122,121,120,119
	.db	118,117,115,114,112,111,109,108,106,104,102,100,98,96,94,92
	.db	90,88,85,83,81,78,76,73,71,68,65,63,60,57,54,51
	.db	48,46,43,40,37,34,31,28,24,21,18,15,12,9,6,3
	.db	0,-3,-6,-9,-12,-15,-18,-21,-24,-28,-31,-34,-37,-40,-43,-46
	.db	-48,-51,-54,-57,-60,-63,-65,-68,-71,-73,-76,-78,-81,-83,-85,-88
	.db	-90,-92,-94,-96,-98,-100,-102,-104,-106,-108,-109,-111,-112,-114,-115,-117
	.db	-118,-119,-120,-121,-122,-123,-124,-124,-125,-126,-126,-127,-127,-127,-127,-127
	.db	-127,-127,-127,-127,-127,-127,-126,-126,-125,-124,-124,-123,-122,-121,-120,-119
	.db	-118,-117,-115,-114,-112,-111,-109,-108,-106,-104,-102,-100,-98,-96,-94,-92
	.db	-90,-88,-85,-83,-81,-78,-76,-73,-71,-68,-65,-63,-60,-57,-54,-51
	.db	-48,-46,-43,-40,-37,-34,-31,-28,-24,-21,-18,-15,-12,-9,-6,-3
	.db	0,3,6,9,12,15,18,21,24,28,31,34,37,40,43,46
	.db	48,51,54,57,60,63,65,68,71,73,76,78,81,83,85,88
	.db	90,92,94,96,98,100,102,104,106,108,109,111,112,114,115,117
	.db	118,119,120,121,122,123,124,124,125,126,126,127,127,127,127,127

