;----------------------------------------------------------------------------;
; Pitch Conversion (x0.5-x2.0)
;----------------------------------------------------------------------------;
; Note1: ATtiny26 @16MHz

.include "tn26def.inc"	; This file is contained in "AVR Family Assembler".
.include "avr.inc"
.include "vp_def.inc"


;----------------------------------------------------------;
; Program code

.cseg
	outi	SP, RAMEND
	 rcall	init_io

	clrw	T2			;Write ptr
	ldiw	Z, 0x0080		;Blend buffer
	clr	EH			;Blend counter

	clrw	Y			;Read ptr
	clr	EL			;Fraction of read ptr

	clr	DH			;D = pitch
	mov	DL, _VOL		;
	cpi	DL, 128			;
	brcs	PC+4			;
	lslw	D			;
	rjmp	main_up			;
	addi	DL, 128			;/


;---------------------------------------;
; Main loop, pitch down (31.25kHz)

main_down:
	 rcall	xfer_data

	cpi	EH, 0
	breq	next_down
	sub	XL, YL
	ori	XL, -64
	mov	T0L, ZL
	sub	ZL, XL
	sbr	ZL, bit7
	cbr	ZL, bit6
	ld	BL, Z+
	cbr	ZL, bit6
	ld	AL, Z
	mov	ZL, T0L
	mov	T0H, EL
	 rcall	interpolation
	mov	AL, AH
	mov	BL, CH
	mov	T0H, EH
	 rcall	interpolation
	mov	CH, AH
	subi	EH, 256/32
next_down:

	cpw	Y, T2		;Check porinter crossover (1)
	in	T0L, SREG	;/

	add	EL, DL		;Next read pointer
	adc	YL, DH		;
	adc	YH, _0		;
	cbr	YH, bit1	;/

	sub	T2L, _255	;Next write pointer
	sbc	T2H, _255	;
	ldi	AL, 1		;
	and	T2H, AL		;
	inc	ZL		;
	cbr	ZL, bit6	;/

	out	SREG, T0L	;Check porinter crossover (2)
	brne	PC+5		;
	cpw	T2, Y		;
	breq	PC+2		;
	ldi	EH, 256/32*31	;/

	rjmp	main_down



;---------------------------------------;
; Main loop, pitch up (31.25kHz)

main_up:
	 rcall	xfer_data

	cpi	EH, 0
	breq	next_up
	sub	XL, YL
	ori	XL, -64
	mov	T0L, ZL
	sub	ZL, XL
	sbr	ZL, bit7
	cbr	ZL, bit6
	ld	BL, Z+
	cbr	ZL, bit6
	ld	AL, Z
	mov	ZL, T0L
	mov	T0H, EL
	 rcall	interpolation
	mov	BL, AH
	mov	AL, CH
	mov	T0H, EH
	 rcall	interpolation
	mov	CH, AH
	subi	EH, 256/32
next_up:

	add	EL, DL		;Next read pointer
	adc	YL, DH		;
	adc	YH, _0		;
	cbr	YH, bit1	;/

	sub	T2L, _255	;Next write pointer
	sbc	T2H, _255	;
	ldi	AL, 1		;
	and	T2H, AL		;
	inc	ZL		;
	cbr	ZL, bit6	;/

	clr	BL		;Check pointer crossover.
	movew	A, T2
	sub	BL, EL
	sbcw	A, Y
	brcc	PC+2
	addi	AH, 2
	cpi	AL, 63
	cpc	AH, _0
	brcc	PC+5
	cpi	EH, 0
	brne	PC+5
	ldi	EH, 256/32
	rjmp	PC+3
	brne	PC+2
	ldi	EH, 256/32*31

	rjmp	main_up



;---------------------------------------;
; AH = AL * T0H + BL * ~T0H;  (81clk)

interpolation:
	tst	T0H
	brne	PC+3
	mov	AH, BL
	ret
	clr	AH
	lsr	AL
	brcc	PC+2
	add	AH, T0H
	rorw	A
	brcc	PC+2
	add	AH, T0H
	rorw	A
	brcc	PC+2
	add	AH, T0H
	rorw	A
	brcc	PC+2
	add	AH, T0H
	rorw	A
	brcc	PC+2
	add	AH, T0H
	rorw	A
	brcc	PC+2
	add	AH, T0H
	rorw	A
	brcc	PC+2
	add	AH, T0H
	rorw	A
	brcc	PC+2
	add	AH, T0H
	rorw	A

	neg	T0H
	clr	BH
	lsr	BL
	brcc	PC+2
	add	BH, T0H
	rorw	B
	brcc	PC+2
	add	BH, T0H
	rorw	B
	brcc	PC+2
	add	BH, T0H
	rorw	B
	brcc	PC+2
	add	BH, T0H
	rorw	B
	brcc	PC+2
	add	BH, T0H
	rorw	B
	brcc	PC+2
	add	BH, T0H
	rorw	B
	brcc	PC+2
	add	BH, T0H
	rorw	B
	brcc	PC+2
	add	BH, T0H
	rorw	B

	addw	A, B
	ret


;---------------------------------------;
; Write to RAM (21clk)
;
;AL = data to be written

write_ram:			;AL = data to be written
	WRITE
	ret


;---------------------------------------;
; Exchange data
;
;CL = data to be output, CH = read data

xfer_data:
	RFSH2

	in	AL, TIFR	;Wait for 32kHz interval
	sbrs	AL, TOV0	;
	rjmp	PC-2		;
	out	TIFR, AL	;
	outi	TCNT0, -2	;/

	out	OCR1B, CH	;Update analog output
	in	T0L, ADCH	;Read A-D data
	outi	ADCSR, 0b11000101;Start A-D

	movew	X, Y		;Read two sapmples from FIFO
	READ			;and interpolation between the data.
	mov	BL, AH
	adiw	XL, 1
	cbr	XH, bit1
	READ
	mov	AL, AH
	mov	T0H, EL
	 rcall	interpolation
	mov	CH, AH

	mov	AL, T0L		;Store data into FIFO
	movew	X, T2		; *wp = new sample;
	RMW			;
	st	Z, AH		;Store pushed out data into blend buffer

	ret



;---------------------------------------;
; Initialize peripherals

init_io:
	clr	_0
	clr	_255
	dec	_255

	ldi	AL, 0b10100111
	mov	_NTRL, AL
	ldi	AL, 0b10000111
	mov	_RAS0, AL
	ldi	AL, 0b10000101
	mov	_CAS0, AL
	ldi	AL, 0b11000111
	mov	_RAS1, AL
	ldi	AL, 0b11000101
	mov	_CAS1, AL
	ldi	AL, 0b10000100
	mov	_OE, AL
	ldi	AL, 0b10000001
	mov	_WE, AL

	outi	MCUCR, 0b01000000	;Disable pull-ups

	out	PORTB, _NTRL		;RAS,CAS,OE,WE,OC1B = output
	outi	DDRB, 0b10101111	;/
	out	DDRA, _255		;AD0..7 = output

					;A/D converter
	outi	ADMUX, 0b00101001	;Ch9:, Vref:Vcc
	outi	ADCSR, 0b11110101	;Clock:500kHz
	sbis	ADCSR, 4		;Wait for EOC
	rjmp	PC-1			;/
	in	_VOL, ADCH		;Get volume setting (PB6)
	outi	ADMUX, 0b10100111	;Ch:7, Vref:2.56V

	outi	DDRB, 0b11101111	;A8 = output

	outi	TCCR0, 0b0100		;TC0.ck = 62.5kHz

					;Timer/Counter 1
	outi	PLLCSR, 0b00000110	;Select 64MHz PLL clock for TC1
	outi	TCCR1A, 0b00100001	;Enable TC1 8bit 250kHz PWM mode
	outi	TCCR1B, 0b00000001	;
	out	OCR1C, _255		;/

	ldiw	X, 0			;Clear RAM
	ldi	AL, 0			;
	 rcall	write_ram		;
	adiw	XL, 1			;
	brne	PC-2			;/

	ret

