;----------------------------------------------------------------------------;
; Wow moduration (+-25%, 10Hz)
;----------------------------------------------------------------------------;
; Note1: ATtiny26 @16MHz

.include "tn26def.inc"	; This file is contained in "AVR Family Assembler".
.include "avr.inc"
.include "vp_def.inc"


;----------------------------------------------------------;
; Program code

.cseg

	outi	SP, RAMEND
	 rcall	init_io

	clrw	T2		;Write ptr

	ldiw	Y, -10000	;Read ptr
	clr	T0H		;Fraction of read ptr

	ldiw	Z, sin*2	;Moduration table (sin)
	clrw	D		;/


;---------------------------------------;
; Main loop (38.5kHz)

main:
	RFSH2
	XFER
	push	AL

	movew	X, Y		;Read data from FIFO
	 rcall	read_ram	; BH = *rp; AH = *rp+1;
	mov	BL, AH		;
	adiw	XL, 1		;
	 rcall	read_ram	;/
	mov	AL, AH
	 rcall	interpolation

	pop	AL		;Store data into FIFO
	movew	X, T2		; *wp = new sample;
	 rcall	write_ram	;/

	lpm	BL, Z		;Get read-out frequency
	adiw	ZL, 1		;
	lpm	BH, Z		;
	sbiw	ZL, 1		;
	subi	DL, 16		;
	brcc	PC+6		;
	adiw	ZL, 2		;
	inc	DH		;
	brne	PC+3		;
	ldiw	Z, sin*2	;/

	dec	BH	;Mod +-50% --> +-25%
	asrw	B	;
	inc	BH	;/

	add	T0H, BL		;Next read pointer
	adc	YL, BH		; Y:T0L += B;
	adc	YH, _0		;/

	sub	T2L, _255	;Next write pointer
	sbc	T2H, _255	;/ T2++;

	rjmp	main


;---------------------------------------;
; Read from RAM (29clk)
;
;AH = read data

read_ram:
	READ
	ret


;---------------------------------------;
; Write to RAM (21clk)
;
;AL = data to be written

write_ram:			;AL = data to be written
	WRITE
	ret


;---------------------------------------;
; Read-Modify-Write to RAM (35clk)
;
;AL = data to be written, AH = read data

rmw_ram:
	RMW
	ret


;---------------------------------------;
; AH = AL * T0H + BL * ~T0H;  (81clk)

interpolation:
	tst	T0H
	brne	PC+3
	mov	AH, BL
	ret
	clr	AH
	lsr	AL
	brcc	PC+2
	add	AH, T0H
	rorw	A
	brcc	PC+2
	add	AH, T0H
	rorw	A
	brcc	PC+2
	add	AH, T0H
	rorw	A
	brcc	PC+2
	add	AH, T0H
	rorw	A
	brcc	PC+2
	add	AH, T0H
	rorw	A
	brcc	PC+2
	add	AH, T0H
	rorw	A
	brcc	PC+2
	add	AH, T0H
	rorw	A
	brcc	PC+2
	add	AH, T0H
	rorw	A

	neg	T0H
	clr	BH
	lsr	BL
	brcc	PC+2
	add	BH, T0H
	rorw	B
	brcc	PC+2
	add	BH, T0H
	rorw	B
	brcc	PC+2
	add	BH, T0H
	rorw	B
	brcc	PC+2
	add	BH, T0H
	rorw	B
	brcc	PC+2
	add	BH, T0H
	rorw	B
	brcc	PC+2
	add	BH, T0H
	rorw	B
	brcc	PC+2
	add	BH, T0H
	rorw	B
	brcc	PC+2
	add	BH, T0H
	rorw	B

	neg	T0H
	addw	A, B
	ret



;---------------------------------------;
; Initialize peripherals

init_io:
	clr	_0
	clr	_255
	dec	_255

	ldi	AL, 0b10100111
	mov	_NTRL, AL
	ldi	AL, 0b10000111
	mov	_RAS0, AL
	ldi	AL, 0b10000101
	mov	_CAS0, AL
	ldi	AL, 0b11000111
	mov	_RAS1, AL
	ldi	AL, 0b11000101
	mov	_CAS1, AL
	ldi	AL, 0b10000100
	mov	_OE, AL
	ldi	AL, 0b10000001
	mov	_WE, AL

	outi	MCUCR, 0b01000000	;Disable pull-ups

	out	PORTB, _NTRL		;RAS,CAS,OE,WE,OC1B = output
	outi	DDRB, 0b11101111	;/
	out	DDRA, _255		;AD0..7 = output

					;A/D converter
	outi	ADMUX, 0b10100111	;Ch:7, Vref:2.56V
	outi	ADCSR, 0b11110101	;Clock:500kHz

					;Timer/Counter 1
	outi	PLLCSR, 0b00000110	;Select 64MHz PLL clock for TC1
	outi	TCCR1A, 0b00100001	;Enable TC1 8bit 250kHz PWM mode
	outi	TCCR1B, 0b00000001	;
	out	OCR1C, _255		;/

	ldiw	X, 0			;Clear RAM
	ldi	AL, 0			;
	 rcall	write_ram		;
	adiw	XL, 1			;
	brne	PC-2			;/

	ret


;---------------------------------------;
; sin table

sin:	.dw 256,258,259,261,262,264,265,267,268,270,272,273,275,276,278,279
	.dw 280,282,283,285,286,288,289,290,292,293,294,295,297,298,299,300
	.dw 301,302,303,304,305,306,307,308,309,310,311,312,312,313,314,315
	.dw 315,316,316,317,317,318,318,318,319,319,319,320,320,320,320,320
	.dw 320,320,320,320,320,320,319,319,319,318,318,318,317,317,316,316
	.dw 315,315,314,313,312,312,311,310,309,308,307,306,305,304,303,302
	.dw 301,300,299,298,297,295,294,293,292,290,289,288,286,285,283,282
	.dw 280,279,278,276,275,273,272,270,268,267,265,264,262,261,259,258
	.dw 256,254,253,251,250,248,247,245,244,242,240,239,237,236,234,233
	.dw 232,230,229,227,226,224,223,222,220,219,218,217,215,214,213,212
	.dw 211,210,209,208,207,206,205,204,203,202,201,200,200,199,198,197
	.dw 197,196,196,195,195,194,194,194,193,193,193,192,192,192,192,192
	.dw 192,192,192,192,192,192,193,193,193,194,194,194,195,195,196,196
	.dw 197,197,198,199,200,200,201,202,203,204,205,206,207,208,209,210
	.dw 211,212,213,214,215,217,218,219,220,222,223,224,226,227,229,230
	.dw 232,233,234,236,237,239,240,242,244,245,247,248,250,251,253,254


