/***************************************************************************/
/*  Name of module   : I2CINTFC.C                                          */
/*  Program language : C51 (Keil version V7.03)                            */
/*  STATUS           : NOT TESTED !!!!                                     */
/*  Name             : P.H. Seerden                                        */
/*  Description      : External interface to the XA-S3 IC driver          */
/*                     routines. This module contains the **EXAMPLE**      */
/*                     interface functions, used by the application to     */
/*                     do IC master-mode transfers.                       */
/*                                                                         */
/*           (C) Copyright 1998 Philips Semiconductors B.V.                */
/*                                                                         */
/***************************************************************************/

#include <reg932.h>

#include "i2cexprt.h"

extern void PrintString(char code *s);

code char retryexp[] = "retry counter expired\n";
code char bufempty[] = "buffer empty\n";
code char nackdata[] = "no ack on data\n";
code char nackaddr[] = "no ack on address\n";
code char timedout[] = "time-out\n";
code char unknowst[] = "unknown status\n";

static I2C_MESSAGE   *p_iicMsg[2];  // pointer to an array of (2) I2C messages
static I2C_TRANSFER  iicTfr;

static BYTE drvStatus;


void I2C_Ready(BYTE status) using 1
{
    drvStatus = status;
}


static void StartTransfer(void)
/******************************
 * Description: Start I2C transfer and wait (with timeout) until the
 *              driver has completed the transfer(s).
 ***************************************************************************/
{
  WORD timeOut;
  BYTE retries = 0;

    do
    {
        drvStatus = I2C_BUSY;       /* Status returned by driver           */
        I2C_Transfer(&iicTfr);

        timeOut = 0;
        while (drvStatus == I2C_BUSY)
        {
            if (++timeOut > 40000)
                drvStatus = I2C_TIME_OUT;
        }

        if (retries == 6)
        {
            PrintString(retryexp);         /* fatal error ! So, ..         */
            return;
        }
        else
            retries++;

        switch (drvStatus)
        {
          case I2C_OK                 : break;
          case I2C_NO_DATA            : PrintString(bufempty);  break;
          case I2C_NACK_ON_DATA       : PrintString(nackdata);  break;
          case I2C_NACK_ON_ADDRESS    : PrintString(nackaddr);  break;
          case I2C_TIME_OUT           : PrintString(timedout);  break;
          default                     : PrintString(unknowst);  break;
        }
    } while (drvStatus != I2C_OK);
}

void I2C_Write(I2C_MESSAGE *msg)
/*******************************
 * Input(s)   : msg     I2C message
 * Returns    : None.
 * Description: Write a message to a slave device.
 * PROTOCOL   : <S><SlvA><W><A><D1><A> ... <Dnum><N><P>
 ***************************************************************************/
{
    iicTfr.nrMessages = 1;
    iicTfr.p_message  = p_iicMsg;
    p_iicMsg[0] = msg;

    StartTransfer();
}

