//***************************************************************************
//* 								main.c 
//*	By : Bauke Siderius		
//*	Date : July 2003
//*	Discription : 	Using Paul Seerden's I2Cslave code to interact with the
//* 				PCA9564 on the I2C bus  
//***************************************************************************
#include <REG932.H>
#include "i2cexprt.h"
#include "ua_exprt.h"
//***************************************************************************
//* Definitions
//***************************************************************************
typedef unsigned char  	BYTE;
typedef unsigned short 	WORD;
//***************************************************************************
//* Functions
//***************************************************************************
void init(void);
//***************************************************************************
//* init()
//* Input(s) : none.
//* Returns : none.
//* Description : initialization of P89LPC903
//***************************************************************************
void init(void)
{
  P0M1 = 0x00;								// P0 in Quasi bi mode		
  P1M1 = 0x0C;								// P1 in Quasi bi mode
  P1M2 = 0x0C;								// P1.2 P13 open drain	
  P2M1 = 0x00;								// P2 in Quasi bi mode
}
//***************************************************************************
//* main()
//* Input(s) : none.
//* Returns : none.
//* Description : main loop
//***************************************************************************
void main(void)
{
  char temp;
  init();									// initialize P89LPC932
  I2C_Init();								// initialize I2C block
  EA  = 1;									// enable interrupts
  while(1)									// main loop
  {
    switch(slaveBuf[0])						// switch on first byte received
    {
      case(0x00):							// Command 00, write byte to P2
      {
        P2 = slaveBuf[1];
      }
      break;
      case(0xEE):							// command EE, change address 
      {										// acording jumper settings
        temp = P0;
        temp &= 0x07;						// mask out non address bits 
        temp <<= 1;							// shift left one
        I2ADR = (0xE0 | temp); 				// generate I2C address depending on P0    
      }
      break;
      case(0xFF):							// command FF, send back I2C slave address
      {
        slaveBuf[0] = I2ADR;  
      }
      break;
      default:
      {
      }
      break;
    }
  }
}	 
