/***************************************************************************/
/*  Acronym           : I2C  Inter IC bus                                  */
/*  Name of module    : I2CEXPRT.H                                         */
/*  Program language  : C                                                  */
/*  Name              : P.H. Seerden                                       */
/*                                                                         */
/*                                                                         */
/*        (C) Copyright 1998 Philips Semiconductors B.V.                   */
/*                                                                         */
/***************************************************************************/
/*                                                                         */
/*  Description:                                                           */
/*                                                                         */
/*  This module consists a number of exported declarations of the I2C      */
/*  driver package. Include this module in your source file if you want    */
/*  to make use of one of the interface functions of the package.          */
/*                                                                         */
/***************************************************************************/

/***************************************************************************/
/*         E X P O R T E D   D A T A    S T R U C T U R E S                */
/***************************************************************************/

typedef unsigned char    BYTE;
typedef unsigned short   WORD;
typedef unsigned long    LONG;


typedef struct
{
    BYTE   address;           /* slave address to sent/receive message     */
    BYTE   nrBytes;           /* number of bytes in message buffer         */
    BYTE   *buf;              /* pointer to application message buffer     */
} I2C_MESSAGE;


typedef struct
{
    BYTE        nrMessages;         /* number of message in one transfer   */
    I2C_MESSAGE	**p_message;		/* pointer to pointer to message       */
} I2C_TRANSFER;


/***************************************************************************/
/*         E X P O R T E D   D A T A    D E C L A R A T I O N S            */
/***************************************************************************/

/**** Status Errors ****/

#define I2C_OK                  0        /* transfer ended No Errors       */
#define I2C_BUSY                1        /* transfer busy                  */
#define I2C_ERR                 2        /* err: general error             */
#define I2C_NO_DATA             3        /* err: No data in block          */
#define I2C_NACK_ON_DATA        4        /* err: No ack on data            */
#define I2C_NACK_ON_ADDRESS     5        /* err: No ack on address         */
#define I2C_DEVICE_NOT_PRESENT  6        /* err: Device not present        */
#define I2C_ARBITRATION_LOST    7        /* err: Arbitration lost          */
#define I2C_TIME_OUT            8        /* err: Time out occurred         */
#define I2C_SLAVE_ERROR         9        /* err: slave mode error          */
#define I2C_INIT_ERROR          10       /* err: Initialization (not done) */


/***************************************************************************/
/*       I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S         */
/***************************************************************************/

extern void I2C_Transfer(I2C_TRANSFER *p);
extern void I2C_Init(void);
extern void I2C_Ready(BYTE status);

extern void I2C_Write(I2C_MESSAGE *msg);

