/*
 * Dallas app2420.pdf s app162.pdf alapjn
 */

#include <p18cxxx.h>
#include <delays.h>

#include "types.h"
#include "delay.h"
#include "1wire.h"

static void DisableAllInterrupts(void);
static void ResumeAllInterrupts(void);

static void DisableAllInterrupts(void)
{
	INTCONbits.GIEH = 0;
	INTCONbits.GIEL = 0;
}

static void ResumeAllInterrupts(void)
{
	INTCONbits.GIEH = 1;
	INTCONbits.GIEL = 1;
}

/*
 * OW_reset
 * visszatrsi rtk: 0 = van eszkz, 1 = nincs eszkz, 2 = rvidzr a buszon
 */
BYTE OW_reset(void)
{
	BYTE presence, temp;

	DisableAllInterrupts();
	OW_HIZ();
	OW_LO();
	//DelayBigUs(500);	// 480
	Delay10TCYx(200);	// 1.25usec * 200, 32 MHz
	Delay10TCYx(200);	// 1.25usec * 200, 32 MHz
	OW_HIZ();
	//DelayUs(70);
	Delay10TCYx(56);	// 32 MHz
	presence = OW_DATA;
	//DelayBigUs(500 - 70);
	Delay10TCYx(172);	// 32 MHz
	Delay10TCYx(172);	// 32 MHz
	temp = OW_DATA;
	ResumeAllInterrupts();

	return (!temp ? 2 : presence);
}

/*
 * OW_write_bit
 */
void OW_write_bit(BYTE val)
{
	DisableAllInterrupts();
	OW_HIZ();
	OW_LO();
	dly5u;
	if (val)
		OW_HIZ();
	//DelayUs(60);
	Delay10TCYx(48);	// 32 MHz
	OW_HI();			// OW_HIZ() volt itt
	dly2u;
	ResumeAllInterrupts();
}

/*
 * OW_write_byte
 */
void OW_write_byte(BYTE val)
{
	BYTE i = 8;

	while (i--) {
		OW_write_bit(val & 0x01);
		val >>= 1;
	}
}

/*
 * OW_read_bit
 */
BYTE OW_read_bit(void)
{
	BYTE val;

	DisableAllInterrupts();
	OW_HIZ();
	OW_LO();
	dly3u;
	OW_HIZ();
	dly5u;
	dly3u;
	val = OW_DATA;
	//DelayUs(50);
	Delay10TCYx(40);	// 32 MHz
	ResumeAllInterrupts();

	return val;
}

/*
 * OW_read_byte
 */
BYTE OW_read_byte(void)
{
	BYTE i, val;

	val = 0;
	for (i = 0; i < 8; i++) {
		if (OW_read_bit())
			val |= BIT(i);
	}

	return val;
}
