//**************************************************************************************************************
//
// Librairie pour le LCD du Nokia 3310
//
//**************************************************************************************************************
//
// Description des Fonctions
//
//**************************************************************************************************************
// void LCD_write_dorc(unsigned char unsigned bytefornokia)            					
//				Utilisation Interne
//**************************************************************************************************************
// void LCD_write_data(unsigned char unsigned byteforLCD_data)         					
//				Utilisation Interne
//**************************************************************************************************************
// void LCD_printchar(unsigned char caracter)                   	   					
//				Affiche un caractere
//**************************************************************************************************************
// void LCD_write_command(unsigned char unsigned byteforLCD_command)   					
//				Execute une commande
//**************************************************************************************************************
// void LCD_gotoxy(unsigned char xnokia, unsigned char ynokia)         					
//				Se positionne en X/Y
//**************************************************************************************************************
// void LCD_clean_ddram(void)                          				   					
//				Efface l'ecran
//**************************************************************************************************************
// void Lcd_init(void)                                   			   					
//				Initialise le LCD
//**************************************************************************************************************
// void LCD_pixel(unsigned char pixelX,unsigned char pixelY,unsigned char pixelMode)	
//				Place un point en memoire
//				aux coordonnes PixelX,PixelY
//				PixelMode : 0 = Effacer le point
//							1 = Afficher un point
//							2 = inverser le point
//**************************************************************************************************************
// void LCD_line(unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2,unsigned char lineMode)
//				Trace une ligne des coordonnes
//				x1,y1 aux coordonnes x2,y2
//				lineMode pareil que PixelMode
//**************************************************************************************************************
// void LCD_rect(unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2,unsigned char rectMode)
//				Trace un rectangle vide des coordonnes
//				x1,y1 aux coordonnes x2,y2
//				RectMode pareil que PixelMode
//**************************************************************************************************************
// void LCD_rectfill(unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2,unsigned char rectMode)
//				Trace un rectangle plein des coordonnes
//				x1,y1 aux coordonnes x2,y2
//				RectMode pareil que PixelMode
//**************************************************************************************************************
// void LCD_circle(unsigned char centerX,unsigned char centerY,unsigned char radius,unsigned char circleMode)
//				Trace un cercle vide avec comme centre CenterX,CenterY
//				et de Rayon Radius
//				CircleMode pareil que PixelMode
//**************************************************************************************************************
// void ecran_noir(void)
//				Rempli l'ecran
//**************************************************************************************************************
// void LCD_redraw(void)
//				Redessine l'ecran , fonction a utiliser aprs LCD_Pixel ou LCD_Line
//
//**************************************************************************************************************
//	reste a faire :
//				prise en compte des caracteres affich sur l'ecran dans la memoire tampon
//				utilis par les graphismes
//
//	a Retenir 	  :
//				L'ecran a une resolution de 84 x 48 pixel
//				X et Y minimum = 0
//				X maximum = 83
//				Y maximum = 47
//**************************************************************************************************************
//#include <pic168xa.h>		// 16F877A
#include <pic18.h>		// 18LF258
#include "delay.h"
#include "Nokia_LCD.h"

/*
Table d'instructions du LCD. quand D/C=0

0010 0xyz      	  // X=1 -> Driver en OFF
                     Y=1 -> Direction Verticale
                     Z=1 -> Commandes Etendue

Mode d'affichage
0000 1001   0x09	// Noir
0000 1000   0x08	// Blanc
0000 1100   0x0c	// Mode Normal
0000 1101   0x0d	// Video Inver

Controle de Temperature
0100 0100   0x44  // Coeficient de temperature 0
0100 0101   0x45  // Coeficient de temperature 1
0100 0110   0x46  // Coeficient de temperature 2
0100 0111   0x47  // Coeficient de temperature 3

Bias (Contraste?)
0001 0xxx         // Etablis la valeur du Bias

Vop
1xxx xxxx         // Etablis la valeur pour Vop
*/



////////////////////////////////////////////////////////////////////////////////
// Table de caracteres ASCII
// 5 unsigned char par caractere.

const unsigned char ASCII_TABLE [585]={
      0x00,0x00,0x00,0x00,0x00,	// 20 space
						0x00,0x00,0x5f,0x00,0x00,	// 21 !
						0x00,0x07,0x00,0x07,0x00,	// 22 "
						0x14,0x7f,0x14,0x7f,0x14,	// 23 #
						0x24,0x2a,0x7f,0x2a,0x12,	// 24 $
						0x23,0x13,0x08,0x64,0x62,	// 25 %
						0x36,0x49,0x55,0x22,0x50,	// 26 &
						0x00,0x05,0x03,0x00,0x00,	// 27 '
						0x00,0x1c,0x22,0x41,0x00,	// 28 (
						0x00,0x41,0x22,0x1c,0x00,	// 29 )
						0x14,0x08,0x3e,0x08,0x14,	// 2a *
						0x08,0x08,0x3e,0x08,0x08,	// 2b +
						0x00,0x50,0x30,0x00,0x00,	// 2c ,
						0x08,0x08,0x08,0x08,0x08,	// 2d -
						0x00,0x60,0x60,0x00,0x00,	// 2e .
						0x20,0x10,0x08,0x04,0x02,	// 2f /
						0x3e,0x51,0x49,0x45,0x3e,	// 30 0
						0x00,0x42,0x7f,0x40,0x00,	// 31 1
						0x42,0x61,0x51,0x49,0x46,	// 32 2
						0x21,0x41,0x45,0x4b,0x31,	// 33 3
						0x18,0x14,0x12,0x7f,0x10,	// 34 4
						0x27,0x45,0x45,0x45,0x39,	// 35 5
						0x3c,0x4a,0x49,0x49,0x30,	// 36 6
						0x01,0x71,0x09,0x05,0x03,	// 37 7
						0x36,0x49,0x49,0x49,0x36,	// 38 8
						0x06,0x49,0x49,0x29,0x1e,	// 39 9
						0x00,0x36,0x36,0x00,0x00,	// 3a :
						0x00,0x56,0x36,0x00,0x00,	// 3b ;
						0x08,0x14,0x22,0x41,0x00,	// 3c <
						0x14,0x14,0x14,0x14,0x14,	// 3d =
						0x00,0x41,0x22,0x14,0x08,	// 3e >
						0x02,0x01,0x51,0x09,0x06,	// 3f ?
						0x32,0x49,0x79,0x41,0x3e,	// 40 @
						0x7e,0x11,0x11,0x11,0x7e,	// 41 A
						0x7f,0x49,0x49,0x49,0x36,	// 42 B
						0x3e,0x41,0x41,0x41,0x22,	// 43 C
						0x7f,0x41,0x41,0x22,0x1c,	// 44 D
						0x7f,0x49,0x49,0x49,0x41,	// 45 E
						0x7f,0x09,0x09,0x09,0x01,	// 46 F
						0x3e,0x41,0x49,0x49,0x7a,	// 47 G
						0x7f,0x08,0x08,0x08,0x7f,	// 48 H
						0x00,0x41,0x7f,0x41,0x00,	// 49 I
						0x20,0x40,0x41,0x3f,0x01,	// 4a J
						0x7f,0x08,0x14,0x22,0x41,	// 4b K
						0x7f,0x40,0x40,0x40,0x40,	// 4c L
						0x7f,0x02,0x0c,0x02,0x7f,	// 4d M
						0x7f,0x04,0x08,0x10,0x7f,	// 4e N
						0x3e,0x41,0x41,0x41,0x3e,	// 4f O
      0x7f,0x09,0x09,0x09,0x06,	// 50 P
						0x3e,0x41,0x51,0x21,0x5e,	// 51 Q
						0x7f,0x09,0x19,0x29,0x46,	// 52 R
						0x46,0x49,0x49,0x49,0x31,	// 53 S
						0x01,0x01,0x7f,0x01,0x01,	// 54 T
						0x3f,0x40,0x40,0x40,0x3f,	// 55 U
						0x1f,0x20,0x40,0x20,0x1f,	// 56 V
						0x3f,0x40,0x38,0x40,0x3f,	// 57 W
						0x63,0x14,0x08,0x14,0x63,	// 58 X
						0x07,0x08,0x70,0x08,0x07,	// 59 Y
						0x61,0x51,0x49,0x45,0x43,	// 5a Z
						0x00,0x7f,0x41,0x41,0x00,	// 5b [
						0x02,0x04,0x08,0x10,0x20,	// 5c
						0x00,0x41,0x41,0x7f,0x00,	// 5d
						0x04,0x02,0x01,0x02,0x04,	// 5e
						0x40,0x40,0x40,0x40,0x40,	// 5f
						0x00,0x01,0x02,0x04,0x00,	// 60
						0x20,0x54,0x54,0x54,0x78,	// 61 a
						0x7f,0x48,0x44,0x44,0x38,	// 62 b
						0x38,0x44,0x44,0x44,0x20,	// 63 c
						0x38,0x44,0x44,0x48,0x7f,	// 64 d
						0x38,0x54,0x54,0x54,0x18,	// 65 e
						0x08,0x7e,0x09,0x01,0x02,	// 66 f
						0x0c,0x52,0x52,0x52,0x3e,	// 67 g
						0x7f,0x08,0x04,0x04,0x78,	// 68 h
						0x00,0x44,0x7d,0x40,0x00,	// 69 i
						0x20,0x40,0x44,0x3d,0x00,	// 6a j
						0x7f,0x10,0x28,0x44,0x00,	// 6b k
						0x00,0x41,0x7f,0x40,0x00,	// 6c l
						0x7c,0x04,0x18,0x04,0x78,	// 6d m
						0x7c,0x08,0x04,0x04,0x78,	// 6e n
						0x38,0x44,0x44,0x44,0x38,	// 6f o
						0x7c,0x14,0x14,0x14,0x08,	// 70 p
						0x08,0x14,0x14,0x18,0x7c,	// 71 q
						0x7c,0x08,0x04,0x04,0x08,	// 72 r
						0x48,0x54,0x54,0x54,0x20,	// 73 s
						0x04,0x3f,0x44,0x40,0x20,	// 74 t
						0x3c,0x40,0x40,0x20,0x7c,	// 75 u
						0x1c,0x20,0x40,0x20,0x1c,	// 76 v
						0x3c,0x40,0x30,0x40,0x3c,	// 77 w
						0x44,0x28,0x10,0x28,0x44,	// 78 x
						0x0c,0x50,0x50,0x50,0x3c,	// 79 y
						0x44,0x64,0x54,0x4c,0x44,	// 7a z
						0x00,0x08,0x36,0x41,0x00,	// 7b
						0x00,0x00,0x7f,0x00,0x00,	// 7c
						0x00,0x41,0x36,0x08,0x00,	// 7d
						0x10,0x08,0x08,0x10,0x08,	// 7e
						0x78,0x46,0x41,0x46,0x78,   // 7F
      0x7C,0x09,0x05,0x05,0x78,   // 80 -> 
      0x7E,0x05,0x09,0x11,0x7E,    // 81 -> 
  //Magyar karakterek							
						 0x20,0x54,0x56,0x55,0x78, // 97sor =225				
						 0x78,0x24,0x22,0x26,0x79, // 98sor =193		
						 0x38,0x54,0x56,0x55,0x18, // 99sor =233		
						 0x7c,0x54,0x56,0x55,0x44, // 100sor =201		
						 0x00,0x44,0x7e,0x41,0x00, // 101sor =237		
						 0x40,0x44,0x7e,0x45,0x40, // 102sor =205		
						 0x38,0x44,0x46,0x45,0x38, // 103sor =243	
						 0x3e,0x41,0x43,0x41,0x3e, // 104sor =211	
						 0x3c,0x40,0x42,0x21,0x7c, // 105sor =250						 
						 0x3e,0x40,0x43,0x40,0x3e, // 106sor =218						 
						 0x38,0x45,0x44,0x45,0x38, // 107sor =246						 
						 0x3c,0x43,0x42,0x43,0x3c, // 108sor =214		
						 0x38,0x47,0x44,0x47,0x38, // 109sor =245						 
						 0x3e,0x43,0x41,0x43,0x3e, // 110sor =213								 
						 0x3c,0x41,0x40,0x21,0x7c, // 109sor =252
						 0x3e,0x41,0x40,0x41,0x3e, // 110sor =220
						 0x3c,0x43,0x40,0x23,0x7c, // 111sor =251
						 0x3e,0x43,0x40,0x43,0x3e, // 112sor =219
						 0x1c,0x08,0x04,0x02,0x01};// 113sor PIPA=230

////////////////////////////////////////////////////////////////////////////////
// Memoire Ecran
////////////////////////////////////////////////////////////////////////////////
static unsigned char  LcdCache [504];
static unsigned int   LcdPos = 0;
////////////////////////////////////////////////////////////////////////////////
// Envois le unsigned char pass en mode serie
////////////////////////////////////////////////////////////////////////////////
void LCD_write_dorc(unsigned char bytefornokia)
{
char caa;
   for (caa=8;caa>0;caa--) 
		{
		nok_sclk=0;
		DelayUs(1);
		if ((bytefornokia&0x80)==0) {
         nok_sda=0;
      		}
		else {
         nok_sda=1;
      		}
		nok_sclk=1;
		bytefornokia=bytefornokia<<1;
		}
}

////////////////////////////////////////////////////////////////////////////////
// Envois des donne serie a l'Ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_write_data(unsigned char byteforLCD_data)
{
   nok_dc=1;
   nok_cs=0;	// chip activ
   LCD_write_dorc(byteforLCD_data);   // routine d'envois des bits en serie
   nok_cs=1;	// chip desactiv
}


////////////////////////////////////////////////////////////////////////////////
// Execute une commande
////////////////////////////////////////////////////////////////////////////////
void LCD_write_command(unsigned char byteforLCD_command)
{
   nok_dc=0;	// unsigned char is a command it is read with the eight SCLK pulse
   nok_cs=0;	// chip activ
   LCD_write_dorc(byteforLCD_command);
   nok_cs=1;	// chip desactiv
}

////////////////////////////////////////////////////////////////////////////////
// Afficher le caractere pass  l'ecran
////////////////////////////////////////////////////////////////////////////////
/*void LCD_printchar(unsigned char caracter,unsigned int charMode)
{
unsigned char char_row;
unsigned int charpos,chardata;

   if(caracter==0xF1) caracter=0x80;
   else if(caracter==0xD1) caracter=0x81;
   else if (caracter<0x20) return;
   else if (caracter>254) return;
   if(caracter>192)
   {	
    if(caracter==225) tablept=480;  	//
    if(caracter==193) tablept=485;   //
    if(caracter==233) tablept=490;  	//
    if(caracter==201) tablept=495;   //
    if(caracter==237) tablept=500;  	//
    if(caracter==205) tablept=505;   // 
    if(caracter==243) tablept=510;   //
    if(caracter==211) tablept=515;  	//
    if(caracter==250) tablept=520;   //
    if(caracter==218) tablept=525;  	//
    if(caracter==246) tablept=530;   // 
    if(caracter==214) tablept=535;   //
    if(caracter==245) tablept=540;   // 
    if(caracter==213) tablept=545;   //    
    if(caracter==252) tablept=550;  	//
    if(caracter==220) tablept=555;   //
    if(caracter==251) tablept=560;  	//
    if(caracter==219) tablept=565;   //
    if(caracter==230) tablept=570;   //PIPA    
   } 
   

   for (char_row=0;char_row<5;char_row++) 			// 5 unsigned chars par caractere
	      {           								  
      charpos=(((caracter&0xff)-0x20)*5)+char_row;
      chardata=ASCII_TABLE[charpos];
	  if (charMode == 0) LcdCache[LcdPos] &= chardata;// Mise en memoire graphique
   if (charMode == 1) LcdCache[LcdPos] |= chardata;
	  if (charMode == 2) LcdCache[LcdPos] ^= chardata;
	  LcdPos += 1;									// incremente position en memoire graphique
   LCD_write_data(chardata);   	// affiche une partie du caractere
       }
   //LCD_write_data(0x00);       	// un espace blanc(separation des caracteres)
   //LcdCache[LcdPos]=0x00;							// Mise en memoire graphique
   if (charMode == 0) LcdCache[LcdPos] &= 0x00;     // Mise en memoire graphique
   if (charMode == 1) LcdCache[LcdPos] |= 0x00;
   if (charMode == 2) LcdCache[LcdPos] ^= 0x00;
   LcdPos += 1;				// incremente position en memoire graphique
}*/
//*****
//void cursorxy(char x, char y)
void LCD_gotoxy(unsigned char xnokia, unsigned char ynokia)
{
	LCD_write_command(0x40|(ynokia&0x07));	// Y axis
	LCD_write_command(0x80|(xnokia&0x7f));	// X axis
}

void LCD_printchar(unsigned char character,unsigned int charMode)
{
	int tablept, count, char_column;
	if ((character<0x20)||(character>254)) {return;}		// Exit function if character is not found.
  if(character>192)
   {	
    if(character==225) tablept=480+10;  	//
    if(character==193) tablept=485+10;   //
    if(character==233) tablept=490+10;  	//
    if(character==201) tablept=495+10;   //
    if(character==237) tablept=500+10;  	//
    if(character==205) tablept=505+10;   // 
    if(character==243) tablept=510+10;   //
    if(character==211) tablept=515+10;  	//
    if(character==250) tablept=520+10;   //
    if(character==218) tablept=525+10;  	//
    if(character==246) tablept=530+10;   // 
    if(character==214) tablept=535+10;   //
    if(character==245) tablept=540+10;   // 
    if(character==213) tablept=545+10;   //    
    if(character==252) tablept=550+10;  	//
    if(character==220) tablept=555+10;   //
    if(character==251) tablept=560+10;  	//
    if(character==219) tablept=565+10;   //
    if(character==230) tablept=570+10;   //PIPA    
   } 
   else	tablept = ((5*character) - 160);						// Point to the columns of the character in the table.
	for (count=5;count>0;count--)							// Draw the columns to print the character.
	{
		char_column = ASCII_TABLE[tablept];
		if(charMode==0) LCD_write_data(char_column);
		if(charMode==1) LCD_write_data(~char_column);
		tablept++;
	}
 if(charMode==0)	LCD_write_data(0x00);										// 1 pixel spacing per character.
 if(charMode==1)	LCD_write_data(0B11111111);
}


//*****
void LCD_printstr(unsigned char x,unsigned char y,const char *str,unsigned int charMode)
{
 LCD_gotoxy(x*6,y); 
 while(*str!=0) LCD_printchar(*str++,charMode);
}

////////////////////////////////////////////////////////////////////////////////
// Positionnement du curseur sur l'Ecran
////////////////////////////////////////////////////////////////////////////////
/*void LCD_gotoxy(unsigned char xnokia, unsigned char ynokia)
{
		LCD_write_command(0x40|(ynokia&0x07));	// Y axe initialisation: 0100 0yyy
		LCD_write_command(0x80|(xnokia&0x7f));	// X axe initialisation: 1xxx xxxx
		LcdPos = (xnokia * 6) + (ynokia * 84);
}*/

////////////////////////////////////////////////////////////////////////////////
// Effacer la RAM Ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_clean_ddram(void)
{
int ddram;  
unsigned int a;

   LCD_gotoxy(0,0);                  		// Retour a l'origine
   for (ddram=504;ddram>0;ddram--) {   		// boucle de remplissage de la memoire en 0x00
      LCD_write_data(0x00);
   }
   for (a=0;a<=503;a++){LcdCache[a]=0x00;} 	// Efface le cache Ecran
}


////////////////////////////////////////////////////////////////////////////////
// Initialisatinn de l'ecran
////////////////////////////////////////////////////////////////////////////////
void Lcd_init(void) {
    unsigned int a;

    DelayBigUs(200);       	    // Petit delais de securit
	nok_dc=1;				    // Destino de unsigned chars -> RAM
	nok_cs=1;				    // Dsactive l'ecran pour l'initialisation
    DelayBigMs(10);
	nok_res=0;				    // Une impulsion de Reset comme sur le datasheet
	DelayBigMs(250);			    // durant 250 mS
	nok_res=1;
	LCD_write_command(0x21);	// Active les commandes etendues
	LCD_write_command(0xC8);  //0x90);	// Defini le Vop. Etabli la tension interne (Contraste)
	LCD_write_command(0x13);	// bias 13. Min 10 Max 17
	LCD_write_command(0x20);	// Mode Horizontal, s'incremente automatiquement
    LCD_write_command(0x0C);  //0x09);	// all on
	DelayBigMs(50);
	LCD_clean_ddram();        // Efface la RAM
	DelayBigMs(10);
	LCD_write_command(0x0C);	// Active les commandes normales
    for (a=0;a<=503;a++){LcdCache[a]=0x00;} 	// Efface le cache Ecran
}


////////////////////////////////////////////////////////////////////////////////
// Trace un Pixel sur l'Ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_pixel(unsigned char pixelX,unsigned char pixelY,unsigned char pixelMode)
{
	unsigned int index;
	unsigned char offset;
    if ( pixelX > 83 ) return;
    if ( pixelY > 47 ) return;
	index = ((pixelY / 8) * 84) + pixelX;
	offset= pixelY - ((pixelY / 8) * 8);
	if (pixelMode == 0) LcdCache[index] &= ~(0x01 << offset);
	if (pixelMode == 1) LcdCache[index] |= (0x01 << offset);
	if (pixelMode == 2) LcdCache[index] ^= (0x01 << offset);
}


////////////////////////////////////////////////////////////////////////////////
// Trace une ligne sur l'Ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_line(unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2,unsigned char lineMode)
{
    int dx, dy, stepx, stepy, fraction;

    dy = y2 - y1;
    dx = x2 - x1;

    if ( dy < 0 )
    {
        dy    = -dy;
        stepy = -1;
    }
    else
    {
        stepy = 1;
    }

    if ( dx < 0 )
    {
        dx    = -dx;
        stepx = -1;
    }
    else
    {
        stepx = 1;
    }

    dx <<= 1;
    dy <<= 1;

    LCD_pixel( x1, y1, lineMode );

    if ( dx > dy )
    {
        fraction = dy - (dx >> 1);
        while ( x1 != x2 )
        {
            if ( fraction >= 0 )
            {
                y1 += stepy;
                fraction -= dx;
            }
            x1 += stepx;
            fraction += dy;
            LCD_pixel( x1, y1, lineMode );
        }
    }
    else
    {
        fraction = dx - (dy >> 1);
        while ( y1 != y2 )
        {
            if ( fraction >= 0 )
            {
                x1 += stepx;
                fraction -= dy;
            }
            y1 += stepy;
            fraction += dx;
            LCD_pixel( x1, y1, lineMode );
        }
    }
}

////////////////////////////////////////////////////////////////////////////////
// Reaffiche l'Ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_redraw(void)
{
	unsigned int a;
    LCD_gotoxy(0,0);      							    // Se placer en 0,0
	LcdPos = 0;
    for (a=0;a<=503;a++){LCD_write_data(LcdCache[a]);} 	// Affiche le bitmap
}

////////////////////////////////////////////////////////////////////////////////
// Ecran noir
////////////////////////////////////////////////////////////////////////////////
void ecran_noir(void)
{
	unsigned int a;
    for (a=0;a<=503;a++){LcdCache[a] = 0xFF;} 	// Affiche le bitmap
	LCD_redraw();
}


////////////////////////////////////////////////////////////////////////////////
// Trace un Rectangle sur l'Ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_rect(unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2,unsigned char rectMode)
{
	LCD_line(x1,y1,x2,y1,rectMode);
	LCD_line(x2,y1,x2,y2,rectMode);
	LCD_line(x2,y2,x1,y2,rectMode);
	LCD_line(x1,y2,x1,y1,rectMode);
	LCD_redraw();
}


////////////////////////////////////////////////////////////////////////////////
// Trace un Rectangle plein sur l'Ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_rectfill(unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2,unsigned char rectMode)
{

	unsigned char a;

	if (x1 <= x2)
		{
			for (a = x1;a <= x2;a++)
		    LCD_line(a,y1,a,y2,rectMode);
		}
	else
		{
			for (a = x2;a <= x1;a++)
		    LCD_line(a,y1,a,y2,rectMode);
		}

	LCD_redraw();
}


////////////////////////////////////////////////////////////////////////////////
// Trace un Cercle sur l'Ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_circle(unsigned char centerX,unsigned char centerY,unsigned char radius,unsigned char circleMode)
{
	signed int tswitch;
	unsigned char y, x = 0;
	unsigned char d;//uchar??

	d = centerY - centerX;
	y = radius;
	tswitch = 3 - 2 * radius;
	while (x <= y) 
		{
		LCD_pixel(centerX + x,centerY + y, circleMode);
		LCD_pixel(centerX + x,centerY - y, circleMode);
		LCD_pixel(centerX - x,centerY + y, circleMode);     
		LCD_pixel(centerX - x,centerY - y, circleMode);
		LCD_pixel(centerY + y - d, centerY + x, circleMode); 
		LCD_pixel(centerY + y - d, centerY - x, circleMode);
		LCD_pixel(centerY - y - d, centerY + x, circleMode); 
		LCD_pixel(centerY - y - d, centerY - x, circleMode);

		if (tswitch < 0) tswitch += (4 * x + 6);
		else {
			tswitch += (4 * (x - y) + 10);
			y--;
		}
		x++;
	}
	LCD_redraw();


}

