#include <pic18.h>
#include "delay.h"
#include "i2c.h"
#include "sajat.h"
#include "Nokia_LCD.h"

__CONFIG(1,HSPLL & OSCSDIS);
__CONFIG(2,BORDIS & WDTDIS);
__CONFIG(3,CCP2RC1);
__CONFIG(4,DEBUGDIS & LVPDIS & STVRDIS);
__CONFIG(5,49167);
__CONFIG(6,57359);
__CONFIG(7,SWDTDIS);

#define CIM 10	

unsigned char a,s[10],cim,adat[3],i;

void BEALLITASOK(void)
{
  TRISA=0B11111111;
  ADCON1=0B11111111;
  ADCON0=0B11111111;
  TRISB=0B00000001;
  TRISC=0B00011000;
  TRISD=0B00000000;
  TRISE=0B001;
}

void I2C_INIT(void)
{
 PIR1=0;
 SSPEN = 1; 
 SSPM3=1;   
 SSPM2=1;  
 SSPM1=1;  
 SSPM0=0;    
 SSPCON2=0;  
 CKE=1;
 SSPADD=CIM;
 IPEN=1;
 SEN=1;
 SSPIE = 1;  //Enable SPI interrups
 GIE = 1;
 SSPIF =0 ;
}

void interrupt isr(void)
{
 if(SSPIF)
	{  
        //Cm rkezett
	 if(S==1&&DA==0&&RW==0&&BF==1)
        {
         cim=SSPBUF;
         i=0;
        }
        //Adat rkezett
     if(S==1&&DA==1&&RW==0&&BF==1)
        {
         adat[i]=SSPBUF;
         i++;
        } 
	}
SSPIF =0 ;
}

void main(void)
 {
  BEALLITASOK();
  Lcd_init(); 
  I2C_INIT();
  LCD_printstr(1,1,"I2C",0);
   while(1)
    {
     INTOSTR(s,cim); 
     LCD_printstr(1,2,s,0);
     INTOSTR(s,adat[0]); 
     LCD_printstr(1,3,s,0);
     INTOSTR(s,adat[1]); 
     LCD_printstr(1,4,s,0);
     INTOSTR(s,adat[2]); 
     LCD_printstr(1,5,s,0);
    }
    
}

/*
; STATE 1: I2C rsi mvelet, utols bjt volt cmbjt.
;
; SSPSTAT bit: S = 1, D_A = 0, R_W = 0, BF = 1
;
; STATE 2: I2C rsi mvelet, utols bjt volt adat byte.
;
; SSPSTAT bit: S = 1, D_A = 1, R_W = 0, BF = 1
;
; STATE 3: I2C olvassi mvelet, utols bjt volt cmbjt.
;
; SSPSTAT bit: S = 1, D_A = 0, R_W = 1, BF = 0
;
; STATE 4: I2C olvassi mvelet, utols bjt volt adat byte.
;
; SSPSTAT bit: S = 1, D_A = 1, R_W = 1, BF = 0
;
; STATE 5: Slave I2C logika reset by NACK a mester.
;
; SSPSTAT bit: S = 1, D_A = 1, R_W = 0, BF = 0
*/