'PSCOPE90 04SEP00: EPE PIC SCOPE PROGRAM: COPYRIGHT (c) JOHN BECKER
'CUT DOWN VERSION OF ORIG EPE V-SCOPE PROGRAM
'MACHINE CODE COMPILED BY REGISTERED A86/D86 ASSEMBLER SOFTWARE
version$ = "V1.1"

WIDTH 80, 43: SCREEN 9: COLOR 15, 1: ON ERROR GOTO errortrap
handshake = 248: PICDELAY = 256: ' delay for sync routine

'file$ = "c:\a86\PSCOPEMS.COM": 'mouse
'file2$ = "C:\a86\PSCOPE36.COM": 'digital main

file$ = "PSCOPEMS.COM": 'mouse
file2$ = "PSCOPE36.COM": 'digital main

column% = 11: CONST pi = 3.141593 / 180
DIM V1%(1000): 'used for GET & PUT functions
DIM freq(25), a$(50), month$(12), origfreq(18)

DIM mode%(column%), box%(column%, 25, 1), ma%(24), mb%(200), store%(32766)
DIM ma, mb, mc, md, me, mv%

DATA FREQ Hz,PK MAX,PK MIN,PK-PK,SYNC,TRIG

DATA 24,24,77,24,24,77,516,516,560: 'freq factors F=1
DATA 9.6,9.6,48,9.6,9.6,48,516,516,560: 'freq factors F=0
'        2K       32K      MEM OFF
'     1   1  2   1   1  2   1   1   2

DATA JAN,FEB,MAR,APR,MAY,JUN,JUL,AUG,SEP,OCT,NOV,DEC

port$(0) = "&H378": port$(1) = "&H278": port$(2) = "&H3BC"

GOSUB setup: route = 6

COLOR 14: LOCATE 4, 62: PRINT "EPE PIC16F877"
LOCATE 6, 60: PRINT "VIRTUAL SCOPE "; version$: COLOR 11
LINE (58 * 8 - 5, 2 * 8 - 5)-(78 * 8 + 7, 7 * 8 + 5), 15, B
LINE (58 * 8, 2 * 8)-(78 * 8 + 2, 7 * 8), 15, B
PAINT (58 * 8 - 1, 2 * 8 - 1), 7, 15

LOCATE 12, 61: PRINT "DISPLAY DATE/TIME"
LINE (58 * 8 - 5, 10 * 8 - 5)-(78 * 8 + 7, 15 * 8 + 5), 15, B
LINE (58 * 8, 10 * 8)-(78 * 8 + 2, 15 * 8), 15, B
PAINT (58 * 8 - 1, 10 * 8 - 1), 7, 15

LINE (60 * 8 - 5, 18 * 8 - 5)-(76 * 8 + 7, 21 * 8 + 5), 15, B
LINE (60 * 8, 18 * 8)-(76 * 8 + 2, 21 * 8), 15, B
PAINT (60 * 8 - 1, 18 * 8 - 1), 7, 15

LOCATE 21, 4: PRINT "WAITING RESPONSE FROM CIRCUIT                  "
GOSUB default

reset1: COLOR 15: mb%(12) = memlength - 440: chanchange = 0: mb%(29) = 0
IF PICCHAN = 12 THEN mb%(12) = mb%(12) \ 2
wait1: LINE (4, 284)-(452, 296), 0, BF: LINE (4, 284)-(8, 296), 13, BF

wait2: COLOR 14: timediv = PICCHAN - 10 + (sample% * 3)
IF fosc = 0 THEN timediv = timediv + 9
mem = mb%(29): IF mem < 0 THEN mem = mem + 65536
mx = mem \ 149: LINE (4, 284)-(4 + mx, 296), 9, BF
GOSUB screenit: COLOR 11: LOCATE 14, 60: PRINT DATE$; " "; TIME$
COLOR 15: IF tim$ = TIME$ THEN GOTO wait3
GOSUB mouse: IF dig = 1 OR freqv = 1 THEN GOTO timepass
IF chanchange > 0 THEN GOTO reset1

CHAN1FREQ: IF chanon(0) = 0 THEN GOTO CHAN2FREQ
x3 = (mb%(21) - mb%(22)) * freq(timediv): a = mb%(23) - 2
IF a > 0 AND x3 <> 0 THEN x3 = x3 / a: t = (1000000 / x3) ELSE t = 0
IF t >= 10000 THEN t = INT(t) ELSE t = INT(t * 100) / 100
n = (mb%(18) - 128) * 20:  'max
n2 = (mb%(17) - 128) * 20: 'min
n4 = n - n2: IF n4 < 10000 THEN n3$ = "mV" ELSE n3$ = " V": n4 = n4 \ 1000
ma%(3) = 0: GOSUB mousein
LOCATE 40, 57: PRINT LEFT$(STR$(t) + "      ", 8):  'freq
LOCATE 41, 57: PRINT LEFT$(STR$(n) + "      ", 6); :      'max V
LOCATE 42, 57: PRINT LEFT$(STR$(n2) + "      ", 6); :     'min V
LOCATE 43, 57: PRINT LEFT$(STR$(n4) + "      ", 6); :     'peak V
FOR a = 1 TO 3: LOCATE 40 + a, 62: PRINT n3$; : NEXT: LOCATE 1, 1
ma%(3) = 1: GOSUB mousein

CHAN2FREQ: IF chanon(1) = 0 THEN GOTO timepass
x3 = (mb%(71) - mb%(72)) * freq(timediv): a = mb%(73) - 2
IF a > 0 AND x3 <> 0 THEN x3 = x3 / a: t = (1000000 / x3) ELSE t = 0
IF t >= 10000 THEN t = INT(t) ELSE t = INT(t * 100) / 100
n = (mb%(68) - 128) * 20:  'max
n2 = (mb%(67) - 128) * 20: 'min
n4 = n - n2: IF n4 < 10000 THEN n3$ = "mV" ELSE n3$ = " V": n4 = n4 \ 1000
ma%(3) = 0: GOSUB mousein
LOCATE 40, 65: PRINT LEFT$(STR$(t) + "      ", 8):  'freq
LOCATE 41, 65: PRINT LEFT$(STR$(n) + "      ", 6); :      'max V
LOCATE 42, 65: PRINT LEFT$(STR$(n2) + "      ", 6); :     'min V
LOCATE 43, 65: PRINT LEFT$(STR$(n4) + "      ", 6); :     'peak V
FOR a = 1 TO 3: LOCATE 40 + a, 70: PRINT n3$; : NEXT: LOCATE 1, 1
ma%(3) = 1: GOSUB mousein

timepass: tim$ = TIME$

wait3: GOSUB mouse: IF INKEY$ <> "" THEN GOTO wait3
IF chanchange > 0 THEN GOTO reset1

IF mb%(29) <> 0 THEN GOTO wait4
IF sim = 1 THEN GOTO reset1
GOSUB saveit: IF sample% = 2 THEN GOTO reset1

OUT portout, 8: LOCATE 20, 64: PRINT "WAIT RESET "
waitreset: IF (INP(portin) + 128) AND 248 <> 248 THEN GOTO waitreset
LOCATE 20, 64: COLOR 10: PRINT "RESET - OK ": OUT portout, 0: GOTO reset1

wait4: IF hold1 = 1 THEN GOSUB hold
IF chanchange > 0 THEN GOTO reset1
IF sample% <> 1 THEN COLOR 14: LOCATE 20, 64: PRINT "CONTINUING ":
GOTO wait2

screenit: CALL ABSOLUTE(SADD(screen$)): RETURN

saveit: IF SAVE% = 0 THEN RETURN
IF sim = 1 THEN RETURN
IF autosave% = 1 THEN a$ = DATE$ + TIME$: GOTO saver
ma%(3) = 0: GOSUB mousein: ma%(3) = 1
COLOR 14, 1: LOCATE 43, 46: PRINT "SAVE NOW "; : COLOR 15, 1
LOCATE 1, 2: PRINT "                             ";

checksave: GOSUB mouse: IF ma%(0) = 0 THEN GOTO checksave
IF ma%(0) = 2 THEN GOTO chks2
IF my% <> 42 THEN GOTO chks2
IF mx% < 45 OR mx% > 53 THEN GOTO chks2
IF ma%(0) = 1 THEN a$ = DATE$ + TIME$: GOTO saver
chks2: ma%(3) = 0: GOSUB mousein: LOCATE 43, 46: PRINT "WAIT SAVE";
ma%(3) = 1: GOSUB mousein: RETURN

saver: month = VAL(LEFT$(a$, 2)): hour = VAL(MID$(a$, 11, 2))
IF month < 10 THEN month = month + 48 ELSE month = month + 55
IF hour < 10 THEN hour = hour + 48 ELSE hour = hour + 55
SAVE$ = MID$(a$, 4, 2) + CHR$(month) + CHR$(hour)
SAVE$ = SAVE$ + MID$(a$, 14, 2) + RIGHT$(a$, 2) + ".Y" + MID$(a$, 9, 2)

a = 32740: FOR b = 1 TO 11: store%(a + b) = mode%(b): NEXT
store%(a + 12) = trig(0): store%(a + 13) = trig(1)
store%(a + 14) = bias(0): store%(a + 15) = bias(1)
store%(a + 16) = shift(0): store%(a + 17) = shift(1)
store%(a + 18) = sync: store%(a + 19) = sample%: store%(a + 20) = dig

DEF SEG = VARSEG(store%(0)): BSAVE SAVE$, 0, 65532: DEF SEG : ma%(3) = 0
GOSUB mousein: IF autosave% = 0 THEN LOCATE 43, 46: PRINT "WAIT SAVE"; :
ma%(3) = 1: GOSUB mousein
COLOR 14, 1: LOCATE 1, 2: PRINT SAVE$; " SAVED"; : COLOR 15, 1: RETURN

'.................................

mousein: CALL ABSOLUTE(SADD(mouse$)): RETURN

mouse: ma%(3) = 1: GOSUB mousein: 'turn on mouse, check for keypress
z$ = UCASE$(INKEY$)
IF z$ = "Q" THEN quit = 1: SYSTEM: 'GOTO endit: 'quitit4
IF ma%(0) = 0 THEN prevmouse = 0: RETURN
IF z$ <> "" THEN prevmouse = 0
IF ma%(0) = prevmouse THEN RETURN
ma%(3) = 0: GOSUB mousein: 'turn off mouse, is restored after action
prevmouse = ma%(0)

mx% = ma%(1) \ 8 - 56: my% = ma%(2) \ 8:
IF mx% < 1 THEN GOTO f1
IF my% < 2 THEN RETURN
ON mx% GOTO c1, c1, c1, c1, c1, c1, c1, c2, c2, c2, c2, c2, c2, c0
IF mx% > 13 AND mx% < 23 AND my% = 23 THEN GOTO ADCRATE
IF mx% > 18 AND my% < 27 THEN RETURN
c3: IF my% > 1 AND my% < 28 THEN RETURN
ON my% - 27 GOTO d10, d10, d11, d11, d12, d12, d13, d0, d14
c0: GOTO freqvolt
c1: chan% = 0: trig = 0: bias = 0: mode% = 1: GOTO c4
c2: chan% = 1: trig = 1: bias = 1: mode% = 3
c4: IF mx% > 4 AND mx% < 10 AND my% > 13 THEN GOTO c6
IF mx% > 4 AND mx% < 10 AND my% < 14 THEN GOTO d15
IF my% > 1 AND my% < 14 THEN RETURN
c6: ON my% - 13 GOTO d0, d0, d0, d0, d0, d0, d0, d0, d2, d2, d3, d3, d3
ON my% - 26 GOTO d0, d5, d5, d0, d6, d6, d0, d7, d0, d8, d9, d9, d9, d9, d9
d0: RETURN
d1: RETURN
d2: mode% = 5: my% = chan% + 1: GOTO sync
d3: mode% = 6: my% = my% - 18 - 4: GOTO symbols
d4: RETURN
d5: GOTO trigger
d6: GOTO shift
d7: GOTO digitalset
d8: GOTO directoryshow
d9: GOTO channelon
d10: GOTO default
d11: GOTO samplesize
d12: GOTO gridon
d13: GOTO PRINTER
d14: GOTO holdit
d15: RETURN

f1: prevmouse = ma%(0): IF my% < 38 OR mx% > -3 THEN RETURN
mx% = ma%(1) \ 8
IF mx% < 16 AND (my% = 38 OR my% = 39) THEN GOTO portchange
IF (mx% > 20 AND mx% < 26 AND my% = 38) THEN GOTO quitit
IF my% = 42 THEN GOTO freqfactor
IF mx% < 35 THEN RETURN
IF mx% < 38 THEN GOTO f5
IF mx% > 44 AND mx% < 54 THEN GOTO f2
RETURN

f2: IF my% = 38 THEN GOTO directoryshow
IF my% = 40 THEN GOTO f3
RETURN

f3: IF sim = 1 THEN RETURN
SAVE% = (SAVE% + 1) AND 1: IF SAVE% = 0 THEN GOTO f4
sample% = sample% AND 2: memlength = sampleval(sample%): ms = 154
GOSUB default

LOCATE 31, 72: PRINT sample$(sample%): mode% = 10: my% = mode%(8)
COLOR 14, 1: LOCATE 41, 46: PRINT "SAVE ON ": COLOR 15, 1: RETURN

f4: autosave% = 0: LOCATE 1, 2: PRINT "                             ";
LOCATE 41, 46: PRINT "SAVE OFF": LOCATE 43, 46: PRINT "WAIT SAVE"; :
LOCATE 39, 33: PRINT "AUTO SAVE": RETURN

f5: IF my% <> 38 THEN RETURN
IF sim = 1 THEN RETURN
autosave% = (autosave% + 1) AND 1
SAVE% = autosave%: IF SAVE% = 0 THEN GOTO f4
sample% = sample% AND 2: memlength = sampleval(sample%): ms = 154
LOCATE 31, 72: PRINT sample$(sample%): mode% = 10: my% = mode%(8)
COLOR 14, 1: LOCATE 41, 46: PRINT "SAVE ON "
LOCATE 39, 33: PRINT "AUTO SAVE": COLOR 15, 1: LOCATE 43, 46
PRINT "         "; : GOSUB default: RETURN

freqfactor: b = ma%(0)
IF mx% > 36 AND mx% < 41 THEN b = 0: GOTO storepaths
IF mx% > 0 AND mx% < 6 THEN b = 0: GOTO recallpaths
IF b = 2 THEN b = -1
IF mx% > 18 AND mx% < 23 THEN b = b / 10: GOTO endfreqfact
IF mx% > 23 AND mx% < 28 THEN GOTO endfreqfact
IF mx% > 29 AND mx% < 35 THEN b = b * 10: GOTO endfreqfact
RETURN

endfreqfact: freq(timediv) = freq(timediv) + b: 'ma%(0)
IF freq(timediv) < 1 THEN freq(timediv) = 1
IF freq(timediv) > 1000 THEN freq(timediv) = 1000
f$ = LEFT$(STR$(freq(timediv)) + "   ", 5)
LOCATE 43, 15: COLOR 11: PRINT f$; : LOCATE 1, 1
LOCATE 41, 28: PRINT "SAVE WHEN DONE": RETURN

recallpaths: FOR a = 0 TO 17: freq(a) = origfreq(a): NEXT: COLOR 14
LOCATE 41, 19: PRINT "ORIG OK ": GOTO endfreqfact

channel: STOP: IF dig = 1 THEN RETURN
IF sim = 1 AND (mode% = 2 OR mode% = 4) THEN RETURN
IF my% < 18 THEN GOSUB boxblank: mode%(mode%) = my%: GOSUB boxcolour
b = 0: a = chan% + 1: clkbit = 80: IF chan% = 1 THEN a = 3: clkbit = 48
IF mode%(a) > 4 THEN gain% = mode%(a) - 5 ELSE gain% = mode%(a) - 1: b = 64
probe% = 0: IF mode%(a + 1) = 15 THEN probe% = 32 + 64 + 2
IF mode%(a + 1) = 16 THEN probe% = 128
bias% = bias(chan%): gain1% = gain% * 4 + b + probe%: byte = 16: bit1 = 32768
a = 256: sendreg = gain1% * a + bias%: down = 38 + chan%: RETURN

freqvolt: IF dig > 0 THEN RETURN
freqv = (freqv + 1) AND 1: mb%(27) = freqv: IF freqv = 0 THEN GOTO fv2
LOCATE 39, 74: PRINT "FV OFF": FOR b = 40 TO 43
LOCATE b, 57: PRINT "                       "; : NEXT: RETURN
fv2: ma%(3) = 0: GOSUB mousein: COLOR 14, 1: LOCATE 39, 74: PRINT "FV ON "
COLOR 15, 1: LOCATE 40, 73: PRINT "FREQ Hz": LOCATE 41, 73: PRINT "PK MAX"
LOCATE 42, 73: PRINT "PK MIN"; : LOCATE 43, 73: PRINT "PK-PK"; : ma%(3) = 1
GOSUB mousein: RETURN

sync: syncchan = chan%: mb%(11) = chan%
GOSUB boxblank: mode%(mode%) = my%: GOSUB boxcolour: RETURN

symbols: sync = my% - 1: mb%(10) = sync
GOSUB boxblank: mode%(mode%) = my%: GOSUB boxcolour: RETURN

trigger: IF ma%(0) = 1 THEN s = 1 ELSE s = -1
x% = 7: trig(bias) = (trig(bias) + s)
IF trig(bias) < 1 THEN trig(bias) = 1 ELSE IF trig(bias) > 255 THEN trig(bias) = 255
mb%(24) = trig(0): mb%(74) = trig(1)
LOCATE 30, 60: PRINT LEFT$(STR$(trig(0) - 128) + "   ", 4)
LOCATE 30, 66: PRINT LEFT$(STR$(trig(1) - 128) + "   ", 4)
a = trig(0) + shift(0): IF a < 1 THEN a = 1 ELSE IF a > 255 THEN a = 255
b = trig(1) + shift(1): IF b < 1 THEN b = 1 ELSE IF b > 255 THEN b = 255
mb%(31) = 255 - a: mb%(81) = 255 - b: RETURN

samplesize: IF sim = 1 THEN RETURN
IF SAVE% = 1 THEN RETURN
IF ma%(0) = 1 THEN s = 1 ELSE s = -1
sample% = sample% - s: IF sample% > 2 THEN sample% = 0
IF sample% < 0 THEN sample% = 2
IF sample% = 1 THEN ms = 9.5 ELSE ms = 154
now = 0: mb%(25) = 0

memlength = sampleval(sample%): mb%(29) = 0: PICMEM = 13 + sample%
LOCATE 31, 72: PRINT sample$(sample%): mode% = 10: my% = mode%(8)
timediv = PICCHAN - 10 + (sample% * 3):
IF fosc = 0 THEN timediv = timediv + 9
f$ = LEFT$(STR$(freq(timediv)) + "   ", 5)
LOCATE 43, 15: COLOR 11: PRINT f$; : LOCATE 1, 1

chanchange = PICMEM: OUT portout, PICMEM OR 8

LOCATE 20, 64: PRINT "WAITING MEM"
waitmemchange: IF (INP(portin) AND 248) <> handshake THEN GOTO waitmemchange
OUT portout, 0
waitzeromem: IF (INP(portin) AND 248) = handshake THEN GOTO waitzeromem
LOCATE 20, 64: PRINT "MEMORY OK  "
waitmem: GOSUB mouse: IF ma%(0) = 1 THEN GOTO waitmem
COLOR 14: LOCATE 20, 64: PRINT "CONTINUING ": RETURN

gridon: grid% = (grid% + 1) AND 1: COLOR (15 - grid%), 1
IF dig = 1 THEN LINE (8, 17)-(447, 274), 0, BF:
LOCATE 33, 73: PRINT "GRID": COLOR 15, 1: mb%(30) = grid%: RETURN

shift: IF dig = 1 THEN RETURN
IF ma%(0) = 1 THEN s = 1 ELSE s = -1
shift(bias) = (shift(bias) + s): IF shift(bias) > 127 THEN shift(bias) = 127
IF shift(bias) < -128 THEN shift(bias) = -128
shiftstore0 = shift(0): shiftstore1 = shift(1)
shiftx:
LOCATE 33, 60: PRINT LEFT$(STR$(shift(0)) + "   ", 4)
LOCATE 33, 66: PRINT LEFT$(STR$(shift(1)) + "   ", 4)

a = trig(0) + shift(0): IF a < 1 THEN a = 1 ELSE IF a > 255 THEN a = 255
b = trig(1) + shift(1): IF b < 1 THEN b = 1 ELSE IF b > 255 THEN b = 255
mb%(16) = shift(0): mb%(66) = shift(1): mb%(31) = 255 - a: mb%(81) = 255 - b
mb%(32) = shift(0) + 128: mb%(82) = shift(1) + 128: RETURN

channelon: IF dig = 2 THEN RETURN
chanon(chan%) = (chanon(chan%) + 1) AND 1
chanon((chan% + 1) AND 1) = 1: a = 57 + (chan% * 8)
FOR b = 40 TO 43: LOCATE b, a: PRINT "        "; : NEXT: LOCATE 1, 1

IF chanon(0) = 1 AND chanon(1) = 0 THEN cb0 = 0: cb1 = 0: PICCHAN = 10
IF chanon(0) = 0 AND chanon(1) = 1 THEN cb0 = 1: cb1 = 1: PICCHAN = 11
IF chanon(0) = 1 AND chanon(1) = 1 THEN cb0 = 0: cb1 = 1: PICCHAN = 12

IF PICCHAN = 10 THEN shiftstore0 = shift(0): shift(0) = 0: shift(1) = shiftstore1: GOSUB shiftx: GOTO chanon2
IF PICCHAN = 11 THEN shiftstore1 = shift(1): shift(1) = 0: shift(0) = shiftstore0: GOSUB shiftx: GOTO chanon2
IF PICCHAN = 12 THEN shift(0) = shiftstore0: shift(1) = shiftstore1: GOSUB shiftx: GOTO chanon2

chanon2:
timediv = PICCHAN - 10 + (sample% * 3):
IF fosc = 0 THEN timediv = timediv + 9
f$ = LEFT$(STR$(freq(timediv)) + "   ", 5)
LOCATE 43, 15: COLOR 11: PRINT f$; : LOCATE 1, 1
chanchange = PICCHAN: OUT portout, PICCHAN
memlength = sampleval(sample%): mb%(29) = 0

LOCATE 39, 58: COLOR (15 - chanon(0)), 1: PRINT "CH1 "; chan$(chanon(0));
COLOR (15 - chanon(1)), 1: PRINT " CH2 "; chan$(chanon(1)): COLOR 15, 1
mb%(26) = chanon(0): mb%(76) = chanon(1): mode% = 11: tim$ = "":
IF sim = 1 THEN GOTO endchan

LOCATE 20, 64: PRINT "WAIT CHAN    "
waitchan: GOSUB mouse
IF (INP(portin) AND 248) <> handshake THEN GOTO waitchan
OUT portout, 0:
waitzerochan: GOSUB mouse
IF (INP(portin) AND 248) = handshake THEN GOTO waitzerochan
LOCATE 20, 64: PRINT "CHANNEL OK  "
waitchan2: GOSUB mouse: IF ma%(0) = 1 THEN GOTO waitchan2
endchan: COLOR 14: LOCATE 20, 64: PRINT "CONTINUING ": RETURN

ADCRATE: chanchange = 9: OUT portout, 9
ma%(3) = 0: GOSUB mousein
LOCATE 20, 64: PRINT "WAIT ADC     "
COLOR 13: LOCATE 24, 72: PRINT "ADC OSC":
waitadc: GOSUB mouse
IF (INP(portin) AND 248 AND 240) <> (handshake AND 240) THEN GOTO waitadc
fosc = (INP(portin) / 8 + 1) AND 1
OUT portout, 0:
waitzeroadc: GOSUB mouse
IF (INP(portin) AND 248 AND 240) = (handshake AND 240) THEN GOTO waitzeroadc
LOCATE 20, 63: PRINT "ADC SWITCHED"

timediv = PICCHAN - 10 + (sample% * 3):
IF fosc = 0 THEN timediv = timediv + 9
f$ = LEFT$(STR$(freq(timediv)) + "   ", 5)
LOCATE 43, 15: COLOR 11: PRINT f$; : LOCATE 1, 1

waitadc2: GOSUB mouse: IF ma%(0) = 1 THEN GOTO waitadc2
ma%(3) = 0: GOSUB mousein:
COLOR 15: LOCATE 24, 72: PRINT "ADC F="; LTRIM$(STR$(fosc)):
endadc: COLOR 14: LOCATE 20, 63: PRINT " CONTINUING ": RETURN

holdit: hold1 = (hold1 + 1) AND 1: LOCATE 37, 72: COLOR 14, 1
PRINT hold$(hold1): COLOR 15, 1: RETURN

digitalset: mb%(29) = 0: mb%(12) = memlength - 440
IF ma%(0) = 1 THEN s = 1 ELSE s = -1
dig = dig + s: IF dig > 2 THEN dig = 0 ELSE IF dig < 0 THEN dig = 2
mb%(5) = dig: LOCATE 35, 60: PRINT dig$(dig): dgx = (dig AND 1) * 2
LINE (8, 17)-(447, 274), 0, BF: IF dig = 1 THEN col = 12 ELSE col = 7
DS1: b = 16 + 5: FOR a = 1 TO 8: LINE (4, b)-(6, b + 5), col, BF
LINE (450, b)-(452, b + 5), col, BF: b = b + 15: NEXT: b = b + 15
FOR a = 1 TO 8: LINE (4, b)-(6, b + 5), col, BF
LINE (450, b)-(452, b + 5), col, BF: b = b + 15: NEXT
IF dig <> 1 THEN col = 14: GOTO digset2

DS2: FOR b = 40 TO 43: LOCATE b, 57: PRINT "                       ";
NEXT: LOCATE 30, 60: PRINT " OFF  OFF ": col = 0
LOCATE 33, 60: PRINT " OFF  OFF ":
LOCATE 39, 74: PRINT "FV OFF"
grid2% = grid%: grid% = 1: GOTO digset3

digset2:  grid% = grid2%: IF dig = 0 THEN GOTO digset4
chanon(0) = 1: chanon(1) = 1: mb%(26) = 1: mb%(76) = 1
LOCATE 39, 58: COLOR 14, 1: PRINT "CH1 ON  CH2 ON "
LOCATE 39, 74: PRINT "FV ON ": COLOR 15, 1

digset4:
IF sim = 0 THEN LOCATE 30, 60: PRINT LEFT$(STR$(trig(0) - 128) + "   ", 4)
IF sim = 0 THEN LOCATE 30, 66: PRINT LEFT$(STR$(trig(1) - 128) + "   ", 4)
LOCATE 33, 60: PRINT LEFT$(STR$(shift(0)) + "   ", 4)
LOCATE 33, 66: PRINT LEFT$(STR$(shift(1)) + "   ", 4)
LOCATE 40, 73: PRINT "FREQ Hz": LOCATE 41, 73: PRINT "PK MAX"
LOCATE 42, 73: PRINT "PK MIN"; : LOCATE 43, 73: PRINT "PK-PK";

digset3: col = 13: mode% = 10: my% = mode%(8): DEF SEG = &HA800
IF dig <> 1 THEN BLOAD "scopgrd1.grd", 0 ELSE BLOAD "scopgrd2.grd", 80
DEF SEG : RETURN

simulateit:
LOCATE 30, 60: PRINT LEFT$(STR$(trig(0) - 128) + "   ", 4)
LOCATE 30, 66: PRINT LEFT$(STR$(trig(1) - 128) + "   ", 4)
LOCATE 33, 60: PRINT LEFT$(STR$(shift(0)) + "   ", 4)
LOCATE 33, 66: PRINT LEFT$(STR$(shift(1)) + "   ", 4)

sim = 0: mb%(28) = sim: LOCATE 41, 46: PRINT "SAVE OFF"
LOCATE 43, 46: PRINT "WAIT SAVE"; : LOCATE 39, 33: PRINT "AUTO SAVE"
LOCATE 1, 2: PRINT "                                      "

simit1: mb%(29) = 0: mb%(12) = memlength - 440
LINE (4 + mx, 285)-(20 + mx, 295), 0, BF: mx = 0
LINE (4 + mx, 285)-(20 + mx, 295), 9, BF: LINE (8, 17)-(447, 274), 0, BF
LOCATE 37, 60: PRINT sim$(sim)
IF dig <> 1 THEN LOCATE 21, 4: PRINT "WAITING RESPONSE FROM CIRCUIT                  "
RETURN

default: IF sim = 1 THEN GOTO enddefault
default = 1: COLOR 13: LOCATE 29, 72: PRINT "DEFAULT": COLOR 15
chanchange = PICCHAN: OUT portout, PICCHAN
chandef: LOCATE 20, 64: PRINT "WAIT CHAN   ": GOSUB mouse
IF sim = 1 THEN GOTO enddefault
IF (INP(portin) AND 248) <> handshake THEN GOTO chandef
OUT portout, 0
waitzerodef: LOCATE 20, 64: PRINT "WAIT CLEAR  ": GOSUB mouse
IF sim = 1 THEN GOTO enddefault
IF (INP(portin) AND 248) = handshake THEN GOTO waitzerodef
PICMEM = 13 + sample%: chanchange = PICMEM: OUT portout, PICMEM
waitmemdef: LOCATE 20, 64: PRINT "WAITING MEM ": GOSUB mouse
IF sim = 1 THEN GOTO enddefault
IF (INP(portin) AND 248) <> handshake THEN GOTO waitmemdef
OUT portout, 0
waitzerodef2: LOCATE 20, 64: PRINT "WAIT CLEAR  ": GOSUB mouse
IF sim = 1 THEN GOTO enddefault
IF (INP(portin) AND 248) = handshake THEN GOTO waitzerodef2
GOSUB ADCRATE

LOCATE 20, 64: PRINT "DEFAULT OK  "
waitlast: GOSUB mouse:
IF sim = 1 THEN GOTO enddefault
IF ma%(0) = 1 THEN GOTO waitlast
COLOR 14: LOCATE 20, 64: PRINT "CONTINUING "
mode% = 10: default = 0: ma%(3) = 0: GOSUB mousein
enddefault: COLOR 15: LOCATE 29, 72: PRINT "DEFAULT"
GOSUB mousein: RETURN

boxcolour: IF mode% < 8 AND my% > 17 THEN RETURN
IF mode% > 8 THEN RETURN
IF my% > 26 THEN RETURN
IF mode% < 5 THEN RETURN
m1 = mode%(mode%): mb%(33) = mode%(1): mb%(83) = mode%(3)
PAINT (box%(mode%, m1, 0), box%(mode%, m1, 1)), 14, 15: RETURN

boxblank: m1 = mode%(mode%)
PAINT (box%(mode%, m1, 0), box%(mode%, m1, 1)), 0, 15: RETURN

hold: ma%(3) = 0: GOSUB mousein
LOCATE 37, 72: COLOR 14, 1: PRINT "HOLDING":
COLOR 10: LOCATE 20, 64: PRINT " HOLDING   ":
COLOR 15, 1: GOSUB mouse
hold2: z$ = INKEY$: IF z$ = "" THEN GOSUB mouse: IF hold1 = 1 THEN GOTO hold2
ma%(3) = 0: GOSUB mousein: LOCATE 37, 72: COLOR 14, 1: PRINT hold$(hold1)
COLOR 15, 1: GOSUB mouse: RETURN

'......................................

PRINTER: LOCATE 35, 72: COLOR 14, 1: PRINT "PRINTER"
x$ = CHR$(27): b$ = x$ + "*" + CHR$(6) + CHR$(134) + CHR$(2)
  'ABOVE SETS HORIZ DENSITY AND NUMBER OF BYTES TO BE SENT
  'chr$(6) is horiz/vert density (90 dpi/60 dpi)
  'no of bytes = 646 (line len + 6) = 256 * 2 + 134, hence chr$(134)+chr$(2)
a = 24: '12 - line space factor
m$ = CHR$(255) + CHR$(255) + CHR$(255): 'm$=border lines; l$=horiz lines
WIDTH LPRINT 255: LPRINT : LPRINT x$; "@"; CHR$(1); CHR$(15): 'RESET
LPRINT x$; "3"; CHR$(a): 'SET FOR A/180 INCH LINE SPACE
mb%(6) = VARSEG(p$)
b = VARPTR(p$): a = 256: g = PEEK(b + 3) * a + PEEK(b + 2)
IF g > 32767! THEN g = g - 65536!
mb%(7) = g: mb%(5) = 3: 'mb%(5) sets mode route within machine code
LPRINT b$; LEFT$(l$, 646): mb%(4) = 0
FOR j = 1 TO 44: GOSUB screenit: mb%(4) = mb%(4) + 640
LPRINT b$; m$; LEFT$(p$, 639); CHR$(0); m$: NEXT: mb%(5) = dig: 'reset mb%(5) to prev
LPRINT b$; m$; LEFT$(l$, 640); m$: LPRINT : LPRINT : CLOSE
LOCATE 35, 72: COLOR 15, 1: PRINT "PRINTER": RETURN

'.............................

setup: LOCATE 21, 7: PRINT "SETTING UP - SPEED DEPENDS ON COMPUTER USED!"

'screen machine code variables - for chan 2 add 50 to mb%(x) & 100 to [si]
'not all are used in this cut down version
'mb%(0) [si+0]  main loop counter
'mb%(1) [si+2]  bit value of screen byte, rotates right
'mb%(2) [si+4]  sample value to be plotted
'mb%(3) [si+6]  holds previous sample value
'mb%(4) [si+8]  screen wipe position counter
'mb%(5) [si+10] mode flag 0 = analogue, 1 = digital, 2 = lissajous
'mb%(6) [si+12] varseg P$, for printer
'mb%(7) [si+14] first byte of P$
'mb%(8) [si+16] inverse/trigshift1 (internal)
'mb%(9) [si+18] inverse/trigshift2 (internal)
'mb%(10) [si+20] sync mode (up, off, down)
'mb%(11) [si+22] syncchan
'mb%(12) [si+24] memlength
'mb%(13) [si+26] don't use - the 26 = EOF problem!
'mb%(14) [si+28] mouse button status from within main code: ' - not used
'mb%(15) [si+30] horiz pixel counter
'mb%(16) [si+32] shift value on its own
'mb%(17) [si+34] peak sample value min
'mb%(18) [si+36] peak sample value max
'mb%(19) [si+38] immediate sign of signal above/below trigger line
'mb%(20) [si+40] stored sign of signal above/below trigger line
'mb%(21) [si+42] first freq peak horiz screen address in pixels
'mb%(22) [si+44] second freq peak horiz screen address in pixels
'mb%(23) [si+46] number of sign flag changes counter
'mb%(24) [si+48] trig value on its own
'mb%(25) [si+50] input via mem or direct (NOW) flag
'mb%(26) [si+52] channel on flag
'mb%(27) [si+54] freqbox on flag
'mb%(28) [si+56] simulate flag
'mb%(29) [si+58] simulate counter
'mb%(30) [si+60] grid flag
'mb%(31) [si+62] shift+trig
'mb%(32) [si+64] new shift
'mb%(33) [si+66] channel gain
'mb%(34) [si+68] temp store sim counter for freq val use
'mb%(35 to 42) [si+70 to 84] only for Lissajous use
'mb%(43) [si+86] varseg store%(0)
'mb%(44) [si+88] portout
'mb%(45) [si+90] portin
'mb%(46) [si+92] delay factor to allow PIC to step when sync on
'mb%(46) [si+94] delay factor counter

'store%(0 to 32767) simulate/recording store
'chan 1 = lsb [evens], chan 2 = msb [odds] of each mb%(x) value

mb%(46) = PICDELAY: setupsim = 0

sample$(0) = "MEM 32K": sample$(1) = "MEM 2K ": sample$(2) = "MEM OFF"
sampleval(0) = 32768: sampleval(1) = 2048: sampleval(2) = 32768: 'OCT99

grid$(0) = "OFF": grid$(1) = "ON ": ' l = 40: l1(0) = 57: l1(1) = 65
chan$(0) = "OFF": chan$(1) = "ON "
dig$(0) = " ANALOGUE ": dig$(1) = " DIGITAL ": dig$(2) = "LISSAJOUS "
hold$(0) = "RUNNING": hold$(1) = "HOLD ON": hold$(2) = "HOLDING"
sim$(0) = "   LIVE   ": sim$(1) = " SIMULATE": bit$(0) = "0": bit$(1) = "1"

scopebox: x = 7: x1 = 56 * 8: y = 2 * 8: y1 = 34 * 8 + 3
LINE (x, y)-(x1, y1), 15, B: LINE (x - 5, y - 5)-(x1 + 5, y1 + 5), 15, B
PAINT (x - 1, y - 1), 7, 15

membox: LINE (x - 5, y1 + 8)-(x1 + 5, y1 + 16 + 6), 15, B

freqvolts: COLOR 14, 1: LOCATE 39, 58: PRINT "CH1 ON  CH2 ON  FV ON ";
COLOR 15, 1
FOR a = 4 TO 7: READ a$: LOCATE a + 36, 73: PRINT a$; : NEXT: LOCATE 1, 1

freqbox: x = 55 * 8 + 2: y = 38 * 8 - 2: x1 = 79 * 8 + 2: y1 = 43 * 8
LINE (x, y)-(x1, y1), 15, B: LINE (x - 2, y - 2)-(x1 + 2, y1 + 2), 15, B
PAINT (x - 1, y - 1), 7, 15

directorybox: LOCATE 39, 46: PRINT "DIRECTORY": x = 44 * 8 + 2
y = 38 * 8: x1 = 54 * 8 + 2: LINE (x, y - 3)-(x1, y + 9), 15, B

savebox: LOCATE 41, 46: PRINT "SAVE OFF"
y = 40 * 8: LINE (x, y - 3)-(x1, y + 9), 15, B

waitsavebox: LOCATE 43, 46: PRINT "WAIT SAVE";
y = 42 * 8: LINE (x, y - 3)-(x1, y + 9), 15, B

autosavebox: LOCATE 39, 33: PRINT "AUTO SAVE": x = 31 * 8 + 2
y = 38 * 8: x1 = 41 * 8 + 2: LINE (x, y - 3)-(x1, y + 9), 15, B

portbox: LOCATE 39, 5: PRINT "PORT ADDRESS": x = 3 * 8 + 2
COLOR 14: LOCATE 40, 8: PRINT port$(port1): COLOR 15
y = 38 * 8: x1 = 16 * 8 + 2: LINE (x, y - 3)-(x1, y + 9 + 8), 15, B

quitbox: LOCATE 39, 23: COLOR 11: PRINT "Q"; : COLOR 15: PRINT "UIT"
x = 21 * 8 + 2
y = 38 * 8: x1 = 26 * 8 + 2: LINE (x, y - 3)-(x1, y + 9), 15, B

freqcorrectbox: COLOR 7: LOCATE 43, 3: PRINT "ORIG  "; : COLOR 15
PRINT "FREQx:      "; : COLOR 14
PRINT CHR$(241); ".1   ";
PRINT CHR$(241); "1   "; CHR$(241); "10   SAVE"; : x = 1 * 8 + 2
y = 42 * 8: x1 = 41 * 8 + 2: LINE (x, y - 3)-(x1, y + 9), 15, B
LINE (x + 44, y - 3)-(x + 44, y + 9), 15: LOCATE 1, 1: COLOR 15

col = 14: LOCATE 26, 59: PRINT "CH1      CH2"

synccolumn: x = 58 * 8: y = 23 * 8 - 1: mode% = 5: READ a$: LOCATE 24, 63
PRINT a$: box%(mode%, 1, 0) = x + 1: box%(mode%, 1, 1) = y + 1 + 1
LINE (x, y)-(x + 18, y + 8), 15, B
x = 67 * 8 + 2: box%(mode%, 2, 0) = x + 1: box%(mode%, 2, 1) = y + 1 + 1
LINE (x, y)-(x + 18, y + 8), 15, B

syncsymbols: x = 63 * 8: y = 24 * 8: b = y: mode% = 6: '20
FOR a = 2 TO 4: box%(mode%, a, 0) = x + 9: box%(mode%, a, 1) = b + 6
b = b + 8: NEXT: LINE (x, y + 8)-(x + 8, y), 15
LINE -(x + 16, y + 8), 15: LINE -(x, y + 8), 15: y = y + 8
LINE (x, y)-(x + 16, y + 8), 15, B: y = y + 8
LINE (x, y)-(x + 8, y + 8), 15: LINE -(x + 16, y), 15: LINE -(x, y), 15

trig0: x = 58 * 8: y = 28 * 8: x1 = 69 * 8 + 2: mode% = 7: READ a$: '25
LOCATE 29, 63: PRINT a$: LINE (x, y - 2 - 1)-(x1, y + 18), 15, B

shift0: y = 31 * 8: LOCATE 1, 65: PRINT "SHIFT"
GET (64 * 8, 0)-(71 * 8, 8), V1%: LOCATE 1, 65: PRINT "     "
PUT (x + 26, y), V1%: LINE (x, y - 2)-(x1, y + 18), 15, B

digitalbox: y = 34 * 8: LOCATE 35, 61: PRINT "ANALOGUE"
LINE (x, y - 3)-(x1, y + 9), 15, B

simulatebox: y = 36 * 8: LOCATE 37, 63: PRINT "LIVE"
LINE (x, y - 3)-(x1, y + 9), 15, B

FOR a = 0 TO 17: READ origfreq(a): NEXT

adcratebox: x = 71 * 8 - 6: x1 = 78 * 8 + 4: y = 23 * 8: ' mode% = 9
LOCATE 24, 72: PRINT "ADC OSC": LINE (x, y - 3)-(x1, y + 9), 15, B

defaultbox: x = 71 * 8 - 6: x1 = 78 * 8 + 4: y = 28 * 8: mode% = 9
LOCATE 29, 72: PRINT "DEFAULT": LINE (x, y - 3)-(x1, y + 9), 15, B

memorybox: y = 30 * 8: LOCATE 31, 72: PRINT sample$(1)
LINE (x, y - 3)-(x1, y + 9), 15, B

gridbox: y = 32 * 8: LOCATE 33, 73: COLOR 14, 1: PRINT "GRID": COLOR 15, 1
LINE (x, y - 3)-(x1, y + 9), 15, B

printerbox: y = 34 * 8: LOCATE 35, 72: PRINT "PRINTER"
LINE (x, y - 3)-(x1, y + 9), 15, B

holdbox: y = 36 * 8: LOCATE 37, 72: COLOR 14, 1: PRINT "RUNNING": COLOR 15, 1
LINE (x, y - 3)-(x1, y + 9), 15, B

monthnames: FOR a = 1 TO 12: READ month$(a): NEXT

setprinterstrings: l$ = CHR$(3): FOR a = 1 TO 10: l$ = l$ + l$: NEXT
l$ = LEFT$(l$, 666): p$ = l$

route = 1
getmousecode: OPEN file$ FOR INPUT AS #1: b = LOF(1)
IF b = 0 THEN GOTO nocode
mouse$ = INPUT$(b, #1): CLOSE 1
getscreencode: OPEN file2$ FOR BINARY AS #1: b = LOF(1)
IF b = 0 THEN GOTO nocode
screen$ = INPUT$(b, #1): CLOSE 1

route = 2
OPEN "PSCOPATH.TXT" FOR INPUT AS #1: INPUT #1, port$:
FOR a = 0 TO 17: INPUT #1, a$: freq(a) = VAL(a$): NEXT: CLOSE

path1:
port1 = VAL(port$): portout = VAL(port$(port1)): portin = portout + 1
mb%(44) = portout: mb%(45) = portin: OUT portout, 0
route = 3

path2:
IF setupsim = 1 THEN GOSUB dirlookup: GOSUB setgrid: GOSUB storedata
route = 4
DEF SEG = &HA800: BLOAD "scopgrd1.grd", 0: DEF SEG
DEF SEG = VARSEG(store%(0)): BLOAD "scopetab.grd", 0: DEF SEG : b = store%(0)
d = 0: FOR a = 1 TO b STEP 9: d = d + 1: a$(d) = "": FOR c = 0 TO 8
e = store%(a + c) AND 255: a$(d) = a$(d) + CHR$(e): NEXT: tablelen = d: NEXT

route = 5
trig(0) = 128: trig(1) = 128: bias(0) = 128: bias(1) = 128: sim = 0
shift(0) = 60: shift(1) = -60: chanon(0) = 1: chanon(1) = 1
shiftstore0 = shift(0): shiftstore1 = shift(1)
mode%(1) = 5: mode%(2) = 14: mode%(3) = 5: mode%(4) = 14
mode%(5) = 1: mode%(6) = 3: mode%(8) = 9: cb0 = 0: cb1 = 1: sync = 2
mode%(9) = 1: ms = 9.5: sample% = 1: PICMEM = 13 + sample%
mode%(10) = 1: grid% = 1: mb%(30) = 1
PICCHAN = 12: timediv = PICCHAN - 10 + (sample% * 3)
IF fosc = 0 THEN timediv = timediv + 9

memlength = sampleval(sample%): LOCATE 31, 72: PRINT sample$(sample%)
LOCATE 37, 60: PRINT sim$(sim): GOSUB boxtexts: mb%(26) = 1: mb%(76) = 1

f$ = LEFT$(STR$(freq(timediv)) + "   ", 5)
LOCATE 43, 15: COLOR 11: PRINT f$; : LOCATE 1, 1

mode% = 5: my% = mode%(5): GOSUB sync
mode% = 6: my% = mode%(6): GOSUB symbols
chan% = 0: syncchan = 0: clkbit = 80
byte = 8: mb%(33) = mode%(1): mb%(83) = mode%(3)
mb%(10) = sync: mb%(11) = chan%

setmachinecodevariables:
now = 0: a = 256: mb%(25) = 0: ma = VARSEG(ma%(0))
mb = VARPTR(mouse$): mc = PEEK(mb + 3) * a + PEEK(mb + 2)
IF ma < 0 THEN ma = ma + 65536!
md = INT(ma / 256): mb = ma - (md * 256)
POKE mc + 5, mb: POKE mc + 6, md
ma = VARSEG(mb%(0))
mb = VARPTR(screen$): mc = PEEK(mb + 3) * a + PEEK(mb + 2)
IF ma < 0 THEN ma = ma + 65536!
md = INT(ma / 256): mb = ma - (md * 256)
POKE mc + 5, mb: POKE mc + 6, md
mb%(43) = VARSEG(store%(0)): RETURN

dirlookup: SCREEN 9, 0, 1, 1
DEF SEG = &HA800: LOCATE 42, 2: PRINT "GETTING DIRECTORY LOOKUP TABLE";
a$ = " -.1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ?"
FOR a = 1 TO LEN(a$): LOCATE 1, 1: PRINT MID$(a$, a, 1): c = 0
FOR b = 0 TO 7: d = PEEK(c) + 1: a$(a) = a$(a) + CHR$(d): c = c + 80: NEXT
a$(a) = a$(a) + MID$(a$, a, 1): NEXT: DEF SEG : GOSUB sort
LOCATE 1, 1: PRINT " ": RETURN

setgrid: LOCATE 42, 2: PRINT "SETTING UP DIGITAL GRID       ";
grid%(0) = 33: grid%(1) = 8: grid%(2) = 66: grid%(3) = 16: grid%(4) = 132
gridv%(0) = 0: gridv%(1) = 0: gridv%(2) = 64: gridv%(3) = 0: gridv%(4) = 4
DEF SEG = &HA800: 'stored in mem area 32K bytes beyond screen mem

digitalgrid:
FOR a = (80 * 30 + 1) TO (80 * 270 + 1) STEP (80 * 15): c = 0: 'vert lines
FOR b = 0 TO 55: d = gridv%(c): c = c + 1: IF c = 5 THEN c = 0
POKE (a + b - 80), d: POKE (a + b + 80), d: POKE (a + b), d: NEXT: NEXT
c = 1: FOR a = 80 * 143 + 2 TO 80 * 143 + 55: d = grid%(c): c = c + 1
IF c = 5 THEN c = 0
POKE a, d: NEXT: BSAVE "scopgrd2.grd", 0, (80 * (273 + 50)): 'digital grid

analoguegrid: CLS 0: LOCATE 42, 2: PRINT "SETTING UP ANALOGUE GRID";
FOR a = (80 * (18 + 2) + 1) TO (80 * (270 + 1) + 1) STEP (80 * 5): c = 0: 'vert lines
FOR b = 0 TO 55: d = gridv%(c): c = c + 1: IF c = 5 THEN c = 0
POKE (a + b), d: NEXT: NEXT
FOR a = (80 * (38 - 13) + 1) TO (80 * 273 + 1) STEP (80 * 20): c = 0: 'horiz lines
FOR b = 0 TO 55: d = grid%(c): c = c + 1: IF c = 5 THEN c = 0
POKE (a + b), d: NEXT: NEXT
BSAVE "scopgrd1.grd", 0, (80 * (273 + 50)): DEF SEG
SCREEN 9, 0, 0, 0: RETURN

directoryshow: IF ma%(0) <> 2 THEN GOTO dirshow
IF directory = 0 THEN RETURN
COLOR 15, 1: GOSUB boxtexts: LOCATE 37, 60: PRINT " SIMULATE "
LOCATE 30, 60: PRINT " OFF  OFF "
LOCATE 41, 46: PRINT "   OFF   ": LOCATE 43, 46: PRINT "   OFF   ";
LOCATE 39, 33: PRINT "   OFF   ": FOR b = 5 TO 7: m1 = mode%(b)
IF b <> 7 THEN PAINT (box%(b, m1, 0), box%(b, m1, 1)), 14, 15
NEXT: LOCATE 39, 46: PRINT "DIRECTORY": directory = 0:
GOTO simulateit

dirshow: route = 7: SCREEN 9, 0, 1, 1: CLS 0: FILES "*.y??"

COLOR 14: LOCATE 1, 19: PRINT "CURRENT REPLAY FILE = "; replay$: COLOR 15
ma%(4) = 2: ma%(3) = 1: GET (0, 0)-(96, 7), V1%: PUT (0, 0), V1%, PRESET
x2% = 0: y2% = 0
clearmouse1: GOSUB mousein: IF ma%(0) <> 0 THEN GOTO clearmouse1

dir2: GOSUB mousein: IF ma%(0) = 1 THEN GOTO dir3
IF ma%(0) = 2 THEN GOTO cleardir
x = 0: y = 80: x1% = (ma%(1) \ 144) * 144: y1% = (ma%(2) \ 8) * 8
IF x1% = x2% AND y1% = y2% THEN GOTO dir2
IF x1% > 540 OR y1% > 340 THEN GOTO dir2
PUT (x2%, y2%), V1%, PSET
GET (x1%, y1%)-(x1% + 96, y1% + 7), V1%: PUT (x1%, y1%), V1%, PRESET
x2% = x1%: y2% = y1%: GOTO dir2
dir3: IF y1% < 2 THEN GOTO dir2

PUT (0, 0), V1%, PSET: a$ = "": DEF SEG = &HA800: FOR c = 0 TO 11
b = c: k$ = "": FOR a = 1 TO 8: k$ = k$ + CHR$(PEEK(b)): b = b + 80: NEXT
GOSUB binarychop: IF q <> 0 THEN a$ = a$ + RIGHT$(a$(q), 1):  ELSE a$ = a$ + "?"
NEXT: DEF SEG : IF MID$(a$, 9, 1) <> "." THEN GOTO dir2
a = ASC(MID$(a$, 3, 1)) - 48: IF a > 9 THEN a = a - 7
decode$ = " (" + LEFT$(a$, 2) + month$(a) + RIGHT$(a$, 2)
a = ASC(MID$(a$, 4, 1)) - 48: IF a > 9 THEN a = a - 7
decode$ = decode$ + STR$(a) + ":" + MID$(a$, 5, 2) + "." + MID$(a$, 7, 2) + ") "

LOCATE 42, 2: PRINT "LOAD "; a$; decode$; " y/n ";
clearmouse2: GOSUB mousein: IF ma%(0) <> 0 THEN GOTO clearmouse2
dirmouse: k$ = INKEY$: IF k$ = "y" THEN GOTO enddir
IF k$ = "n" THEN GOTO dir4
GOSUB mousein: IF ma%(0) = 0 THEN GOTO dirmouse

IF ma%(0) = 1 THEN GOTO enddir
dir4: LOCATE 42, 2: PRINT "                                          ";
waitmouseclr: GOSUB mousein: IF ma%(0) <> 0 THEN GOTO waitmouseclr
GOTO dir2

enddir: CLS 0: DEF SEG = &HA800: BLOAD "scopgrd1.grd", 0: DEF SEG
SCREEN 9, 0, 0, 0: LOCATE 1, 2: PRINT "LOADING "; a$; : kk = 1
DEF SEG = VARSEG(store%(0)): BLOAD a$, 0: DEF SEG
sim = 1: directory = 1: mb%(28) = 1: mb%(29) = 0
GOSUB directoryboxcolours: COLOR 12, 1: GOSUB boxtexts
LOCATE 31, 72: PRINT sample$(sample%): ' STOP
memlength = sampleval(sample%): ms = 154
LOCATE 41, 46: PRINT "   OFF   ": LOCATE 43, 46: PRINT "   OFF   ";
LOCATE 39, 33: PRINT "   OFF   ": replay$ = a$ + decode$
LOCATE 37, 60: PRINT "  REPLAY  ": ma%(4) = 0: SAVE% = 0
GOSUB mouse: LOCATE 39, 46: PRINT "DIRECTORY":
COLOR 14: LOCATE 1, 2: PRINT "REPLAY "; replay$;
COLOR 15, 1: RETURN

cleardir: CLS 0: DEF SEG = &HA800: BLOAD "scopgrd1.grd", 0: DEF SEG
SCREEN 9, 0, 0, 0: ma%(4) = 0: GOSUB mouse: RETURN

directoryboxcolours: a = 32740: FOR b = 5 TO 7: m1 = mode%(b)
IF store%(a + b) <> 0 THEN mode%(b) = store%(a + b)
IF b <> 7 THEN PAINT (box%(b, m1, 0), box%(b, m1, 1)), 0, 15
IF b <> 7 THEN m1 = mode%(b): PAINT (box%(b, m1, 0), box%(b, m1, 1)), 12, 15
NEXT: mb%(33) = mode%(1): mb%(83) = mode%(3)
IF store%(a + 12) = 0 THEN RETURN: 'TEMP BYPASS TILL NEW FILES CREATED
trig(0) = store%(a + 12): trig(1) = store%(a + 13)
bias(0) = store%(a + 14): bias(1) = store%(a + 15)
shift(0) = store%(a + 16): shift(1) = store%(a + 17)
sync = store%(a + 18): sample% = store%(a + 19): dig = store%(a + 20)
IF sample% = 1 THEN ms = 9.5 ELSE ms = 154
RETURN

boxtexts:
LOCATE 30, 60: PRINT LEFT$(STR$(trig(0) - 128) + "   ", 4)
LOCATE 30, 66: PRINT LEFT$(STR$(trig(1) - 128) + "   ", 4)
LOCATE 33, 60: PRINT LEFT$(STR$(shift(0)) + "   ", 4)
LOCATE 33, 66: PRINT LEFT$(STR$(shift(1)) + "   ", 4)
LOCATE 35, 60: PRINT dig$(dig): mb%(5) = dig
LOCATE 31, 72: PRINT sample$(sample%): ' STOP
mb%(24) = trig(0): mb%(74) = trig(1): mb%(16) = shift(0): mb%(66) = shift(1)
a = trig(0) + shift(0): IF a < 1 THEN a = 1 ELSE IF a > 255 THEN a = 255
mb%(31) = 255 - a: mb%(32) = shift(0) + 128: mb%(82) = shift(1) + 128
a = trig(1) + shift(1): IF a < 1 THEN a = 1 ELSE IF a > 255 THEN a = 255
mb%(81) = 255 - a: mb%(10) = sync: RETURN

sort: num% = a: span% = num% / 2: DO WHILE span% > 0
FOR i% = span% TO num% - 1: j% = i% - span% + 1
FOR j% = (i% - span% + 1) TO 1 STEP -span%
IF a$(j%) <= a$(j% + span%) THEN EXIT FOR
SWAP a$(j%), a$(j% + span%): NEXT j%: NEXT i%: span% = span% / 2
LOOP: a = 0: FOR i% = 1 TO num%: IF a$(i%) = "" THEN GOTO endsort
FOR b = 1 TO LEN(a$(i%)) - 1: store%(a + 1) = ASC(MID$(a$(i%), b, 1)) - 1
a = a + 1: NEXT: store%(a + 1) = ASC(RIGHT$(a$(i%), 1)): a = a + 1
endsort: NEXT i%: a = a - 1: store%(0) = a: DEF SEG = VARSEG(store%(0))
BSAVE "scopetab.grd", 0, (a * 2): DEF SEG : RETURN

binarychop: l = 1: h = tablelen
chop1: q = INT((h + l) / 2): IF LEFT$(a$(q), 8) = k$ THEN RETURN
IF k$ < a$(q) OR a$(q) = "" THEN h = q - 1 ELSE l = q + 1
IF l > h THEN q = 0: RETURN
GOTO chop1

analysis:
d = 0: e = 0: LOCATE 1, 1: PRINT mb%(34); kk; mult: f = 8
s = 0: s1 = 0: c = f
a = mb%(34) / 2: b = store%(a): j = a
IF b < 0 THEN b = b + 65536
b = b AND 255: l = b: h = b
FOR a = (mb%(34) / 2) TO (mb%(34) / 2) + 440: b = store%(a)
IF b < 0 THEN b = b + 65536
b = b AND 255
IF b > (l + kk) THEN s = 1
IF b < (l - kk) THEN s = -1
IF s = s1 THEN GOTO 311
LINE (f, 20)-(f, 32), 14 + s
peak = ABS(h - b): 'max - min
d = (f - c): dd = d * 2: LINE (dd + 8, 256 + 17)-(dd + 8, 256 - peak + 17), 13
h = b: j = a: c = f
311 : s1 = s: l = b: f = f + 1: NEXT: kk = kk * 2: RETURN

portchange: port1 = port1 + 1: IF port1 > 2 THEN port1 = 0
portout = VAL(port$(port1)): portin = portout + 1
mb%(44) = portout: mb%(45) = portin: OUT portout, 0
COLOR 14: LOCATE 40, 8: PRINT port$(port1): COLOR 15: GOTO storepaths

quitit: IF ma%(0) <> 1 AND quit = 0 THEN RETURN
IF quit > 0 AND ma%(0) = 2 THEN GOTO quit3
quit = quit + 1: IF quit > 1 THEN quit = 2: RETURN
quitit4:
COLOR 10: LOCATE 20, 2: PRINT " ARE YOU SURE YOU WANT TO QUIT Y/N ?  ";
COLOR 15: BEEP
quit2: GOSUB mouse: IF quit = 2 AND ma%(0) = 1 THEN GOTO endit
IF quit = 0 THEN GOTO quit3: 'STOP
IF quit = 2 AND ma%(0) = 2 THEN STOP
z$ = UCASE$(INKEY$): IF z$ = "" THEN GOTO quit2
IF z$ = "Y" THEN GOTO endit
quit3: LOCATE 20, 3: PRINT "                                   ";
LOCATE 1, 1: quit = 0: quitkey = 0: RETURN

endit: LOCATE 20, 3: PRINT "                                   ";
COLOR 14: LOCATE 42, 3: PRINT "PROGRAM HAS NOW ENDED              ";
BEEP: LOCATE 1, 1: SYSTEM: STOP

storedata: FOR a = 0 TO 17: freq(a) = origfreq(a): NEXT: GOSUB storepaths
f$ = LEFT$(STR$(freq(timediv)) + "   ", 5)
LOCATE 43, 15: COLOR 11: PRINT f$; : LOCATE 1, 1
LOCATE 41, 19: PRINT "                       "; : LOCATE 1, 1: RETURN

storepaths:
OPEN "PSCOPATH.TXT" FOR OUTPUT AS #1: PRINT #1, STR$(port1):
FOR a = 0 TO 17: PRINT #1, STR$(freq(a)): NEXT: CLOSE : COLOR 10
LOCATE 41, 19: PRINT "         FACTORS STORED"; : LOCATE 1, 1: COLOR 15
RETURN

errortrap: number = ERR
IF (number = 52 OR number = 53) AND route = 1 THEN GOTO nocode
IF number = 53 AND route = 2 THEN setupsim = 1: RESUME path1
IF number = 53 AND route = 4 THEN DEF SEG : setupsim = 1: RESUME path2
IF number = 64 AND route = 4 THEN DEF SEG : setupsim = 1: RESUME path2
IF number = 53 AND route = 7 THEN GOTO nodirectory
GOTO problem

nodirectory:
LOCATE 10, 3: COLOR 14: PRINT "NO SCOPE FILES CREATED YET"
LOCATE 12, 3: PRINT "RELEASE MOUSE TO CONTINUE"
waithere: GOSUB mouse: IF ma%(0) = 1 THEN GOTO waithere
RESUME cleardir

problem: LINE (8, 17)-(447, 274), 0, BF: COLOR 10: LOCATE 7, 3
PRINT "EPE PIC VSCOPE "; version$: COLOR 14: LOCATE 9, 3
PRINT "UNFORESEEN MS-DOS ERROR NUMBER"; number; "AUTHOR'S ROUTE"; route
LOCATE 11, 3: COLOR 11
PRINT "NOTE THE ABOVE NUMBERS AND THE CIRCUMSTANCES UNDER"
LOCATE 12, 3: PRINT "WHICH THE ERROR OCCURRED AND ADVISE THE TECHNICAL"
LOCATE 13, 3: PRINT "DEPT AT "; : COLOR 10: PRINT "EPE MAGAZINE "; :
COLOR 11: PRINT "OF THE DETAILS IF YOU CANNOT"
LOCATE 14, 3: PRINT "FIND OUT THE REASON FOR YOURSELF": COLOR 14
LOCATE 16, 3: PRINT "PRESS Q TO QUIT OR ANY OTHER KEY TO RESTART PROGRAM"

COLOR 10: LOCATE 22, 3: PRINT "HELPFUL SUGGESTION": COLOR 11
LOCATE 24, 3: PRINT "TO FIND OUT WHAT A DOS ERROR CODE MEANS, HALT THIS"
LOCATE 25, 3: PRINT "PROGRAM (CTRL+BREAK), PRESS F6 TO ENTER "; CHR$(34);
PRINT "IMMEDIATE"; : PRINT CHR$(34); : LOCATE 26, 3
PRINT "SCREEN AREA AND TYPE IN THE WORD "; CHR$(34);
COLOR 14: PRINT "ERROR"; : COLOR 11: PRINT CHR$(34); " FOLLOWED"
LOCATE 27, 3: PRINT "BY THE NUMBER IN QUESTION, E.G.:"
COLOR 14: LOCATE 29, 3: PRINT "ERROR 53": COLOR 11
LOCATE 31, 3: PRINT "AND PRESS THE <ENTER> KEY. IN THE INSTANCE OF ";
COLOR 14: PRINT "53": COLOR 11
LOCATE 32, 3: PRINT "THE SCREEN SHOULD SHOW A BOX STATING ";
COLOR 14: PRINT "FILE NOT FOUND": COLOR 15

holdprob: z$ = INKEY$: IF z$ = "" THEN GOTO holdprob
IF UCASE$(z$) = "Q" THEN SYSTEM ELSE RUN

nocode: CLOSE : LINE (8, 17)-(447, 274), 0, BF: COLOR 10
LOCATE 18, 3: PRINT "MAIN FILE(S) NOT FOUND:": COLOR 14
LOCATE 20, 3: PRINT file$:
LOCATE 22, 3: COLOR 15: PRINT ; "and/or "
LOCATE 24, 3: COLOR 14: PRINT file2$: COLOR 10
LOCATE 26, 3: PRINT "PROGRAM SETUP ABORTED": END

