;PSCOPE36.J:       ;12NOV99 modified from orig V-SCOPE FILE
jmp STARTALL

;variables used, mainly for normal screen - add 100 for chan2
;(not all used in PSCOPE cut down version)
;[si]           main counter
;[si+2]         bit val of screen byte location, rotates from 128 to 1
;[si+4]  [+104] sample value to be plotted
;[si+6]  [+106] holds previous sample value
;[si+8]         screen wipe position counter (column count address)
;[si+10]        mode flag 0 = ana, 1 = dig, 2 = liss, 3 = printer
;[si+12]        varseg p$ (for printer use)
;[si+14]        displacement counter for screen dot byte
;[si+16]        inverse (trig+shift)1
;[si+18]        inverse (trig+shift)2
;[si+20]        sync, up=1 off=2 down=3
;[si+22]        syncchan
;[si+24]        mem size in use (memlength)
;[si+26]        don't use - the 26 = EOF problem!
;[si+28]        mouse button status
;[si+30]        horiz pixel counter for freq use
;[si+32] [+132] shift value on its own
;[si+34] [+134] min peak value
;[si+36] [+134] max peak value
;[si+38]        immediate sign flag for signal above/below trigger level
;[si+40] [+140] store for signal trigger sign flag
;[si+42] [+142] first store of address for signal crossing trigger value
;[si+44] [+144] second store of address for signal crossing trigger value
;[si+46] [+146] flag changes counter
;[si+48] [+148] trig value on its own
;[si+50]        flag for NOW (input direct or from PCB memory)
;[si+52] [+152] flag for chan ON
;[si+54]        flag for freqbox on (=0) / off (=1)
;[si+56]        simulate flag
;[si+58]        simulate counter
;[si+60]        grid flag
;[si+62] [+162] shift+trig value
;[si+64] [+164] new shift val
;[si+66] [+166] channel gain
;[si+68]        temp store of sim counter value
;[si+70 to +84] only for Lissajous use (via DI=70)
;[si+86]        varseg pointer store%(0)
;[si+88]        portout address
;[si+90]        portin address
;[si+92]        delay factor for sync (to allow PIC time to step on)
;               and compensates for fast computers (e.g. 120MHz and above)
;[si+94]        counter for delay factor

SETSEGMENT:
mov ds,01111    ;value changed from Basic: varseg(mb%(0))
ret

STARTALL:
push ds
call SETSEGMENT
mov si,0           ;segment address for mb%(0)
mov ax,1           ;ensure mouse is on
int 33H
mov [si+28][w],0      ;clear mouse press store

cmp [si+10][b],0
je R0
cmp [si+10][b],1
je R1
cmp [si+10][b],2
je R2
cmp [si+10][b],3
je R3
jmp EXOD

R0:
call SCOPEROUTE
jmp EXOD

R1:
call DIGITAL
jmp EXOD

R2:
call LISSAJOUS
jmp EXOD

R3:
call PRINTERPLOT

EXOD:             ;final exit point
pop ds
retf

SCOPEROUTE:
RESETTHEM:
mov [si][w],440    ;set main loop counter
mov [si+2][w],128  ;bit val of screen byte location
mov [si+8][w],1361 ;screen wipe position counter
mov [si+30][w],0   ;pixel counter
mov [si+34][w],255 ;min val 1 store
mov [si+36][w],0   ;max val 1 store
mov [si+38][w],0   ;immediate sign flag 1
mov [si+40][w],0   ;sign flag store 1
mov [si+42][w],0   ;first signal crossing store 1
mov [si+44][w],0   ;second signal crossing store 1
mov [si+46][w],0   ;flag changes counter 1
mov [si+134][w],255;min val 2 store
mov [si+136][w],0  ;max val 2 store
mov [si+138][w],0  ;immediate sign flag 2
mov [si+140][w],0  ;sign flag store 2
mov [si+142][w],0  ;first signal crossing store 2
mov [si+144][w],0  ;second signal crossing store 2
mov [si+146][w],0  ;flag changes counter 2

ENDRESET:
call SYNC
call STARTVALUE1
mov bx,[si+58]     ;temp store of sim counter for freq analysis use
mov [si+68],bx
cmp [si+24],450    ;check if enough bytes left for screen display
ja MAINLOOP        ;yes, enough

mov [si+58][w],0   ;no
mov [si+34][w],0   ;set min val1 to 0
mov [si+134][w],0  ;set min val2 to 0
ret

MAINLOOP:
CALL GETIT1
cmp [si+28][w],0   ;is mouse pressed?
je MAINLOOP2
ret

MAINLOOP2:
call SCREENIT
cmp [si+52][w],1   ;is chan1 on?
jne TRYCHAN2       ;no
call GETCHAN1
TRYCHAN2:
cmp [si+152][w],1  ;is chan2 on?
jne ENDCHANS       ;no
call GETCHAN2
call ADDTRIG2

ENDCHANS:
cmp [si+52][b],1   ;is chan1 on?
jne CHANSX
call ADDTRIG1
CHANSX:
shr [si+2][w],1    ;shift right screen bit
cmp [si+2][w],0
jne ENDSCREEN
mov [si+2][w],128  ;when bit = 0 reset to 128
inc [si+8][w]      ;and inc screen byte counter
inc [si+14][w]    ;inc grid pattern counter
cmp [si+14][w],5
jb ENDSCREEN
mov [si+14][w],0
ENDSCREEN:
dec [si][w]
jnz MAINLOOP
sub [si+24][w],440
jnc ENDMAIN
mov [si+58][w],0
ENDMAIN:

GETFREQETC:
cmp [si+54][b],0      ;is freq on (=0)?
ja FREQ2A             ;off (=1)
mov di,[si+68]        ;reclaim sim counter start value
mov cx,440
call FREQ1
FREQ1A:
mov di,[si+68]        ;reclaim sim counter start value
mov cx,440
call FREQ2
FREQ2A:
ret

SCREENIT:       ;route for screen plotting
mov [si+14][w],0;displacement counter for screen dot byte
inc [si+30][w]  ;increment pixel counter
add [si+58][w],2;inc simulate counter twice
mov di,[si+8]   ;get screen column address
add di,20480    ;set to start at bottom of screen (+256 lines)
mov cl,[si+2]   ;get bit value of screen byte
mov ch,255      ;invert CL into CH
sub ch,cl

CLRPREVIOUS:
mov al,0        ;set counter to zero
cmp [si+60][b],0;is grid on or off?
je NOGRID       ;off

WITHGRID:
push di
push ds
mov ds,0a000    ;set screen segment
WITHGRIDA:
mov ah,[di][b]  ;get prev screen val
and ah,ch       ;knock out current bit, retaining rest
or ah,[di+32768];OR in grid pattern
mov [di],ah
sub di,80       ;dec screen line
inc al          ;inc counter
jnz WITHGRIDA   ;loop if not zero
pop ds
pop di
ret

NOGRID:
push di
push ds
mov ds,0a000    ;set screen segment
NOGRIDA:
and [di][b],ch  ;knock out current screen bit, retaining rest
sub di,80       ;dec screen line
inc al          ;inc counter
jnz NOGRIDA     ;loop if not zero
pop ds
pop di
ret

GETCHAN1:
mov bx,[si+4]   ;value of Chan 1 sample to be plotted, only BL is used
cmp [si+32],256 ;is shift a negative number?
ja GC12         ;yes

add bx,[si+32]  ;no, add shift value
cmp bx,256      ;is it above max val?
jb GC1         ;no
mov bx,255      ;yes, so limit to 255
jmp GC1

GC12:
add bx,[si+32]  ;yes, add shift value
cmp bx,256      ;is it still a negative value?
jb GC1          ;no
mov bx,0        ;yes, limit to 0

GC1:
mov [si+4],bx   ;store shifted value of sample
cmp bl,[si+6]   ;is sample > prev sample?
ja SWAP1
mov bh,[si+6]   ;prev into BH, BL holds current
jmp UPDATE1

SWAP1:          ;prev is lower than current so swap positions
mov bh,bl       ;current into BH
mov bl,[si+6]   ;prev into BL

UPDATE1:
push ds
mov ds,0a000
call POKEIT
pop ds
ret

ADDTRIG1:
push cx
mov cl,80
mov dx,0
mov ax,[si+62]    ;get trig/shift val chan 1
mul cl

mov bx,ax
add bx,[si+8]

mov dx,0
mov ax,255
sub ax,[si+64]    ;get inverse shift1 val
mul cl
add ax,[si+8]
push ds
mov ds,0a000
mov [bx][b],170
mov bx,ax
mov [bx][b],255
pop ds
pop cx
mov bx,[si+4]   ;move shifted current Chan 1 sample to prev sample store
mov [si+6],bx
ret

GETCHAN2:
mov bx,[si+104] ;value of Chan 2 sample to be plotted, only BL is used
cmp [si+132],256;is shift a negative number?
ja GC22         ;yes

add bx,[si+132] ;no, add shift value
cmp bx,256      ;is it above max val?
jb GC2         ;no
mov bx,255      ;yes, so limit to 255
jmp GC2

GC22:
add bx,[si+132] ;yes, add shift value
cmp bx,256      ;is it still a negative value?
jb GC2          ;no
mov bx,0        ;yes, limit to 0

GC2:
mov [si+104],bx ;store shifted value of sample
cmp bl,[si+106] ;is sample > prev sample?
ja SWAP2        ;yes
mov bh,[si+106] ;no, prev into BH, BL holds current
jmp UPDATE2

SWAP2:          ;prev is lower then current so swap positions
mov bh,bl       ;current into BH
mov bl,[si+106] ;prev into BL

UPDATE2:
push ds
mov ds,0a000
call POKEIT
pop ds
ret

ADDTRIG2:
push cx
mov dx,0
mov cl,80
mov ax,[si+162]    ;get trig/shift val chan 2
mul cl
mov bx,[si+8]
add bx,ax
mov dx,0
mov ax,255
sub ax,[si+164]    ;get inverse shift2 val
mul cl
add ax,[si+8]
push ds
mov ds,0a000
mov [bx][b],170
mov bx,ax
mov [bx][b],255
pop ds
pop cx
mov bx,[si+104] ;move shifted current Chan 2 sample to prev sample store
mov [si+106],bx
ret

;.........

POKEIT:
push di
push cx
mov cl,80
mov dx,0
mov ah,0
mov al,bl       ;multiply value by 80
mul cl
pop cx
sub di,ax       ;subtract from screen address
sub bh,bl       ;subtract low from high value
add bh,1

POKE1:
or [di],cl      ;update bytes between bl and bh
sub di,80
dec bh
jnz POKE1
pop di
ret

;..............

FREQ1:
mov ax,[si+86]       ;get varseg store%(0)
push ds
mov ds,ax
mov bl,[di][b]
pop ds
mov bh,0

GETMINMAX1:
cmp bx,[si+36]      ;is bx> max?
jb MINCHECK1
mov [si+36],bx
jmp GETSIGNDATA1
MINCHECK1:
cmp bx,[si+34]      ;is bx<=min
ja GETSIGNDATA1
mov [si+34],bx

GETSIGNDATA1:       ;get sign of signal level above/below trigger
mov ax,[si+48]      ;get trig value
add ax,10           ;set window above trig
cmp bx,ax
ja ABOVETRIG1       ;it's above
sub ax,20           ;set window below trig
cmp bx,ax
ja ENDFREQ1         ;it's not low enough
mov [si+38][w],1    ;it's below, set flag to 1
jmp ENDFREQ1        ;don't increment counter

ABOVETRIG1:         ;it's above - set flag to 2
mov [si+38][w],2

FLAGCHANGE1:
mov ax,[si+38]
cmp [si+40],ax      ;is there a flag change?
je ENDFREQ1         ;no, so no action
mov [si+44],cx      ;yes, store sim count val in second counter
cmp [si+46][w],1    ;is flag change counter > 1?
ja ENDFLAG1         ;yes
mov [si+42],cx      ;no, so store sim count also into first counter
ENDFLAG1:
inc [si+46][w]      ;increment flag change counter
ENDFREQ1:
mov [si+40],ax      ;store sign flag
add di,2
dec cx
jnz FREQ1
ret

FREQ2:
mov ax,[si+86]
push ds
mov ds,ax
mov bl,[1+di][b]  ;get value
pop ds
mov bh,0
GETMINMAX2:
cmp bx,[si+136]   ;is bx> max?
jb MINCHECK2
mov [si+136],bx
jmp GETSIGNDATA2
MINCHECK2:
cmp bx,[si+134]   ;is bx<=min
ja GETSIGNDATA2
mov [si+134],bx

GETSIGNDATA2:     ;get sign of signal level above/below trigger
mov ax,[si+148]
add ax,10
cmp bx,ax
ja ABOVETRIG2     ;it's above
sub ax,20
cmp bx,ax
ja ENDFREQ2
mov [si+138][w],1 ;it's below, set flag to 1
jmp ENDFREQ2      ;don't increment counter

ABOVETRIG2:       ;it's above - set flag to 2
mov [si+138][w],2

FLAGCHANGE2:
mov ax,[si+138]
cmp [si+140],ax   ;is there a flag change?
je ENDFREQ2       ;no, so no action
mov [si+144],cx   ;yes, store count in second counter
cmp [si+146][w],1 ;is flag change counter > 1?
ja ENDFLAG2       ;yes
mov [si+142],cx   ;no, so store count also into first pixel counter
ENDFLAG2:
inc [si+146][w]   ;increment flag change counter

ENDFREQ2:
mov [si+140],ax   ;store sign flag
add di,2
dec cx
jnz FREQ2
ret

;.....

SCREENLOOP:     ;replaced sequence ......
mov ah,[di][b]  ;get prev screen val
and ah,ch       ;knock out current bit, retaining rest
cmp [si+11][b],0;is grid on or off?
je DOCHAN1      ;off
or ah,[di+32768];on, so OR in grid pattern

DOCHAN1:
cmp [si+9][b],1 ;is chan 1 on?
jne DOCHAN2     ;no
cmp al,bl       ;yes, is counter < BL?
jb DOCHAN2      ;it's less
cmp al,bh       ;is counter > BH?
ja DOCHAN2      ;it's greater
or ah,cl        ;OR AH with CL

DOCHAN2:
cmp [si+10][b],1
jne SHOWVAL
cmp al,dl       ;is counter < DL?
jb SHOWVAL      ;it's less
cmp al,dh       ;is counter > DH?
ja SHOWVAL      ;it's greater
or ah,cl        ;OR AH with CL

SHOWVAL:
mov [di],ah     ;output val to screen byte
sub di,80       ;dec screen line ...inc
inc al          ;inc counter
jnz SCREENLOOP  ;loop if not zero

;...............

GETIT1:
cmp [si+56][b],1  ;is simulate on?
jne GETEXT1       ;no so call in ext source
call SIM1         ;yes, get sim value
ret

MOUSEON:
ret

GETEXT1:
cmp [si+52][w],1   ;is chan1 on?
jne GETEXT2        ;no
mov dx,[si+88]     ;yes, set printer port output address
mov al,0          ;tell PIC lsb chan 1 needed
out dx,al

WAITLSB1:
call MOUSEGET      ;check for mouse press
cmp [si+28][w],0   ;is mouse pressed?
ja MOUSEON         ;yes

mov dx,[si+90]     ;set printer port input address
in al,dx           ;wait for handshake
and al,128
jnz WAITLSB1

in al,dx           ;get lsb chan 1
ror al,1 
ror al,1 
ror al,1 
and al,15
mov [si+4],al 

GETEX1:
mov dx,[si+88]     ;tell PIC msb chan 1 needed
mov al,1           
out dx,al 

WAITMSB1:
call MOUSEGET      ;check for mouse press
cmp [si+28][w],0   ;is mouse pressed?
ja MOUSEON         ;yes

mov dx,[si+90]     ;set printer port input address
in al,dx          ;wait for handshake
and al,128
jz WAITMSB1

in al,dx           ;get msb chan 1
rol al,1
and al,240
or [si+4],al

GETEXT2:
cmp [si+152][w],1  ;is chan2 on?
jne STORESCOPE     ;no

mov dx,[si+88]     ;tell PIC lsb chan 2 needed
mov al,2
out dx,al

WAITLSB2:
call MOUSEGET      ;check for mouse press
cmp [si+28][w],0   ;is mouse pressed?
ja MOUSEON2        ;yes

mov dx,[si+90]     ;set printer port input address
in al,dx           ;wait for handshake
and al,128
jnz WAITLSB2

in al,dx           ;get lsb chan 2
ror al,1 
ror al,1 
ror al,1 
and al,15
mov [si+104],al 

mov dx,[si+88]     ;tell PIC msb chan 2 needed
mov al,3
out dx,al

WAITMSB2:
call MOUSEGET      ;check for mouse press
cmp [si+28][w],0   ;is mouse pressed?
ja MOUSEON2        ;yes

mov dx,[si+90]     ;wait for handshake
in al,dx 
and al,128
jz WAITMSB2

in al,dx           ;get msb chan 2
rol al,1 
and al,240
or [si+104],al 
jmp STORESCOPE

MOUSEON2:
ret

;.........

STORESCOPE:
mov dx,[si+88]      ;tell PIC to step address
mov al,4 
out dx,al 

;mov al,[si+4]       ;get chan1 val
;mov ah,[si+104]     ;get chan2 val

mov al,255          ;invert chan 1 val
sub al,[si+4]
mov [si+4],al

mov ah,255          ;invert chan 2 val
sub ah,[si+104]
mov [si+104],ah

;mov al,[si+4]       ;get chan1 val
;mov ah,[si+104]     ;get chan2 val

mov bx,[si+58]      ;get store count
mov dx,[si+86]      ;get store%(0) varseg
push ds
mov ds,dx
mov [bx],ax         ;store both scope vals
pop ds
ret

;..........

SIM1:
mov bx,[si+58]
mov ax,[si+86]
push ds
mov ds,ax
mov al,[bx][b]
pop ds
mov ah,0
mov dh,[si+66]
call SIMMOD
mov ah,0
mov [si+4],ax

SIM2:
mov bx,[si+58]
mov ax,[si+86]
push ds
mov ds,ax
mov al,[1+bx][b]
pop ds
mov ah,0
mov dh,[si+166]
call SIMMOD
mov ah,0
mov [si+104],ax
ret

SIMMOD:          ;change simulation amplitude as appropriate
cmp dh,5         ;is chan gain = 5?
je SIM1A         ;yes, so no action
ja SIMMUL        ;above, so multiply AL
jb SIMNEG        ;below, so divide AL

SIMMUL:
cmp al,128
je SIM1A
ja SIM1B
jb SIM1C

SIM1B:           ;>128
sub al,128
SIM12B:
shl ax,1
dec dh
cmp dh,5
ja SIM12B
cmp ax,128
jb SIM13B
mov ax,127
SIM13B:
add al,128
jmp SIM1A

SIM1C:
mov dl,128
sub dl,al
mov al,dl
SIM12C:
shl ax,1
dec dh
cmp dh,5
ja SIM12C
cmp ax,128
jbe SIM13C
mov ax,128
SIM13C:
mov dl,128
sub dl,al
mov al,dl
jmp SIM1A

SIMNEG:
cmp al,128
je SIM1A
ja SIM2B
jb SIM2C

SIM2B:
sub al,128
SIM22B:
shr al,1
inc dh
cmp dh,5
jb SIM22B
add al,128
jmp SIM1A

SIM2C:
mov dl,128
sub dl,al
mov al,dl
SIM22C:
shr al,1
inc dh
cmp dh,5
jb SIM22C
mov dl,128
sub dl,al
mov al,dl

SIM1A:
ret

LISSAJOUS:
call SYNC
cmp [si+24],440   ;check if enough bytes left for screen display
ja CLEARLISSA     ;yes, enough
mov [si+58][w],0  ;no
ret

CLEARLISSA:
push ds
mov ds, 0a000
mov al,0
mov si,1361
CLRLISS1:
mov bx,53
CLRLISS2:
mov [si+bx][w],0
dec bx
jnz CLRLISS2
add si,80
dec al
jnz CLRLISS1
pop ds
mov si,0

STARTLISSA:
mov [si][w],440 ;reset main counter
mov bx,[si+4]   ;value of Chan 1 (Y) sample to be plotted, only BL is used
mov dx,[si+104] ;value of Chan 2 (X) sample to be plotted, only DL is used
mov di,70       ;set mem for location 0 at mb%(35)
mov [di+4],bx  ;c=y
mov [di+6],dx  ;d=x

LISSLOOP:
mov [di][w],0;y2=0
mov [di+2][w],0;x2=0
mov [di+12][w],0;sw=0
call GETIT1     ;get new X, Y
call LY0

LISS3:
add [si+58][w],2  ;inc simulate counter
dec [si][w]       ;decrement loop counter
jnz LISSLOOP
sub [si+24][w],440
jnc ENDLISS
mov [si+58][w],0
ENDLISS:
ret               ;end of LISSAJOUS, return to mode routing

LY0:
mov bx,[si+4]   ;value of Chan 1 (Y) sample to be plotted, only BL is used
cmp bx,[di+4]  ;compare y and C
ja LY1          ;y>C
jb LY2          ;y<C
jmp LX0         ;y=C

LY1:
sub bx,[di+4]  ;y2=y-C
mov [di],bx  ;store y2
jmp LX0

LY2:
mov ax,[di+4]  ;get C
sub ax,bx       ;y2=C-y
mov [di],ax  ;store y2
inc [di+12][b]  ;cw=1

LX0:
mov bx,[si+104] ;value of Chan 2 (X) sample to be plotted, only DL is used
cmp bx,[di+6]  ;compare x and D
ja LX1          ;x>D
jb LX2          ;x<D
jmp LX10        ;x=D

LX1:
sub bx,[di+6]  ;x2=x-D
mov [di+2],bx  ;store x2
jmp LX10

LX2:
mov ax,[di+6]  ;get D
sub ax,bx       ;x2=D-x
mov [di+2],ax  ;store x2
inc [di+12][b]  ;cw=cw+1

LX10:            ;get sign
mov [di+14][b],1 ;sx=1
cmp [di+12][b],1 ;is sw=1?
jne GETVERT      ;no, so sx stays at 1 (sign is positive)
mov [di+14][b],0 ;yes so sx=0 (sign is negative)

GETVERT:         ;set initial value of vert1
mov [di+8][w],0 ;vert1=0
mov bh,0
mov bl,[di+2]   ;get x2
cmp bl,0         ;is x2=0?
je LISSZ         ;yes
mov dx,0         ;set remainder location to 0
mov al,0         ;set low byte of AX to 0
mov ah,[di]   ;no, so move (y2*256) into ax for division
div bx           ;divide ax/bx (y2/x2) (remainder in dx, not used)
mov [di+8],ax   ;vert1=(y2*256)/x2
LISSZ:
call PLOTIT
ret

PLOTIT:
mov cx,[si+104]   ;get X
cmp cx,[di+6]    ;compare x and D
ja RIGHT1         ;x>D
jb LEFT1          ;x<D

mov cx,[si+4]     ;X=D so now get Y
cmp cx,[di+4]    ;compare y and C
jb UP1            ;y<C
jmp DOWN1         ;y>=C

RIGHT1:
mov bl,0
mov bh,[di+4]    ;get C*256
cmp [di+14][b],1  ;compare sx to 1
je RX2            ;sx=1
sub bx,[di+8]    ;sx=0 so subract vert1 (hh=(c*256)-vert1)
JMP RX3
RX2:
add bx,[di+8]    ;add vert 1 (hh=(c*256)+vert1)

RX3:
mov [di+10],bx    ;store hh
mov cx,[si+4]     ;get Y
cmp cx,[di+4]    ;compare y and C
jb UPRT           ;y<C
call DOWNRIGHT    ;y>=C
ret

UPRT:
call UPRIGHT
ret

LEFT1:
mov bl,0
mov bh,[di+4]    ;get C*256
cmp [di+14][b],1  ;compare sx to 1
je RX4            ;sx=1
add bx,[di+8]    ;sx=0 so add vert1 (hh=(c*256)+vert1)
jmp RX5
RX4:
sub bx,[di+8]    ;sub vert1 (hh=(c*256)-vert1)
RX5:
mov [di+10],bx    ;store hh
mov cx,[si+4]     ;get Y
cmp cx,[di+4]    ;compare y and C
jb UPLT           ;y<C
call DOWNLEFT     ;y>=C
ret

UPLT:
call UPLEFT
ret

DOWN1:
call LISSPLOT     ;show it
mov cx,[di+4]    ;get C
cmp cx,[si+4]     ;compare C and Y
jae DOWN2         ;c>=Y
inc [di+4][w]    ;c<Y so c=c+1
jmp DOWN1
DOWN2:
ret

UP1:
call LISSPLOT     ;show it
mov cx,[di+4]    ;get C
cmp cx,[si+4]     ;compare c and Y
jbe UP2           ;c<=Y
dec [di+4][w]    ;c>Y so c=c-1
jmp UP1
UP2:
ret

DOWNRIGHT:
call LISSPLOT     ;showit
mov cl,[di+4]    ;get C
mov bx,[di+10]    ;get hh
cmp cl,bh         ;compare c and (hh/256)
jae DNR2          ;c>=hh
inc [di+4][w]    ;c<hh so c=c+1
jmp DOWNRIGHT
DNR2:
mov cx,[di+8]    ;get vert
add [di+10],cx    ;hh=hh+vert1
inc [di+6][w]    ;d=d+1
mov cx,[di+6]    ;get D
cmp cx,[si+104]   ;compare D and X
jb DOWNRIGHT      ;d<X
ret               ;d>=X

UPRIGHT:
call LISSPLOT     ;show it
mov cl,[di+4]    ;get C
mov bx,[di+10]    ;get hh
cmp cl,bh         ;compare c and (hh/256)
jbe UPR2          ;c<=hh
dec [di+4][w]    ;c>hh so c=c-1
jmp UPRIGHT
UPR2:
mov cx,[di+8]    ;get vert
sub [di+10],cx    ;hh=hh-vert
inc [di+6][w]    ;d=d+1
mov cx,[di+6]    ;get D
cmp cx,[si+104]   ;compare d and X
jb UPRIGHT        ;d<X
ret               ;d>=X

DOWNLEFT:
call LISSPLOT     ;show it
mov cl,[di+4]    ;get C
mov bx,[di+10]    ;get hh
cmp cl,bh         ;compare c and (hh/256)
jae DNL2          ;c>=hh
inc [di+4][w]    ;c<hh so c=c+1
jmp DOWNLEFT
DNL2:
mov cx,[di+8]    ;get vert
add [di+10],cx    ;hh=hh+vert
dec [di+6][w]    ;d=d-1
mov cx,[di+6]    ;get D
cmp cx,[si+104]   ;compare d and X
ja DOWNLEFT       ;d>X
ret               ;d<=X

UPLEFT:
call LISSPLOT     ;show it
mov cl,[di+4]    ;get C
mov bx,[di+10]    ;get hh
cmp cl,bh         ;compare c and (hh/256)
jbe UPL2          ;c<=hh
dec [di+4][w]    ;c>hh so c=c-1
jmp UPLEFT
UPL2:
mov cx,[di+8]    ;get vert
sub [di+10],cx    ;hh=hh-vert
dec [di+6][w]    ;d=d-1
mov cx,[di+6]    ;get D
cmp cx,[si+104]   ;compare d and X
ja UPLEFT         ;d>X
ret               ;d<=X

LISSPLOT:
mov dx,[di+6]    ;get D (horiz position)
mov bl,dl         ;store value
shr bl,1          ;divide by 8 to get column
shr bl,1
shr bl,1          ;bl holds column
and dl,7          ;get pixel within column byte

mov ch,128        ;convert difference to bit number
PIXDIFF:
cmp dl,0          ;is pixel count 0?
je ENDDIFF        ;yes
dec dl            ;no; dec pixel count
shr ch,1          ;shift left bit number
jmp PIXDIFF       ;repeat

ENDDIFF:
mov bh,80         ;
mov ax,[di+4]    ;get C (line number)
mul bh            ;multiply ax * 80 to get screen byte (c*80)
mov bh,0
add bx,ax         ;add column (bl already holds column number)
add bx,1372       ;add down displacement (1360) + right (12)

push ds
mov ds,0a000      ;set screen segment
push si
mov si,0
or [si+bx][b],ch  ;OR bit value with screen display byte
pop si
pop ds
ret

DIGITAL:
mov [si][w],440    ;reset main counter
mov [si+2][w],128  ;bit val of screen byte location
mov [si+8][w],1681 ;screen byte counter (21 down 1 across)

call SYNC
cmp [si+24],440   ;check if enough bytes left for screen display
ja MAINDIG        ;yes, enough
mov [si+58][w],0  ;no
ret

MAINDIG:
mov cl,[si+2]      ;get bit value of screen byte
mov ch,255         ;invert CL into CH
sub ch,cl
call DIGLOOP
shr [si+2][w],1   ;shift right screen bit
cmp [si+2][w],0
jne ENDSCRDIG
mov [si+2][w],128 ;when bit = 0 reset to 128
inc [si+8][w]     ;and inc screen byte counter
ENDSCRDIG:
add [si+58][w],2
dec [si][w]
jnz MAINDIG
sub [si+24][w],440
jnc ENDDIG
mov [si+58][w],0
ENDDIG:
ret
nop             ;this is a pad to avoid QB EOF failure!

DIGLOOP:        ;routine that plots for 1 vertical line
push cx         ;10NOV99
call GETIT1
pop cx          ;10NOV99
mov di,[si+8]   ;set screen vert counter
mov bx,[si+4]   ;value of Chan 1 (Y) sample to be plotted, only BL is used
cmp [si+52][w],1;is chan1 on?
je DG2          ;yes
mov bx,0        ;no
DG2:
mov dx,[si+104] ;value of Chan 2 (X) sample to be plotted, only DL is used
cmp [si+152][w],1; is chan2 on?
je DG3          ;yes
mov dx,0        ;no
DG3:
push si         ;store SI
mov si,32768    ;set logic bit store address to 32768 above DS
push dx
mov dl,128      ;set bit value of sample
call SHOWDIG
pop bx          ;recall chan 2 (X)
add di,1200     ;set screen origin
mov dl,128
call SHOWDIG
pop si          ;recall prev SI
cmp [si+60][b],0;is grid on or off?
ja DIGGRID      ;on
ret             ;off
nop

DIGGRID:
mov al,0        ;set counter to zero
push di
push ds
mov ds,0a000    ;set screen segment
WITHDIGGRIDA:
mov ah,[di][b]  ;get prev screen val
;and ah,ch      ;knock out current bit, retaining rest
or ah,[di+32768];OR in grid pattern
mov [di],ah
sub di,80       ;dec screen line ...inc
inc al          ;inc counter
jnz WITHDIGGRIDA;loop if not zero
pop ds
pop di
ret

SHOWDIG:
push ds
mov ds,0a000    ;set screen segment

GETBIT:
and [di][b],ch  ;knockout prev bit at logic 0 line
mov bh,bl       ;mov sample to bh
and bh,dl       ;AND with shifting reg
cmp bh,0        ;is answer >0 (is bit set)?
je LOGIC1       ;yes, bit = 1  ......... ja
                ;there was a logic error here which has been corrected
                ;(ja to je) but names and decriptions are as previously!

LOGIC0:         ;no = bit = 0
or [di][b],cl   ;OR logic 0 line with CL
and [di+400][b],ch ;knockout prev bit at logic 1 line
mov dh,0        ;set logic flag
jmp ENDBIT

LOGIC1:
or [di+400][b],cl;OR logic 1 line with CL
mov dh,1        ;set logic flag

ENDBIT:
cmp dh,[si][b]   ;is bit equal to previous bit?
je EQUALLOGIC    ;yes

DIFFLOGIC:       ;no, set vertical logic change line
or [di][b],cl
or [di+80][b],cl
or [di+160][b],cl
or [di+240][b],cl
or [di+320][b],cl
or [di+400][b],cl
jmp NEXTBIT

EQUALLOGIC:         ;delete any existing logic change line
and [di+80][b],ch
and [di+160][b],ch
and [di+240][b],ch
and [di+320][b],ch

NEXTBIT:
mov [si][b],dh     ;store new bit value
add si,1
add di,1200     ;raise screen by 15 lines
shr dl,1
jnz GETBIT
pop ds
ret

;.............

PRINTERPLOT:    ;compiles screen data into printer format
;for each screen column, horiz bit is set, then moving
;downwards, the screen byte for each of 8 lines within the column
;is sampled and ANDed with horiz bit. If horiz bit is not zero,
;a store is ORed with the vertical bit. After each sampling for that
;column, the vertical bit is shifted right by one place (i.e. through
;128, 64, 32, 16, 8, 4, 2, 1. After each 8 lines, the store value is
;poked into the printer string byte. The byte address is incremented,
;the horiz byte is shifted right by one place (i.e. through 128 to 1 as
;with vertical bit). The same lines of the same column are again sampled
;but now ANDing with the new position of the horiz byte. This continues
;until all eight bits of that the column have been dealt with, each time
;the stored value is poked into a new printer string byte. After required
;number of columns have been processed, the printer string is output to
;the printer from BASIC.

mov ax,[si+12]  ;get segment for P$
mov bx,[si+8]   ;starting column count/address
;add bx,1361     ;add down displacement
mov di,[si+14]  ;get destination address of first p$ byte
push ds
mov ds,0a000    ;set screen segment
mov [si],ax ;store p$ segment ... 32768

mov al,80       ;set line len = 80 bytes
PE:
mov ch,128      ;horiz pixel bit (for screen read)
PD:
push bx         ;store current column count address
mov dl,0        ;set running store to zero
mov cl,128      ;set p$ bit reg (vertical bit)

PF:
mov ah,[si+bx]  ;get screen byte
and ah,ch       ;get current bit value
cmp ah,0
je PG           ;POR
or dl,cl        ;OR running store with cl
PG:
add bx,80       ;inc down line count
shr cl,1        ;shift right p$ bit reg
jnz PF          ;if not zero then goto PF

pop bx          ;recall prev column count address
push ds
mov ds,[si] ;set p$ segment
mov [di],dl     ;mov running store into p$
pop ds
inc di          ;inc destination address
shr ch,1        ;PB=PB/2
jnz PD          ;if not zero, repeat (next D)
inc bx          ;inc column count
dec al          ;dec line length counter
jnz PE          ;if not zero, repeat process
pop ds
ret

;...............

SYNC:
cmp [si+20][b],2
jb SYNCUP1      ;sync=1
ja SYNCDOWN1    ;sync=3
call GETIT1
ret             ;sync=2

SYNCUP1:
cmp [si+22][b],1   ;is chan2 sync required?
jb SYNCUP1A        ;no
call SYNCUP2       ;yes
ret

SYNCUP1A:
call GETPOS1
cmp [si+24][w],0   ;are there enough memory bytes left?
je ENDSYNCUP1      ;no
call GETNEG1       ;yes
cmp [si+24][w],0   ;are there enough memory bytes left?
je ENDSYNCUP1      ;no
call GETTRIGPOS1   ;yes
ENDSYNCUP1:
mov ax,255
sub ax,[si+62]
ret

SYNCDOWN1:
cmp [si+22][b],1     ;is chan2 required?
jb SYNCDOWN1A        ;no
call SYNCDOWN2       ;yes
ret

SYNCDOWN1A:
call GETNEG1
cmp [si+24][w],0     ;are there enough memory bytes left?
je ENDSYNCDOWN1      ;no
call GETPOS1         ;yes
cmp [si+24][w],0     ;are there enough memory bytes left?
je ENDSYNCDOWN1      ;no
call GETTRIGNEG1     ;yes
ENDSYNCDOWN1:
ret

GETPOS1:
call GETIT1
call DELAY
mov cx,[si+48]     ;trig val
add cx,10
cmp [si+4],cx
ja ENDPOS1
add [si+58][w],2
dec [si+24][w]
jnz GETPOS1
sub [si+58][w],2
ENDPOS1:
ret

GETNEG1:
call GETIT1
call DELAY
mov cx,[si+48]     ;trig val
sub cx,10
cmp [si+4],cx
jb ENDNEG1
add [si+58][w],2
dec [si+24][w]
jnz GETNEG1
sub [si+58][w],2
ENDNEG1:
ret

GETTRIGPOS1:
call GETIT1
call DELAY
mov cx,[si+48]     ;trig val
cmp [si+4],cx
jae ENDTRIGPOS1
add [si+58][w],2
dec [si+24][w]
jnz GETTRIGPOS1
sub [si+58][w],2
mov cl,0
ENDTRIGPOS1:
ret

GETTRIGNEG1:
call GETIT1
call DELAY
mov cx,[si+48]     ;trig val
cmp [si+4],cx
jbe ENDTRIGNEG1
add [si+58][w],2
dec [si+24][w]
jnz GETTRIGNEG1
sub [si+58][w],2
ENDTRIGNEG1:
ret
nop

SYNCUP2:
call GETPOS2
cmp [si+24][w],0
je ENDSYNCUP2
call GETNEG2
cmp [si+24][w],0
je ENDSYNCUP2
call GETTRIGPOS2
ENDSYNCUP2:
ret

SYNCDOWN2:
call GETNEG2
cmp [si+24][w],0
je ENDSYNCDOWN2
call GETPOS2
cmp [si+24][w],0
je ENDSYNCDOWN2
call GETTRIGNEG2
ENDSYNCDOWN2:
ret

GETPOS2:
call GETIT1
call DELAY
mov cx,[si+148]     ;trig val
add cx,10
cmp [si+104],cx
ja ENDPOS2
add [si+58][w],2
dec [si+24][w]
jnz GETPOS2
sub [si+58][w],2
ENDPOS2:
ret

GETNEG2:
call GETIT1
call DELAY
mov cx,[si+148]     ;trig val
sub cx,10
cmp [si+104],cx
jb ENDNEG2
add [si+58][w],2
dec [si+24][w]
jnz GETNEG2
sub [si+58][w],2
ENDNEG2:
ret

GETTRIGPOS2:
call GETIT1
call DELAY
mov cx,[si+148]     ;trig val
cmp [si+104],cx
jae ENDTRIGPOS2
add [si+58][w],2
dec [si+24][w]
jnz GETTRIGPOS2
sub [si+58][w],2
ENDTRIGPOS2:
ret

GETTRIGNEG2:
call GETIT1
call DELAY
mov cx,[si+148]     ;trig val
cmp [si+104],cx
jbe ENDTRIGNEG2
add [si+58][w],2
dec [si+24][w]
jnz GETTRIGNEG2
sub [si+58][w],2
ENDTRIGNEG2:
ret

MOUSEGET:
push dx
push cx
mov bx,0
mov ax,1           ;ensure mouse is on
int 33H
mov ax,03        ;get button status and mouse position
int 33H
mov [si+28],bx   ;button status into mb%(14)
                 ;bit 0 = left button, bit 1 = right button
                 ;bit value of 1 = button held down (0 = button up)
pop cx
pop dx
ret

STARTVALUE1:
mov bx,[si+4]   ;value of Chan 1 sample to be plotted, only BL is used
cmp [si+32],256 ;is shift a negative number?
ja GS12         ;yes

add bx,[si+32]  ;no, add shift value
cmp bx,256      ;is it above max val?
jb GS1         ;no
mov bx,255      ;yes, so limit to 255
jmp GS1

GS12:
add bx,[si+32]  ;yes, add shift value
cmp bx,256      ;is it still a negative value?
jb GS1          ;no
mov bx,0        ;yes, limit to 0

GS1:
mov [si+6],bx
;ret

STARTVALUE2:
mov bx,[si+104] ;value of Chan 2 sample to be plotted, only BL is used
cmp [si+132],256;is shift a negative number?
ja GS22         ;yes

add bx,[si+132] ;no, add shift value
cmp bx,256      ;is it above max val?
jb GS2         ;no
mov bx,255      ;yes, so limit to 255
jmp GS2

GS22:
add bx,[si+132] ;yes, add shift value
cmp bx,256      ;is it still a negative value?
jb GS2          ;no
mov bx,0        ;yes, limit to 0

GS2:
mov [si+106],bx ;store shifted value of sample
ret

DELAY:           ;delay used during sync to allow PIC to respond to
mov ax,[si+92]   ;address step
mov [si+94][w],ax
LOOPJ:
;call MOUSEGET      ;check for mouse press
;cmp [si+28][w],0   ;is mouse pressed?
;ja MOUSEON3        ;yes
dec [si+94][w]
jnz LOOPJ
MOUSEON3:
ret
