/* Chebyshev approximations to Lyle's tables.
 * The tables themselves are given in the comments.
 */

/* rms error 3.4e-8, error[16]=2.7e-7 */
static double lm1[10] = {
-0.0000034729,
 0.0000133884,
 0.0000187733,
-0.0003578840,
 0.0009671247,
 0.0039176720,
-0.0355359033,
 0.0524413612,
 0.5553864593,
 1.5064855057
};

/* Published table for m1, 0 <= b/c <= 1, increment 0.05
 * except second item in table is for b/c = 0.025.
 * The other tables below are for the same domain.
 */
/*
1.041667,
1.042978,
1.046862,
1.062294,
1.087510,
1.121795,
1.164216,
1.213685,
1.269024,
1.329023,
1.392498,
1.458333,
1.525512,
1.593137,
1.660442,
1.726790,
1.791667,
1.854675,
1.915518,
1.973987,
2.029950,
2.083333
*/

/* rms error 4.8e-6, error[5]=5.0e-5 */
static double lm2[10] = {
-0.0001169260,
 0.0001500950,
 0.0011789118,
-0.0056765335,
-0.0013112684,
 0.0738861156,
-0.1056741543,
-0.6266412368,
-0.5858267544,
 2.2537343007
};
/*
2.3872,
2.3913,
2.4035,
2.4508,
2.5237,
2.6140,
2.7115,
2.8057,
2.8859,
2.9430,
2.9694,
2.9601,
2.9119,
2.8239,
2.6971,
2.5337,
2.3372,
2.1114,
1.8608,
1.5898,
1.3028,
1.0037,
*/

/* rms error 3.8e-4, error[12]=-4.7e-3 */
static double lm3[10] = {
 -0.0042606155,
 -0.0010468853,
  0.0446113661,
 -0.0731942602,
 -0.2972370222,
  1.0307506768,
  1.1953246487,
 -4.7029195421,
-10.3484992669,
  9.3066657497
};
/*
14.97,
15.01,
15.13,
15.59,
16.25,
16.96,
17.56,
17.91,
17.89,
17.42,
16.49,
15.11,
13.36,
11.33,
9.11,
6.83,
4.58,
2.44,
0.48,
-1.24,
-2.69,
-3.85
*/

/* rms err 2.0e-8, error[4]=2.1e-7 */
static double ll0[14] = {
 0.0000005312,
-0.0000009967,
 0.0000024127,
-0.0000043949,
 0.0000086993,
-0.0000174566,
 0.0000341420,
-0.0000458429,
 0.0000391753,
-0.0008766349,
 0.0103861660,
-0.0608657354,
 0.1636987232,
 0.7359809131
};

/*
0.5,
0.5252663,
0.5489951,
0.5924342,
0.6310248,
0.6652018,
0.6953236,
0.7217163,
0.7446891,
0.7645392,
0.7815523,
0.7960019,
0.8081473,
0.8182324,
0.8264842,
0.8331124,
0.8383088,
0.8422476,
0.8450864,
0.8469663,
0.8480134,
0.8483397
*/

/* rms error 3.3e08, error[12]=2.9e-7 */
static double ll1[12] = {
-0.0000006228,
 0.0000017514,
 0.0000034603,
-0.0000388956,
 0.0000651590,
 0.0005838149,
-0.0037738396,
 0.0050897845,
 0.0357531842,
-0.1230922762,
-0.6230238402,
 3.2591183517
};
/*
3.732639,
3.732506,
3.731810,
3.727159,
3.716052,
3.696644,
3.667845,
3.629250,
3.581036,
3.523847,
3.458662,
3.386676,
3.309190,
3.227522,
3.142942,
3.056619,
2.969599,
2.882783,
2.796929,
2.712655,
2.630449,
2.550686
*/


/* rms error 5.8e-6, error[18]=5.4e-5 */
static double ll2[10] = {
 0.0002006024,
-0.0007747556,
-0.0005694527,
 0.0135103091,
-0.0334095624,
-0.0667246939,
 0.4391517110,
 0.1414009803,
-3.1632194405,
 1.3214159925
};
/*
4.1667,
4.1614,
4.1434,
4.0584,
3.8971,
3.6550,
3.3359,
2.9510,
2.5161,
2.0499,
1.5715,
1.0990,
0.6479,
0.2308,
-0.1431,
-0.4677,
-0.7400,
-0.9592,
-1.1265,
-1.2448,
-1.3175,
-1.3490
*/

/* rms error 5.4e-4, error[10]=5.2e-3 */
static double ll3[10] = {
 0.0095823670,
-0.0126747061,
-0.0646408894,
 0.2999226114,
-0.0681630799,
-2.0782285220,
 2.4921454033,
 8.0862929808,
-9.0838699736,
 4.0410431616
};
/*
17.05,
17.00,
16.81,
15.88,
14.13,
11.60,
8.45,
4.98,
1.49,
-1.73,
-4.42,
-6.44,
-7.68,
-8.16,
-7.93,
-7.09,
-5.77,
-4.09,
-2.21,
-0.23,
1.74,
3.62
*/

/* rms error 4.2e-8, error[11]=-5.4e-7 */
static double lm1a[10] = {
 0.0000033780,
-0.0000134754,
-0.0000187875,
 0.0003579377,
-0.0009673040,
-0.0039179989,
 0.0355358520,
-0.0524412952,
-0.5553866352,
 2.6601812765
};
/* Published table for m1, 0 <= c/b <= 1, increment 0.05
 * except second item in table is for c/b = 0.025.
 */
/*
3.125,
3.123699,
3.119805,
3.104373,
3.079157,
3.044872,
3.002451,
2.952982,
2.897643,
2.837644,
2.774168,
2.708333,
2.641155,
2.573529,
2.506224,
2.439877,
2.375,
2.311992,
2.251149,
2.192680,
2.136717,
2.083333
*/

/* rms error 5.5e-6, error[13]=-6.6e-5 */
static double lm2a[10] = {
-0.0001538028,
 0.0003005328,
 0.0014141190,
-0.0098646583,
 0.0099736709,
 0.1195762265,
-0.5202566888,
-0.0148097666,
 5.8936719056,
-4.4761545717
};
/*
-9.7656,
-9.7463,
-9.6886,
-9.4613,
-9.0942,
-8.6040,
-8.0115,
-7.3402,
-6.6144,
-5.8573,
-5.0903,
-4.3316,
-3.5961,
-2.8951,
-2.2366,
-1.6260,
-1.0656,
-0.5563,
-0.0970,
 0.3141,
 0.6800,
 1.0037
*/
/* rms error 9.3e-4, error[1]=-7.0e-3*/
static double lm3a[8] = {
 -0.0747921450,
  0.2366356004,
  0.2073998920,
 -3.0719280632,
  5.4073000573,
 11.4653879484,
-45.6116695255,
 27.5899097906
};
/*
76.29,
76.01
75.14,
71.79,
66.50,
59.67,
51.78,
43.36,
34.88,
26.77,
19.34,
12.82,
7.32,
2.89,
-0.51,
-2.94,
-4.52,
-5.37,
-5.61,
-5.37,
-4.75,
-3.85
*/
/* rms error 2.0e-8, error[4]=2.1e-7 */
static double ll0a[14] = {
 0.0000005312,
-0.0000009967,
 0.0000024127,
-0.0000043949,
 0.0000086993,
-0.0000174566,
 0.0000341420,
-0.0000458429,
 0.0000391753,
-0.0008766349,
 0.0103861660,
-0.0608657354,
 0.1636987232,
 0.7359809131
};
/*
0.5,
0.5252663
0.5489951,
0.5924342,
0.6310248,
0.6652018,
0.6953236,
0.7217163,
0.7446891,
0.7645392,
0.7815523,
0.7960019,
0.8081473,
0.8182324,
0.8264842,
0.8331124,
0.8383088,
0.8422476,
0.8450864,
0.8469663,
0.8480134,
0.8483397
*/
/* rms error 4.2e-8, error[13]=-3.9e-7 */
static double ll1a[10] = {
-0.0000082220,
 0.0000262887,
 0.0000667570,
-0.0007981488,
 0.0016823136,
 0.0093955024,
-0.0669376719,
 0.0672334814,
 0.9499148137,
 1.5901108600
};
/*
0.781250,
0.783689,
0.790984,
0.819830,
0.866769,
0.930230,
1.008207,
1.098406,
1.198386,
1.305696,
1.417987,
1.533097,
1.649113,
1.764399,
1.877606,
1.987664,
2.093763,
2.195318,
2.291944,
2.383421,
2.469663,
2.550686
*/
/* rms error 5.8e-6, error[3]=5.7e-5 */
static double ll2a[10] = {
 0.0002543603,
-0.0003568791,
-0.0027957820,
 0.0145977757,
-0.0039745506,
-0.1824652010,
 0.5252161031,
 0.6204189765,
-4.4483986846,
 2.1285089025
};
/*
6.5104,
6.4896,
6.4274,
6.1838,
5.7944,
5.2827,
4.6774,
4.0102,
3.3128,
2.6145,
1.9404,
1.3107,
0.7400,
0.2378,
-0.1912,
-0.5460,
-0.8287,
-1.0437,
-1.1966,
-1.2939,
-1.3425,
-1.3490
*/
/* rms error 4.2e-4, error[4]=4.3e-3 */
static double ll3a[10] = {
 -0.0087938529,
 -0.0016908604,
  0.1275226249,
 -0.3170188018,
 -0.5340837082,
  4.2395340927,
 -4.7459343890,
 -16.3780190744,
  41.6213541023,
 -20.3831149153
};
/*
-69.30,
-68.94
-67.88,
-63.77,
-57.35,
-49.20,
-39.99,
-30.44,
-21.17,
-12.70,
-5.39,
 0.55,
 5.05,
 8.17,
10.03,
10.82,
10.73,
9.97,
8.73,
7.16,
5.42,
3.62
*/
