#include "lcd.h"



//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
void lcd_2wire_put_nibble(unsigned char nib, unsigned char rs)
{
	unsigned char i;


	LCD_DAT0;
	for (i=0; i<7; i++) LCD_SHIFTBIT;	// kiuritjuk a shiftreget, igy az utolso kimenet alacsonyan fogja tartani LCD EN -t, amig ujbol feltoltjuk

	LCD_DAT1;		// EN miatt ez a bit mindig 1
	LCD_SHIFTBIT;	// shiftreg beleptetes

	if (rs) LCD_DAT1 else LCD_DAT0;
	LCD_SHIFTBIT;

	if (nib&8) LCD_DAT1 else LCD_DAT0;
	LCD_SHIFTBIT;

	if (nib&4) LCD_DAT1 else LCD_DAT0;
	LCD_SHIFTBIT;

	if (nib&2) LCD_DAT1 else LCD_DAT0;
	LCD_SHIFTBIT;

	if (nib&1) LCD_DAT1 else LCD_DAT0;
	LCD_SHIFTBIT;

	LCD_DAT0;  // shiftreg 7. bit, nem hasznalt
	LCD_SHIFTBIT;

	LCD_DAT0;  // utolso adat 0. hogy E nulla maradhasson (LCD_DAT lehuzza dodaval a shiftregbe toltott elso bitet)
	LCD_SHIFTBIT;

	LCD_DAT1; // LCD EN most lesz 1
	DelayUs(LCD_DELAY_STROBE);
	LCD_DAT0; // E
}
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
void lcd_initdisplay(void)
{
	DelayMs(20);

	lcd_2wire_put_nibble(3,0);
	DelayMs(5);

	lcd_2wire_put_nibble(3,0);
	DelayUs(200);

	lcd_2wire_put_nibble(3,0);
	DelayUs(200);

	lcd_2wire_put_nibble(2,0);
	DelayUs(40);

	//lcd_put(LCD_COMMAND_SET_FUNCTION+LCD_2_LINE_DISPLAY,0);
	lcd_put(LCD_COMMAND_SET_FUNCTION,0);
	lcd_put(LCD_COMMAND_DISPLAYONOFF+LCD_DISPLAY_ON,0);
	lcd_put(LCD_COMMAND_DISPLAY_CLEAR,0);
	DelayMs(2);
	lcd_put(LCD_COMMAND_ENTRY_MODE_SET+LCD_CURSOR_INCREASE,0);

}
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
void lcd_put(unsigned char Ins,unsigned char RS)
{
	lcd_2wire_put_nibble(  (Ins>>4)& 0x0F,RS);
	DelayUs(LCD_DELAY_PUT4BIT);

	lcd_2wire_put_nibble(Ins,RS);
	DelayUs(LCD_DELAY_PUT4BIT);

	DelayUs(LCD_DELAY_WRI); 
}
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
void lcd_put_str(char Str[])
{
	unsigned char i;

	for (i=0; Str[i]!=0; i++)  lcd_put(Str[i],1);
	return;
}
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
void lcd_put_strc(const char Str[])
{
	unsigned char i;

	for (i=0; Str[i]!=0; i++)  lcd_put(Str[i],1);
	return;
}

