#ifndef LCD_H
#define LCD_H

#define CBITSET(x,mask) (x) = (x) | (mask) 
#define CBITCLR(x,mask) (x) = (x) &~ (mask) 

//--------------------------------------------------------------------------
// LCD SETUP
//--------------------------------------------------------------------------
#define DelayMs __delay_ms
#define DelayUs __delay_us

#define LCD_PORT		PORTB
#define LCD_PORT_LAT	latb
#define LCD_CLK_MASK	64
#define LCD_DAT_MASK	128

/*
#define LCD_LINE0	0
#define LCD_LINE1	64
#define LCD_LINE2	16
#define LCD_LINE3	80
*/
#define LCD_LINE0	0
#define LCD_LINE1	64
#define LCD_LINE2	20
#define LCD_LINE3	84


#define LCD_DELAY_STROBE			1
#define LCD_DELAY_WRI				50
#define LCD_DELAY_PUT4BIT			10


#define LCD_SHIFTBIT	{ CBITSET(LCD_PORT_LAT,LCD_CLK_MASK);LCD_PORT=LCD_PORT_LAT;CBITCLR(LCD_PORT_LAT,LCD_CLK_MASK);LCD_PORT=LCD_PORT_LAT;       }
#define LCD_DAT0	{ CBITCLR(LCD_PORT_LAT,LCD_DAT_MASK);LCD_PORT=LCD_PORT_LAT; }
#define LCD_DAT1	{ CBITSET(LCD_PORT_LAT,LCD_DAT_MASK);LCD_PORT=LCD_PORT_LAT; }
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------



#define	LCD_COMMAND_SET_DD_POS		128

#define	LCD_COMMAND_SET_CG_POS		64

#define	LCD_COMMAND_SET_FUNCTION	32
#define	LCD_8_BITS_INTERFACE		16	// 0: 4
#define	LCD_2_LINE_DISPLAY			8	// 0: 1
#define	LCD_5_X_10_DOTS				4	// 0: 5 X 7 dots

#define	LCD_COMMAND_SHIFT			16
#define	LCD_DISPLAY_SHIFT			8	// 0: Cursor move
#define	LCD_RIGHT_SHIFT				4	// 0: left shift

#define	LCD_COMMAND_DISPLAYONOFF	8
#define	LCD_DISPLAY_ON				4	// 0: off
#define	LCD_CURSOR_ON				2	// 0: cursor off
#define	LCD_BLINKING_ON				1	// 0: blinking off

#define	LCD_COMMAND_ENTRY_MODE_SET	4
#define	LCD_CURSOR_INCREASE			2	// 0: cursor decrease
#define	LCD_DISPLAY IS SHIFTED		1	// 0: not shifted

#define	LCD_COMMAND_RETURN HOME		2

#define	LCD_COMMAND_DISPLAY_CLEAR	1



void lcd_2wire_put_nibble	(unsigned char nib, unsigned char rs);
void lcd_initdisplay		(void);
void lcd_put  				(unsigned char Ins,unsigned char RS);
void lcd_put_str			(char 			Str[]);
void lcd_put_strc			(const char		Str[]);

#define lcd_display_clear() { lcd_put(LCD_COMMAND_DISPLAY_CLEAR,0);DelayMs(2); }
#define	lcd_display_setpos(i) { lcd_put(LCD_COMMAND_SET_DD_POS+i,0); }


#endif