//---------------------------------------------------------------------------

#include <vcl.h>
#include <stdio.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
#define LPTDATA   0x278
#define LPTSTS    0x279

#define SPI_OP_CODE 0x40    //Device Opcode: 0 1 0 0 A2 A1 A0 R/W
#define SPI_OP_READ 0x01
#define SPI_OP_WRITE 0x00

//OUT
#define MOSI      0x01    //Serial data input     LPT Pin2 (DATA0) --- pin13 (SI)
#define _CS       0x02    //Chip Select           LPT Pin3 (DATA1) --- pin11 (_CS)
#define SCK       0x04    //Serial clock input    LPT Pin4 (DATA2) --- pin12 (SCK)
//IN
#define MISO      0x40    //Serial data out             LPT Pin10 (STS6)nAck     --- pin14 (SO)
#define INTA      0x20    //Interrupt output for PORTA. LPT Pin12 (STS5)PaperOut --- pin20 (INTA)
#define INTB      0x10    //Interrupt output for PORTB. LPT Pin13 (STS4)Select   --- pin19 (INTB)

//Adress Pin15..17 A0..2
//_RESET pin18
//PORTA pin21..28 GPA0..7
//PORTB pin1..8 GPB0..7

//Register adress BANK==0
#define IODIRA      0x00  //I/O DIRECTION REGISTER 1-input 0-output def:1
#define IODIRB      0x01
#define IPOLA       0x02  //INPUT POLARITY REGISTER 1-neg. (opposite logic state of the input pin) 0-normal def:0
#define IPOLB       0x03
#define GPINTENA    0x04  //INTERRUPT-ON-CHANGE CONTROL REGISTER 1-enable on-change event. 0-disable def:0
#define GPINTENB    0x05
#define DEFVALA     0x06  //DEFAULT COMPARE REGISTER FOR INTERRUPT-ON-CHANGE  def:0
#define DEFVALB     0x07
#define INTCONA     0x08  //INTERRUPT CONTROL REGISTER 1-compared to DEFVAL
                          //0-Pin value is compared against the previous pin value.  def:0
#define INTCONB     0x09
#define IOCON       0x0A  //I/O EXPANDER CONFIGURATION REGISTER   0x0B is same
//bit 7 BANK: Controls how the registers are addressed DO NOT CHANGE
#define BANK 0x80
//      1 = The registers associated with each port are separated into different banks
//      0 = The registers are in the same bank (addresses are sequential)
//bit 6 MIRROR: INT Pins Mirror bit
#define MIRROR 0x40
//      1 = The INT pins are internally connected
//      0 = The INT pins are not connected. INTA is associated with PortA and INTB is associated with PortB
//bit 5 SEQOP: Sequential Operation mode bit.
#define SEQOP 0x20
//      1 = Sequential operation disabled, address pointer does not increment.
//      0 = Sequential operation enabled, address pointer increments.
//bit 3 HAEN: Hardware Address Enable bit (MCP23S17 only).
#define HAEN 0x08
//      1 = Enables the MCP23S17 address pins.
//      0 = Disables the MCP23S17 address pins. adress=0
//bit 2 ODR: This bit configures the INT pin as an open-drain output.
#define ODR 0x04
//      1 = Open-drain output (overrides the INTPOL bit).
//      0 = Active driver output (INTPOL bit sets the polarity).
//bit 1 INTPOL: This bit sets the polarity of the INT output pin.
#define INTPOL 0x02
//      1 = Active-high.
//      0 = Active-low.
//#define IOCON       0x0B  ->0x0A
#define GPPUA       0x0C  //PULL-UP RESISTOR CONFIGURATION REGISTER  1 = Pull-up enabled 100 k. 0 = Pull-up disabled. def:0
#define GPPUB       0x0D
#define INTFA       0x0E  //INTERRUPT FLAG REGISTER (read-only) 1 = Pin caused interrupt. 0 = Interrupt not pending.
#define INTFB       0x0F
#define INTCAPA     0x10  //CAPTURE REGISTER (read-only) These bits reflect the logic level on the port pins at the time of interrupt due to pin change
#define INTCAPB     0x11
#define GPIOA       0x12  //GENERAL PURPOSE I/O PORT REGISTER
//The GPIO register reflects the value on the port.
//Reading from this register reads the port. Writing to this
//register modifies the Output Latch (OLAT) register.
#define GPIOB       0x13
#define OLATA       0x14  //OUTPUT LATCH REGISTER
#define OLATB       0x15

void ShowReg(char*prefix, unsigned char reg,unsigned char val);

TForm1 *Form1;
HINSTANCE hLib;
short _stdcall (*inp32)(short portaddr);
void _stdcall (*oup32)(short portaddr, short datum);
//------ ---------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//------ ---------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
     hLib = LoadLibrary("inpout32.dll");

     if (hLib == NULL)
     {
         return ;
     }

     /*  get the address of the function */

     (void*)inp32 =  GetProcAddress(hLib, "Inp32");

     (void*)oup32 =  GetProcAddress(hLib, "Out32");
    unsigned short int x;

    x=inp32(LPTDATA);
    CB2->Checked=((x&0x04)?true:false);
    CB1->Checked=((x&0x02)?true:false);
    CB0->Checked=((x&0x01)?true:false);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CB0Click(TObject *Sender)
{

    unsigned short int x=0;
    unsigned short int tmpx;

    if(CB0->Checked)x|=0x01;
    if(CB1->Checked)x|=0x02;
    if(CB2->Checked)x|=0x04;

    tmpx=inp32(LPTDATA)&0xf8;

    oup32(LPTDATA,tmpx|x);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
    unsigned short int x;

    x=inp32(LPTSTS);
    CBS6->Checked=((x&0x40)?true:false);
    CBS5->Checked=((x&0x20)?true:false);
    CBS4->Checked=((x&0x10)?true:false);

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
    unsigned short int x;

    x=inp32(LPTDATA);
    CB2->Checked=((x&0x04)?true:false);
    CB1->Checked=((x&0x02)?true:false);
    CB0->Checked=((x&0x01)?true:false);

}
//---------------------------------------------------------------------------
void SetBit(unsigned short Bit)
{
    unsigned short tmp;
    tmp=inp32(LPTDATA);
    oup32(LPTDATA,tmp|Bit);
}
void ClearBit(unsigned short Bit)
{
    unsigned short tmp;
    tmp=inp32(LPTDATA);
    oup32(LPTDATA,tmp&(~Bit) );
}

unsigned short ReadBit(unsigned short Bit)
{
    return inp32(LPTSTS)&Bit;
}

unsigned char SPISendByte(unsigned char Byte)
{
    unsigned char ret;
    int i;
    ClearBit(SCK);

    for(i=0;i<8;i++)
    {

        //MOSI=Byte[7]  set data bit
        if(Byte&0x80)SetBit(MOSI); else ClearBit(MOSI);

        ret<<=1;
        ret|=(ReadBit(MISO)?0x01:0x00);

        Byte<<=1;//shift data

        //SCK 0-->1
        SetBit(SCK);
        ClearBit(SCK);

    }

    return ret;
}
unsigned char SPIWrite(unsigned char Addr,unsigned char Cmd,unsigned char Data)
{
    unsigned char ret;
    ClearBit(_CS);
    ClearBit(SCK);

    ret=SPISendByte(SPI_OP_CODE|(Addr<<1)|SPI_OP_WRITE);
    ret=SPISendByte(Cmd);
    ret=SPISendByte(Data);

    SetBit(_CS);

    ShowReg("SPIWrite ",Cmd,Data);

    return ret;
}
unsigned char SPIRead(unsigned char Addr,unsigned char Cmd)
{
    unsigned char ret;
    ClearBit(_CS);
    ClearBit(SCK);

    ret=SPISendByte(SPI_OP_CODE|(Addr<<1)|SPI_OP_READ);
    ret=SPISendByte(Cmd);
    ret=SPISendByte(0);

    SetBit(_CS);
    ShowReg("SPIRead ",Cmd,ret);
    return ret;
}
unsigned char SPIAddr(void)
{
    unsigned char addr=0;

    if(Form1->CBA0->Checked)addr|=0x01;
    if(Form1->CBA1->Checked)addr|=0x02;
    if(Form1->CBA2->Checked)addr|=0x04;
    return addr;
}
void __fastcall TForm1::Button4Click(TObject *Sender)
{

    unsigned short int x=0;
    unsigned char Addr;
    unsigned char ret;

    if(CBD0->Checked)x|=0x01;
    if(CBD1->Checked)x|=0x02;
    if(CBD2->Checked)x|=0x04;
    if(CBD3->Checked)x|=0x08;

    if(CBD4->Checked)x|=0x10;
    if(CBD5->Checked)x|=0x20;
    if(CBD6->Checked)x|=0x40;
    if(CBD7->Checked)x|=0x80;


    Addr=SPIAddr() ;
    ret=SPIWrite(Addr,OLATA,  x);// PortA output latch write
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button5Click(TObject *Sender)
{

    unsigned short int x=0;
    unsigned char Addr;
    int i;

    Addr=SPIAddr() ;
    x=SPIRead(Addr,OLATA);// PortA output latch read



    CBD0->Checked=x&0x01;
    CBD1->Checked=x&0x02;
    CBD2->Checked=x&0x04;
    CBD3->Checked=x&0x08;

    CBD4->Checked=x&0x10;
    CBD5->Checked=x&0x20;
    CBD6->Checked=x&0x40;
    CBD7->Checked=x&0x80;

}
//---------------------------------------------------------------------------


void __fastcall TForm1::Button2Click(TObject *Sender)
{
    unsigned char Addr;
    unsigned char ret;
    unsigned char Data;

    Addr=SPIAddr() ;
    Data= 0
           |(0?BANK:0)     //1-different banks 0- sequential
           |(0?MIRROR:0)     //1-INTA or INTB 0-PORTA->INTA,PORTB->INTB
           |(0?SEQOP:0)        //1-address pointer does not increment 0-increment
           |(1?HAEN:0)       //1-Enables address pins 0-Disables adress=0
           |(0?ODR:0)        //1-INT pin Open-drain output 0-Active driver output
           |(1?INTPOL:0)      // 1- Active-high 0- Active-low
           ;
    ret=SPIWrite(Addr,IOCON,  Data);

    ret=SPIWrite(Addr,IODIRA,  0x0);// PortA output

    ret=SPIWrite(Addr,IODIRB,  0xff);// PortB input
    ret=SPIWrite(Addr,GPINTENB,  0xff);// PortB enable on-change event
    ret=SPIWrite(Addr,GPPUB,  0xff);// PortB Pull-up enabled 100 k
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button3Click(TObject *Sender)
{

    unsigned short int x=0;
    unsigned char Addr;
    int i;

    Addr=SPIAddr() ;
    x=SPIRead(Addr,GPIOB);// PortB read

    CBB0->Checked=x&0x01;
    CBB1->Checked=x&0x02;
    CBB2->Checked=x&0x04;
    CBB3->Checked=x&0x08;

    CBB4->Checked=x&0x10;
    CBB5->Checked=x&0x20;
    CBB6->Checked=x&0x40;
    CBB7->Checked=x&0x80;

    x=SPIRead(Addr,INTFB);// PortB INTERRUPT FLAG REGISTER read 1 = Pin caused interrupt
    x=SPIRead(Addr,INTCAPB);// PortB CAPTURE REGISTER read
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button6Click(TObject *Sender)
{

    unsigned short int x=0;
    unsigned char Addr;
    int i;

    Addr=SPIAddr() ;
    x=SPIRead(Addr,INTFB);// PortB INTERRUPT FLAG REGISTER read 1 = Pin caused interrupt

    CBBF0->Checked=x&0x01;
    CBBF1->Checked=x&0x02;
    CBBF2->Checked=x&0x04;
    CBBF3->Checked=x&0x08;

    CBBF4->Checked=x&0x10;
    CBBF5->Checked=x&0x20;
    CBBF6->Checked=x&0x40;
    CBBF7->Checked=x&0x80;

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button7Click(TObject *Sender)
{
    unsigned short int x=0;
    unsigned char Addr;
    int i;

    Addr=SPIAddr() ;
    x=SPIRead(Addr,INTCAPB);// PortB CAPTURE REGISTER read

    CBBC0->Checked=x&0x01;
    CBBC1->Checked=x&0x02;
    CBBC2->Checked=x&0x04;
    CBBC3->Checked=x&0x08;

    CBBC4->Checked=x&0x10;
    CBBC5->Checked=x&0x20;
    CBBC6->Checked=x&0x40;
    CBBC7->Checked=x&0x80;


}
//---------------------------------------------------------------------------
void ShowReg(char*prefix, unsigned char reg,unsigned char val)
{
    char tmp[100];
    char Name[20];
    switch(reg)
    {
        case IODIRA  :strcpy(Name,"IODIRA  ");break;
        case IODIRB  :strcpy(Name,"IODIRB  ");break;
        case IPOLA   :strcpy(Name,"IPOLA   ");break;
        case IPOLB   :strcpy(Name,"IPOLB   ");break;
        case GPINTENA:strcpy(Name,"GPINTENA");break;
        case GPINTENB:strcpy(Name,"GPINTENB");break;
        case DEFVALA :strcpy(Name,"DEFVALA ");break;
        case DEFVALB :strcpy(Name,"DEFVALB ");break;
        case INTCONA :strcpy(Name,"INTCONA ");break;
        case INTCONB :strcpy(Name,"INTCONB ");break;
        case IOCON   :strcpy(Name,"IOCON   ");break;
        case GPPUA   :strcpy(Name,"GPPUA   ");break;
        case GPPUB   :strcpy(Name,"GPPUB   ");break;
        case INTFA   :strcpy(Name,"INTFA   ");break;
        case INTFB   :strcpy(Name,"INTFB   ");break;
        case INTCAPA :strcpy(Name,"INTCAPA ");break;
        case INTCAPB :strcpy(Name,"INTCAPB ");break;
        case GPIOA   :strcpy(Name,"GPIOA   ");break;
        case GPIOB   :strcpy(Name,"GPIOB   ");break;
        case OLATA   :strcpy(Name,"OLATA   ");break;
        case OLATB   :strcpy(Name,"OLATB   ");break;
    }

    sprintf(tmp,"%s %s=%02X %d%d%d%d %d%d%d%d"
        , prefix
        ,Name
        ,(int)val
        ,(val&0x80?1:0)
        ,(val&0x40?1:0)
        ,(val&0x20?1:0)
        ,(val&0x10?1:0)
        ,(val&0x08?1:0)
        ,(val&0x04?1:0)
        ,(val&0x02?1:0)
        ,(val&0x01?1:0)
        );
    Form1->Memo1->Lines->Add(tmp);
}
void ReadReg(unsigned char Addr,unsigned char reg)
{
    unsigned char val;
    val=SPIRead(Addr,reg);
}
void __fastcall TForm1::Button8Click(TObject *Sender)
{
    unsigned char Addr;
    Addr=SPIAddr() ;

    ReadReg(Addr,IODIRA   );
    ReadReg(Addr,IODIRB   );
    ReadReg(Addr,IPOLA    );
    ReadReg(Addr,IPOLB    );
    ReadReg(Addr,GPINTENA );
    ReadReg(Addr,GPINTENB );
    ReadReg(Addr,DEFVALA  );
    ReadReg(Addr,DEFVALB  );
    ReadReg(Addr,INTCONA  );
    ReadReg(Addr,INTCONB  );
    ReadReg(Addr,IOCON    );
    ReadReg(Addr,GPPUA    );
    ReadReg(Addr,GPPUB    );
    ReadReg(Addr,INTFA    );
    ReadReg(Addr,INTFB    );
    ReadReg(Addr,INTCAPA  );
    ReadReg(Addr,INTCAPB  );
    ReadReg(Addr,GPIOA    );
    ReadReg(Addr,GPIOB    );
    ReadReg(Addr,OLATA    );
    ReadReg(Addr,OLATB    );

}
//---------------------------------------------------------------------------

