//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
//OUT
#define DS      0x01    //serial data input           LPT Pin2 (DATA0) --- pin14 (SI)
#define _OE     0x02    //output enable (active LOW)  LPT Pin3 (DATA1) --- pin13 (_OE)
#define STCP    0x04    //storage register clock input LPT Pin4 (DATA2) --- pin12 (STCP)
#define SHCP    0x08    //shift register clock input  LPT Pin5 (DATA3) --- pin11 (SHCP)
//IN
#define Q7      0x40    //serial data output          LPT Pin10 (STS6)nAck     --- pin9 (Q7')

TForm1 *Form1;
HINSTANCE hLib;
short _stdcall (*inp32)(short portaddr);
void _stdcall (*oup32)(short portaddr, short datum);
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
     hLib = LoadLibrary("inpout32.dll");

     if (hLib == NULL)
     {
          return ;
     }

     /* get the address of the function */

     (void*)inp32 =  GetProcAddress(hLib, "Inp32");

     (void*)oup32 =  GetProcAddress(hLib, "Out32");
    unsigned short int x;

    x=inp32(0x278);
    CB3->Checked=((x&0x08)?true:false);
    CB2->Checked=((x&0x04)?true:false);
    CB1->Checked=((x&0x02)?true:false);
    CB0->Checked=((x&0x01)?true:false);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CB0Click(TObject *Sender)
{

    unsigned short int x=0;
    unsigned short int tmpx;

    if(CB0->Checked)x|=0x01;
    if(CB1->Checked)x|=0x02;
    if(CB2->Checked)x|=0x04;
    if(CB3->Checked)x|=0x08;

    tmpx=inp32(0x279)&0xf0;

    oup32(0x278,tmpx|x);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
    unsigned short int x;

    x=inp32(0x279);
    CBS6->Checked=((x&0x40)?true:false);

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
    unsigned short int x;

    x=inp32(0x278);
    CB3->Checked=((x&0x08)?true:false);
    CB2->Checked=((x&0x04)?true:false);
    CB1->Checked=((x&0x02)?true:false);
    CB0->Checked=((x&0x01)?true:false);

}
//---------------------------------------------------------------------------
void SetBit(unsigned short Bit)
{
    unsigned short tmp;
    tmp=inp32(0x278);
    oup32(0x278,tmp|Bit);
}
void ClearBit(unsigned short Bit)
{
    unsigned short tmp;
    tmp=inp32(0x278);
    oup32(0x278,tmp&(~Bit) );
}

unsigned short ReadBit(unsigned short Bit)
{
    return inp32(0x279)&Bit;
}
void __fastcall TForm1::Button2Click(TObject *Sender)
{
    //SHCP 0..1 shift left
    ClearBit(SHCP);
    SetBit(SHCP);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button3Click(TObject *Sender)
{

    //STCP 0..1  store shift reg to data reg
    ClearBit(STCP);
    SetBit(STCP);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button4Click(TObject *Sender)
{

    unsigned short int x=0;
    int i;

    if(CBD0->Checked)x|=0x01;
    if(CBD1->Checked)x|=0x02;
    if(CBD2->Checked)x|=0x04;
    if(CBD3->Checked)x|=0x08;

    if(CBD4->Checked)x|=0x10;
    if(CBD5->Checked)x|=0x20;
    if(CBD6->Checked)x|=0x40;
    if(CBD7->Checked)x|=0x80;

    for(i=0;i<8;i++)
    {
        //DS=x[7]  set data bit
        if(x&0x80)SetBit(DS); else ClearBit(DS);

        x<<=1;//shift data

        //SHCP 0..1  shift left
        ClearBit(SHCP);
        SetBit(SHCP);

    }

    //STCP 0..1  store data
    ClearBit(STCP);
    SetBit(STCP);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button5Click(TObject *Sender)
{

    unsigned short int x=0;
    int i;

    for(i=0;i<8;i++)
    {
        x<<=1;//shift data
        //x[0]=Q7  read data bit
        if(ReadBit(Q7))x|=0x01; else x&=0xfe;

        //DS=x[0] loop back
        if(x&0x01)SetBit(DS); else ClearBit(DS);


        //SHCP 0..1  shift left
        ClearBit(SHCP);
        SetBit(SHCP);

    }


    CBD0->Checked=x&0x01;
    CBD1->Checked=x&0x02;
    CBD2->Checked=x&0x04;
    CBD3->Checked=x&0x08;

    CBD4->Checked=x&0x10;
    CBD5->Checked=x&0x20;
    CBD6->Checked=x&0x40;
    CBD7->Checked=x&0x80;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button6Click(TObject *Sender)
{
    unsigned short int x=0;

    //x[0]=Q7  read data bit
    if(ReadBit(Q7))x|=0x01; else x&=0xfe;

    //DS=x[0] loop back
    if(x&0x01)SetBit(DS); else ClearBit(DS);


    //SHCP 0..1  shift left
    ClearBit(SHCP);
    SetBit(SHCP);

    //STCP 0..1  store data
    ClearBit(STCP);
    SetBit(STCP);
}
//---------------------------------------------------------------------------
  
