Attribute VB_Name = "PicComms"
Public Declare Function SendPacket Lib "PICBOOT32.dll" (ByVal hComPort As Long, PacketData As Byte, ByVal NumOfBytes As Integer) As Integer
Public Declare Function GetPacket Lib "PICBOOT32.dll" (ByVal hComPort As Long, PacketData As Byte, ByVal NumOfBytesLim As Integer) As Integer
Public Declare Function OpenPIC Lib "PICBOOT32.dll" (ByVal ComPort As String, ByVal BitRate As Long, ByVal ReadTimeOut As Long) As Long
Public Declare Function ClosePIC Lib "PICBOOT32.dll" (ByVal hComPort As Long) As Integer
Public Declare Function SendGetPacket Lib "PICBOOT32.dll" (ByVal hComPort As Long, PacketData As Byte, ByVal NumOfBytes As Integer, ByVal NumOfBytesLim As Integer, ByVal NumOfRetrys As Integer) As Integer
Public Declare Function SyncPIC Lib "PICBOOT32.dll" (ByVal hComPort As Long, PacketData As Byte) As Integer

Public Declare Sub Sleep Lib "kernel32.dll" (ByVal dwMilliseconds As Long)
Public Declare Function timeGetTime Lib "WinMM.dll" () As Long
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" ( _
        ByRef Destination As Any, _
        ByRef Source As Any, _
        ByVal numbytes As Long)
                
Public gDataBfr(2250000) As Byte     'big enough buffer to hold any size flash part
Public gDevicePFMSz As Long

Public Type PICBOOT
    PortHandle As Long          'port info
    BitRate As Long
    CommPort As String
    DeviceName As String        'device info
    DeviceCode As String
    InFileName As String
End Type

Public PicBootS As PICBOOT
Public gDeviceID As Byte

'////////////////////////////////////////////////////////////////
'// Function Name:
'// Description: function for Wait
'// Arguments: none
'// Return Values: none
'////////////////////////////////////////////////////////////////
Public Sub Wait(ByVal inMilliseconds As Long)
    Dim SleepTime As Long, TimeNow As Long
    Dim SleepTo As Long, SleepEnd As Long

    Const MaxSleep As Long = 100

    TimeNow = timeGetTime()
    SleepTime = inMilliseconds \ 10
    If (SleepTime > MaxSleep) Then SleepTime = MaxSleep
    SleepTo = TimeNow + inMilliseconds

    Do
        DoEvents
        TimeNow = timeGetTime()
        SleepEnd = SleepTo - TimeNow
        If (SleepEnd <= SleepTime) Then Exit Do
        Call Sleep(SleepTime)
    Loop

    If (SleepEnd > 0) Then Call Sleep(SleepEnd)
End Sub
'////////////////////////////////////////////////////////////////

Public Function BytesToLong(TheArray() As Byte) As Long
   Dim TempLong As Long

   Call CopyMemory(TempLong, TheArray(LBound(TheArray)), 4)
   BytesToLong = TempLong

End Function

Public Sub LongToBytes(ByRef TheArray() As Byte, ByRef TheLong As Long)

   Call CopyMemory(TheArray(LBound(TheArray)), TheLong, 4)

End Sub
Function WriteDevice() As Boolean
'writes must be multiple of 512 bytes. upto 4096 bytes

    Dim bfr(5000) As Byte
    Dim RetStat As Integer

    Dim BufferSize As Long
    Dim Cntr  As Integer
    Dim PageBlank As Boolean
    Dim tempArray(10) As Byte
    
    WriteDevice = True
    
    BufferSize = ((gPeakAddr - &H1D000000) And (Not 3)) + 4
    
    If BufferSize > gDevicePFMSz Then
    
        MsgBox "Code Size is bigger than the available Flash memory", vbOK, "Memory Size Error"
        Exit Function
        
    End If
    
    
'KM changed nPacket and PktSize to longs to avoid 16 bit integer overflows
    Dim nPacket As Long
'    Dim nPacket As Integer
    Dim byteCount As Long
    Dim addr As Long
    Dim PktSize As Long
'    Dim PktSize As Integer
    Dim NumPackets As Long
        
    PktSize = 512
    nPacket = 0
    frmBootload.txtOperation = "Programming"
    NumPackets = BufferSize / PktSize
    frmBootload.ProgressBar1.Max = NumPackets
    DoEvents
    
    Do While BufferSize > 0
        frmBootload.txtOperation = "Programming " & nPacket & " of " & NumPackets & " blocks"
    
        byteCount = BufferSize - PktSize
        
        If byteCount <= 0 Then
            byteCount = BufferSize
        Else
            byteCount = PktSize
        End If
        
        bfr(0) = 2  'prog device
        bfr(1) = 0
        
        LongToBytes tempArray, (byteCount / 4)
        
        bfr(2) = tempArray(0) '400H, 1024 inst words, 4096 bytes
        bfr(3) = tempArray(1) And &HFF
        
'KM removed upper byte which creates 4 byte long overflow
'addr = &H9D000000 + (nPacket * PktSize)
        addr = nPacket * PktSize
        
        LongToBytes tempArray, addr
        
        bfr(4) = tempArray(0)
        bfr(5) = tempArray(1)
        bfr(6) = tempArray(2)
        bfr(7) = &H9D
        
        PageBlank = True
        For i = 0 To (byteCount - 1)
            bfr(i + 8) = gDataBfr(i + (nPacket * PktSize))
            If bfr(i + 8) <> &HFF Then PageBlank = False
        Next i

        frmBootload.ProgressBar1.Value = nPacket
        DoEvents
        
        BufferSize = BufferSize - byteCount
        nPacket = nPacket + 1

        If PageBlank Then
            bfr(0) = &H22  'prog flash with all FF, no need to send the buffer
            SendPacket PicBootS.PortHandle, bfr(0), 8
        Else
            SendPacket PicBootS.PortHandle, bfr(0), byteCount + 8
        End If
        
        Cntr = 3 * 200
        
'       Wait (2000)
        Wait (100)
        Do While Cntr > 0
            DoEvents

            RetStat = GetPacket(PicBootS.PortHandle, bfr(0), 20)
            If RetStat > 0 Then Exit Do
            Cntr = Cntr - 1
        Loop
        
                
        If Cntr = 0 Then
            WriteDevice = False
            Exit Function
        End If
                
    Loop

    BufferSize = ((gPeakAddr - &H1D000000) And (Not 3)) + 4

    If VerifyDevice Then
        bfr(0) = 8  'verify_ok. mark flash as good
        bfr(1) = 0
        bfr(2) = 1
        bfr(3) = 1
        
        LongToBytes tempArray, BufferSize

        bfr(4) = tempArray(0)
        bfr(5) = tempArray(1)
        bfr(6) = tempArray(2)
        bfr(7) = 0

        SendPacket PicBootS.PortHandle, bfr(0), 8
        Wait (2000)
        'get the reply
        Cntr = 3 * 200
        bfr(0) = 0
        bfr(1) = 0
        Do While Cntr > 0
            DoEvents
            
            RetStat = GetPacket(PicBootS.PortHandle, bfr(0), 10)
            If RetStat <> 0 Then Exit Do
            Cntr = Cntr - 1
        Loop
        
        If RetStat <= 0 Or bfr(0) = &H45 Or bfr(0) = &H47 Then
            ''error
            WriteDevice = False
            frmBootload.txtOperation = "Verify error during VERIFY_OK write"
            If RetStat = -4 Then
                frmBootload.txtOperation = "Verify error during VERIFY_OK write: checksum error"
            ElseIf RetStat = -2 Then
                frmBootload.txtOperation = "Verify error during VERIFY_OK write: timeout error"
            End If
        Else
            WriteDevice = True
            frmBootload.txtOperation = "Verify SUCCESS"
        End If
    Else
        WriteDevice = False
    End If

End Function

Function VerifyDevice() As Boolean
'must be 32 bit alligned

    Dim tempArray(10) As Byte
    Dim bfr(5000) As Byte
    Dim RetStat As Integer

    Dim BufferSize As Long
    Dim Cntr  As Integer
    Dim addr As Long
    
    BufferSize = ((gPeakAddr - &H1D000000) And (Not 3)) + 4
    
    If BufferSize > gDevicePFMSz Then
    
        MsgBox "Code Size is bigger than the available Flash memory", vbOK, "Memory Size Error"
        Exit Function
        
    End If
        
'KM changed nPacket and PktSize to longs to avoid 16 bit integer overflows
    Dim nPacket As Long
'    Dim nPacket As Integer
    Dim byteCount As Long
    Dim PktSize As Long
'    Dim PktSize As Integer
    Dim NumPackets As Long
    
    nPacket = 0
    PktSize = 512
    frmBootload.txtOperation = "Verifying"
    NumPackets = BufferSize / PktSize
    frmBootload.ProgressBar1.Max = NumPackets
    frmBootload.ProgressBar1.Value = 0

    DoEvents
    
    Do While BufferSize > 0

        frmBootload.txtOperation = "Verifying " & nPacket & " of " & NumPackets & " blocks"
        byteCount = BufferSize - PktSize
        
        If byteCount <= 0 Then
            byteCount = BufferSize
        Else
            byteCount = PktSize
        End If
        
        bfr(0) = 1  'read device
        bfr(1) = 0
        
        LongToBytes tempArray, (byteCount / 4)
        bfr(2) = tempArray(0) '400H, 1024 inst words, 4096 bytes
        bfr(3) = tempArray(1) And &HFF
        
        addr = &H9D000000 + (nPacket * PktSize)
        
        LongToBytes tempArray, addr
        
        bfr(4) = tempArray(0)
        bfr(5) = tempArray(1)
        bfr(6) = tempArray(2)
        bfr(7) = &H9D
                
        SendPacket PicBootS.PortHandle, bfr(0), 8
                
        Cntr = 1 * 200
        
'        Wait (2000)
        Wait (250)
        RetStat = 0
        Do While Cntr > 0
            DoEvents
'            Wait (2000)
            RetStat = GetPacket(PicBootS.PortHandle, bfr(0), 5000)
            If RetStat <> byteCount Then Exit Do
            Cntr = Cntr - 1
        Loop
                
        If Cntr = 0 Or RetStat < byteCount Then
            VerifyDevice = False
            If RetStat = -4 Then
                frmBootload.txtOperation = "Verify read packet checksum error"
            ElseIf RetStat = -2 Then
                frmBootload.txtOperation = "Verify read packet timeout error"
            End If
            Exit Function
        Else
        
            For i = 0 To (byteCount - 1)
            
                If bfr(i + 8) <> gDataBfr(i + (nPacket * PktSize)) Then
                    addr = &H9D000000 + (i + (nPacket * PktSize))
                    MsgBox "Verify Error at 0x" & Hex(addr)
                    VerifyDevice = False
                    frmBootload.txtOperation = "Verify ERROR"
                    Exit Function
                End If
                
            Next i
                
        End If
                
        BufferSize = BufferSize - byteCount
        
        frmBootload.ProgressBar1.Value = nPacket
        
        nPacket = nPacket + 1
        
    Loop
    
    VerifyDevice = True
    frmBootload.txtOperation = "Verify SUCCESS"


End Function

Function EraseDevice() As Boolean

    ReDim DevID(10) As Byte
    Dim RetStat As Integer

    DevID(0) = 3  'erase device
    DevID(1) = 0
    DevID(2) = 1
    DevID(3) = 0
    SendPacket PicBootS.PortHandle, DevID(0), 4
    
    frmBootload.txtOperation = "Erasing"
    frmBootload.ProgressBar1.Value = 1
    DoEvents
    
    Dim Cntr  As Integer
        
    frmBootload.ProgressBar1.Max = 6 * 200
    Do While Cntr < frmBootload.ProgressBar1.Max
    
        frmBootload.ProgressBar1.Value = Cntr
        DoEvents
        
        RetStat = GetPacket(PicBootS.PortHandle, DevID(0), 10)
        If RetStat > 0 Then Exit Do
        Cntr = Cntr + 1
    Loop
                
    If RetStat <= 0 Then
        EraseDevice = False
        frmBootload.ProgressBar1.Value = frmBootload.ProgressBar1.Max / 2
        frmBootload.txtOperation = "Erase ERROR"
    Else
        frmBootload.ProgressBar1.Value = frmBootload.ProgressBar1.Max
        frmBootload.txtOperation = "Erase SUCCESS"
        EraseDevice = True
    End If

End Function

Function ReadVersion() As String
    ReDim DevID(16) As Byte
    Dim RetStat As Integer

    DevID(0) = 9  'read version
    DevID(1) = 0
    DevID(2) = 2
    DevID(3) = 0
    'RetStat = SendGetPacket(PicBootS.PortHandle, DevID(0), 4, 16, 10)
    SendPacket PicBootS.PortHandle, DevID(0), 4
    Wait (2000)
    RetStat = GetPacket(PicBootS.PortHandle, DevID(0), 16)
    If RetStat <= 0 Then
        ReadVersion = Empty
    Else
    
        gDevicePFMSz = BytesToLong(DevID)
        gDeviceID = DevID(6)
        
        ReadVersion = "PIC32 BL V" & DevID(4) & "." & DevID(5)
    
    End If
    
End Function

Function GotoRunMode() As Integer
    ReDim DevID(10) As Byte
    Dim RetStat As Integer

    DevID(0) = 0
    DevID(1) = 0
    DevID(2) = 0
    DevID(3) = 0
    DevID(4) = 0
    DevID(5) = 0
    RetStat = SendPacket(PicBootS.PortHandle, DevID(0), 6)
    frmBootload.txtOperation = "Switched to Run Mode"
    
End Function



