VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmBootload 
   Caption         =   "PIC32 Boot Loader"
   ClientHeight    =   1515
   ClientLeft      =   165
   ClientTop       =   450
   ClientWidth     =   4875
   Icon            =   "frmBootload.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   1515
   ScaleWidth      =   4875
   StartUpPosition =   2  'CenterScreen
   Begin MSComctlLib.ProgressBar ProgressBar1 
      Height          =   255
      Left            =   540
      TabIndex        =   2
      Top             =   855
      Width           =   2775
      _ExtentX        =   4895
      _ExtentY        =   450
      _Version        =   393216
      BorderStyle     =   1
      Appearance      =   0
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   4050
      Top             =   720
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin MSComctlLib.ImageList ImageList2 
      Left            =   4500
      Top             =   630
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   16711935
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   11
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmBootload.frx":030A
            Key             =   ""
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmBootload.frx":065E
            Key             =   ""
         EndProperty
         BeginProperty ListImage3 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmBootload.frx":09B2
            Key             =   ""
         EndProperty
         BeginProperty ListImage4 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmBootload.frx":0D06
            Key             =   ""
         EndProperty
         BeginProperty ListImage5 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmBootload.frx":105A
            Key             =   ""
         EndProperty
         BeginProperty ListImage6 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmBootload.frx":13AE
            Key             =   ""
         EndProperty
         BeginProperty ListImage7 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmBootload.frx":1702
            Key             =   ""
         EndProperty
         BeginProperty ListImage8 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmBootload.frx":1A56
            Key             =   ""
         EndProperty
         BeginProperty ListImage9 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmBootload.frx":1DAA
            Key             =   ""
         EndProperty
         BeginProperty ListImage10 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmBootload.frx":20FE
            Key             =   ""
         EndProperty
         BeginProperty ListImage11 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmBootload.frx":2452
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin MSComctlLib.Toolbar Toolbar1 
      Align           =   1  'Align Top
      Height          =   360
      Left            =   0
      TabIndex        =   1
      Top             =   0
      Width           =   4875
      _ExtentX        =   8599
      _ExtentY        =   635
      ButtonWidth     =   609
      ButtonHeight    =   582
      AllowCustomize  =   0   'False
      Appearance      =   1
      Style           =   1
      ImageList       =   "ImageList2"
      _Version        =   393216
      BeginProperty Buttons {66833FE8-8583-11D1-B16A-00C0F0283628} 
         NumButtons      =   9
         BeginProperty Button1 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Open"
            Object.ToolTipText     =   "Open HEX File"
            ImageIndex      =   1
         EndProperty
         BeginProperty Button2 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Object.Visible         =   0   'False
            Key             =   "Clear"
            Object.ToolTipText     =   "Clear Memory"
            ImageIndex      =   3
         EndProperty
         BeginProperty Button3 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
         EndProperty
         BeginProperty Button4 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Connect"
            Object.ToolTipText     =   "Connect to Device"
            ImageIndex      =   6
            Style           =   1
         EndProperty
         BeginProperty Button5 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Write"
            Object.ToolTipText     =   "Write Device"
            ImageIndex      =   8
         EndProperty
         BeginProperty Button6 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Verify"
            Object.ToolTipText     =   "Verify Device"
            ImageIndex      =   11
         EndProperty
         BeginProperty Button7 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Erase"
            Object.ToolTipText     =   "Erase Program Flash Area"
            ImageIndex      =   9
         EndProperty
         BeginProperty Button8 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
         EndProperty
         BeginProperty Button9 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Run"
            Object.ToolTipText     =   "Launch User Application"
            ImageIndex      =   10
         EndProperty
      EndProperty
   End
   Begin MSComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   255
      Left            =   0
      TabIndex        =   0
      Top             =   1260
      Width           =   4875
      _ExtentX        =   8599
      _ExtentY        =   450
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   5
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   3968
            MinWidth        =   1058
            Text            =   "Status"
            TextSave        =   "Status"
            Key             =   "PStatus"
            Object.ToolTipText     =   "Right click for memory read/write settings."
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Alignment       =   1
            AutoSize        =   2
            Object.Width           =   556
            MinWidth        =   529
            Text            =   "NA"
            TextSave        =   "NA"
            Key             =   "FirmVer"
            Object.ToolTipText     =   "Firmware version."
         EndProperty
         BeginProperty Panel3 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Alignment       =   1
            AutoSize        =   2
            Object.Width           =   1693
            MinWidth        =   706
            Text            =   "UNKNOWN"
            TextSave        =   "UNKNOWN"
            Object.ToolTipText     =   "PIC device, right click to select."
         EndProperty
         BeginProperty Panel4 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Alignment       =   1
            AutoSize        =   2
            Object.Width           =   953
            MinWidth        =   706
            Text            =   "COM1"
            TextSave        =   "COM1"
            Key             =   "CommPort"
            Object.ToolTipText     =   "Right click to change COM port."
         EndProperty
         BeginProperty Panel5 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Alignment       =   1
            AutoSize        =   2
            Object.Width           =   794
            MinWidth        =   706
            Text            =   "9600"
            TextSave        =   "9600"
            Key             =   "BitRate"
            Object.ToolTipText     =   "Right click to set bit rate."
         EndProperty
      EndProperty
   End
   Begin VB.Label txtOperation 
      AutoSize        =   -1  'True
      Caption         =   "Progress"
      Height          =   195
      Left            =   540
      TabIndex        =   3
      Top             =   495
      Width           =   615
   End
   Begin VB.Menu M_PortSettings 
      Caption         =   "PortSettings"
      Visible         =   0   'False
      Begin VB.Menu M_FPPort 
         Caption         =   "COM1"
         Index           =   1
      End
      Begin VB.Menu M_FPPort 
         Caption         =   "COM2"
         Checked         =   -1  'True
         Index           =   2
      End
      Begin VB.Menu M_FPPort 
         Caption         =   "COM3"
         Index           =   3
      End
      Begin VB.Menu M_FPPort 
         Caption         =   "COM4"
         Index           =   4
      End
      Begin VB.Menu M_FPPort 
         Caption         =   "COM5"
         Index           =   5
      End
      Begin VB.Menu M_FPPort 
         Caption         =   "COM6"
         Index           =   6
      End
      Begin VB.Menu M_FPPort 
         Caption         =   "COM7"
         Index           =   7
      End
      Begin VB.Menu M_FPPort 
         Caption         =   "COM8"
         Index           =   8
      End
      Begin VB.Menu M_FPPort 
         Caption         =   "COM9"
         Index           =   9
      End
     Begin VB.Menu M_FPPort 
         Caption         =   "COM10"
         Index           =   10
      End
   End
   Begin VB.Menu M_BitRateSettings 
      Caption         =   "BitRatetSettings"
      Visible         =   0   'False
      Begin VB.Menu M_FPBaud 
         Caption         =   "1200"
         Index           =   1
      End
      Begin VB.Menu M_FPBaud 
         Caption         =   "2400"
         Index           =   2
      End
      Begin VB.Menu M_FPBaud 
         Caption         =   "4800"
         Index           =   3
      End
      Begin VB.Menu M_FPBaud 
         Caption         =   "9600"
         Index           =   4
      End
      Begin VB.Menu M_FPBaud 
         Caption         =   "19200"
         Index           =   5
      End
      Begin VB.Menu M_FPBaud 
         Caption         =   "38400"
         Checked         =   -1  'True
         Index           =   6
      End
      Begin VB.Menu M_FPBaud 
         Caption         =   "57600"
         Index           =   7
      End
      Begin VB.Menu M_FPBaud 
         Caption         =   "115200"
         Index           =   8
      End
   End
   Begin VB.Menu M_About 
      Caption         =   "AboutMenu"
      Visible         =   0   'False
      Begin VB.Menu M_About1 
         Caption         =   "About"
      End
   End
End
Attribute VB_Name = "frmBootload"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Const STATUS_NO_DEV_FOUND As String = "No Comms..."
Const STATUS_NOT_CON As String = "Not connected..."
Const STATUS_DEVICE_FOUND As String = " detected..."
Const STATUS_DATA_FILE_NOT_FOUND As String = "Data file not found..."
Const STATUS_FAILED_TO_OPEN_PORT As String = "Failed to open port..."
Const STATUS_NO_VERSION_INFO As String = "No firmware version available..."
Const STATUS_FOUND_DEVICE As String = "Device found..."
Const STATUS_READ_FAILURE As String = "Failed to read device..."
Const STATUS_WRITE_FAILURE As String = "Failed to write device..."
Const STATUS_ERASE_FAILURE As String = "Erase Error..."
Const STATUS_VERIFY_FAILURE As String = "Verify ERROR"
Const STATUS_ABORT As String = "Operation aborted..."
Const STATUS_FINISHED As String = "SUCCESS"
Const STATUS_VERIFY_ERROR As String = "Verify error received..."
Const STATUS_RUNMODE_SET As String = "Run mode is set..."
Const STATUS_HEX_FORMAT As String = "HEX file not padded properly..."
Const STATUS_HEX_IMPORTED As String = "HEX file imported..."
Const STATUS_INVALID_HEX As String = "Invalid HEX file..."
Const STATUS_HEX_EXPORTED As String = "HEX file exported..."
Const STATUS_VERIFYOK_ERROR As String = "Verify Ok command failed..."


Const MODE_NOT_CONNECTED As Integer = 0
Const MODE_CONNECTED_IDLE As Integer = 1
Const MODE_WORKING As Integer = 2

Const PANEL_STATUS As Integer = 1
Const PANEL_FWVER As Integer = 2
Const PANEL_DEVICE As Integer = 3
Const PANEL_PORT As Integer = 4
Const PANEL_BITRATE As Integer = 5


'Flag used for a
Dim PanelClicked As Integer
Dim HideToolFlag As Byte

Private Sub M_PDevSelector_Click()
    DisconnectDev

    dSelectDevice.Cm_DevList.ListIndex = 0
    dSelectDevice.Show vbModal, frmBootload
End Sub

Private Sub M_PSendCfg_Click()
    dWriteFuses.Show vbModal, frmBootload
End Sub

Private Sub StatusBar1_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
    If Button = 2 Then
        If PanelClicked = 1 Then
           PopupMenu M_About, vbPopupMenuRightButton
        End If
        
        If PanelClicked = 4 Then
            PopupMenu M_PortSettings, vbPopupMenuRightButton
        End If
    
        If PanelClicked = 5 Then
            PopupMenu M_BitRateSettings, vbPopupMenuRightButton
        End If
    End If
End Sub

Private Sub StatusBar1_PanelClick(ByVal Panel As Panel)
    PanelClicked = Panel.Index
End Sub




'******************************************************************************
'Main Form related functions
'******************************************************************************
Private Sub Form_Load()

    On Error GoTo ErrorHandler

    'Set the size
    Me.Height = 1920
    Me.Width = 6000
    
    gPeakAddr = 0
    SetDisplayMode MODE_NOT_CONNECTED
    
    MyIndex = GetSetting("PIC32BOOT", "portindex")
    M_FPPort_Click (CInt(MyIndex))
    MyIndex = GetSetting("PIC32BOOT", "bitrateindex")
    M_FPBaud_Click (CInt(MyIndex))
    
    StatusBar1.Panels(PANEL_STATUS).Text = STATUS_NOT_CON
    
    Exit Sub
    
ErrorHandler:
    
    StatusBar1.Panels(PANEL_STATUS).Text = "Core error:  " & Err.Description
    Err.Clear
End Sub


Private Sub Form_Unload(Cancel As Integer)
    'Close port if open
    If PicBootS.PortHandle > 0 Then
        ClosePIC (PicBootS.PortHandle)
        PicBootS.PortHandle = 0
    End If
    
End Sub

Private Sub ConnectToPIC()
    Dim TempReturn As String
    Dim RetStat As Integer
    Dim DevID(20) As Byte
        
    On Error GoTo ErrorHandler
    
    If PicBootS.PortHandle <= 0 Then
        PicBootS.PortHandle = OpenPIC(PicBootS.CommPort, PicBootS.BitRate, 5)
    End If
    If PicBootS.PortHandle < 0 Then
        StatusBar1.Panels(PANEL_STATUS) = STATUS_FAILED_TO_OPEN_PORT
        Toolbar1.Buttons(4).Value = tbrUnpressed
        Exit Sub
    End If
        
    Me.txtOperation = "Detecting..."
    DoEvents

    Dim Cntr As Long
    Dim Sync As Boolean
    
    Me.ProgressBar1.Max = (5 * 200)
    Do While Cntr < (5 * 200)
    
        Cntr = Cntr + 1
        DoEvents
    
        RetStat = SyncPIC(PicBootS.PortHandle, DevID(0))
        Me.ProgressBar1.Value = Cntr
        
        If RetStat > 0 Then
            Sync = True
            Exit Do
        End If
        
    Loop

    If Not Sync Then
    
        StatusBar1.Panels(PANEL_STATUS) = STATUS_NO_DEV_FOUND
        Me.txtOperation = "No Device Found"
        DisconnectDev
        Exit Sub
        
    End If
    
    'Get firmware version
    StatusBar1.Panels(PANEL_FWVER) = ReadVersion
    If StatusBar1.Panels(PANEL_FWVER) = Empty Then
        StatusBar1.Panels(PANEL_STATUS) = STATUS_NO_VERSION_INFO
        Me.txtOperation = "Baudrate Sync Error"
        DisconnectDev
        Exit Sub
    End If
    
    PicBootS.DeviceCode = gDeviceID
    PicBootS.DeviceName = GetSetting("DEVICELIST", PicBootS.DeviceCode)

    StatusBar1.Panels(PANEL_DEVICE) = PicBootS.DeviceName
    StatusBar1.Panels(PANEL_STATUS) = STATUS_FOUND_DEVICE

    SetDisplayMode MODE_CONNECTED_IDLE
    Me.txtOperation = "Device FOUND"
    Me.ProgressBar1.Value = Me.ProgressBar1.Max
    
    Exit Sub

'Handle some errors
ErrorHandler:
    If Err.Description = STATUS_FAILED_TO_OPEN_PORT Then
        
    End If
    StatusBar1.Panels(PANEL_STATUS).Text = "Core error:  " & Err.Description
    Err.Clear
End Sub



Private Sub M_About_Click()
    frmAbout.Show vbModal, frmBootload
End Sub

'******************************************************************************
'Port related setting functions
'******************************************************************************
Private Sub M_FPBaud_Click(Index As Integer)
    
    DisconnectDev
    
    M_FPBaud(1).Checked = Not CBool(Index Xor 1)
    M_FPBaud(2).Checked = Not CBool(Index Xor 2)
    M_FPBaud(3).Checked = Not CBool(Index Xor 3)
    M_FPBaud(4).Checked = Not CBool(Index Xor 4)
    M_FPBaud(5).Checked = Not CBool(Index Xor 5)
    M_FPBaud(6).Checked = Not CBool(Index Xor 6)
    M_FPBaud(7).Checked = Not CBool(Index Xor 7)
    M_FPBaud(8).Checked = Not CBool(Index Xor 8)
    
    PicBootS.BitRate = CLng(M_FPBaud(Index).Caption)
    
    StatusBar1.Panels(PANEL_BITRATE) = M_FPBaud(Index).Caption
    
    SetDisplayMode MODE_NOT_CONNECTED
            
    SetSetting CStr(Index), "PIC32BOOT", "bitrateindex"
            
End Sub


Private Sub M_FPPort_Click(Index As Integer)
        
    DisconnectDev
            
    M_FPPort(1).Checked = Not CBool(Index Xor 1)
    M_FPPort(2).Checked = Not CBool(Index Xor 2)
    M_FPPort(3).Checked = Not CBool(Index Xor 3)
    M_FPPort(4).Checked = Not CBool(Index Xor 4)
    M_FPPort(5).Checked = Not CBool(Index Xor 5)
    M_FPPort(6).Checked = Not CBool(Index Xor 6)
    M_FPPort(7).Checked = Not CBool(Index Xor 7)
    M_FPPort(8).Checked = Not CBool(Index Xor 8)
    M_FPPort(9).Checked = Not CBool(Index Xor 9)
    M_FPPort(10).Checked = Not CBool(Index Xor 10)   
    PicBootS.CommPort = M_FPPort(Index).Caption
     
    StatusBar1.Panels(PANEL_PORT) = M_FPPort(Index).Caption
     
    SetDisplayMode MODE_NOT_CONNECTED
    
    SetSetting CStr(Index), "PIC32BOOT", "portindex"
        
End Sub
'******************************************************************************


'******************************************************************************
'Toolbar related functions
'******************************************************************************
Private Sub Toolbar1_ButtonClick(ByVal Button As MSComctlLib.Button)
    Dim sFile As String
    Dim ProgMemAddrH As Long
    Dim command(5) As Byte
    Dim writeFail As Boolean

    Select Case Button.Key
        Case "Open"
                
            With CommonDialog1
                .DialogTitle = "Open HEX File"
                .CancelError = False
                .Flags = cdlOFNHideReadOnly
                .Filter = "INHEX32 Files (*.HEX)|*.HEX|All Files (*.*)|*.*"
                .ShowOpen
                If Len(.FileName) = 0 Then
                    Exit Sub
                End If
            
                PicBootS.InFileName = .FileName
                .FileName = ""
            End With


            RetStat = ImportP32HEXFile(PicBootS.InFileName)


            If RetStat = -2 Then
                StatusBar1.Panels(PANEL_STATUS).Text = STATUS_HEX_FORMAT
            Else
                If RetStat > 0 Then
                    StatusBar1.Panels(PANEL_STATUS).Text = STATUS_HEX_IMPORTED
                Else
                    StatusBar1.Panels(PANEL_STATUS).Text = STATUS_INVALID_HEX
                End If
            End If
                    
        Case "Connect"
            If Toolbar1.Buttons(4).Value = tbrUnpressed Then
                DisconnectDev
            Else
                ConnectToPIC
            End If
            
        Case "Write"
        
            Dim MyButtons
            MyButtons = MsgBox("OVERWRITE PROGRAM FLASH" & vbCrLf & "Do you want to continue?", vbYesNo, "Disable Bootloader...")
            If MyButtons = vbNo Then   ' User chose Yes.
                Exit Sub   ' Perform some action.
            End If
                
            If gPeakAddr = 0 Then
                MsgBox "NO Hex Data Available. Please load a Hex file."
                Exit Sub
            End If
                    
            frmBootload.MousePointer = 13
            SetDisplayMode MODE_WORKING
            StatusBar1.Panels(PANEL_STATUS).Text = "Programming..."
            If WriteDevice Then
                 StatusBar1.Panels(PANEL_STATUS).Text = STATUS_FINISHED
            Else
                 StatusBar1.Panels(PANEL_STATUS).Text = STATUS_WRITE_FAILURE
            End If

            SetDisplayMode MODE_CONNECTED_IDLE
            frmBootload.MousePointer = 0
            
        Case "Verify"
        
            If gPeakAddr = 0 Then
                MsgBox "NO Hex Data Available. Please load a Hex file."
                Exit Sub
            End If
                    
            frmBootload.MousePointer = 13
            SetDisplayMode MODE_WORKING
            StatusBar1.Panels(PANEL_STATUS).Text = "Verifying..."
            If VerifyDevice Then
                 StatusBar1.Panels(PANEL_STATUS).Text = STATUS_FINISHED
            Else
                 StatusBar1.Panels(PANEL_STATUS).Text = STATUS_VERIFY_FAILURE
            End If

            SetDisplayMode MODE_CONNECTED_IDLE
            frmBootload.MousePointer = 0
            
        Case "Erase"

            MyButtons = MsgBox("ERASE PROGRAM FLASH CONTENTS" & vbCrLf & "Do you want to continue?", vbYesNo, "Disable Bootloader...")
            If MyButtons = vbNo Then   ' User chose Yes.
                Exit Sub   ' Perform some action.
            End If
                
            frmBootload.MousePointer = 13
            SetDisplayMode MODE_WORKING
            StatusBar1.Panels(PANEL_STATUS).Text = "Erasing..."
            If EraseDevice Then
                 StatusBar1.Panels(PANEL_STATUS).Text = STATUS_FINISHED
            Else
                 StatusBar1.Panels(PANEL_STATUS).Text = STATUS_ERASE_FAILURE
            End If

            SetDisplayMode MODE_CONNECTED_IDLE
            frmBootload.MousePointer = 0

        Case "Run"

            GotoRunMode
            DisconnectDev
            StatusBar1.Panels(PANEL_STATUS).Text = STATUS_RUNMODE_SET
            
    End Select
End Sub




Private Sub Toolbar1_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
    If Button = 2 Then
        MsConFlag = 2
        PopupMenu M_About, vbPopupMenuRightButton
    End If
End Sub

'******************************************************************************



Private Sub DisconnectDev()

    Me.txtOperation = "Disconnected"
    Me.ProgressBar1.Value = 0
    DoEvents

    gDevicePFMSz = 0
    gDeviceID = 0
    
    'close the port
    If PicBootS.PortHandle > 0 Then
        ClosePIC (PicBootS.PortHandle)
        PicBootS.PortHandle = -1
    End If
    
    Toolbar1.Buttons(4).Value = tbrUnpressed
    StatusBar1.Panels(PANEL_STATUS).Text = STATUS_NOT_CON
    StatusBar1.Panels(PANEL_FWVER).Text = " "
    StatusBar1.Panels(PANEL_DEVICE).Text = " "

    SetDisplayMode (MODE_NOT_CONNECTED)

End Sub



Private Sub SetDisplayMode(DspMode As Integer)
    
    Toolbar1.Buttons(1).Enabled = True
    Toolbar1.Buttons(4).Enabled = True
    Toolbar1.Buttons(5).Enabled = False
    Toolbar1.Buttons(6).Enabled = False
    Toolbar1.Buttons(7).Enabled = False
    Toolbar1.Buttons(9).Enabled = False
    
    M_FPPort(1).Enabled = True
    M_FPPort(2).Enabled = True
    M_FPPort(3).Enabled = True
    M_FPPort(4).Enabled = True
    M_FPPort(5).Enabled = True
    M_FPPort(6).Enabled = True
    M_FPPort(7).Enabled = True
    M_FPPort(8).Enabled = True
    M_FPPort(9).Enabled = True
    M_FPPort(10).Enabled = True
    
    M_FPBaud(1).Enabled = True
    M_FPBaud(2).Enabled = True
    M_FPBaud(3).Enabled = True
    M_FPBaud(4).Enabled = True
    M_FPBaud(5).Enabled = True
    M_FPBaud(6).Enabled = True
    M_FPBaud(7).Enabled = True
    M_FPBaud(8).Enabled = True
    
    
    If (DspMode And MODE_CONNECTED_IDLE) Then
    
        Toolbar1.Buttons(1).Enabled = True 'open
        Toolbar1.Buttons(4).Enabled = True 'connect
        Toolbar1.Buttons(5).Enabled = True 'Prog
        Toolbar1.Buttons(6).Enabled = True 'verify
        Toolbar1.Buttons(7).Enabled = True 'erase
        Toolbar1.Buttons(9).Enabled = True 'run
        
    End If
    
    If (DspMode And MODE_WORKING) Then
    
        Toolbar1.Buttons(1).Enabled = False 'open
        Toolbar1.Buttons(4).Enabled = False 'connect
        Toolbar1.Buttons(5).Enabled = False 'Prog
        Toolbar1.Buttons(6).Enabled = False 'verify
        Toolbar1.Buttons(7).Enabled = False 'erase
        Toolbar1.Buttons(9).Enabled = False 'run
         
        M_FPPort(1).Enabled = False
        M_FPPort(2).Enabled = False
        M_FPPort(3).Enabled = False
        M_FPPort(4).Enabled = False
        M_FPPort(5).Enabled = False
        M_FPPort(6).Enabled = False
        M_FPPort(7).Enabled = False
        M_FPPort(8).Enabled = False
        M_FPPort(9).Enabled = False
 	M_FPPort(10).Enabled = False
        
        M_FPBaud(1).Enabled = False
        M_FPBaud(2).Enabled = False
        M_FPBaud(3).Enabled = False
        M_FPBaud(4).Enabled = False
        M_FPBaud(5).Enabled = False
        M_FPBaud(6).Enabled = False
        M_FPBaud(7).Enabled = False
        M_FPBaud(8).Enabled = False
    
    
    End If
    

    
End Sub



