Attribute VB_Name = "FileAccess"
Private Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long
Public gPeakAddr As Long

Public Function GetSetting(INISection As String, INIKey As String) As String
    Dim MyString As String
    
    MyString = "                                                      "
    RetStat = GetPrivateProfileString(INISection, INIKey, "", MyString, 20, VB.App.Path & "\" & VB.App.EXEName & ".INI")
    GetSetting = Mid(MyString, 1, InStr(1, MyString, Chr(0), vbBinaryCompare) - 1)
End Function

Public Function SetSetting(MySetting As String, INISection As String, INIKey As String) As Long
    SetSetting = WritePrivateProfileString(INISection, INIKey, MySetting, VB.App.Path & "\" & VB.App.EXEName & ".INI")
End Function


Public Function ImportP32HEXFile(InHEXFile As String) As Integer
    Dim FileLine
    Dim InData(256) As Byte

    Dim LineData As String
    Dim LineDataCount As Byte
    Dim LineAddr As Long
    Dim LineCode As Byte

    Dim DataCount As Byte
    Dim OutAddr As Long
    Dim LongAddr As Long
    Dim Checksum As Long
    Dim OutOffset As Long

    Dim OutLine As String

    Dim LineAddrHigh As Long
        
    'Examine the HEX file for incompatability
    ImportP32HEXFile = ValidateHEXFile(InHEXFile)
    If ImportP32HEXFile < 0 Then
        MsgBox "Hex File Error..."
        Exit Function
    End If

    Set fs = CreateObject("Scripting.FileSystemObject")
    Set InFile = fs.OpenTextFile(InHEXFile, 1, False, 0)

    gPeakAddr = 0

    For i = 0 To 520000
        gDataBfr(i) = &HFF
    Next i

    Do While InFile.AtEndOfStream <> True
        FileLine = InFile.ReadLine

        LineCode = 0
        If Mid(FileLine, 1, 1) = ":" Then
            'Parse the line
            LineDataCount = Val("&H" & Mid(FileLine, 2, 2))
            LineAddr = Val("&H1" & Mid(FileLine, 4, 4)) And 65535
            LineCode = Val("&H" & Mid(FileLine, 8, 2))
            LineData = Mid(FileLine, 10, (LineDataCount * 2))

            Select Case LineCode
                Case 0
                    If LineAddrHigh >= &H1D00 And LineAddrHigh <= &H1D08 Then

                        OutAddr = (LineAddrHigh * 65536) + (LineAddr And 65535)

                        For i = 0 To LineDataCount - 1
                            gDataBfr(OutAddr - &H1D000000 + i) = Val("&H" & Mid(LineData, (i * 2) + 1, 2))
                        Next i

                        OutAddr = OutAddr + LineDataCount
                        If OutAddr > gPeakAddr Then gPeakAddr = OutAddr

                    End If
                   
                Case 1
                    Exit Do
                    
                Case 4
                    LineAddrHigh = (Val("&H1" & Mid(FileLine, 10, 4)) And 65535)
                                        
            End Select
        End If
    Loop

End Function

Function ValidateHEXFile(InHEXFile As String) As Integer
    Dim Checksum As Integer
    Dim InFileLine As String
    Dim DataCount As Integer
    Dim AddrCode As Integer
    Dim Address As Long
    Dim DataByte As Integer
        
    On Error GoTo ErrorHandler
    
        
    Set fs = CreateObject("Scripting.FileSystemObject")
    ChDir VB.App.Path
    Set InFile = fs.OpenTextFile(InHEXFile, 1, False, 0)
    
    'Check for an empty file
    If InFile.AtEndOfStream = True Then
        ValidateHEXFile = -1
        InFile.Close
        Exit Function
    End If
    
    'Validate the file before using it
    Do While InFile.AtEndOfStream <> True
        InFileLine = InFile.ReadLine
        
        AddrCode = 0
        If Mid(InFileLine, 1, 1) = "" Then
            DataByte = Asc(" ")
        Else
            DataByte = Asc(Mid(InFileLine, 1, 1))
        End If
        
        'check the line
        Select Case DataByte
            Case Asc(":")
                AddrCode = Val("&H" & Mid(InFileLine, 8, 2))
                DataCount = Val("&H" & Mid(InFileLine, 2, 2))
                Address = Val("&H1" & Mid(InFileLine, 4, 4)) And 65535

            
                Checksum = 0
                For i = 0 To DataCount + 4
                    Checksum = Checksum + Val("&H" & Mid(InFileLine, (2 * i) + 2, 2))
                Next i
            
                If (Checksum And 255) <> 0 Then
                    ValidateHEXFile = -3
                    InFile.Close
                    Exit Function
                End If
            Case Asc(" "), Asc(vbTab), Asc(vbCr), Asc(vbLf)
            Case Else
                ValidateHEXFile = -4
                InFile.Close
                Exit Function
        End Select
        
        If AddrCode = 1 Then
            Exit Do
        End If
        
        If InFile.AtEndOfStream = True Then
            ValidateHEXFile = -5
            InFile.Close
            Exit Function
        End If
    Loop
    
    If ValidateHEXFile <> -2 Then
        ValidateHEXFile = 1
    End If
    
    InFile.Close
    Exit Function
    
ErrorHandler:
    Err.Clear
    ValidateHEXFile = -6
    InFile.Close
End Function

