;------------------------
; Save parameters to EEPROM
;


_saveToEEPROM
	banksel	EEADR
	clrf	EEADR
	movfw	flags
	call	_EEPROMwrite
	banksel	PORTA
	return


_EEPROMwrite
	banksel		PIR2
	bcf		PIR2, EEIF
	banksel	EEADR
	movwf	EEDATA
	banksel	EECON1
	ifdef	EEPGD
	bcf		EECON1, EEPGD
	endif
	bsf		EECON1, WREN
	bcf		INTCON, GIE
_EEPROMwrite2
	btfsc	INTCON, GIE
	goto	_EEPROMwrite2	; ensure GIE wasn't reset by Int Handler
	
	movlw	0x55
	movwf	EECON2
	movlw	0xAA
	movwf	EECON2
	bsf		EECON1, WR
	bcf		EECON1, WREN
	bsf		INTCON, GIE
	banksel	PIR2
_waitWriteDone
	btfss	PIR2, EEIF
	goto	_waitWriteDone
	banksel	EEADR
	return


_EEPROMread
	banksel	EEADR
	movwf	EEADR
	banksel	EECON1
	ifdef	EEPGD
	bcf		EECON1, EEPGD
	endif
	bsf		EECON1, RD
	banksel	EEDATA
	movfw	EEDATA
	banksel	PORTA
	return


_EEPROMboot	clrw
	call	_EEPROMread
	andlw	(1<<intEdge | 1<<suppressZeros)
	movwf	flags
	return


_readPreset
	nop
	movlw	.1
	call	_EEPROMread
	movwf	loadThou
	movlw	.2
	call	_EEPROMread
	movwf	loadHund
	movlw	.3
	call	_EEPROMread
	movwf	loadTens
	movlw	.4
	call	_EEPROMread
	movwf	loadUnit
	return


_savePreset
	movlw	.1
	banksel	EEADR
	movwf	EEADR
	banksel	PORTA
	movfw	loadThou
	call	_incEEwrite
	movfw	loadHund
	call	_incEEwrite
	movfw	loadTens
	call	_incEEwrite	
	movfw	loadUnit


_incEEwrite
	call	_EEPROMwrite
	banksel	EEADR
	incf	EEADR,F
	banksel	PORTA
	return