;------------------------------------------------------------------------
; 4-digit up/down counter
; for PIC16F88
; http://picprojects.org.uk
; 30-04-2009 
; counter2009.asm
;
; I wrote this for a bit of fun. If you find it useful
; that's great, if it doesn't do what you want, well
; it didn't cost you anything did it :-)
;
; Students:  
; This code isn't commented, good luck to you working out
; how it functions.  If you can pass it off as your own work
; you deserve what you get.
;
; Please don't ask me for help modifying it to do what you
; want rather than what it does because it is what it is.
;
; Notes:
; ----------------------------------------------------
; Fixed issue with reset button not working unless
; preset setup executed
;
; Added function to save preset counter value to EEPROM
; and restore it when after a power cycle
;

	ifdef	__16F88
		list	p=16f88		; 16F88 can be used
		#include "p16f88.inc"
	
;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF
T1Count	EQU	.2000
	endif

	ifdef	__16F87
		list	p=16f87		; 16F87 can be used
		#include "p16f87.inc"
	
;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF
T1Count	EQU	.2000
	endif

	ifdef	__16F627
		list	p=16f627		; 16F627 can be used
		#include <p16f627.inc>	; processor specific variable definitions
		__CONFIG _CP_OFF & DATA_CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _INTOSC_OSC_NOCLKOUT & _MCLRE_ON & _LVP_OFF
		#define	PIR2	PIR1
T1Count	EQU	.1000
	endif
	ifdef	__16F627A
		list	p=16f627A		; 16F627A can be used
		#include <p16f627A.inc>	; processor specific variable definitions
		__CONFIG _CP_OFF & DATA_CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _INTOSC_OSC_NOCLKOUT & _MCLRE_ON & _LVP_OFF
		#define	PIR2	PIR1
T1Count	EQU	.1000
	endif

	ifdef	__16F628
		list	p=16f628		; 16F628 can be used
		#include <p16f628.inc>	; processor specific variable definitions
		__CONFIG _CP_OFF & DATA_CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _INTOSC_OSC_NOCLKOUT & _MCLRE_ON & _LVP_OFF
		#define	PIR2	PIR1
T1Count	EQU	.1000
	endif
	ifdef	__16F628A
		list	p=16f628A		; 16F628A can be used
		#include <p16f628A.inc>	; processor specific variable definitions
		__CONFIG _CP_OFF & DATA_CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _INTOSC_OSC_NOCLKOUT & _MCLRE_ON & _LVP_OFF
		#define	PIR2	PIR1
T1Count	EQU	.1000
	endif

	ifdef	__16F648A
		list	p=16f648A		; 16F648A can be used
		#include <p16f648A.inc>	; processor specific variable definitions
		__CONFIG _CP_OFF & DATA_CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _INTOSC_OSC_NOCLKOUT & _MCLRE_ON & _LVP_OFF
		#define	PIR2	PIR1
T1Count	EQU	.1000
	endif


;###########################################################################

	org	0x2100
	de	0xFF	; mode 

	org	0x2101
	de 0,0,0,0x55		; counter preset
	
	org	0x2108
	de "counter2009.asm"

;###########################################################################

          errorlevel -302     ; suppress banksel warning messages
          errorlevel -311     ; suppress HIGH operator warning messages

	cblock 0x20
	debounce
	Unit
	Tens
	Hund
	Thou
	unit7seg
	tens7seg
	hund7seg
	thou7seg
	indLED
	mplxrot
	keyNow
	keyLast
	keyEdge
	loadUnit
	loadTens
	loadHund
	loadThou
	state

	endc

	cblock 0x70
	Wisr
	Sisr
	flags

	endc

; indicator LEDs 
overflow	equ 0
hold		equ 1
up			equ 2
down		equ 3


; flag bits
invert			equ 0
suppressZeros	equ 1
resetNext		equ 2
keysReady		equ 3
intEdge			equ 4

#define	digitDrive 	PORTA
#define	segmentDrive	PORTB
#define	overflowPulse	PORTA,7
#define	switchIn	PORTA,6
#define	countIn		PORTB,0




	org 0x000
	nop
	clrf	PCLATH
	goto	_main
	
	org 0x004

	#include counter_functions.inc
	#include counter_eeprom.inc
	#include counter_main.inc


	end
