
;-----------------------------------------------------------------------------------------

_main
	clrf	STATUS
	clrf	PORTB

;	clrf	Unit
;	clrf	Tens
;	incfsz	Tens,F
;	goto	$-1
;	incfsz	Unit,F
;	goto	$-3

	
	ifdef	OSCCON
	banksel	OSCCON
	movlw	b'01110000'	; set OSCCON for internal RC oscillator
	movwf	OSCCON		; running at 8Mhz
	endif
	
	banksel	OPTION_REG
	movlw	b'00000000'	; enable weak pull up on PORTB
	movwf	OPTION_REG

	ifdef	ANSEL
	banksel	ANSEL
	clrf	ANSEL	; Set I/O ports for digital mode
	endif

	ifdef	CMCON
	banksel	CMCON
	movlw	7
	movwf	CMCON
	endif

	banksel	TRISA
	movlw	b'00000001'
	movwf	TRISB

	movlw	b'01100000'
	movwf	TRISA

	banksel	PORTA

	movlw	0xFF
	movwf	PORTB
	movlw	0x08
	movwf	PORTA
	
	call	_clear
	clrf	indLED


	movlw	.0
	movwf	loadUnit
	movwf	loadTens
	movwf	loadHund
	movwf	loadThou


						; If you want it to default to count down at power up
						; swap the bsf/bcf instructions here
	bsf		indLED, up
	bcf		indLED, down
	
	movlw	0xFF
	movwf	keyNow
	movwf	keyLast
	movlw	.5
	movwf	debounce

	movlw 	b'00000100'	; Enable Timer 2 and configure for
	movwf	T2CON		; 1:1 pre and postscale


		
	movlw	b'00001011'	; configure Timer one for Compare mode
	movwf	CCP1CON		; and Special Event Trigger function
	movlw	LOW T1Count	; Setup the compare registers to T1Count
	movwf	CCPR1L		; set the CCP1IF every 1mS
	movlw	HIGH T1Count
	movwf	CCPR1H
	movlw	b'00000001'
	movwf	T1CON



	
	call	_EEPROMboot
	call	_readPreset

	bsf		flags, invert

	movlw	b'00010000'
	movwf	mplxrot

	btfsc	switchIn	; test if SW1 down
	call	_config

	clrf	state

	banksel	OPTION_REG
	btfsc	flags, intEdge
	bsf		OPTION_REG, INTEDG
	
	banksel	PORTA

	bsf		INTCON, INTE
	bsf		INTCON, GIE		; enable Global interrupt


;---------------------------------------------------------------------------

;
; core code loop
;
_coreLoop
	btfsc	PIR1,CCP1IF		; 1mS timer tick
	call	_timerTick
	goto	_coreLoop
		
_timerTick
	bcf		PIR1,CCP1IF		; clear timer 1 int' flag
	call	_dec7seg
	call	_multiplex
	btfss	flags, keysReady
	return
	
	bcf		flags, keysReady
	
	btfsc	keyEdge,0	; up/down
	call	_upDown

	btfsc	keyEdge,1	; reset
	call	_resetCounter	

	btfsc	keyEdge,2	; hold
	call	_hold

	btfsc	keyEdge,3	; load
	call	_load

	btfsc	keyEdge,4	; increment
	call	_loadInc
	
	return