_isr
	movwf	Wisr	
	swapf	STATUS,W		
	clrf	STATUS	
	movwf	Sisr
	bcf		INTCON, INTF	 ; reset INTF
	bcf		indLED, overflow
	bcf		overflowPulse


	
	btfss	flags, resetNext
	goto	_counter
	call	_resetCounter
	bcf		flags, resetNext




; Up/Down counter function
;
_counter	

	btfss	indLED, up
	goto	_borrow
	;goto	countDown


_countUp
	bcf		indLED, overflow
	incf	Unit,F
	movlw	.10
	xorwf	Unit,W
	bnz		_carry
	clrf	Unit
	
	incf	Tens,F
	movlw	.10
	xorwf	Tens,W
	bnz		_carry
	clrf	Tens

	incf	Hund,F
	movlw	.10
	xorwf	Hund,W
	bnz		_carry
	clrf	Hund

	incf	Thou,F
	movlw	.10
	xorwf	Thou,W
	bnz		_carry
	clrf	Thou
	
_carry
	movfw	Unit
	xorwf	loadUnit,W
	bnz		_exitInt
	movfw	Tens
	xorwf	loadTens,W
	bnz		_exitInt
	movfw	Hund
	xorwf	loadHund,W
	bnz		_exitInt
	movfw	Thou
	xorwf	loadThou,W
	bnz		_exitInt
	
	btfss	indLED, hold
	goto	_upNoHold

	
_upHold
	bsf		indLED, overflow
	bsf		overflowPulse
	bsf		flags, resetNext
	bcf		INTCON, INTE
	goto	_exitInt

_upNoHold
	call	_resetCounter	
	bsf		indLED, overflow
	bsf		overflowPulse
	goto	_exitInt


;----------------------


_borrow	
	nop
_countDown
	movlw	0x09

	decf	Unit,F	; decrement units
	btfss	Unit,7	; test for underflow
	goto	_testZ	; done
	movwf	Unit	; set units back to 9

	decf	Tens,F
	btfss	Tens,7
	goto	_testZ
	movwf	Tens
	
	decf	Hund,F
	btfss	Hund,7
	goto	_testZ
	movwf	Hund
	
	decf	Thou,F
	btfss	Thou,7
	goto	_testZ
	movwf	Thou


_testZ
	movfw	Unit
	iorwf	Tens,W
	iorwf	Hund,W
	iorwf	Thou,W
	bnz		_exitInt

	bsf		indLED, overflow
	bsf		overflowPulse
	bsf		flags, resetNext

	btfsc	indLED, hold
	bcf		INTCON,INTE

	
_exitInt
	swapf	Sisr,W	
	movwf	STATUS	
	swapf	Wisr,F	
	swapf	Wisr,W	
	retfie


; Lookup decimal value in W and convert to 
; 7 segment display data
;
; 000
;5   1
;5   1
; 666
;4   2
;4   2
; 333

_lookup
	addwf	PCL,F
			; 76543210
	retlw	b'00111111'	;0
	retlw	b'00000110'	;1
	retlw	b'01011011'	;2
	retlw	b'01001111'	;3
	retlw	b'01100110'	;4
	retlw	b'01101101'	;5
	retlw	b'01111101'	;6
	retlw	b'00000111'	;7
	retlw	b'01111111'	;8
	retlw	b'01101111'	;9
	retlw	b'00000000'	;blank (10)
	retlw	b'01000000'	;-     (11)
	retlw	b'01010000'	; r    (12)
	retlw	b'00011000'	; L    (13)
_lookupend

	if (high(_lookup)!=high(_lookupend))
		error("_lookup page error")
	endif



; Clear counter to zero
;
_resetCounter
	movf	state,F
	skpz
	return
	bcf		INTCON, INTF
	bsf		INTCON, INTE
	bcf		flags, resetNext
	bcf		indLED, overflow
	bcf		overflowPulse
	btfss	indLED,up
	goto	_preset
	


_clear
	clrf	Unit
	clrf	Tens
	clrf	Hund
	clrf	Thou
	return

_preset
	movfw	loadUnit
	movwf	Unit
	movfw	loadTens
	movwf	Tens
	movfw	loadHund
	movwf	Hund
	movfw	loadThou
	movwf	Thou
	
	return



; Toggle up/down counter setting

_upDown
	movlw	(1<<up | 1<<down)
	xorwf	indLED,F
	return


; Toggle hold counter setting
;
_hold
	movlw	1<<hold
	xorwf	indLED,F
	bcf	INTCON, INTF
	bsf	INTCON, INTE
	return


; Convert count data to 7 seg display data
;
_dec7seg
	movfw	Unit
	call	_lookup
	movwf	unit7seg
	movfw	Tens
	call	_lookup
	movwf	tens7seg
	movfw	Hund
	call	_lookup
	movwf	hund7seg
	movfw	Thou
	call	_lookup
	movwf	thou7seg
	
	btfss	flags, suppressZeros
	return

_blankZeros
	movf	state,f	; don't suppress zero's when presetting
	skpz
	return
	movlw	.10
	call	_lookup	; load W with blank

	movf	Thou,F
	skpz
	return
	movwf	thou7seg

	movf	Hund,F
	skpz
	return
	movwf	hund7seg
	
	movf	Tens,F
	skpnz	
	movwf	tens7seg
	return


_multiplex
	movfw	digitDrive
	andlw	0x80
	movwf	digitDrive
	movlw	b'00010000'
	rrf		mplxrot,F
	skpnc
	movwf	mplxrot
	
	btfsc	mplxrot,0
	rlf		unit7seg,W
	btfsc	mplxrot,1
	rlf		tens7seg,W
	btfsc	mplxrot,2
	rlf		hund7seg,W
	btfsc	mplxrot,3
	rlf		thou7seg,W
	btfsc	mplxrot,4
	rlf		indLED,W
	
 	btfsc	flags, invert
	xorlw	0xFF
	movwf	segmentDrive

	movfw	digitDrive
	andlw	0x80
	iorwf	mplxrot,W
	movwf	digitDrive
	
	nop		; ensure digitDrive I/O line has gone high
	nop		; before we test switchIn
	nop		; Works with one NOP, two more to be sure.

	btfsc	switchIn
	iorwf	keyNow,F
	comf	mplxrot,W
	btfss	switchIn
	andwf	keyNow,F
	btfss	mplxrot,0
	return

	decfsz	debounce,F
	return
	movlw	.5
	movwf	debounce

	movfw	keyLast
	xorwf	keyNow,W
	andwf	keyNow,W
	movwf	keyEdge

	movfw	keyNow
	movwf	keyLast
	bsf		flags, keysReady

	return


;---------------------------------------------------------
_load
	bcf	INTCON, INTE
	bcf	INTCON, INTE
	movf	state,F
	bnz	_loadNext
	movlw	.11
	movwf	Thou
	movwf	Hund
	movwf	Tens
	clrf	Unit
	incf	state,F
	movlw	Unit
	movwf	FSR
	return

_loadNext
	movfw	FSR
	xorlw	Thou
	bz		_loadExit
	incf	FSR,F
	clrf	INDF
	return
	
	
_loadExit
	movfw	Unit
	movwf	loadUnit
	movfw	Tens
	movwf	loadTens
	movfw	Hund
	movwf	loadHund
	movfw	Thou
	movwf	loadThou
	clrf	Unit
	clrf	Tens
	clrf	Hund
	clrf	Thou
	clrf 	state

	call	_savePreset

	bcf		INTCON, INTF
	bsf		INTCON, INTE
	return


_loadInc
	movf	state,F
	skpnz
	return
	incf	INDF,F
	movfw	INDF
	xorlw	.10
	skpnz
	clrf	INDF
	return

;--------------------------------------------------------------------
; Power on config function

_config
	movlw	b'00010000'
	movwf	state
	call	_configNext
	
_configLoop
	btfss	PIR1,CCP1IF	; 1mS timer tick
	goto	_configLoop

	bcf		PIR1,CCP1IF	; 

	call	_multiplex
	btfss	flags, keysReady
	goto	_configLoop

	bcf		flags, keysReady

	btfsc	keyEdge,4
	call	_configNext

	btfss	keyEdge,3
	goto	_configLoop
		
	clrf	state
	call	_saveToEEPROM
	call	_resetCounter

	return


_configNext
	movlw	b'0001000';
	rrf		state,F
	skpnc
	movwf	state
	
	btfsc	state,0
	goto	_rzs
	btfsc	state,1
	goto	_fzs
	btfsc	state,2
	goto	_rnzs
	goto	_fnzs
	

_fnzs
	bcf		flags, suppressZeros
	bcf		flags, intEdge
	movlw	.13
	movwf	Thou
	movlw	.0
	movwf	Hund
	movwf	Tens
	movwf	Unit
	goto	_dec7seg

_rnzs
	bcf		flags, suppressZeros
	bsf		flags, intEdge
	movlw	.12
	movwf	Thou
	movlw	.0
	movwf	Hund
	movwf	Tens
	movwf	Unit
	goto	_dec7seg

_fzs
	bsf		flags, suppressZeros
	bcf		flags, intEdge
	movlw	.13
	movwf	Thou
	movlw	.10
	movwf	Hund
	movwf	Tens
	movlw	.0
	movwf	Unit
	goto	_dec7seg

_rzs
	bsf		flags, suppressZeros
	bsf		flags, intEdge
	movlw	.12
	movwf	Thou
	movlw	.10
	movwf	Hund
	movwf	Tens
	movlw	.0
	movwf	Unit
	goto	_dec7seg

