/*
 * Program to generate a Testfile for a DCF77 Time Signal
 * to be used by ISIS VSM written in C#
 * First 20 Bits are all zero.
 * There is header of 6 zero bytes, followed by a sync byte.
 * Those are numbered 100+ in the Doc-File
 * Only the min field is incremented, so no hour/data rollover 
 * in this Version.
 * Output File is DCF77.txt for ISIS and DCF77_Doc.txt for 
 * Documentation (Isis does not support comments in Input files).
 * Output Dir is D:\_AVR\DCF77\ adapt to your system
 * Version 1.0 by fgv 9.4.2008
 * Start Time of the DCF77 Telegrams is 10.4.2008 9:15,
 * there are 7 Telegrams, total time 7 min
 */

using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Threading;
using System.Globalization;

namespace DCF77
{
    public class Program
			
    {
			public static StreamWriter output;
			public static StreamWriter outdoc;

			public static double TimePos;
			public static string dcf77;
			public static int BitNumber = 0;
			public static bool parity;
			public static int test;

				public static byte ToBCD(byte X) {
					byte res;
					res = (byte) ((X / 10) << 4);
					res += (byte)(X % 10);
					return res;
				}


			public static bool bitout(byte a, int Anzahl)
			{

				a = ToBCD(a);
				parity = false;
				test = 0;
				
				for (int i = 0; i < Anzahl; i++)
				{
					if ((a & 0x01) != 0)
					{
						EinsPuls(ref TimePos);
						parity = !parity;    // invert parity

					}	else {
						NullPuls(ref TimePos);
					}
					a = (byte) (a >> 1);
				}
				return parity;
			}
			
        public static void EinsPuls(ref double TimePos) {
					output.WriteLine(" ");
					TimePos += 0.001;
					output.WriteLine ("{0:f4} 0",TimePos);  // Pulse am Anfang High
					TimePos += .198;
					output.WriteLine("{0:f4} 0",TimePos);  // Fallende Flanke 0.1ms
					TimePos += .001;
					output.WriteLine("{0:f4} 5",TimePos);  // Langer Puls 198 ms low
					TimePos += .800;
					output.WriteLine("{0:f4} 5",TimePos);		// Rest der Sekunde high
					outdoc.WriteLine("Bit #{0:d2} Value: 1", BitNumber++);
					}

				public static void NullPuls(ref double TimePos)	{
					output.WriteLine(" ");
					TimePos += 0.001;
					output.WriteLine("{0:f4} 0", TimePos);  // Pulse am Anfang High
					TimePos += .098;
					output.WriteLine("{0:f4} 0", TimePos);  // Fallende Flanke 0.1ms
					TimePos += .001;
					output.WriteLine("{0:f4} 5", TimePos);  // Langer Puls 198 ms low
					TimePos += .900;
					output.WriteLine("{0:f4} 5", TimePos);		// Rest der Sekunde high
					outdoc.WriteLine("Bit #{0:d2} Value: 0", BitNumber++);
					}

				public static void LeerPuls(ref double TimePos) {
					output.WriteLine(" "); 
					TimePos += 1.0;
					output.WriteLine("{0:f4} 5", TimePos);		// Rest der Sekunde high
					outdoc.WriteLine("Bit #{0:d2} Value: Empty", BitNumber++);
					outdoc.WriteLine("");
					}

				static void Main(string[] args)
        {
					
					

					byte	jahr = 08,					// Do, 10.4.2008 9:15
								monat  = 04,
								tag  = 10,
								wotag = 4,
								hour = 9,
								min = 15,
								sec = 0;

					bool parity;

					

					
					File.Delete("D:\\_AVR\\DCF77\\DCF77.txt");
					output = File.AppendText("D:\\_AVR\\DCF77\\DCF77.txt");

					File.Delete("D:\\_AVR\\DCF77\\DCF77_Doc.txt");
					outdoc = File.AppendText("D:\\_AVR\\DCF77\\DCF77_Doc.txt");
					BitNumber = 70;


					Thread.CurrentThread.CurrentCulture = new CultureInfo("en-US");  //Wegen Dezimalpunkt

					parity = false;
					TimePos = 0.0;
					output.WriteLine("{0:f4} 5", TimePos);		// 1. Wert in DCF77.txt 0.0  5

					BitNumber = 100;
					for (int m = 0; m < 7; m++) {  // Dummy Pulses + Sync
						NullPuls(ref TimePos);
						}
						LeerPuls(ref TimePos);					
					
					
					// from here on synchronized telegrams
					// First 20 bits zero! (not used by the clock)
				
					for (int k = 0; k < 8; k++) {				// 7 complete DCF77 Telegrams
						BitNumber = 1;

						// Ausgabe erste 20 bits null
						for (int j = 0; j < 20; j++)
						{
							NullPuls(ref TimePos);
						}

						// Ausgabe minute
						outdoc.WriteLine("Minute: {0:d2}", min);
						if ((bitout(min, 7) )) { // wenn parity ungerade, eine zustzliche 1 ausgeben
							EinsPuls(ref TimePos);
						} else {
							NullPuls(ref TimePos);					// sonst ne 0
						}

						// Ausgabe Stunde
						parity = false;
						outdoc.WriteLine("Stunde: {0:d2}", hour);
						if ((bitout(hour, 6)))  
							EinsPuls(ref TimePos);
						 else 
							NullPuls(ref TimePos);
						

						// Ausgabe Datum
						parity = false;
						outdoc.WriteLine("Datum: {0:d2}.{1:d2}.{2:d2}, Wochentag: {3:d2}", tag,monat,jahr,wotag);
						parity = bitout(tag, 6);
						parity ^= bitout(wotag, 3);
						parity ^= bitout(monat, 5);
						parity ^= bitout(jahr, 8);

						if ((parity)) {
							EinsPuls(ref TimePos);
						} else {
							NullPuls(ref TimePos);
						}
						// Telegrammende, Leerpuls
						outdoc.WriteLine("Syncbit");
						LeerPuls(ref TimePos);
						
						min++;
					}
				  output.Close();
					outdoc.Close();

			    

					Console.Write("Any key to continue:");
					Console.ReadLine();
        }
    }
}
