/*****************************************************
This program was produced by the
CodeWizardAVR V1.25.9 Standard
Automatic Program Generator
 Copyright 1998-2008 Pavel Haiduc, HP InfoTech s.r.l.
http://www.hpinfotech.com

Project : 
Version : 1.1
Date    : 09.04.2008
Author  : Friedrich Vissel                
Company : Private customer                
Comments: 


Chip type           : ATmega16
Program type        : Application
Clock frequency     : 10,000000 MHz
Memory model        : Small
External SRAM size  : 0
Data Stack size     : 256
*****************************************************/

#include <mega16.h>

// Alphanumeric LCD Module functions
#asm
   .equ __lcd_port=0x12 ;PORTD
#endasm
#include <lcd.h>

#include <mega16.h> 
#include <string.h>
#include <bcd.h>
#include <stdio.h>

#define FILTER_LEN 18   // 18 Bytes = 144 Bits

#define BIT_EMPTY 0x00
#define BIT_SYNC	0x01
#define BIT_ZERO	0x02
#define BIT_ONE		0x03

#define Parity 				0x01
#define ParityError 	0x02
#define LastValid			0x04
#define SecureValid		0x08
#define CurrentValid  0x10

#define ParityBit1	28
#define ParityBit2  35
#define ParityBit3  58
#define MonthBit		50
#define DayBit			42
#define WeekDayBit  45
#define SyncBit			59

#define DCF77in PINA.0
#define SyncLed PORTB.0
#define DCFLed  PORTB.2
#define IntLed  PORTB.1 
#define ON 0
#define OFF 1

// Global Vars

char i;
char Timer200ms;
char SyncTimer;
static signed int Timer1s;


char filter[FILTER_LEN];      
char pos=0;							// Current byte position in array (0..FILTER_LEN - 1)   
char bpos =1;			  		// Currently selected bit in byte (0..7)
char ingral=0;  				// The integral over filter values
int inmax=0;
int incnt=0;
unsigned char TimeStat = 0xFF;

/* Timestamp definition */
typedef struct {
	unsigned int  year;
	unsigned char month;
	unsigned char weekday;
	unsigned char day;
	unsigned char hour;
	unsigned char minute;
	unsigned char second;
} sTimeStamp, *pTimeStamp;

sTimeStamp tsLastValid;
sTimeStamp tsCurrent;
sTimeStamp tsSecure;
sTimeStamp t;
char BitPosition;
char Status = 0;
char Value = 0;
char ValidCounter = 0;
char InvalidCounter = 0;

// Function forward declarations
void putbit (void);
void dcf77_timer( void );

//-----------------------------------------------------------------------------
// Timer 0 output compare interrupt service routine
//-----------------------------------------------------------------------------
interrupt [TIM0_COMP] void timer0_comp_isr(void) {
  DCFLed = DCF77in;   			    //@ each interrupt (625 Hz) update DCFLed 
      if (--Timer200ms == 0) {
		Timer200ms = 125;
		SyncTimer++;
		Timer1s++;
		IntLed = ~IntLed;     // changes very 200ms (for Diagnostics)
	}
	#asm("sei");
  putbit();
  #asm("cli");
}

//-----------------------------------------------------------------------------
//  Signal angepasstes Filter nach Clemens Helfmeier
//  Signal adapted filter by Clemens Helfmeier                         
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// get one bit from the stream.
// return values are:
// 0x00 no bit in stream available
// 0x02 "0" read
// 0x03 "1" read
//-----------------------------------------------------------------------------
char getbit(void) {
	char ret=0x00;
	if ((ingral < inmax/4) && (incnt > 0)) {
		if ((incnt-39) - (inmax-108) < 0) {
			ret=BIT_ONE;
		} else {
			ret=BIT_ZERO;
		}
		incnt=0;
		return ret;
	}
	return BIT_EMPTY;
}

//-----------------------------------------------------------------------------
// put one bit from the PORT into the filter
// advance the pointer in the filter array
// this function must be called regularily (done in timer0_cmp_isr)
//-----------------------------------------------------------------------------
void putbit (void) {
	unsigned char F;
	bpos = bpos << 1;		//advance pointer in array
	if(bpos==0) {
		bpos=1;
		if (++pos >= FILTER_LEN) { 
		  pos=0;
		}
	}
  F = filter[pos];
	if ((F & bpos)!= 0) { 
		ingral--;
	}
	if (DCF77in == 0) {
    F |= bpos;
    ingral++;
  } else {
    F &= ~bpos;
  }
	filter[pos] = F;
  if ((inmax - ingral) <= 3) {
    incnt++;
  }
  if ((ingral == inmax +1)) {
    inmax = ingral;
    incnt = 1;
  }
  if ((incnt == 0) && (ingral <= 3)) {
    inmax = 3;
	}
}

//-----------------------------------------------------------------------------
// get the current time
// return values are:
// 0x00 success
// 0x02 no time avail
// 0xFF invalid param
//-----------------------------------------------------------------------------

unsigned char dcf77_getTime(pTimeStamp ts) {
	if (ts == 0) 
	  return 0xFF;
	if ((Status & SecureValid) != 0) {
	  memcpy(ts, &tsSecure, sizeof(tsSecure));
	  return 0;
	}
	return 0x02;
}

//-----------------------------------------------------------------------------
// Input one bit into the decoder, 0 means bit of value 0, 
// any other value is interpreted as value 1
//-----------------------------------------------------------------------------
void dcf77_putBit(char inbit) {
	if (inbit != 0)
		Status ^= Parity;			// Parity Bit umschalten wenn Bit = 1
	switch (BitPosition) {
		case 20:
			Status &= ~Parity;  // Parity Bit lschen
			break;
		case ParityBit1:
			if ((Status & Parity) != 0)
			  goto putBit_ParityError;
			tsCurrent.minute = bcd2bin ((Value>>1) & 0x7F);
			break;
		case ParityBit2:
			if ((Status & Parity) != 0)
			  goto putBit_ParityError;
			tsCurrent.hour = bcd2bin ((Value>>2) & 0x3F);
			break; 
		case ParityBit3:
			if ((Status & Parity) != 0)
			  goto putBit_ParityError;
			tsCurrent.year = bcd2bin ((Value) & 0xFF) + 2000;
			Status |= CurrentValid;
			break; 
		case MonthBit:
		  tsCurrent.month = bcd2bin((Value>>3) & 0x1F);
		  break;
		case WeekDayBit:
		  tsCurrent.weekday = bcd2bin ((Value>>5) & 0x07);
		  break;
		case DayBit:
		  tsCurrent.day = bcd2bin((Value>>2)&0x3F);
			break;
		case 4:
			if ((Status & (CurrentValid | LastValid)) == (CurrentValid | LastValid)) {
			   // wenn Current und LastValid beide gltig, vergleichen
			  if ( (tsLastValid.year == tsCurrent.year) 
			    && (tsLastValid.month == tsCurrent.month) 
			    && (tsLastValid.day == tsCurrent.day) 
			    && (tsLastValid.hour == tsCurrent.hour) 
			    && (tsLastValid.minute == tsCurrent.minute)) { 
					ValidCounter++;
			  } else {
					InvalidCounter++;
			  }  
				if ((ValidCounter + InvalidCounter)>=3) {
					if (ValidCounter > InvalidCounter) {
					  // Timestamp sollte korrekt sein
					  ValidCounter=0;
						InvalidCounter=0;
						memcpy(&tsSecure, &tsLastValid, sizeof(tsSecure)); 
						Status |= SecureValid;
					} else {
						Status &= ~LastValid;  // LastValid ungltig
					}
				}
			}
			Status &= ~CurrentValid;
			SyncLed = OFF; 
			break;
		} // switch
	if (inbit == 0) {
		Value = Value>>1;
		} else {
	  Value = Value>>1 | 0x80;
	}
	BitPosition++;
	return;
putBit_ParityError:
	Status &= ~Parity;
	Status |= ParityError;
}

//-----------------------------------------------------------------------------
// Input the synchronisation bit into the decoder
//-----------------------------------------------------------------------------
void dcf77_putSync( void ) {
	if ((BitPosition == SyncBit) && ((Status & ParityError) == 0)) {
		// the sync bit is at the correct position, there was no error
		Status |= CurrentValid;
		if ((Status & LastValid) == 0) {  // LastValid ist ungltig
			// this is the first timestamp recieved, copy it
			memcpy( &tsLastValid, &tsCurrent, sizeof( tsLastValid ) );
			tsLastValid.second = 0;   // Sec  ab hier hochzhlen
			ValidCounter = 0;
			InvalidCounter = 0;
			Status ^= (LastValid | CurrentValid);
			// LastValid gltig, Current ungltig
			// remove the current valid, 
			// we don't want to compare them already, they are equal.
		}
	}
	/* reset Parity and Error bits */
	Status &= ~(Parity | ParityError);
	BitPosition = 1;	/* synchronize */
	SyncLed = ON;
	return;
}

//-----------------------------------------------------------------------------
// Increase the given timestamp by one second
//-----------------------------------------------------------------------------
void dcf77_incTS( sTimeStamp *ts ) {
	char maxday;
	if (++ts->second >= 60) {
		ts->second = 0;
		if (++ts->minute >= 60) {
			ts->minute = 0;
			if (++ts->hour >= 24) {
			  if (++ts->weekday > 7) {
			     ts->weekday = 1;
			  }
				ts->hour = 0;
				ts->day++;
				maxday = 30;
				if (ts->month == 2) 
					maxday=28;
				else if ((ts->month < 8) && ((ts->month & 1) != 0)) 
					maxday = 31;
				else if ((ts->month >= 8) && ((ts->month & 1) == 0)) 
					maxday = 31;
			if (ts->day > maxday) {
					ts->day = 1;
					if (++ts->month > 12) {
						ts->month = 1;
						ts->year++;
					}
				}
			}
		}
	}
}

//-----------------------------------------------------------------------------
// Should be called regularily with exactly 1 Hz. It keeps track of the time.
//-----------------------------------------------------------------------------
void dcf77_timer( void ) {
	if ((Status & LastValid) != 0) 
		dcf77_incTS( &tsLastValid );
	if ((Status & SecureValid) != 0) 
		dcf77_incTS( &tsSecure );
	}
	
//-----------------------------------------------------------------------------
// Gibt die Zeit auf dem LCD aus  (time output to LCD)
//-----------------------------------------------------------------------------
void dcf77_printtime(pTimeStamp t) {
 unsigned char zeit[17];					// Variable fr das Zeit-String
 unsigned char datum[17];         // Variable fr das Datum-String
 sprintf(zeit,"%02u:%02u:%02u        ",t->hour,t->minute, t->second);
  // Wochentag
  if(t->weekday == 7) sprintf(datum,"So, ");       // First day of week is Monday, german Std.
  if(t->weekday == 1) sprintf(datum,"Mo, ");
  if(t->weekday == 2) sprintf(datum,"Di, ");
  if(t->weekday == 3) sprintf(datum,"Mi, ");
  if(t->weekday == 4) sprintf(datum,"Do, ");
  if(t->weekday == 5) sprintf(datum,"Fr, ");
  if(t->weekday == 6) sprintf(datum,"Sa, ");
  if ((t->day) <10) 	sprintf((datum+4)," %01u.",t->day); 
  if ((t->day) >=10)  sprintf((datum+4),"%02u.",t->day);

 sprintf(datum+7,"%02u.",t->month);
 sprintf(datum+10,"%04u  ", t->year);
 lcd_gotoxy(0,0);
 lcd_puts(zeit);
 lcd_gotoxy(0,1);
 lcd_puts(datum);
 }
 
//-----------------------------------------------------------------------------
// Main program loop
//-----------------------------------------------------------------------------

void main(void)
{

// Input/Output Ports initialization
// Port A initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTA=0x00;
DDRA=0x00;

// Port B initialization
// Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out 
// State7=1 State6=1 State5=1 State4=1 State3=1 State2=1 State1=1 State0=1 
PORTB=0xFF;
DDRB=0xFF;

// Port C initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTC=0x00;
DDRC=0x00;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 156,250 kHz
// Mode: CTC top=OCR0
// OC0 output: Disconnected
TCCR0=0x0B;
TCNT0=0x00;
OCR0=0xF9;      // fv nach altem Listing gendert

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: Timer 1 Stopped
// Mode: Normal top=FFFFh
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer 1 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x00;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: Timer 2 Stopped
// Mode: Normal top=FFh
// OC2 output: Disconnected
ASSR=0x00;
TCCR2=0x00;
TCNT2=0x00;
OCR2=0x00;

// External Interrupt(s) initialization
// INT0: Off
// INT1: Off
// INT2: Off
MCUCR=0x00;
MCUCSR=0x00;

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK=0x02;

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
SFIOR=0x00;

// LCD module initialization
lcd_init(16);

// Global enable interrupts
lcd_clear();
lcd_gotoxy(0,0);
lcd_putsf("WAIT FOR DCF77");
lcd_gotoxy(0,1);
lcd_putsf("<v1.1 fv>");

#asm("sei")
Timer1s = -5;

while (1){

	i = getbit();
	if ( i != BIT_EMPTY) {
  	if (SyncTimer >7)  {  
    	dcf77_putSync();
    }
  	SyncTimer = 0;
  	if (i == BIT_ONE) 
    	dcf77_putBit(1);
  	else
   		dcf77_putBit(0);
 	}
  TimeStat = dcf77_getTime(&t);
   
	if (Timer1s >= 0) {
		#asm("cli");
		PORTB.3 = ~PORTB.3;     //t Sekundensignal fr Simu
		Timer1s = Timer1s - 5;
		#asm("sei");
		dcf77_timer();
		if (TimeStat == 0) dcf77_printtime(&t);
	}


} //while	
}
