	list	b=4
        LIST    P=EEPROM8, R=DECIMAL
        INCLUDE "./MEMORY.INC"
        LIST    M=_24LC512



		errorlevel -311			; Disable "Operand of HIGH operator was larger than H'FFFF'"

branch	macro 	address, duration
			db	duration, 0xB0
			db	low(address-($+2)), high(address-($+2))
		endm

bsr		macro 	address, duration
			db	duration, 0xC8 + (upper(address) & 0x07)
			db	low(address-($+2)), high(address-($+2))
		endm

jsr		macro 	address, duration
			db	duration, 0xC0 + (upper(address) & 0x07)
			db	low(address), high(address)
		endm

do		macro	count, duration
			db	duration, 0xA0
			db	low(count), high(count)
		endm

jump	macro 	address, duration
			db	duration, 0xE0 + (upper(address) & 0x07)
			db	low(address), high(address)
		endm

loop	macro	address, duration
			db	duration, 0x90
			db	low(address-($+2)), high(address-($+2))
		endm

noop	macro	duration
			db	duration, 0x00
			db	0x00, 0x00
		endm

restart	macro	duration
			db	duration, 0xF0
			db	0x00, 0x00
		endm

ret		macro	duration
			db	duration, 0xD0
			db	0x00, 0x00
		endm

speed	macro	scode,duration
			dt	duration, 0xD0
			dt	scode & 0x0F, 0x00
		endm


Adr0:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0  
	jump	Adr2,.200	; Duration * 1ms

Adr1:			; 5 * 32 bit display pattern
	db     .255, .255, .255, .224, .192, .0, .0, .32, .223, .255, .255, .160, .192, .0, .0, .32, .255, .255, .255, .224
	jump	Adr1,.200	; Duration * 1ms

Adr2:			; 5 * 32 bit display pattern
	db     .248, .224, .241, .192, .205, .176, .219, .96, .204, .54, .216, .96, .240, .192, .217, .128, .205, .240, .243, .224
	do		.200,.250	; Duration * 1ms

Adr02:			; 5 * 32 bit display pattern
	db     .248, .224, .241, .192, .205, .176, .219, .96, .204, .54, .216, .96, .240, .192, .217, .128, .205, .240, .243, .224
	noop	.250	; Duration * 1ms

Adr3:			; 5 * 32 bit display pattern
	db     .248, .224, .241, .192, .205, .176, .219, .96, .204, .54, .216, .96, .240, .192, .217, .128, .205, .240, .243, .224
	loop	Adr02,.250	; Duration * 1ms

Adr4:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .205, .176, .219, .96, .204, .54, .216, .96, .240, .192, .217, .128, .0, .0, .0, .0
	do		.4,.125	; Duration * 1ms

Adr04:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .205, .176, .219, .96, .204, .54, .216, .96, .240, .192, .217, .128, .0, .0, .0, .0
	noop	.125	; Duration * 1ms

Adr5:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .205, .176, .219, .96, .204, .54, .216, .96, .240, .192, .217, .128, .0, .0, .0, .0
	loop	Adr04,.125		; Duration * 1ms

Adr14:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .0, .0, .0, .0, .204, .54, .216, .96, .0, .0, .0, .0, .0, .0, .0, .0
	do		.4,.125	; Duration * 1ms

Adr014:		; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .0, .0, .0, .0, .204, .54, .216, .96, .0, .0, .0, .0, .0, .0, .0, .0
	noop	.125	; Duration * 1ms

Adr15:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .0, .0, .0, .0, .204, .54, .216, .96, .0, .0, .0, .0, .0, .0, .0, .0
	loop	Adr014,.125		; Duration * 1ms

Adr16:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,.0, .0, .0, .0, .0, .0, .0, .0, .0
	do		.4,.125	; Duration * 1ms

Adr016:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,.0, .0, .0, .0, .0, .0, .0, .0, .0
	noop	.125	; Duration * 1ms

Adr17:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,.0, .0, .0, .0, .0, .0, .0, .0, .0
	loop	Adr016,.125		; Duration * 1ms

Adr18:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .0, .0, .0, .0, .204, .54, .216, .96, .0, .0, .0, .0, .0, .0, .0, .0
	do		.4,.125	; Duration * 1ms

Adr018:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .0, .0, .0, .0, .204, .54, .216, .96, .0, .0, .0, .0, .0, .0, .0, .0
	noop	.125	; Duration * 1ms

Adr19:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .0, .0, .0, .0, .204, .54, .216, .96, .0, .0, .0, .0, .0, .0, .0, .0
	loop	Adr018,.125		; Duration * 1ms

Adr20:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .205, .176, .219, .96, .204, .54, .216, .96, .240, .192, .217, .128, .0, .0, .0, .0
	do		.4,.125	; Duration * 1ms

Adr020:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .205, .176, .219, .96, .204, .54, .216, .96, .240, .192, .217, .128, .0, .0, .0, .0
	noop	.125	; Duration * 1ms

Adr21:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .205, .176, .219, .96, .204, .54, .216, .96, .240, .192, .217, .128, .0, .0, .0, .0
	loop	Adr020,.125		; Duration * 1ms

Adr22:			; 5 * 32 bit display pattern
	db     .248, .224, .241, .192, .205, .176, .219, .96, .204, .54, .216, .96, .240, .192, .217, .128, .205, .240, .243, .224
	do		.200,.250	; Duration * 1ms

Adr022:			; 5 * 32 bit display pattern
	db     .248, .224, .241, .192, .205, .176, .219, .96, .204, .54, .216, .96, .240, .192, .217, .128, .205, .240, .243, .224
	noop	.250	; Duration * 1ms

Adr23:			; 5 * 32 bit display pattern
	db     .248, .224, .241, .192, .205, .176, .219, .96, .204, .54, .216, .96, .240, .192, .217, .128, .205, .240, .243, .224
	loop	Adr022,.250	; Duration * 1ms

Adr24:			; 5 * 32 bit display pattern
	db     .241, .193, .227, .128, .155, .97, .182, .192, .152, .109, .176, .192, .225, .129, .179, .0, .155, .225, .231, .192  
	noop   .200  ; Duration * 1ms

Adr25:			; 5 * 32 bit display pattern
	db     .227, .131, .199, .0, .54, .195, .109, .128, .48, .219, .97, .128, .195, .3, .102, .0, .55, .195, .207, .128
	noop   .200  ; Duration * 1ms

Adr27:			; 5 * 32 bit display pattern
	db     .199, .7, .142, .0, .109, .134, .219, .0, .97, .182, .195, .0, .134, .6, .204, .0, .111, .135, .159, .0
	noop   .200  ; Duration * 1ms


Adr28:			; 5 * 32 bit display pattern
	db     .142, .15, .28, .0, .219, .13, .182, .0, .195, .109, .134, .0, .12, .13, .152, .0, .223, .15, .62, .0
	noop   .200  ; Duration * 1ms


Adr29:			; 5 * 32 bit display pattern
	db     .28, .30, .56, .0, .182, .27, .108, .0, .134, .219, .12, .0, .24, .27, .48, .0, .190, .30, .124, .0
	noop   .200  ; Duration * 1ms


Adr30:			; 5 * 32 bit display pattern
	db     .56, .60, .112, .0, .108, .54, .216, .0, .13, .182, .24, .0, .48, .54, .96, .0, .124, .60, .248, .0
	noop   .200  ; Duration * 1ms


Adr31:			; 5 * 32 bit display pattern
	db     .112, .120, .224, .0, .216, .109, .176, .0, .27, .108, .48, .0, .96, .108, .192, .0, .248, .121, .240, .0
	noop   .200  ; Duration * 1ms


Adr32:			; 5 * 32 bit display pattern
	db     .224, .241, .192, .0, .176, .219, .96, .0, .54, .216, .96, .0, .192, .217, .128, .0, .240, .243, .224, .0
	noop   .200  ; Duration * 1ms

Adr33:			; 5 * 32 bit display pattern
	db     .224, .241, .192, .0, .176, .219, .96, .0, .182, .216, .96, .0, .192, .217, .128, .0, .240, .243, .224, .0
	noop   .200  ; Duration * 1ms

Adr34:			; 5 * 32 bit display pattern
	db     .193, .227, .128, .0, .225, .182, .192, .0, .237, .176, .192, .0, .129, .179, .0, .0, .225, .231, .192, .0
	noop   .200  ; Duration * 1ms

Adr35:			; 5 * 32 bit display pattern
	db     .131, .199, .0, .0, .195, .109, .128, .0, .219, .97, .128, .0, .131, .102, .0, .0, .195, .207, .128, .0
	noop   .200  ; Duration * 1ms

Adr36:			; 5 * 32 bit display pattern
	db     .135, .142, .0, .0, .134, .219, .0, .0, .182, .195, .0, .0, .134, .204, .0, .0, .135, .159, .0, .0
	noop   .200  ; Duration * 1ms

Adr37:			; 5 * 32 bit display pattern
	db     .143, .28, .0, .0, .141, .182, .0, .0, .237, .134, .0, .0, .141, .152, .0, .0, .143, .62, .0, .0
	noop   .200  ; Duration * 1ms

Adr38:			; 5 * 32 bit display pattern
	db     .158, .56, .0, .0, .155, .108, .0, .0, .219, .12, .0, .0, .155, .48, .0, .0, .158, .124, .0, .0
	noop   .200  ; Duration * 1ms

Adr39:			; 5 * 32 bit display pattern
	db     .188, .112, .0, .0, .182, .216, .0, .0, .182, .24, .0, .0, .182, .96, .0, .0, .188, .248, .0, .0
	noop   .200  ; Duration * 1ms

Adr40:			; 5 * 32 bit display pattern
	db     .248, .224, .0, .0, .237, .176, .0, .0, .236, .48, .0, .0, .236, .192, .0, .0, .249, .240, .0, .0
	noop   .200  ; Duration * 1ms

Adr41:			; 5 * 32 bit display pattern
	db     .241, .192, .0, .0, .219, .96, .0, .0, .216, .96, .0, .0, .217, .128, .0, .0, .243, .224, .0, .0
	noop   .200  ; Duration * 1ms

Adr42:			; 5 * 32 bit display pattern
	db     .227, .128, .0, .0, .182, .192, .0, .0, .176, .192, .0, .0, .179, .0, .0, .0, .231, .192, .0, .0
	noop   .200  ; Duration * 1ms

Adr43:			; 5 * 32 bit display pattern
	db     .199, .0, .0, .0, .237, .128, .0, .0, .225, .128, .0, .0, .230, .0, .0, .0, .207, .128, .0, .0
	noop   .200  ; Duration * 1ms

Adr44:			; 5 * 32 bit display pattern
	db     .142, .0, .0, .0, .219, .0, .0, .0, .195, .0, .0, .0, .204, .0, .0, .0, .159, .0, .0, .0
	noop   .200  ; Duration * 1ms

Adr45:			; 5 * 32 bit display pattern
	db     .156, .0, .0, .0, .182, .0, .0, .0, .134, .0, .0, .0, .152, .0, .0, .0, .190, .0, .0, .0
	noop   .200  ; Duration * 1ms


Adr46:			; 5 * 32 bit display pattern
	db     .184, .0, .0, .0, .236, .0, .0, .0, .140, .0, .0, .0, .176, .0, .0, .0, .252, .0, .0, .0
	noop   .200  ; Duration * 1ms

Adr47:			; 5 * 32 bit display pattern
	db     .240, .0, .0, .0, .216, .0, .0, .0, .152, .0, .0, .0, .224, .0, .0, .0, .248, .0, .0, .0
	noop   .200  ; Duration * 1ms

Adr48:			; 5 * 32 bit display pattern
	db     .224, .0, .0, .0, .176, .0, .0, .0, .176, .0, .0, .0, .192, .0, .0, .0, .240, .0, .0, .0
	noop   .200  ; Duration * 1ms

Adr49:			; 5 * 32 bit display pattern
	db     .192, .0, .0, .0, .224, .0, .0, .0, .224, .0, .0, .0, .128, .0, .0, .0, .224, .0, .0, .0
	noop   .200  ; Duration * 1ms

Adr50:			; 5 * 32 bit display pattern
	db     .128, .0, .0, .0, .192, .0, .0, .0, .192, .0, .0, .0, .128, .0, .0, .0, .192, .0, .0, .0
	do		.4,  .200  ; Duration * 1ms

Adr51:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,.0, .0, .0, .0, .0, .0, .0, .0, .0
	noop	.125	; Duration * 1ms

Adr52:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,.0, .0, .0, .0, .0, .0, .0, .0, .0
	loop	Adr51,.125		; Duration * 1ms

Adr53:			; 5 * 32 bit display pattern
	db     .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,.0, .0, .0, .0, .0, .0, .0, .0, .0
	restart	.200	

;Adr6:			; 5 * 32 bit display pattern
;	db	b'10000000',b'10000000',b'10000000',b'10000000'
;	db	b'10000000',b'10000000',b'10000000',b'10000000'
;	db	b'10000000',b'10000000',b'10000000',b'10000000'
;	db	b'10000000',b'10000000',b'10000000',b'10000000'
;	db	b'10000000',b'10000000',b'10000000',b'10000000'
;	branch	Adr5,.50		; Duration * 1ms

;Adr7:			; 5 * 32 bit display pattern
;	db	b'10000000',b'10000000',b'10000000',b'10000000'
;	db	b'10000000',b'10000000',b'10000000',b'10000000'
;	db	b'10000000',b'10000000',b'10000000',b'10000000'
;	db	b'10000000',b'10000000',b'10000000',b'10000000'
;	db	b'10000000',b'10000000',b'10000000',b'10000000'
;	jsr		Adr8,.50		; Duration * 1ms

;Adr8:			; 5 * 32 bit display pattern
;	db	b'10000000',b'10000000',b'10000000',b'10000000'
;	db	b'10000000',b'10000000',b'10000000',b'10000000'
;	db	b'10000000',b'10000000',b'10000000',b'10000000'
;	db	b'10000000',b'10000000',b'10000000',b'10000000'
;	db	b'10000000',b'10000000',b'10000000',b'10000000'
;	ret			.50			; Duration * 1ms

	end
