/*
 * Project name:
     Multimeter
 * Copyright:
     (c) Ar2r, 2008.
 * Description:
     Uses ADC x2 (A0 & A1) chanels I & U result in range of 0-3500 mV
     Vref=3,5V. It calculates Power & Resistance from U & I
     and displays results on LCDx2row. Also sends value of U & I on
     serial port.
 * Test configuration:
     MCU:             PIC16F877
     Oscillator:      HS, 14.31818 MHz
     Ext. Modules:    LCD
     SW:              mikroC v8.2
 * NOTES:
     None.
*/

unsigned char ch;
unsigned int Napon_rd, Struja_rd;
unsigned long u, i, power, res;

#include "Ar2r.h"

void main()
{
  INTCON = 0;                              // Disable all interrupts
  Usart_Init(19200);                       // Initialize USART module (8 bit, 38400 baud rate, no parity)
                                           // (I think this is bug in MikroC, Init is on 19200 but it
                                           // actualy works at speed 38400)
  
  Lcd_Init(&PORTB);                        // Lcd_Init, see Autocomplete
  LCD_Cmd(LCD_CURSOR_OFF);                 // send command to LCD (cursor off)
  Ar2r();                                  // Show splash screen :)
  LCD_Cmd(LCD_CLEAR);                      // send command  to LCD (clear LCD)

  ADCON1     = 0x88;                       // configure Vref, and analog channels
  TRISA      = 0xFF;                       // designate PORTA as input

  while (1)
    {
      // Voltage
      Napon_rd=ADC_read(1);                // get ADC value for U from channel 1
      u=(long)Napon_rd*3500;               // covert adc reading to milivolts
      u=u/1023;                            // 0..1023 -> 0-3500mV

      ch=u/1000;                           // extract 10.00 U digit
      Usart_Write(48+ch);                  // write ASCII digit on serial port
      if (ch==0)
        {
          LCD_Chr(1,2, 32);                // write empty space if digit is 0
        }
      else
        {
          LCD_Chr(1,2,48+ch);              // write ASCII digit at 1st row, 2nd column
        }

      ch=(u/100) %10;                      // extract 01.00 U digit
      Usart_Write(48+ch);                  // write ASCII digit on serial port
      LCD_Chr_CP(48+ch);                   // write ASCII digit at cursor point
      LCD_Chr_CP('.');                     // write '.' at cursor point
      Usart_Write(',');                    // write ',' on serial port

      ch=(u/10) %10;                       // extract 00.10 U digit
      Usart_Write(48+ch);                  // write ASCII digit on serial port
      LCD_Chr_CP(48+ch);                   // write ASCII digit at cursor point

      ch=u %10;                            // extract 00.01 U digit
      Usart_Write(48+ch);                  // write ASCII digit on serial port
      //if (Button(&PORTD, 1, 1, 0))         // read jumper 2 ON/OFF for last digit of U
        {
          LCD_Chr_CP(48+ch);               // write ASCII digit at cursor point
        }
      //else
        {
          //LCD_Chr_CP(32);                  // write empty space at cursor point
        }
      LCD_Chr_CP('V');                     // write 'V' at cursor point
      Usart_Write('V');                    // write 'V' on serial port
      Usart_Write('\n');                   // write '\n' on serial port

      // Curent
      Struja_rd=ADC_read(0);               // get ADC value for I from channel 0
      i=(long)Struja_rd*3500;              // covert adc reading to milivolts
      i=i/1023;                            // 0..1023 -> 0-3500mV

      ch=i/1000;                           // extract 1.000 I digit
      Usart_Write(48+ch);                  // write ASCII digit on serial port
      LCD_Chr(1,10,48+ch);                 // write ASCII digit at 1st row, 10th column
      LCD_Chr_CP('.');                     // write '.' at cursor point
      Usart_Write(',');                    // write ',' on serial port

      ch=(i/100) %10;                      // extract 0.100 I digit
      Usart_Write(48+ch);                  // write ASCII digit on serial port
      LCD_Chr_CP(48+ch);                   // write ASCII digit at cursor point

      ch=(i/10) %10;                       // extract 0.010 I digit
      Usart_Write(48+ch);                  // write ASCII digit on serial port
      LCD_Chr_CP(48+ch);                   // write ASCII digit at cursor point

      ch=i %10;                            // extract 0.001 I digit
      Usart_Write(48+ch);                  // write ASCII digit on serial port
      //if (Button(&PORTD, 0, 1, 0))         // read jumper 1 ON/OFF for last digit of I
        {
          LCD_Chr_CP(48+ch);               // write ASCII digit at cursor point
        }
      //else
        {
          //LCD_Chr_CP(32);                  // write empty space at cursor point
        }
      LCD_Chr_CP('A');                     // write 'A' at cursor point
      Usart_Write('A');                    // write 'A' on serial port
      Usart_Write('\n');                   // write '\n' on serial port

      //Power Calculation
      power=u*i/1000;
      ch=power/1000;                       // extract 10.00 P digit
      if (ch==0)
        {
          LCD_Chr(2,2, 32);                // write empty space if digit is 0
        }
      else
        {
          LCD_Chr(2,2,48+ch);              // write ASCII digit at 2nd row, 2nd column
        }

      ch=(power/100) %10;                  // extract 01.00 P digit
      LCD_Chr_CP(48+ch);                   // write ASCII digit at cursor point
      LCD_Chr_CP('.');                     // write '.' at cursor point

      ch=(power/10) %10;                   // extract 0.10 P digit
      LCD_Chr_CP(48+ch);                   // write ASCII digit at cursor point

      ch=power %10;                        // extract 0.01 P digit
      LCD_Chr_CP(48+ch);                   // write ASCII digit at cursor point
      LCD_Chr_CP('W');                     // write 'W' at cursor point

      // Resistance Calculation
      if(power==0)
        {
          LCD_Out(2,10,"  ");              // write empty space
          LCD_Chr_CP(243);                 // write 'infinity' at cursor point
          LCD_Out(2,13,"  ");              // write empty space
          LCD_Chr_CP(244);                 // write 'ohm' at cursor point
        }
      else
        {
          res=u*100/i;
          if(res>=10000)
            {
              LCD_Out(2,10," > 1K");       // write " > 1K"
              LCD_Chr_CP(244);             // write 'ohm' at cursor point
            }
          else
            {
              ch=res/1000;                 // extract 100.0 R digit
              if (ch==0)
                {
                  LCD_Chr(2,10, 32);       // write empty space if digit is 0
                }
              else
                {
                  LCD_Chr(2,10,48+ch);     // write ASCII digit at 2nd row, 10th column
                }

              ch=(res/100) %10;            // extract 010.0 R digit
              if (ch==0 && res<=99)
                {
                  LCD_Chr_CP(32);          // write empty space if digit is 0
                }
              else
                {
                  LCD_Chr_CP(48+ch);       // write ASCII digit at cursor point
                }

              ch=(res/10) %10;             // extract 001.0 R digit
              LCD_Chr_CP(48+ch);           // write ASCII digit at cursor point
              LCD_Chr_CP('.');             // write '.' at cursor point

              ch=res %10;                  // extract 000.1 R digit
              LCD_Chr_CP(48+ch);           // write ASCII digit at cursor point
              LCD_Chr_CP(244);             // write 'ohm' at cursor point
            }
        }

      //Delay_ms(50);                        // Waits 50ms
  }
}
