;=======3x595.ASM================================11/02/07==
        list    p=16f628A
	#include	<p16f628A.inc>
	errorlevel	-302
	__CONFIG   _CP_OFF  & _LVP_OFF & _BODEN_OFF & _MCLRE_OFF & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT 
 	
;------------------------------------------------------------
 
;------------------------------------------------------------
;	bit equates

BINC	equ	0		;increase button
BDEC	equ	1		;decrease button
RBPU	equ	7		;RB PU enable bit
;------------------------------------------------------------
;	program variable
			cblock 0x20
				cntr_lo	
				cntr_mi	
				cntr_hi	
				temp	
				ncount  
				mcount
				sr_tmp
				sr_sr
			endc	
;------------------------------------------------------------
		
;------------------------------------------------------------

        org     0x00
        goto	start
        org     0x04
;
		org     0x05
start	bsf		STATUS,RP0  	;switch to bank 1
		movlw	b'11000111' 	;inputs/outputs
	    movwf   TRISB
	    bcf		OPTION_REG,RBPU ;RB PU enable
		bcf		STATUS,RP0  	;switch back to bank 0
		movlw	0x07			;
		movwf	CMCON			;comparators off
		bcf		STATUS,RP0    	;bank 0
		clrf	cntr_lo
		clrf	cntr_mi
		clrf	cntr_hi	 
		call	outchg			;write out   
;------------------------------------------------------------
repeat	
		call	pressck			;look for incr/decr button press
		movlw	0x80			;delay 100 milliseconds
		movwf	mcount
loadn	movlw	0xff
		movwf	ncount
decn	decfsz	ncount,f  		;decrement N
		goto	decn			;again
		decfsz	mcount,f  		;decrement M
		goto	loadn			;again
		goto	repeat
;------------------------------------------------------------
pressck	btfss	PORTB,BDEC 		;decrease button pressed?
		call	deccntr			;yes, decrement cntrs
		btfss	PORTB,BINC		;increase button pressed?
		call	inccntr			;yes, increment cntrs
		return
;------------------------------------------------------------
inccntr	movf	cntr_lo,w    	;test for maximum
		sublw	0xff
		btfss	STATUS,Z
		goto	do_i			;not at maximum
		movf	cntr_mi,w
		sublw	0xff  	;compare
		btfss	STATUS,Z
		goto	do_i			;not at maximum
		movf	cntr_hi,w    	;test for maximum
		sublw	0xff
		btfss	STATUS,Z
		goto	do_i			;not at maximum
		goto	inc				;at maximum	
do_i	incf	cntr_lo,f    	;increment
		btfss	STATUS,Z
		goto	inc
		incf	cntr_mi,f
		btfss	STATUS,Z
		goto	inc
		incf	cntr_hi,f
		goto	inc
		incf	cntr_hi,f
inc		call	outchg			;write out
		return					;press check done
;------------------------------------------------------------
deccntr	movf	cntr_lo,w    	;test for minimum
		sublw	0x00
		btfss	STATUS,Z
		goto	do_d			;not at minimum
		movf	cntr_mi,w
		sublw	0x00  	;compare
		btfss	STATUS,Z
		goto	do_d			;not at minimum
		movf	cntr_hi,w    	;test for minimum
		sublw	0x00
		btfss	STATUS,Z
		goto	do_d			;not at minimum
		goto	dec				;at minimum		
do_d	decf	cntr_lo,f    	;decrement
		movf	cntr_lo,w	
		sublw	0xff
		btfss	STATUS,Z
		goto	dec
		decf	cntr_mi,f    	;decrement
		movf	cntr_mi,w	
		sublw	0xff
		btfss	STATUS,Z
		goto	dec
		decf	cntr_hi,f    	;decrement
dec		call	outchg			;write out
		return					;press check done
;------------------------------------------------------------
outchg	
		movfw	cntr_hi
		call	set_leds		;write out bits <16:23>
		movfw	cntr_mi
		call	set_leds		;write out bits <8:15>
		movfw	cntr_lo
		call	set_leds		;write out bits <0:7>
		return
;------------------------------------------------------------
		include	"595.INC"	;
;
        end
;------------------------------------------------------------
;       memory unprotected
;       watchdog timer disabled (default is enabled)
;       INT_OSC (using 4 MHz osc for test) INT
;       power-up timer on
;		brown-out detect on
;============================================================




