#include <P12F675.inc>

;====================Ismertet===================================================
;Szoftveres PWM genertor, a kontroller bels 4 MHz-es oszcilltorval
;A kitlts 0-100%-ig 10 % lpsekben llthat, frekvencia = 100 kHz
;A bellts mdja: A GP4 GP2 GP1 GP0 portlbakra kttt kapcsolk segtsgvel belltjuk binris kdban
;a kvnt kitltsi rtk/10 szmot (Pl. 80% esetn binris 8-at), majd az MCLR bemenet segtsgvel 
; reset utn a belltott kitltssel fog mkdni a GP5 kimeneten a PWM jel
;================================================================================

	errorlevel -302
	__CONFIG _INTRC_OSC_NOCLKOUT & _WDT_OFF & _PWRTE_OFF & _MCLRE_ON & _BODEN_OFF & _CP_OFF & _CPD_OFF

	#define DIP_SWITCH	;Ha a kls kapcsolk 0-ba hznak az aktv llapotukban, akkor kell, egybknt kikommentezni!

	org 0
	goto Init
Init:
	banksel GPIO
	clrf GPIO
	movlw 0x07
	movwf CMCON
	banksel ANSEL
	clrf ANSEL
	movlw b'00010111'
#ifdef DIP_SWITCH
	movwf WPU			;Ha DIP kapcsol van hasznlva, akkor bekapcsoljuk a bels felhzellenllsokat
#endif
	movwf TRISIO		;GP5 kimenet, tbbi bemenet, GP3 = MCLR funkci
	banksel GPIO		;Visszavltunk a 0-s bankba
	movlw .1			;A szmtott goto (computed goto) miatt a PCLATH rtke 1
	movwf PCLATH

#ifdef	DIP_SWITCH		;beolvassuk a portrl a belltott kitltst
	comf GPIO, W		;kpezzk a GPIO komplemenst, DIP kapcsol esetn (0-ra aktv)
#else	
	movf GPIO, W
#endif

	andlw b'00000111'	;els krben csak az als bitek rdekelnek minket, az MSB-t ksbb vizsgljuk
	goto Select_Duty
	
	org 100				;0x100-as cm belltsa
Select_Duty:

#ifdef DIP_SWITCH
	btfss GPIO, GP4		;ha 70%-nl nagyobb a kitlts, akkor azt a legmagasabb (GP4) helyrtk jelzi
#else
	btfsc GPIO, GP4
#endif
	addlw .8			;ha 70%-nl nagyobb a kitlts, akkor a tblzatban plusz 8-al ugrunk
	addwf PCL, F		;ugrtblzat a kitltsnek megfelelen, a kitltsi rtket a W tartalmazza
	goto Duty_0
	goto Duty_10
	goto Duty_20
	goto Duty_30
	goto Duty_40
	goto Duty_50
	goto Duty_60
	goto Duty_70
	goto Duty_80
	goto Duty_90
	goto Duty_100
	goto Duty_0		;illeglis bellts (11)
	goto Duty_0		;illeglis bellts (12)
	goto Duty_0		;illeglis bellts (13)
	goto Duty_0		;illeglis bellts (14)
	goto Duty_0		;illeglis bellts (15)
		
Duty_0:
	bcf GPIO, GP5
	goto Duty_0

Duty_10:
	bsf GPIO, GP5
	bcf	GPIO, GP5
	nop
	nop
	nop
	nop
	nop
	nop
	goto Duty_10

Duty_20:
	bsf GPIO, GP5
	nop
	bcf	GPIO, GP5
	nop
	nop
	nop
	nop
	nop
	goto Duty_20

Duty_30:
	bsf GPIO, GP5
	nop
	nop
	bcf GPIO, GP5
	nop
	nop
	nop
	nop
	goto Duty_30

Duty_40:
	bsf GPIO, GP5
	nop
	nop
	nop
	bcf GPIO, GP5
	nop
	nop
	nop
	goto Duty_40

Duty_50:
	bsf GPIO, GP5
	nop
	nop
	nop
	nop
	bcf GPIO, GP5
	nop
	nop
	goto Duty_50

Duty_60:
	bsf GPIO, GP5
	nop
	nop
	nop
	nop
	nop
	bcf GPIO, GP5
	nop
	goto Duty_60

Duty_70:
	bsf GPIO, GP5
	nop
	nop
	nop
	nop
	nop
	nop
	bcf GPIO, GP5
	goto Duty_70

Duty_80:
	bcf GPIO,GP5
	nop
	bsf GPIO, GP5
	nop
	nop
	nop
	nop
	nop
	goto Duty_80

Duty_90:
	bcf GPIO, GP5
	bsf GPIO, GP5
	nop
	nop
	nop
	nop
	nop
	nop
	goto Duty_90

Duty_100:
	bsf GPIO, GP5
	goto Duty_100

	END